/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.util.ExpressionChunkVisitor;

public class CompositeExpressionChunkVisitor
implements ExpressionChunkVisitor {
    private final ExpressionChunkVisitor[] visitors;

    public CompositeExpressionChunkVisitor(ExpressionChunkVisitor ... visitors) {
        this.visitors = visitors;
    }

    @Override
    public void visitTextChunk(JRExpressionChunk chunk) {
        ExpressionChunkVisitor[] expressionChunkVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionChunkVisitor visitor = expressionChunkVisitorArray[n2];
            visitor.visitTextChunk(chunk);
            ++n2;
        }
    }

    @Override
    public void visitParameterChunk(JRExpressionChunk chunk) {
        ExpressionChunkVisitor[] expressionChunkVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionChunkVisitor visitor = expressionChunkVisitorArray[n2];
            visitor.visitParameterChunk(chunk);
            ++n2;
        }
    }

    @Override
    public void visitFieldChunk(JRExpressionChunk chunk) {
        ExpressionChunkVisitor[] expressionChunkVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionChunkVisitor visitor = expressionChunkVisitorArray[n2];
            visitor.visitFieldChunk(chunk);
            ++n2;
        }
    }

    @Override
    public void visitVariableChunk(JRExpressionChunk chunk) {
        ExpressionChunkVisitor[] expressionChunkVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionChunkVisitor visitor = expressionChunkVisitorArray[n2];
            visitor.visitVariableChunk(chunk);
            ++n2;
        }
    }

    @Override
    public void visitResourceChunk(JRExpressionChunk chunk) {
        ExpressionChunkVisitor[] expressionChunkVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionChunkVisitor visitor = expressionChunkVisitorArray[n2];
            visitor.visitResourceChunk(chunk);
            ++n2;
        }
    }
}

