/*
 * Decompiled with CFR 0.152.
 */
package serpro.transmissao;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JDialog;
import javax.swing.JFrame;
import serpro.transmissao.JParametrosNet;
import serpro.transmissao.JTipoDeclaracao;
import serpro.transmissao.JTransnetDlg;
import serpro.transmissao.JUtil;

public class JDeclaracao {
    public String m_strNome;
    public String m_strNI;
    public String m_strlblNome;
    public String m_strlblNI;
    public String m_strPrograma;
    public String m_strNIFormatado;
    public String m_strControleSRF;
    public String m_strUserSenha;
    private String m_strErro;
    private Window m_pParentFrame;
    private JTipoDeclaracao[] m_TiposDeclaracao;
    private int m_nQtdeTiposDeclaracao;
    private String m_strRecibo;

    public JDeclaracao() {
        this.InitTiposDeclaracao();
    }

    public JDeclaracao(JFrame jFrame) {
        this.m_pParentFrame = jFrame;
        this.InitTiposDeclaracao();
    }

    private void InitTiposDeclaracao() {
        this.m_nQtdeTiposDeclaracao = 1;
        this.m_TiposDeclaracao = new JTipoDeclaracao[this.m_nQtdeTiposDeclaracao];
        this.m_TiposDeclaracao[0] = new JTipoDeclaracao("IRPF    2005", 1500, "Nome do contribuinte", "CPF", "2004", "999.999.999-99");
    }

    public int Identificar(String string) {
        File file = new File(JUtil.NOME_ARQUIVO_CERTIFICADO);
        if (!file.exists()) {
            this.m_strErro = "O arquivo contendo o certificado digital utilizado pelo Receitanet\n n\u00e3o foi encontrado!\nPara funcionar adequadamente, o Receitanet deve ser reinstalado.";
            return 1;
        }
        System.setProperty("javax.net.ssl.trustStore", JUtil.NOME_ARQUIVO_CERTIFICADO);
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        if (string.length() == 0) {
            this.m_strErro = "ERRO!\nO nome do arquivo declara\u00e7\u00e3o n\u00e3o foi informado.";
            return 1;
        }
        if (!JUtil.FileExists(string)) {
            this.m_strErro = "ERRO!\nO arquivo declara\u00e7\u00e3o \"" + string + "\" n\u00e3o existe.";
            return 1;
        }
        if (!JUtil.IsFile(string)) {
            this.m_strErro = "ERRO!\nO arquivo selecionado n\u00e3o \u00e9 um arquivo declara\u00e7\u00e3o reconhecido por esta vers\u00e3o do Receitanet.";
            return 1;
        }
        int n = string.length();
        String string2 = string.substring(n - 3, n);
        if ((string2 = string2.toUpperCase()).compareTo("REC") == 0) {
            this.m_strErro = "ERRO!\nO arquivo selecionado \u00e9 um arquivo de recibo de entrega.\nPor favor, selecione o arquivo declara\u00e7\u00e3o correspondente (extens\u00e3o \".DEC\").";
            return 1;
        }
        if (string2.compareTo("DBK") == 0) {
            this.m_strErro = "ERRO!\nA DECLARA\u00c7\u00c3O N\u00c3O FOI TRANSMITIDA.\nO arquivo selecionado \u00e9 uma c\u00f3pia de seguran\u00e7a.\nPor favor, gere novamente sua declara\u00e7\u00e3o usando o programa gerador fornecido pela Secretaria da Receita Federal.";
            return 1;
        }
        if (string2.compareTo("DEC") != 0) {
            this.m_strErro = "ERRO!\nO arquivo selecionado n\u00e3o \u00e9 um arquivo declara\u00e7\u00e3o reconhecido por esta vers\u00e3o do Receitanet.";
            return 1;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_strErro = "ERRO!\nO arquivo " + string + " n\u00e3o foi encontrado.";
            return 1;
        }
        String string3 = "";
        try {
            string3 = randomAccessFile.readLine();
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            this.m_strErro = "Ocorreu um erro durante a leitura do arquivo declara\u00e7\u00e3o " + string + "." + iOException.getMessage();
            return 1;
        }
        if (!this.SetValuesIdentificacao(string3)) {
            return 1;
        }
        if (!this.ValidaNomeArquivo(string)) {
            this.m_strErro = "ERRO!\nO arquivo selecionado n\u00e3o \u00e9 um arquivo de declara\u00e7\u00e3o v\u00e1lido.\nPor favor, gere novamente sua declara\u00e7\u00e3o usando o programa gerador fornecido pela Secretaria da Receita Federal.";
            return 1;
        }
        return 0;
    }

    public boolean Transmitir(String string) {
        JTransnetDlg jTransnetDlg = this.m_pParentFrame instanceof JDialog ? new JTransnetDlg((JDialog)this.m_pParentFrame, string, this.m_strUserSenha) : new JTransnetDlg((JFrame)this.m_pParentFrame, string, this.m_strUserSenha);
        jTransnetDlg.setVisible(true);
        if (jTransnetDlg.getRetCode() == 0) {
            this.m_strErro = jTransnetDlg.getLastError();
            return false;
        }
        this.m_strRecibo = jTransnetDlg.getRecibo();
        return this.GravaRecibo(string, this.m_strRecibo);
    }

    public int EnviarDeclaracao(Window window, JParametrosNet jParametrosNet, String string) {
        JUtil.NOME_ARQUIVO_CERTIFICADO = string;
        return this.EnviarDeclaracao(window, jParametrosNet);
    }

    public int EnviarDeclaracao(Window window, JParametrosNet jParametrosNet) {
        this.m_pParentFrame = window;
        if (jParametrosNet.m_strNomeArqDeclaracao.length() == 0) {
            jParametrosNet.m_strMensagem = "ERRO!\nO nome do arquivo declara\u00e7\u00e3o a ser transmitido n\u00e3o foi passado corretamente para o m\u00f3dulo de transmiss\u00e3o.";
            return 1;
        }
        int n = this.Identificar(jParametrosNet.m_strNomeArqDeclaracao);
        if (n != 0) {
            jParametrosNet.m_strMensagem = this.m_strErro;
            return n;
        }
        if (!this.Transmitir(jParametrosNet.m_strNomeArqDeclaracao)) {
            jParametrosNet.m_strMensagem = this.m_strErro;
            return 1;
        }
        if (this.m_strRecibo.indexOf("\nNC") != -1 || this.m_strRecibo.indexOf("\rNC") != -1) {
            jParametrosNet.m_strMensagem = "Esta declara\u00e7\u00e3o" + this.m_strNI + "foi transmitida com sucesso, no entanto foi entregue fora do prazo e ensejou aplica\u00e7\u00e3o de multa. Imprima o Recibo de Entrega e Notifica\u00e7\u00e3o de Lan\u00e7amento acionando a op\u00e7\u00e3o correspondente no programa gerador da declara\u00e7\u00e3o.";
            return 2;
        }
        jParametrosNet.m_strMensagem = "Declara\u00e7\u00e3o transmitida com sucesso.";
        return 0;
    }

    public String GetLastError() {
        return this.m_strErro;
    }

    private int PesquisaDeclaracao(String string) {
        int n = -1;
        for (int i = 0; i < this.m_nQtdeTiposDeclaracao; ++i) {
            if (string.compareTo(this.m_TiposDeclaracao[i].m_strIDDeclaracao) != 0) continue;
            n = i;
            break;
        }
        return n;
    }

    private boolean ValidaNomeArquivo(String string) {
        File file = new File(string);
        String string2 = file.getName().substring(0, 8);
        for (int i = 0; i < 8 && string2.charAt(i) != '~'; ++i) {
            if (string2.charAt(i) == this.m_strNI.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean SetValuesIdentificacao(String string) {
        String string2 = string.substring(0, 12);
        int n = this.PesquisaDeclaracao(string2);
        if (n == -1) {
            this.m_strErro = "O arquivo selecionado n\u00e3o \u00e9 um arquivo de declara\u00e7\u00e3o v\u00e1lido ou o esta declara\u00e7\u00e3o n\u00e3o \u00e9 reconhecida por esta vers\u00e3o do programa Receitanet.";
            return false;
        }
        String string3 = string.substring(12, 16);
        if (this.m_TiposDeclaracao[n].m_iTipoFormulario != 9999 && string3.compareTo(this.m_TiposDeclaracao[n].m_strExercicio) != 0) {
            this.m_strErro = "O arquivo selecionado n\u00e3o \u00e9 um arquivo de declara\u00e7\u00e3o v\u00e1lido.\nPor favor, gere novamente sua declara\u00e7\u00e3o usando o programa gerador fornecido pela Secretaria da Receita Federal.";
            return false;
        }
        int n2 = Integer.parseInt(string.substring(16, 20));
        if (n2 != this.m_TiposDeclaracao[n].m_iTipoFormulario) {
            this.m_strErro = "O arquivo selecionado n\u00e3o \u00e9 um arquivo de declara\u00e7\u00e3o v\u00e1lido.\nPor favor, gere novamente sua declara\u00e7\u00e3o usando o programa gerador fornecido pela Secretaria da Receita Federal.";
            return false;
        }
        String string4 = string.substring(0, 7);
        string4 = string4.trim();
        String string5 = string.substring(8, 12);
        string5 = string5.trim();
        this.m_strNI = string.substring(21, 35);
        this.m_strNI = this.m_strNI.trim();
        this.m_strNome = string.substring(39, 99);
        this.m_strNome = this.m_strNome.trim();
        this.m_strControleSRF = string.substring(101, 111);
        this.m_strControleSRF = this.FormatNI(this.m_strControleSRF, "99.99.99.99.99");
        if (this.m_strControleSRF.length() == 0) {
            this.m_strErro = "O arquivo selecionado n\u00e3o \u00e9 um arquivo de declara\u00e7\u00e3o v\u00e1lido.\nPor favor, gere novamente sua declara\u00e7\u00e3o usando o programa gerador fornecido pela Secretaria da Receita Federal.";
            return false;
        }
        this.m_strNIFormatado = this.FormatNI(this.m_strNI, this.m_TiposDeclaracao[n].m_strFormatoNI);
        this.m_strlblNome = this.m_TiposDeclaracao[n].m_strLabelNome;
        this.m_strlblNI = this.m_TiposDeclaracao[n].m_strLabelNI;
        this.m_strPrograma = string4 + " " + string5 + " Ano " + string3;
        return true;
    }

    private String FormatNI(String string, String string2) {
        int n = 0;
        String string3 = "";
        for (int i = 0; i < string2.length(); ++i) {
            string3 = string2.charAt(i) == '9' ? string3 + string.charAt(n++) : string3 + string2.charAt(i);
        }
        return string3;
    }

    private boolean GravaRecibo(String string, String string2) {
        String string3;
        File file = new File(string);
        String string4 = file.getParent();
        try {
            Class.forName("receitanet.ReceitanetApp");
            string3 = string4.substring(string4.length() - 1).compareTo("\\") != 0 ? string4 + "\\" + this.m_strNI.substring(0, 8) + ".REC" : file.getParent() + this.m_strNI.substring(0, 8) + ".REC";
        }
        catch (Exception exception) {
            string3 = string.substring(0, string.length() - 4) + ".REC";
        }
        try {
            RandomAccessFile randomAccessFile = null;
            randomAccessFile = new RandomAccessFile(string3, "rw");
            randomAccessFile.writeBytes(string2);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            this.m_strErro = "Ocorreu um erro na grava\u00e7\u00e3o do recibo de entrega da declara\u00e7\u00e3o.";
            this.m_strErro = this.m_strErro + "\n\n";
            this.m_strErro = this.m_strErro + exception.getMessage();
            this.m_strErro = this.m_strErro + "\n\n";
            this.m_strErro = this.m_strErro + "Para obter o recibo de entrega desta declara\u00e7\u00e3o transmita-a novamente.";
            return false;
        }
        return true;
    }
}

