/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.repositorioXML;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.repositorio.repositorioXML.AdaptadorXMLObjeto;

public class MapeamentoObjetoNegocioXML {
    private static Map<String, MapeamentoObjetoNegocioXML> mapeamentos = new Hashtable<String, MapeamentoObjetoNegocioXML>();
    private Map<String, AdaptadorXMLObjeto> tabelaMapeamento;

    private MapeamentoObjetoNegocioXML(Document documentoMapeamento) {
        Element documentElement = documentoMapeamento.getDocumentElement();
        AdaptadorXMLObjeto adaptadorRaiz = new AdaptadorXMLObjeto(documentElement);
        this.getTabelaMapeamento().put("Mapeamento", adaptadorRaiz);
        this.getTabelaMapeamento().put(documentElement.getAttribute("ElementoXML"), adaptadorRaiz);
        this.mapearChildNodes("", documentElement);
    }

    private void mapearChildNodes(String identificaoAncestrais, Element nodo) {
        if (nodo.hasChildNodes()) {
            NodeList filhos = nodo.getChildNodes();
            for (int i = 0; i < filhos.getLength(); ++i) {
                if (filhos.item(i).getNodeType() != 1 || !filhos.item(i).getNodeName().equals("Classe")) continue;
                Element nodeFilho = (Element)filhos.item(i);
                String identificaoDesteNode = identificaoAncestrais.length() == 0 ? nodeFilho.getAttribute("ElementoXML") : identificaoAncestrais + "." + nodeFilho.getAttribute("ElementoXML");
                this.getTabelaMapeamento().put(identificaoDesteNode, new AdaptadorXMLObjeto(nodeFilho));
                this.mapearChildNodes(identificaoDesteNode, nodeFilho);
            }
        }
    }

    public static MapeamentoObjetoNegocioXML getMapeamento(Document documentoMapeamento) {
        String nomeObjetoRaiz = documentoMapeamento.getDocumentElement().getAttribute("ClasseJava");
        if (nomeObjetoRaiz == null || nomeObjetoRaiz.length() == 0) {
            LogPPGD.erro((String)"Mapeamento incorreto: o atributo \"ClasseJava\" est\u00e1 ausente ou incorreto");
            throw new IllegalArgumentException("Mapeamento incorreto: o atributo \"ClasseJava\" est\u00e1 ausente ou incorreto");
        }
        if (mapeamentos.containsKey(nomeObjetoRaiz)) {
            return mapeamentos.get(nomeObjetoRaiz);
        }
        MapeamentoObjetoNegocioXML novoMapeamento = new MapeamentoObjetoNegocioXML(documentoMapeamento);
        mapeamentos.put(nomeObjetoRaiz, novoMapeamento);
        return novoMapeamento;
    }

    private String determinaNomeCompleto(Node node) {
        if (node.getParentNode() != node.getOwnerDocument().getDocumentElement()) {
            return this.determinaNomeCompleto(node.getParentNode()) + "." + node.getNodeName();
        }
        return node.getNodeName();
    }

    public AdaptadorXMLObjeto getAdaptadorXMLObjeto(String nomeCompleto) {
        LogPPGD.debug((String)("Solicitado AdaptadorXMLObjeto de: " + nomeCompleto));
        return this.getTabelaMapeamento().get(nomeCompleto);
    }

    public Iterator<String> iteratorAdaptadoresXMLObjeto() {
        return this.getTabelaMapeamento().keySet().iterator();
    }

    public Map<String, AdaptadorXMLObjeto> getTabelaMapeamento() {
        if (this.tabelaMapeamento == null) {
            this.tabelaMapeamento = new Hashtable<String, AdaptadorXMLObjeto>();
        }
        return this.tabelaMapeamento;
    }
}

