/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import serpro.ppgd.infraestrutura.JanelaPrincipalPPGD;
import serpro.ppgd.infraestrutura.ajuda.PDFHelp;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.infraestrutura.util.HelpUtil;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class PlataformaPPGD {
    protected static PlataformaPPGD plataformaDefault = null;
    protected Map<String, JPanel> listaPaineisInstanciados = new HashMap<String, JPanel>();
    private JanelaPrincipalPPGD aplicativo;
    private HelpUtil help;
    private ArrayList<PDFHelp> listPdfHelp;
    private boolean isAjudaJavaHelp;
    private static boolean emDesign = true;
    private boolean comportamentoPadraoSair = true;

    public void cadastraPainel(String chave, JPanel pPainel) {
        this.listaPaineisInstanciados.put(chave, pPainel);
    }

    public boolean existePainelCadastrado(String chave) {
        return this.listaPaineisInstanciados.containsKey(chave);
    }

    public JPanel getPainel(String chave) {
        return this.listaPaineisInstanciados.get(chave);
    }

    public HelpUtil getJavaHelp() {
        if (this.help == null) {
            System.err.println("ATEN\u00c3\u0087\u00c3\u0083O: Obtendo JavaHelp em projeto configurado para usar PDF. Para configurar como projeto JavaHelp, adicione a flag 'usaJavaHelp = true' ao aplicacao.properties.");
        }
        return this.help;
    }

    public void setNavegadorHelpVisivel(boolean visivel) {
        if (this.help != null) {
            this.help.setNavigatorVisible(visivel);
        }
    }

    public boolean isAjudaJavaHelp() {
        return this.isAjudaJavaHelp;
    }

    public PDFHelp getPDFHelpUtil() {
        return this.listPdfHelp.get(0);
    }

    public void setHelpID(JComponent componente, String id) {
        if (this.isAjudaJavaHelp) {
            if (this.help != null) {
                this.help.setHelpID(componente, id);
            }
        } else {
            this.listPdfHelp.get(0).setHelpID(componente, id);
        }
    }

    public void setHelpID(Container componente, String id) {
        if (this.isAjudaJavaHelp) {
            if (this.help != null) {
                this.help.setHelpID(componente, id);
            }
        } else {
            this.listPdfHelp.get(0).setHelpID(componente, id);
        }
    }

    public void setHelpID(JComponent componente, String id, String filePdf) {
        if (this.isAjudaJavaHelp) {
            if (this.help != null) {
                this.help.setHelpID(componente, id);
            }
        } else {
            for (PDFHelp help : this.listPdfHelp) {
                if (!help.getPdfFile().equals(filePdf)) continue;
                help.setHelpID(componente, id);
            }
        }
    }

    public void habilitaHelp(JRootPane root, String id) {
        if (this.help != null) {
            this.help.enableHelpKey(root, id);
        }
    }

    public void habilitaHelp(JPanel p, String id) {
        if (this.help != null) {
            this.help.enableHelpKey(p, id);
        }
    }

    public void setHelpID(String nomeComponente, String id) {
        if (this.isAjudaJavaHelp) {
            if (this.help != null) {
                JComponent c = (JComponent)this.getComponent(nomeComponente);
                this.help.setHelpID(c, id);
            }
        } else {
            JComponent c = (JComponent)this.getComponent(nomeComponente);
            this.listPdfHelp.get(0).setHelpID(c, id);
        }
    }

    public void setHelpID(String nomeComponente) {
        if (this.help != null) {
            JComponent c = (JComponent)this.getComponent(nomeComponente);
            String helpID = c.getClientProperty("helpID").toString();
            this.help.setHelpID(c, helpID);
        }
    }

    public static void setPlataforma(PlataformaPPGD aPlataforma) {
        plataformaDefault = aPlataforma;
    }

    public static PlataformaPPGD getPlataforma() {
        if (plataformaDefault == null) {
            plataformaDefault = new PlataformaPPGD();
        }
        return plataformaDefault;
    }

    public void carrega(Class<?> classJanelaPGD) {
        try {
            PlataformaPPGD.setEmDesign(false);
            this.configuraFontes();
            this.setAplicativo((JanelaPrincipalPPGD)classJanelaPGD.newInstance());
            UIManager.put("OptionPane.yesButtonText", "Sim");
            UIManager.put("OptionPane.yesButtonMnemonic", "83");
            UIManager.put("OptionPane.noButtonText", "N\u00ef\u00bf\u00bdo");
            UIManager.put("OptionPane.noButtonMnemonic", "78");
            UIManager.put("OptionPane.okButtonText", "Ok");
            UIManager.put("OptionPane.okButtonMnemonic", "79");
            UIManager.put("OptionPane.cancelButtonText", "Cancelar");
            UIManager.put("OptionPane.cancelButtonMnemonic", "67");
            UIManager.put("FileChooser.lookInLabelText", "Procurar em:");
            UIManager.put("FileChooser.saveInLabelText", "Salvar em:");
            UIManager.put("FileChooser.filesOfTypeLabelText", "Tipo do Arquivo:");
            UIManager.put("FileChooser.saveButtonText", "Salvar");
            UIManager.put("FileChooser.cancelButtonText", "Cancelar");
            UIManager.put("FileChooser.cancelButtonMnemonic", "67");
            UIManager.put("FileChooser.fileNameLabelText", "Nome do Arquivo:");
            this.aplicaArvore("ppgdarvore.xml");
            this.carregaHelp();
            this.getJanelaPrincipal().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (PlataformaPPGD.this.isComportamentoPadraoSair()) {
                        PlataformaPPGD.this.exitPgd();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configuraFontes() {
        FontesUtil.getInstancia().carregaFontes();
    }

    public void exitPgd() {
        try {
            String classeFacade = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.facade", "serpro.ppgd.repositorio.FacadeDefault");
            Class<?> classe = Class.forName(classeFacade);
            Method methGetInstancia = classe.getMethod("getInstancia", new Class[0]);
            PPGDFacade facade = (PPGDFacade)methGetInstancia.invoke(null, new Object[0]);
            Method methGetDeclaracao = classe.getMethod("salvaUltimaDeclaracaoAberta", new Class[0]);
            methGetDeclaracao.invoke((Object)facade, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public void exibe() {
        Dimension dim = this.obtemResolucao();
        if (dim != null) {
            this.getJanelaPrincipal().setSize(dim);
        }
        this.getJanelaPrincipal().setLocationRelativeTo(null);
        this.getJanelaPrincipal().setVisible(true);
    }

    private Dimension obtemResolucao() {
        String resolucao = FabricaUtilitarios.getProperties().getProperty("resolucao", "");
        if (resolucao.trim().length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(resolucao, ",");
        int width = 0;
        int height = 0;
        if (st.hasMoreTokens()) {
            width = Integer.parseInt(st.nextToken().trim());
        }
        if (st.hasMoreTokens()) {
            height = Integer.parseInt(st.nextToken().trim());
        }
        return new Dimension(width, height);
    }

    public void refreshJanelaPrincipal() {
        Dimension d = this.getJanelaPrincipal().getSize();
        ++d.width;
        ++d.height;
        this.getJanelaPrincipal().setSize(d);
        --d.width;
        --d.height;
        this.getJanelaPrincipal().setSize(d);
    }

    public JFrame getJanelaPrincipal() {
        return this.aplicativo.getJanelaPrincipal();
    }

    public JPanel getPainelPrincipal() {
        return this.aplicativo.getPainelPrincipal();
    }

    public Component getAreaPaineis() {
        return this.aplicativo.getAreaPaineis();
    }

    public Component getScrollAreaPaineis() {
        return this.aplicativo.getScrollAreaPaineis();
    }

    public Component getAreaArvore() {
        return this.aplicativo.getAreaArvore();
    }

    public Component getArvore() {
        return this.aplicativo.getArvore();
    }

    public Component getToolbar() {
        return this.aplicativo.getToolbar();
    }

    public Component getPainelSplit() {
        return this.aplicativo.getPainelSplit();
    }

    public void escondeSplit() {
        this.getPainelSplit().setVisible(false);
        this.getJanelaPrincipal().validate();
    }

    public void exibeSplit() {
        this.getPainelSplit().setVisible(true);
        this.getJanelaPrincipal().validate();
    }

    public void aplicaMenuBar(String aXml) {
    }

    public void aplicaArvore(String aFonteArvore) {
        JScrollPane areaArvore = (JScrollPane)this.getAreaArvore();
        if (!aFonteArvore.endsWith(".xml")) {
            try {
                Class<?> c = Class.forName(aFonteArvore);
                areaArvore.setViewportView((Component)c.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Component getComponent(String aNome) {
        return this.aplicativo.getComponent(aNome);
    }

    public void mudaPainelExibido(JPanel painelAcionado) {
        Container areaPaineis = (Container)this.getAreaPaineis();
        areaPaineis.removeAll();
        areaPaineis.add(painelAcionado);
        areaPaineis.validate();
        areaPaineis.repaint();
        this.getScrollAreaPaineis().repaint();
        ((JScrollPane)this.getScrollAreaPaineis()).revalidate();
    }

    public void componentEnabled(String id, boolean enabled) {
        this.aplicativo.getComponent(id).setEnabled(enabled);
    }

    public void componentVisible(String id, boolean visible) {
        this.aplicativo.getComponent(id).setVisible(visible);
    }

    public void exibeDialog(JPanel p, String titulo, boolean modal) {
        JDialog dialogo = new JDialog(this.getJanelaPrincipal(), titulo, modal);
        dialogo.getContentPane().add(p);
        dialogo.setSize(dialogo.getPreferredSize());
        dialogo.setResizable(false);
        dialogo.setLocationRelativeTo(null);
        dialogo.pack();
        dialogo.setVisible(true);
    }

    public int exibeDialogOpcoes(String titulo, String texto, String[] opcoes, boolean modal) {
        return -1;
    }

    public JPanel instanciaPainel(String painelStr) throws Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        JPanel painelInstanciado = null;
        if (!painelStr.endsWith(".xml") && painelStr.trim().length() > 0) {
            Class<?> c = Class.forName(painelStr);
            painelInstanciado = (JPanel)c.newInstance();
        }
        return painelInstanciado;
    }

    public void limpaPainelPrincipal() {
        this.componentVisible("splitPPGD", false);
    }

    public void mostraPainelPrincipal() {
        this.componentVisible("splitPPGD", true);
    }

    public void desabilitaComponentes(String[] componentes) {
        for (int i = 0; i < componentes.length; ++i) {
            this.componentEnabled(componentes[i], false);
        }
    }

    public void habilitaComponentes(String[] componentes) {
        for (int i = 0; i < componentes.length; ++i) {
            this.componentEnabled(componentes[i], true);
        }
    }

    public boolean temDeclaracoes() {
        try {
            String classeFacade = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.facade", "serpro.ppgd.repositorio.FacadeDefault");
            Class<?> classe = Class.forName(classeFacade);
            Method methGetInstancia = classe.getMethod("getInstancia", new Class[0]);
            PPGDFacade facade = (PPGDFacade)methGetInstancia.invoke(null, new Object[0]);
            Method methExisteDeclaracoes = classe.getMethod("existeDeclaracoes", new Class[0]);
            return (Boolean)methExisteDeclaracoes.invoke((Object)facade, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void acionaAjuda() {
        if (this.listPdfHelp != null) {
            this.listPdfHelp.get(0).acionaAjuda();
        }
    }

    public void acionaAjuda(String marcador) {
        if (this.listPdfHelp != null) {
            this.listPdfHelp.get(0).acionaAjuda(marcador);
        }
    }

    protected void carregaHelp() {
        String helpSetNameOrPDF = FabricaUtilitarios.getProperties().getProperty("help", "");
        String defaultHelpID = FabricaUtilitarios.getProperties().getProperty("help.default.id", "");
        boolean bl = this.isAjudaJavaHelp = !helpSetNameOrPDF.trim().endsWith(".pdf");
        if (!this.isAjudaJavaHelp) {
            String[] pdfFiles;
            this.listPdfHelp = new ArrayList();
            for (String file : pdfFiles = helpSetNameOrPDF.split(",")) {
                PDFHelp pdfHelp = new PDFHelp(file);
                this.listPdfHelp.add(pdfHelp);
            }
        } else if (!helpSetNameOrPDF.equals("")) {
            this.help = new HelpUtil(this.getJanelaPrincipal().getRootPane(), defaultHelpID);
            this.help.setHelpSet(helpSetNameOrPDF);
        }
    }

    public static void setEmDesign(boolean emDesign) {
        PlataformaPPGD.emDesign = emDesign;
    }

    public static boolean isEmDesign() {
        return emDesign;
    }

    public void setComportamentoPadraoSair(boolean comportamentoPadraoSair) {
        this.comportamentoPadraoSair = comportamentoPadraoSair;
    }

    public boolean isComportamentoPadraoSair() {
        return this.comportamentoPadraoSair;
    }

    public void adequarToolbarEsplitAcessiveis(boolean modoAcessivelHabilitado) {
    }

    public JanelaPrincipalPPGD getAplicativo() {
        return this.aplicativo;
    }

    public void setAplicativo(JanelaPrincipalPPGD aplicativo) {
        this.aplicativo = aplicativo;
    }
}

