/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import jsignnet.aplicacao.JSignNet;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.JSignException;
import jsignnet.infra.Recursos;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.X509Name;

public final class X509CertificadoUtil {
    private static final String X509_CERT_TYPE = "X.509";
    private static final String AUTHORITY_KEY_IDENTIFIER_OID = "2.5.29.35";
    private static final String SUBJECT_ALTERNATIVE_NAME_OID = "2.5.29.17";
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private static final String EXTENDED_KEY_USAGE_OID = "2.5.29.37";

    private X509CertificadoUtil() {
    }

    public static X509Certificate[] converteCertificados(Certificate[] arrayCertificados) throws CertificateException {
        X509Certificate[] resposta = new X509Certificate[arrayCertificados.length];
        for (int i = 0; i < arrayCertificados.length; ++i) {
            resposta[i] = X509CertificadoUtil.converteCertificado(arrayCertificados[i]);
        }
        return resposta;
    }

    public static X509Certificate converteCertificado(Certificate certIn) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance(X509_CERT_TYPE);
        ByteArrayInputStream stream = new ByteArrayInputStream(certIn.getEncoded());
        return (X509Certificate)cf.generateCertificate(stream);
    }

    public static String getIdentificadorChaveAutoridade(X509Certificate certificado) throws IOException {
        byte[] extensionValue = certificado.getExtensionValue(AUTHORITY_KEY_IDENTIFIER_OID);
        if (extensionValue == null) {
            return "";
        }
        byte[] bOctets = ((DEROctetString)X509CertificadoUtil.toDER(extensionValue)).getOctets();
        ASN1Sequence asn1Seq = (ASN1Sequence)X509CertificadoUtil.toDER(bOctets);
        ASN1OctetString chaveIdentificacao = null;
        ASN1Sequence autoridadeCertificadoraASN1 = null;
        ASN1OctetString numeroSerialCertificado = null;
        int tamanho = asn1Seq.size();
        block5: for (int i = 0; i < tamanho; ++i) {
            DERTaggedObject derTagObjeto = (DERTaggedObject)asn1Seq.getObjectAt(i);
            DERObject derObjeto = derTagObjeto.getObject();
            switch (derTagObjeto.getTagNo()) {
                case 0: {
                    chaveIdentificacao = (DEROctetString)derObjeto;
                    continue block5;
                }
                case 1: {
                    if (derObjeto instanceof ASN1Sequence) {
                        autoridadeCertificadoraASN1 = (ASN1Sequence)derObjeto;
                        continue block5;
                    }
                    autoridadeCertificadoraASN1 = new DERSequence(derObjeto);
                    continue block5;
                }
                case 2: {
                    numeroSerialCertificado = (DEROctetString)derObjeto;
                }
            }
        }
        StringBuffer resposta = new StringBuffer();
        if (chaveIdentificacao != null) {
            byte[] bKeyIdent = chaveIdentificacao.getOctets();
            resposta.append(MessageFormat.format("Chave: {0}", X509CertificadoUtil.converteByteParaStringHexa(bKeyIdent)));
            resposta.append('\n');
        }
        if (autoridadeCertificadoraASN1 != null) {
            resposta.append("contato");
            resposta.append('\n');
            int len = autoridadeCertificadoraASN1.size();
            for (int i = 0; i < len; ++i) {
                DERTaggedObject generalName = (DERTaggedObject)autoridadeCertificadoraASN1.getObjectAt(i);
                resposta.append('\t');
                resposta.append(X509CertificadoUtil.getNome(generalName));
                resposta.append('\n');
            }
        }
        if (numeroSerialCertificado != null) {
            byte[] bCertSerialNumber = numeroSerialCertificado.getOctets();
            resposta.append(MessageFormat.format("N\u00famero Serial {0}", X509CertificadoUtil.converteByteParaStringHexa(bCertSerialNumber)));
            resposta.append('\n');
        }
        return resposta.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DERObject toDER(byte[] bytes) throws IOException {
        ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(bytes));
        try {
            DERObject dERObject = in.readObject();
            return dERObject;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String converteByteParaStringHexa(DERInteger inteiroDER) {
        String numeroControle = inteiroDER.getValue().toString(16).toUpperCase();
        StringBuffer resposta = new StringBuffer();
        for (int i = 0; i < numeroControle.length(); ++i) {
            resposta.append(numeroControle.charAt(i));
            if ((i + 1) % 4 != 0 || i + 1 == numeroControle.length()) continue;
            resposta.append(' ');
        }
        return resposta.toString();
    }

    private static String converteByteParaStringHexa(byte[] bytes) {
        StringBuffer resposta = new StringBuffer(new BigInteger(1, bytes).toString(16).toUpperCase());
        if (resposta.length() > 4) {
            for (int i = 4; i < resposta.length(); i += 5) {
                resposta.insert(i, ' ');
            }
        }
        return resposta.toString();
    }

    private static String getNome(DERTaggedObject nomeDER) {
        StringBuffer resposta = new StringBuffer();
        switch (nomeDER.getTagNo()) {
            case 0: {
                ASN1Sequence objetoASN1 = (ASN1Sequence)nomeDER.getObject();
                String sOid = ((DERObjectIdentifier)objetoASN1.getObjectAt(0)).getId();
                String sVal = X509CertificadoUtil.converteObjetoEmHex(objetoASN1.getObjectAt(1));
                resposta.append(MessageFormat.format(Recursos.getString("OutrosNomes"), sOid, sVal));
                break;
            }
            case 1: {
                DEROctetString rfc822 = (DEROctetString)nomeDER.getObject();
                String sRfc822 = new String(rfc822.getOctets());
                resposta.append(MessageFormat.format(Recursos.getString("NomeRfc822"), sRfc822));
                break;
            }
            case 2: {
                DEROctetString dns = (DEROctetString)nomeDER.getObject();
                String sDns = new String(dns.getOctets());
                resposta.append(MessageFormat.format(Recursos.getString("NomeDNS"), sDns));
                break;
            }
            case 4: {
                ASN1Sequence diretorioASN1 = (ASN1Sequence)nomeDER.getObject();
                X509Name nome = new X509Name(diretorioASN1);
                resposta.append(MessageFormat.format(Recursos.getString("NomeDiretorio"), nome.toString()));
                break;
            }
            case 6: {
                DEROctetString uri = (DEROctetString)nomeDER.getObject();
                String sUri = new String(uri.getOctets());
                resposta.append(MessageFormat.format(Recursos.getString("NomeURI"), sUri));
                break;
            }
            case 7: {
                DEROctetString enderecoIp = (DEROctetString)nomeDER.getObject();
                byte[] ip = enderecoIp.getOctets();
                StringBuffer ipString = new StringBuffer();
                byte j = 0;
                int bl = ip.length;
                for (int i = 0; i < bl; ++i) {
                    j = ip[i];
                    ipString.append(j & 0xFF);
                    if (i + 1 >= ip.length) continue;
                    ipString.append('.');
                }
                resposta.append(MessageFormat.format(Recursos.getString("EnderecoIp"), ipString.toString()));
                break;
            }
            case 8: {
                DEROctetString idRegistro = (DEROctetString)nomeDER.getObject();
                byte[] idRegistroByte = idRegistro.getOctets();
                StringBuffer idRegistroString = new StringBuffer();
                for (int i = 0; i < idRegistroByte.length; ++i) {
                    byte b = idRegistroByte[i];
                    idRegistroString.append(b & 0xFF);
                    if (i + 1 >= idRegistroByte.length) continue;
                    idRegistroString.append('.');
                }
                resposta.append(MessageFormat.format(Recursos.getString("IdRegistro"), idRegistroString.toString()));
                break;
            }
            default: {
                resposta.append(MessageFormat.format(Recursos.getString("TipoNaoSuportado"), "" + nomeDER.getTagNo()));
            }
        }
        return resposta.toString();
    }

    public static String getNomesAlternativosSujeito(X509Certificate certificado) throws IOException {
        byte[] extensao = certificado.getExtensionValue(SUBJECT_ALTERNATIVE_NAME_OID);
        if (extensao == null) {
            return "";
        }
        byte[] octetos = ((DEROctetString)X509CertificadoUtil.toDER(extensao)).getOctets();
        ASN1Sequence nomes = (ASN1Sequence)X509CertificadoUtil.toDER(octetos);
        StringBuffer resposta = new StringBuffer();
        int len = nomes.size();
        for (int i = 0; i < len; ++i) {
            resposta.append(X509CertificadoUtil.getNome((DERTaggedObject)nomes.getObjectAt(i)));
            resposta.append('\n');
        }
        return resposta.toString();
    }

    public static String getNomesAlternativosSujeito(X509Certificate certificado, String oid) throws IOException {
        String resposta = "";
        byte[] extensao = certificado.getExtensionValue(SUBJECT_ALTERNATIVE_NAME_OID);
        if (extensao != null) {
            byte[] octetos = ((DEROctetString)X509CertificadoUtil.toDER(extensao)).getOctets();
            ASN1Sequence generalNames = (ASN1Sequence)X509CertificadoUtil.toDER(octetos);
            boolean tagTipoOtherName = false;
            int len = generalNames.size();
            for (int i = 0; i < len; ++i) {
                DERTaggedObject umGeneralName = (DERTaggedObject)generalNames.getObjectAt(i);
                if (umGeneralName.getTagNo() != 0) continue;
                ASN1Sequence objetoCodificadoASN1 = (ASN1Sequence)umGeneralName.getObject();
                boolean posOID = false;
                String sOid = ((DERObjectIdentifier)objetoCodificadoASN1.getObjectAt(0)).getId();
                if (!sOid.equals(oid)) continue;
                boolean posEnvelopeValor = true;
                ASN1TaggedObject envelopeValor = (ASN1TaggedObject)objetoCodificadoASN1.getObjectAt(1);
                DERObject valor = envelopeValor.getObject();
                if (valor instanceof DERPrintableString) {
                    resposta = DERPrintableString.getInstance(valor).getString();
                    break;
                }
                resposta = DERUTF8String.getInstance(valor).getString();
                break;
            }
        }
        return resposta;
    }

    private static String converteObjetoEmHex(Object objeto) {
        if (objeto instanceof DERString) {
            return ((DERString)objeto).getString();
        }
        if (objeto instanceof DERInteger) {
            return X509CertificadoUtil.converteByteParaStringHexa((DERInteger)objeto);
        }
        if (objeto instanceof byte[]) {
            return X509CertificadoUtil.converteByteParaStringHexa((byte[])objeto);
        }
        if (objeto instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)objeto;
            return "[" + tagObj.getTagNo() + "] " + X509CertificadoUtil.converteObjetoEmHex(tagObj.getObject());
        }
        DERUTF8String resposta = DERUTF8String.getInstance(objeto);
        return resposta.getString();
    }

    public static String getUsoChave(X509Certificate certificado) throws IOException {
        byte[] extensao = certificado.getExtensionValue(KEY_USAGE_OID);
        if (extensao == null) {
            return "";
        }
        byte[] octetos = ((DEROctetString)X509CertificadoUtil.toDER(extensao)).getOctets();
        DERBitString derBitString = (DERBitString)X509CertificadoUtil.toDER(octetos);
        StringBuffer resposta = new StringBuffer();
        byte[] arrayBytes = derBitString.getBytes();
        boolean keyAgreement = false;
        for (int i = 0; i < arrayBytes.length; ++i) {
            boolean[] b = new boolean[8];
            b[7] = (arrayBytes[i] & 0x80) == 128;
            b[6] = (arrayBytes[i] & 0x40) == 64;
            b[5] = (arrayBytes[i] & 0x20) == 32;
            b[4] = (arrayBytes[i] & 0x10) == 16;
            b[3] = (arrayBytes[i] & 8) == 8;
            b[2] = (arrayBytes[i] & 4) == 4;
            b[1] = (arrayBytes[i] & 2) == 2;
            boolean bl = b[0] = (arrayBytes[i] & 1) == 1;
            if (i == 0) {
                if (b[7]) {
                    resposta.append(Recursos.getString("DigitalSignatureKeyUsageString"));
                    resposta.append('\n');
                }
                if (b[6]) {
                    resposta.append(Recursos.getString("NonRepudiationKeyUsageString"));
                    resposta.append('\n');
                }
                if (b[5]) {
                    resposta.append(Recursos.getString("KeyEnciphermentKeyUsageString"));
                    resposta.append('\n');
                }
                if (b[4]) {
                    resposta.append(Recursos.getString("DataEnciphermentKeyUsageString"));
                    resposta.append('\n');
                }
                if (b[3]) {
                    resposta.append(Recursos.getString("KeyAgreementKeyUsageString"));
                    resposta.append('\n');
                    keyAgreement = true;
                }
                if (b[2]) {
                    resposta.append(Recursos.getString("KeyCertSignKeyUsageString"));
                    resposta.append('\n');
                }
                if (b[1]) {
                    resposta.append(Recursos.getString("CrlSignKeyUsageString"));
                    resposta.append('\n');
                }
                if (!b[0] || !keyAgreement) continue;
                resposta.append(Recursos.getString("EncipherOnlyKeyUsageString"));
                resposta.append('\n');
                continue;
            }
            if (i != 1 || !b[7] || !keyAgreement) continue;
            resposta.append(Recursos.getString("DecipherOnlyKeyUsageString"));
            resposta.append('\n');
        }
        return resposta.toString();
    }

    public static String getUsoExtendidoChave(X509Certificate certificado) throws IOException {
        byte[] extensao = certificado.getExtensionValue(EXTENDED_KEY_USAGE_OID);
        if (extensao == null) {
            return "";
        }
        byte[] octetos = ((DEROctetString)X509CertificadoUtil.toDER(extensao)).getOctets();
        ASN1Sequence sequenciaASN1 = (ASN1Sequence)X509CertificadoUtil.toDER(octetos);
        StringBuffer resposta = new StringBuffer();
        String descricaoRecurso = null;
        int len = sequenciaASN1.size();
        for (int i = 0; i < len; ++i) {
            String oid = ((DERObjectIdentifier)sequenciaASN1.getObjectAt(i)).getId();
            try {
                descricaoRecurso = Recursos.getString(oid);
            }
            catch (MissingResourceException e) {
                descricaoRecurso = Recursos.getString("RecursoDesconhecido");
            }
            resposta.append(MessageFormat.format(descricaoRecurso, oid));
            resposta.append('\n');
        }
        return resposta.toString();
    }

    public static X509CertificadoWrapper certificadoFromBytes(byte[] dados) throws JSignException {
        try {
            ASN1InputStream ain = new ASN1InputStream(dados);
            Certificate cert = CertificateFactory.getInstance("X509", "BC").generateCertificate(ain);
            return new X509CertificadoWrapper(X509CertificadoUtil.converteCertificado(cert));
        }
        catch (Exception e) {
            JSignNet.logger.severe("Erro no processo de parsing do certificado: " + e.getMessage());
            throw new JSignException(e, "Erro no processo de parsing do certificado: " + e.getMessage());
        }
    }
}

