/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos;

import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.formatosexternos.RelatorioXML;
import serpro.ppgd.gui.NavegadorHtml;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class RelatorioMultiploXML
implements RelatorioIf {
    private List<RelatorioXML> relatorios = new ArrayList<RelatorioXML>();
    private List<DuplaParam> parametros = new ArrayList<DuplaParam>();
    private String titulo;
    private String nomeArquivo;
    private JasperPrint jasperPrint;
    private boolean preparado = false;
    private String PARAM_PAG_INICIAL = "pagInicial";

    public RelatorioMultiploXML(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, String nomeArquivo) {
        this.titulo = aTitulo;
        this.nomeArquivo = nomeArquivo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz));
    }

    public RelatorioMultiploXML(String aTitulo, String aRelatorioJasper, String nomeArquivo) {
        this.titulo = aTitulo;
        this.nomeArquivo = nomeArquivo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper));
    }

    public RelatorioMultiploXML(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        this.titulo = aTitulo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz));
    }

    public RelatorioMultiploXML(String aTitulo, String aRelatorioJasper) {
        this.titulo = aTitulo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper));
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            Object valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.getRelatorios().add(novoRelatorio);
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            Object valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.getRelatorios().add(novoRelatorio);
    }

    @Override
    public void imprimir() {
        try {
            this.prepara();
            JasperPrintManager.printReport((JasperPrint)this.jasperPrint, (boolean)false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void gerarPDF() {
        try {
            this.prepara();
            byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)this.jasperPrint);
            String nomeArq = null;
            String separador = System.getProperty("file.separator");
            if (this.nomeArquivo != null) {
                nomeArq = this.nomeArquivo;
            } else {
                long diferenciador = new Date().getTime();
                nomeArq = "relatorio" + diferenciador + ".pdf";
            }
            String caminho = UtilitariosArquivo.getPathDados() + separador + nomeArq;
            FileOutputStream stream = new FileOutputStream(caminho);
            stream.write(bytes);
            stream.close();
            NavegadorHtml.executarNavegador((String)("file://" + UtilitariosArquivo.getPathDados() + separador + this.nomeArquivo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prepara() {
        if (!this.isPreparado()) {
            int pageCount = 1;
            this.jasperPrint = new JasperPrint();
            int y = this.getRelatorios().size();
            for (int x = 0; x < y; ++x) {
                this.addParametro(this.PARAM_PAG_INICIAL, String.valueOf(pageCount), x);
                JasperPrint printTmp = this.getRelatorios().get(x).obterPaginas();
                List lista = printTmp.getPages();
                pageCount += lista.size();
                if (x == 0) {
                    this.jasperPrint = printTmp;
                    continue;
                }
                for (int i = 0; i < lista.size(); ++i) {
                    this.jasperPrint.addPage((JRPrintPage)lista.get(i));
                }
            }
            this.preparado = true;
        }
    }

    @Override
    public void visualizar() {
        this.prepara();
        if (this.nomeArquivo != null) {
            this.jasperPrint.setName(this.nomeArquivo);
        }
        PPGDJasperViewer viewer = new PPGDJasperViewer(this.jasperPrint, false, new Locale("pt", "BR"));
        viewer.setTitle(this.getTitulo());
        viewer.setIconImage(Frame.getFrames()[0].getIconImage());
        viewer.setVisible(true);
        viewer.addWindowFocusListener(new WindowFocusListener(){
            private boolean firstLost = true;

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (this.firstLost) {
                    e.getWindow().toFront();
                    this.firstLost = false;
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
    }

    public void addParametro(String nome, String valor) {
        for (int x = 0; x < this.getRelatorios().size(); ++x) {
            this.getRelatorios().get(x).addParametro(nome, valor);
        }
        this.parametros.add(new DuplaParam(nome, valor));
    }

    public void addParametro(String nome, String valor, int indice) {
        this.getRelatorios().get(indice).addParametro(nome, valor);
    }

    public void addParametro(String nome, Object valor) {
        for (int x = 0; x < this.getRelatorios().size(); ++x) {
            this.getRelatorios().get(x).addParametro(nome, valor);
        }
        this.parametros.add(new DuplaParam(nome, valor));
    }

    public void addParametroUltimo(String nome, String valor) {
        this.getRelatorios().get(this.getRelatorios().size() - 1).addParametro(nome, valor);
    }

    public List<DuplaParam> getAllParametro() {
        return this.parametros;
    }

    @Override
    public String getTitulo() {
        return this.titulo;
    }

    @Override
    public void setTitulo(String aTitulo) {
        this.titulo = aTitulo;
    }

    @Override
    public boolean isHabilitado() {
        return false;
    }

    @Override
    public void setHabilitado(boolean aHabilitado) {
    }

    @Override
    public boolean isPreparado() {
        return this.preparado;
    }

    public int getQtdPaginas() {
        int qtd = -1;
        if (this.isPreparado()) {
            qtd = this.jasperPrint.getPages().size();
        }
        return qtd;
    }

    public void setRelatorios(List<RelatorioXML> relatorios) {
        this.relatorios = relatorios;
    }

    public List<RelatorioXML> getRelatorios() {
        return this.relatorios;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    private class DuplaParam {
        String nome;
        Object valor;

        public String getNome() {
            return this.nome;
        }

        public void setNome(String nome) {
            this.nome = nome;
        }

        public Object getValor() {
            return this.valor;
        }

        public void setValor(Object valor) {
            this.valor = valor;
        }

        public DuplaParam(String nome, Object valor) {
            this.nome = nome;
            this.valor = valor;
        }
    }
}

