/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.hash;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.hash.excecao.HashIncorretoException;
import serpro.util.PLong;

public class UtilitariosHash {
    public static void geraCRCArquivo(String pArquivo, String pArquiHash, String codificacao) throws HashIncorretoException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        String hashCalculado = null;
        long hashCalculadoLinhaAnterior = 0L;
        try {
            String linha;
            BufferedReader in = null;
            in = codificacao != null ? new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(pArquivo), codificacao)) : new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(pArquivo)));
            while ((linha = in.readLine()) != null) {
                long hash;
                if (hashCalculadoLinhaAnterior != 0L) {
                    pLong.setValue(hashCalculadoLinhaAnterior);
                }
                hashCalculadoLinhaAnterior = hash = crc32.CalcCrc32(linha, linha.length(), pLong);
                hashCalculado = crc32.getStrCrc32();
            }
            in.close();
            File arqHash = new File(pArquiHash);
            if (arqHash.exists()) {
                arqHash.delete();
            }
            arqHash.createNewFile();
            BufferedWriter outHsh = null;
            outHsh = codificacao != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(arqHash), codificacao)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(arqHash)));
            outHsh.write(hashCalculado);
            outHsh.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HashIncorretoException(e);
        }
    }

    public static void validarCRCArquivo(String pArquivo, String pArquiHash, String codificacao) throws HashIncorretoException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        String hashCalculado = null;
        long hashCalculadoLinhaAnterior = 0L;
        String hashLido = "";
        try {
            String linha;
            BufferedReader inHsh = null;
            inHsh = codificacao != null ? new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(pArquiHash), codificacao)) : new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(pArquiHash)));
            hashLido = inHsh.readLine();
            BufferedReader in = null;
            in = codificacao != null ? new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(pArquivo), codificacao)) : new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(pArquivo)));
            while ((linha = in.readLine()) != null) {
                long hash;
                if (hashCalculadoLinhaAnterior != 0L) {
                    pLong.setValue(hashCalculadoLinhaAnterior);
                }
                hashCalculadoLinhaAnterior = hash = crc32.CalcCrc32(linha, linha.length(), pLong);
                hashCalculado = crc32.getStrCrc32();
            }
            in.close();
            inHsh.close();
            if (!hashLido.equals(hashCalculado)) {
                throw new HashIncorretoException("As informa\u00e7\u00f5es da declara\u00e7\u00e3o foram corrompidas ap\u00f3s sua grava\u00e7\u00e3o no registro.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HashIncorretoException(e);
        }
    }
}

