/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.acoes;

import br.gov.serpro.gcap.acoes.ActionAb;
import br.gov.serpro.gcap.acoes.VerificarPendenciasAction;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.dialogs.PainelImprimirDemonstrativo;
import br.gov.serpro.gcap.gui.dialogs.PainelSelecionarImpressaoDarfMoedaEspecie;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class ImprimirDarfMoedaEspecieAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    private static final int DARF_MOEDAS_ESPECIE = 2;
    private VerificarPendenciasAction verificarPendencias = new VerificarPendenciasAction();
    private VerificarPendenciasAction.PendenciasDemonstrativo pendenciasDemonstrativo;
    private IdDemonstrativoGCAP idSelecionado = null;

    @Override
    public void executarAcao(ActionEvent e) {
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImprimirDarfMoedaEspecieAction.this.visualizarDarf(ControladorGui.getDemonstrativoAberto());
                    }
                });
            } else {
                RetornoValidacao validacao;
                if (this.idSelecionado == null) {
                    PainelImprimirDemonstrativo painelImprimirDemonstrativo = new PainelImprimirDemonstrativo(2);
                    GuiUtil.exibeDialog(painelImprimirDemonstrativo, true, MensagemUtil.getMensagem("ImpressaoDarf"), false);
                    this.idSelecionado = painelImprimirDemonstrativo.getIdSelecionado();
                }
                if ((validacao = this.idSelecionado.getTerritorioParaisoFiscal().validar().getPrimeiroRetornoValidacaoMaisSevero()).isValido()) {
                    GCAPFacade.getInstancia();
                    GCAPFacade.abreDeclaracao(this.idSelecionado);
                    this.visualizarDarf(GCAPFacade.getInstancia().getDeclaracao());
                    if (!ControladorGui.isDemonstrativoAberto()) {
                        GCAPFacade.getInstancia();
                        GCAPFacade.fechaDeclaracao();
                    }
                } else {
                    GuiUtil.mostrarAviso("demonstrativoDesatualizado");
                }
                this.idSelecionado = null;
            }
        }
        catch (Exception pE) {
            ControladorGui.tratarException(pE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visualizarDarf(DemonstrativoGCAP demonstrativo) {
        if (demonstrativo.getMoedasAlienadas().isVazio()) {
            GuiUtil.mostrarAviso("NaoExistemDadosRelatorioDarf");
            return;
        }
        if (!this.temPendencia(demonstrativo.getMoedasAlienadas())) {
            PainelSelecionarImpressaoDarfMoedaEspecie painelSelecionarImpressao = new PainelSelecionarImpressaoDarfMoedaEspecie(demonstrativo);
            String mensagem = MensagemUtil.getMensagem("ImpressaoDarf");
            GuiUtil.exibeDialog(painelSelecionarImpressao, true, mensagem, false);
            return;
        }
        GuiUtil.mostrarAviso("ErroImprimirDarfErrosImpeditivos");
    }

    private boolean temPendencia(ColecaoMoedaAlienada moedaAlienada) {
        List listaPendencias = FabricaUtilitarios.verificarPendencias((Object)((Object)moedaAlienada));
        ArrayList<Pendencia> listaPendenciasDemonstrativo = new ArrayList<Pendencia>();
        for (Pendencia pendencia : listaPendencias) {
            if (pendencia.getSeveridade() != 3) continue;
            listaPendenciasDemonstrativo.add(pendencia);
        }
        if (listaPendenciasDemonstrativo.size() > 0) {
            VerificarPendenciasAction verificarPendenciasAction = this.verificarPendencias;
            Objects.requireNonNull(verificarPendenciasAction);
            this.pendenciasDemonstrativo = new VerificarPendenciasAction.PendenciasDemonstrativo(verificarPendenciasAction, listaPendenciasDemonstrativo, 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFecharDemonstrativoExigido() {
        if (ControladorGui.isDemonstrativoAberto()) {
            this.idSelecionado = ControladorGui.getDemonstrativoAberto().getIdDemonstrativo();
        }
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDemonstrativo() {
        return "ConfirmarFecharDemonstrativo";
    }
}

