/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades;

import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.identificacao.PainelIdentificacao;
import br.gov.serpro.gcap.observador.ObservadorEspacosDuplicados;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorData;
import br.gov.serpro.gcap.validador.ValidadorDataFimAnteriorDataInicio;
import br.gov.serpro.gcap.validador.ValidadorDataNoExercicio;
import br.gov.serpro.gcap.validador.ValidadorNomePessoaFisica;
import java.io.File;
import java.util.List;
import serpro.ppgd.infraestrutura.eventos.BarramentoEventos;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class IdDemonstrativoGCAP
extends ObjetoNegocio
implements IdentificadorDeclaracaoXML,
ObjetoFicha {
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF");
    private DataHora dataUltimoAcesso = new DataHora((ObjetoNegocio)this, "Data \u00daltimo Acesso");
    private Alfa exercicio = new Alfa((ObjetoNegocio)this, "Exerc\u00edcio", 4);
    private Data dataInicioPermanencia = new Data((ObjetoNegocio)this, "Data Inicio Perman\u00eancia");
    private Data dataFimPermanencia = new Data((ObjetoNegocio)this, "Data Fim Perman\u00eancia");
    private Codigo paisDeclarante = new Codigo((ObjetoNegocio)this, "Pais Declarante", CadastroTabelasGCAP.recuperarPaises());
    private Alfa telefoneDeclarante = new Alfa((ObjetoNegocio)this, "Telefone Declarante", 10);
    private Alfa dddDeclarante = new Alfa((ObjetoNegocio)this, "Telefone Declarante", 2);
    private Logico territorioParaisoFiscal = new Logico((ObjetoNegocio)this, "Territ\u00f3rio Para\u00edso Fiscal");

    public IdDemonstrativoGCAP() {
        this.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        BarramentoEventos.getInstancia().registraOutput((Object)this);
        this.adicionarValidadores();
        this.setFicha("Ganho de Capital - Identifica\u00e7\u00e3o do Contribuinte");
    }

    private void adicionarValidadores() {
        this.cpf.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.cpf.getNomeCampo()})));
        this.cpf.addValidador((ValidadorIf)new ValidadorCPF(3));
        this.nome.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.nome.getNomeCampo()})));
        this.nome.addValidador((ValidadorIf)new ValidadorNomePessoaFisica(3));
        this.nome.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.paisDeclarante.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.paisDeclarante.getNomeCampo()})));
        this.dataInicioPermanencia.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.dataInicioPermanencia.getNomeCampo()})));
        this.dataInicioPermanencia.addValidador((ValidadorIf)new ValidadorData(3));
        this.dataInicioPermanencia.addValidador((ValidadorIf)new ValidadorDataNoExercicio(3));
        this.dataFimPermanencia.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.dataFimPermanencia.getNomeCampo()})));
        this.dataFimPermanencia.addValidador((ValidadorIf)new ValidadorData(3));
        this.dataFimPermanencia.addValidador((ValidadorIf)new ValidadorDataNoExercicio(3));
        this.dataFimPermanencia.addValidador((ValidadorIf)new ValidadorDataFimAnteriorDataInicio(this.dataInicioPermanencia, this.dataFimPermanencia, 3));
        this.territorioParaisoFiscal.addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (IdDemonstrativoGCAP.this.paisTemTerritorioParaisoFiscal() && IdDemonstrativoGCAP.this.getTerritorioParaisoFiscal().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("perguntaEmBranco", new String[]{"\u00c9 residente de " + IdDemonstrativoGCAP.this.getPaisDeclarante().getConteudoAtual(3) + "?"}));
                }
                return new RetornoValidacao(0);
            }
        });
    }

    public Alfa getNome() {
        return this.nome;
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Alfa getExercicio() {
        return this.exercicio;
    }

    public DataHora getDataUltimoAcesso() {
        return this.dataUltimoAcesso;
    }

    public Data getDataInicioPermanencia() {
        return this.dataInicioPermanencia;
    }

    public Data getDataFimPermanencia() {
        return this.dataFimPermanencia;
    }

    public Codigo getPaisDeclarante() {
        return this.paisDeclarante;
    }

    public Alfa getTelefoneDeclarante() {
        return this.telefoneDeclarante;
    }

    public Alfa getDddDeclarante() {
        return this.dddDeclarante;
    }

    public Logico getTerritorioParaisoFiscal() {
        return this.territorioParaisoFiscal;
    }

    public String getPathArquivo() {
        String diretorioDadosApp = GcapUtil.DIR_DADOS;
        String path = diretorioDadosApp + "/" + this.cpf.naoFormatado();
        File flDados = new File(path);
        if (!flDados.exists()) {
            flDados.mkdirs();
        }
        StringBuffer nomeArquivoDec = new StringBuffer();
        nomeArquivoDec.append(path);
        nomeArquivoDec.append("/" + this.getNomeArquivo());
        nomeArquivoDec.append(".xml");
        return nomeArquivoDec.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof IdDemonstrativoGCAP && ((IdDemonstrativoGCAP)((Object)obj)).getCpf().naoFormatado().equals(this.getCpf().naoFormatado()) && ((IdDemonstrativoGCAP)((Object)obj)).getDataInicioPermanencia().naoFormatado().equals(this.getDataInicioPermanencia().naoFormatado()) && ((IdDemonstrativoGCAP)((Object)obj)).getDataFimPermanencia().naoFormatado().equals(this.getDataFimPermanencia().naoFormatado());
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarCamposInformacao();
        retorno.add(this.getNome());
        retorno.add(this.getCpf());
        return retorno;
    }

    public String getClasseFicha() {
        return PainelIdentificacao.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getNomeArquivo() {
        IdDemonstrativoGCAP idSelecionado = this;
        if (idSelecionado.getDataInicioPermanencia().isVazio()) {
            idSelecionado = ControladorGui.getDemonstrativoAberto().getIdDemonstrativo();
        }
        String strInicio = idSelecionado.getDataInicioPermanencia().getDia() + idSelecionado.getDataInicioPermanencia().getMes();
        String strFim = idSelecionado.getDataFimPermanencia().getDia() + idSelecionado.getDataFimPermanencia().getMes();
        return idSelecionado.getCpf().naoFormatado() + "-" + strInicio + "-" + strFim + "-" + ConstantesGlobais.NOME_PROGRAMA + "-" + ConstantesGlobais.EXERCICIO;
    }

    public boolean isDemonstrativoBrasil() {
        return "105".equals(this.getPaisDeclarante().getConteudoAtual(0));
    }

    public boolean isDemonstrativoExterior() {
        return !"105".equals(this.getPaisDeclarante().getConteudoAtual(0));
    }

    public boolean paisTemTerritorioParaisoFiscal() {
        return !this.paisDeclarante.isVazio() && !"".equals(this.paisDeclarante.getConteudoAtual(3).trim());
    }

    public boolean isParaisoFiscal() {
        return this.getPaisDeclarante().getConteudoAtual(2).equals(Logico.SIM);
    }

    public boolean isTerritorioParaisoFiscal() {
        return this.getTerritorioParaisoFiscal().naoFormatado().equals(Logico.SIM);
    }
}

