/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.apuracao.ApuracaoBemImovel;
import br.gov.serpro.gcap.entidades.apuracao.ParcelaApuracaoCustoAquisicao;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.entidades.aquisicao.ParcelaAquisicao;
import br.gov.serpro.gcap.entidades.bensimoveis.BemImovel;
import br.gov.serpro.gcap.entidades.calculo.ValidadorCorretagemTotalExcedida;
import br.gov.serpro.gcap.entidades.consolidacao.ObservadorCalculoConsolidacaoBemImovel;
import br.gov.serpro.gcap.entidades.perguntas.PerguntasImovel;
import br.gov.serpro.gcap.entidades.perguntas.PerguntasUtil;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.bensimoveis.PainelListaBemImovel;
import br.gov.serpro.gcap.negocio.CalculoImpostoDevidoUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.observador.ObservadorCalculoImpostoDevido;
import br.gov.serpro.gcap.observador.ObservadorTransporte;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.ConstantesGlobaisGCAP;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorComparacaoData;
import br.gov.serpro.gcap.validador.ValidadorComparacaoValor;
import br.gov.serpro.gcap.validador.ValidadorData;
import br.gov.serpro.gcap.validador.ValidadorDataAquisicao;
import br.gov.serpro.gcap.validador.ValidadorGanhoAlienacaoParcial;
import br.gov.serpro.gcap.validador.ValidadorIsencao180DiasDataPrimeiraAlienacao;
import br.gov.serpro.gcap.validador.ValidadorIsencaoPergunta180Dias;
import br.gov.serpro.gcap.validador.ValidadorIsencaoPerguntaImovelUnico;
import br.gov.serpro.gcap.validador.ValidadorNaoNuloGCAP;
import br.gov.serpro.gcap.validador.ValidadorPerguntaAlienacaoParcial;
import br.gov.serpro.gcap.validador.ValidadorPerguntaBemGrandeValor;
import br.gov.serpro.gcap.validador.ValidadorPerguntaImovelResidencial;
import br.gov.serpro.gcap.validador.ValidadorPerguntaMP252;
import br.gov.serpro.gcap.validador.ValidadorPerguntaMP252Parte2;
import br.gov.serpro.gcap.validador.ValidadorPerguntaOutraAlienacao;
import br.gov.serpro.gcap.validador.ValidadorPerguntaOutroImovel;
import br.gov.serpro.gcap.validador.ValidadorSomatorioParcelas;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCEP;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class AlienacaoBemImovel
extends AlienacaoBem
implements ObjetoFicha {
    public static final String NOME_FICHA_BEM_IMOVEl = "Bens Im\u00f3veis";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_AQUISICAO = "Aquisi\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_PERGUNTAS = "Perguntas";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static int REDUCAO_AUSENTE = 0;
    public static int REDUCAO_IMOVEL_PEQUENO_VALOR = 1;
    public static int REDUCAO_UNICO_IMOVEL = 2;
    public static int REDUCAO_APLICACAO_OUTRO_IMOVEL = 3;
    private BemImovel bemImovel = new BemImovel(this);
    private ApuracaoBemImovel apuracao = new ApuracaoBemImovel();
    private ApuracaoBemImovel apuracaoFinal = new ApuracaoBemImovel();
    private ValorPositivo valorAplicado = new ValorPositivo(this, "Valor aplicado na aquisi\u00e7\u00e3o de im\u00f3vel residencial no prazo de 180 dias.");
    private PerguntasImovel perguntas = new PerguntasImovel();
    public static int ANO_TRANSICAO_LEI_180_DIAS = 2018;

    public AlienacaoBemImovel() {
        this.getNatureza().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarNaturezaGCAPBemImovel());
        this.adicionarValidadores();
        this.adicionarObservadores();
    }

    private void adicionarObservadores() {
        this.adicionarObservadoresZerarDadosAquisicao();
        this.adicionarObservadoresAquisicao();
        this.adicionarObservadoresPerguntas();
        this.adicionarObservadoresOperacao();
        this.adicionarObservadoresCalculoApuracao();
        this.adicionarObservadoresCalculoImposto();
        this.adicionarObservadoresCalculoImpostoAPrazo();
        this.adicionaObservadoresConsolidacao();
    }

    public void adicionarObservadoresZerarDadosAquisicao() {
        this.getBemImovel().getBemAdquiridoNoBrasil().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoBrasil()) {
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().clear();
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getHouveReforma().clear();
                } else if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoExterior()) {
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getHouveReforma().clear();
                }
            }
        });
        this.getBemImovel().getAquisicao().getHouveReforma().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (!AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().clear();
                }
                if (!AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma()) {
                    AlienacaoBemImovel.this.getAquisicao().getCustoAquisicao().clear();
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao().clear();
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().clear();
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().clear();
                }
            }
        });
        this.getBemImovel().getAquisicao().getOrigemRendimentos().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                block3: {
                    block2: {
                        if (!Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) break block2;
                        AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().clear();
                        for (ParcelaAquisicao parcela : AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                            parcela.getCustoAquisicaoOrigemMEDolar().clear();
                        }
                        break block3;
                    }
                    if (!Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) break block3;
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao().clear();
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().clear();
                    for (ParcelaAquisicao parcela : AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                        parcela.getCustoAquisicaoOrigemNacionalDolar().clear();
                        parcela.getCotacaoDolar().clear();
                    }
                }
            }
        });
    }

    public void adicionarObservadoresAquisicao() {
        Observador obsCalculaCustoAquisicaoReal = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel.this.getBemImovel().getAquisicao().calcularCustoAquisicaoReal(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar(), AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao());
            }
        };
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addObservador(obsCalculaCustoAquisicaoReal);
        this.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao().addObservador(obsCalculaCustoAquisicaoReal);
        Observador obsCalculaCustoAquisicaoTotalDolar = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel.this.getBemImovel().getAquisicao().calcularCustoAquisicaoTotalDolar(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar(), AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
            }
        };
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addObservador(obsCalculaCustoAquisicaoTotalDolar);
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().addObservador(obsCalculaCustoAquisicaoTotalDolar);
        this.getBemImovel().getAquisicao().getOrigemRendimentos().addObservador(obsCalculaCustoAquisicaoTotalDolar);
        this.getBemImovel().getAquisicao().getHouveReforma().addObservador(obsCalculaCustoAquisicaoTotalDolar);
        Observador obsCalculaTorna = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo lValorTorna = new ValorPositivo(null, "", 11, 9);
                ValorPositivo lCustoAquisicao = new ValorPositivo(null, "", 11, 9);
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    lCustoAquisicao.setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicao());
                } else {
                    lCustoAquisicao.setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicao());
                }
                if (String.valueOf(CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(AlienacaoBemImovel.this.getNatureza().naoFormatado()) && AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacao().comparacao(">", "0,00") && lCustoAquisicao.comparacao(">", "0,00")) {
                    lValorTorna.append('+', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacao());
                    lValorTorna.append('/', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacao().operacao('+', lCustoAquisicao));
                    lValorTorna.append('*', lCustoAquisicao);
                    lValorTorna.converteQtdCasasDecimais(2);
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTorna().setConteudo(lValorTorna);
                } else {
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTorna().clear();
                }
            }
        };
        this.getApuracao().getValorLiquidoAlienacao().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getCustoAquisicao().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicao().addObservador(obsCalculaTorna);
        this.getNatureza().addObservador(obsCalculaTorna);
        obsCalculaTorna = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo lValorTorna = new ValorPositivo(null, "", 11, 9);
                ValorPositivo lCustoAquisicao = new ValorPositivo(null, "", 11, 9);
                ValorPositivo lCotacaoDolar = new ValorPositivo(null, "", 11, 9);
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    lCustoAquisicao.setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar());
                    if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar().comparacao(">", "0,00")) {
                        lCotacaoDolar.append('+', AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal());
                        lCotacaoDolar.append('/', AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar());
                    }
                } else {
                    lCustoAquisicao.setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
                    lCotacaoDolar.setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao());
                }
                if (String.valueOf(CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(AlienacaoBemImovel.this.getNatureza().naoFormatado()) && AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar().comparacao(">", "0,00") && lCustoAquisicao.comparacao(">", "0,00")) {
                    lValorTorna.append('+', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar());
                    lValorTorna.append('/', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar().operacao('+', lCustoAquisicao));
                    lValorTorna.append('*', lCustoAquisicao);
                    lValorTorna.converteQtdCasasDecimais(2);
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNDolar().setConteudo(lValorTorna);
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal().setConteudo(lValorTorna.operacao('*', lCotacaoDolar));
                } else {
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNDolar().clear();
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal().clear();
                }
            }
        };
        this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao().addObservador(obsCalculaTorna);
        this.getNatureza().addObservador(obsCalculaTorna);
        obsCalculaTorna = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo lValorTorna = new ValorPositivo(null, "", 11, 9);
                ValorPositivo lCustoAquisicao = new ValorPositivo(null, "", 11, 9);
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    lCustoAquisicao.setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar());
                } else {
                    lCustoAquisicao.setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
                }
                if (String.valueOf(CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(AlienacaoBemImovel.this.getNatureza().naoFormatado()) && AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar().comparacao(">", "0,00") && lCustoAquisicao.comparacao(">", "0,00")) {
                    lValorTorna.append('+', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar());
                    lValorTorna.append('/', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar().operacao('+', lCustoAquisicao));
                    lValorTorna.append('*', lCustoAquisicao);
                    lValorTorna.converteQtdCasasDecimais(2);
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar().setConteudo(lValorTorna);
                } else {
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar().clear();
                }
            }
        };
        this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar().addObservador(obsCalculaTorna);
        this.getNatureza().addObservador(obsCalculaTorna);
        this.getBemImovel().getAquisicao().getOrigemRendimentos().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel.this.alterarOrigemRendimentos((String)valorAntigo, (String)valorNovo);
            }
        });
        this.getBemImovel().getBemAdquiridoNoBrasil().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoExterior()) {
                    AlienacaoBemImovel.this.getAquisicao().getOrigemRendimentos().setConteudo(Aquisicao.CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL);
                } else {
                    AlienacaoBemImovel.this.getAquisicao().getResidenteBrasilAplicacaoExterior().setConteudo(Logico.NAO);
                    AlienacaoBemImovel.this.getAquisicao().getMoedaEstrangeira().clear();
                }
                if (((String)valorAntigo).trim().length() > 0) {
                    AlienacaoBemImovel.this.alterarOndeBemFoiAdquirido();
                }
            }
        });
        this.getBemImovel().getAquisicao().getBemAtualizado().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (!AlienacaoBemImovel.this.getBemImovel().getAquisicao().bemAtualizado()) {
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getValorDTA().clear();
                    AlienacaoBemImovel.this.getBemImovel().getAquisicao().getDataDTA().clear();
                }
            }
        });
    }

    public void adicionarObservadoresOperacao() {
        this.getAlienacaoAPrazo().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (propriedade.equals(((Informacao)observado).getNomeCampo()) && ((String)valorAntigo).length() > 0) {
                    AlienacaoBemImovel.this.limparCalculoImposto();
                }
            }
        });
        this.getBemGrandeValor().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                String opcao = "";
                boolean operacaoMaior35k = AlienacaoBemImovel.this.isValorOperacaoMaior35K();
                try {
                    opcao = (String)valorNovo;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (operacaoMaior35k || !operacaoMaior35k && opcao.length() > 0) {
                    AlienacaoBemImovel.this.getBemGrandeValorOperacao().setConteudo(AlienacaoBemImovel.this.getBemGrandeValor());
                }
            }
        });
        this.getNatureza().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (!AlienacaoBemImovel.this.isAdquirenteRequerido()) {
                    AlienacaoBemImovel.this.getBemImovel().getAdquirentes().clear();
                }
                if (!AlienacaoBemImovel.this.isMP252PermitidaParaNaturezaSelecionada()) {
                    AlienacaoBemImovel.this.getPerguntas().getMP252Parte2().clear();
                    AlienacaoBemImovel.this.getPerguntas().getMP252().clear();
                    AlienacaoBemImovel.this.getPerguntas().getMP252Aux().clear();
                    AlienacaoBemImovel.this.getPerguntas().getMP252PrimeiraAlienacao().clear();
                }
            }
        });
        this.getDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (ControladorGui.getDemonstrativoAberto() != null) {
                    ControladorGui.getDemonstrativoAberto().getBensImoveis().atualizarDatasAlienacoes();
                }
            }
        });
    }

    public void limparCalculoImposto() {
        this.getCalculoImposto().getImpostoPago().clear();
        this.getValorLiquidoRecebidoAnosAnteriores().clear();
        this.getColecaoParcelaAlienacao().itens().clear();
    }

    public void adicionarObservadoresPerguntas() {
        this.getPerguntas().getMP252Parte2().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (PerguntasImovel.LABEL_CAMPO_MP252_PARTE2.equals(nomePropriedade) && !"P".equals(valorNovo) && AlienacaoBemImovel.this.isAlienacaoAPrazo()) {
                    for (ParcelaAlienacaoBem parcela : AlienacaoBemImovel.this.getColecaoParcelaAlienacao().itens()) {
                        parcela.getValorInformadoReducaoAplicacaoOutroImovel().clear();
                        parcela.getValorInformadoReducaoAplicacaoOutroImovelMN().clear();
                        parcela.getValorInformadoReducaoAplicacaoOutroImovelME().clear();
                    }
                }
            }
        });
        this.getPerguntas().getMP252().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (ControladorGui.getDemonstrativoAberto() != null) {
                    ControladorGui.getDemonstrativoAberto().getBensImoveis().atualizarDatasAlienacoes();
                }
            }
        });
        this.getPerguntas().getMP252PrimeiraAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (ControladorGui.getDemonstrativoAberto() != null) {
                    ControladorGui.getDemonstrativoAberto().getBensImoveis().atualizarDatasAlienacoes();
                }
            }
        });
        this.getPerguntas().getDataPrimeiraAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (ControladorGui.getDemonstrativoAberto() != null) {
                    ControladorGui.getDemonstrativoAberto().getBensImoveis().atualizarDatasAlienacoes();
                }
            }
        });
        this.getPerguntas().getOutraAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (ControladorGui.getDemonstrativoAberto() != null) {
                    ControladorGui.getDemonstrativoAberto().getBensImoveis().atualizarDatasAlienacoes();
                }
            }
        });
    }

    public void adicionarObservadoresCalculoApuracao() {
        this.getValorAlienacao().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getValorAlienacao()));
        this.getValorAlienacaoDolar().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getValorAlienacaoDolar()));
        this.getCustoCorretagem().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getCustoCorretagem()));
        this.getValorCorretagemDolar().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getCustoCorretagemDolar()));
        this.getCotacaoDolarDataAlienacao().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getCotacaoDolarOrigemNacional()));
        this.getCotacaoDolarDataAlienacao().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getCotacaoDolarOrigemME()));
        this.getBemImovel().getAquisicao().getCustoAquisicaoTorna().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getCustoAquisicaoTorna()));
        this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getCustoAquisicaoTornaOrigemMNReal()));
        this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar().addObservador(new ObservadorTransporte((Informacao)this.getApuracao().getCustoAquisicaoTornaOrigemMEDolar()));
        Observador obs = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicao().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicao());
                } else if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicao().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicao());
                } else {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicao().clear();
                }
            }
        };
        this.getBemImovel().getAquisicao().getCustoAquisicao().addObservador(obs);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicao().addObservador(obs);
        obs = new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getPercentualCustoAquisicaoOrigemMN().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemNacional());
                } else if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getPercentualCustoAquisicaoOrigemMN().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional());
                } else {
                    AlienacaoBemImovel.this.getApuracao().getPercentualCustoAquisicaoOrigemMN().clear();
                }
            }
        };
        this.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional().addObservador(obs);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemNacional().addObservador(obs);
        this.getBemImovel().getAquisicao().getHouveReforma().addObservador(obs);
        obs = new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getPercentualCustoAquisicaoOrigemME().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemME());
                } else if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getPercentualCustoAquisicaoOrigemME().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemME());
                } else {
                    AlienacaoBemImovel.this.getApuracao().getPercentualCustoAquisicaoOrigemME().clear();
                }
            }
        };
        this.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemME().addObservador(obs);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemME().addObservador(obs);
        this.getBemImovel().getAquisicao().getHouveReforma().addObservador(obs);
        obs = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicaoOrigemNacionalReal().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal());
                } else if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicaoOrigemNacionalReal().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
                } else {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicaoOrigemNacionalReal().clear();
                }
            }
        };
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal().addObservador(obs);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal().addObservador(obs);
        obs = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicaoOrigemMEDolar().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar());
                } else if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicaoOrigemMEDolar().setConteudo(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
                } else {
                    AlienacaoBemImovel.this.getApuracao().getCustoAquisicaoOrigemMEDolar().clear();
                }
            }
        };
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().addObservador(obs);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar().addObservador(obs);
        obs = new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                AlienacaoBemImovel.this.getApuracao().getGanhoCapitalTotalExterior().setConteudo(AlienacaoBemImovel.this.getApuracao().getGanhoCapital5OrigemMNReal().operacao('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital5OrigemMEReal()));
            }
        };
        this.getApuracao().getGanhoCapital5OrigemMNReal().addObservador(obs);
        this.getApuracao().getGanhoCapital5OrigemMEReal().addObservador(obs);
        this.getBemImovel().getAquisicao().getParcelasAquisicao().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                final ParcelaAquisicao parcela = (ParcelaAquisicao)((Object)valorNovo);
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().isModoEdicao()) {
                    AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().novaParcela();
                }
                parcela.getData().addObservador(new Observador(){

                    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                        if (AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().size() > parcela.getIndice().asInteger()) {
                            ((ParcelaApuracaoCustoAquisicao)((Object)AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().get(parcela.getIndice().asInteger()))).getData().setConteudo(parcela.getData());
                        }
                    }
                });
                parcela.getPercentualCustoTotal().addObservador(new Observador(){

                    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                        if (AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().size() > parcela.getIndice().asInteger()) {
                            ((ParcelaApuracaoCustoAquisicao)((Object)AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().get(parcela.getIndice().asInteger()))).getPercentualCustoTotal().setConteudo(parcela.getPercentualCustoTotal());
                        }
                    }
                });
                parcela.getPercentualCustoTotalReal().addObservador(new Observador(){

                    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                        if (AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().size() > parcela.getIndice().asInteger()) {
                            ((ParcelaApuracaoCustoAquisicao)((Object)AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().get(parcela.getIndice().asInteger()))).getPercentualCustoTotalReal().setConteudo(parcela.getPercentualCustoTotalReal());
                        }
                    }
                });
                parcela.getPercentualCustoTotalDolar().addObservador(new Observador(){

                    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                        if (AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().size() > parcela.getIndice().asInteger()) {
                            ((ParcelaApuracaoCustoAquisicao)((Object)AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().get(parcela.getIndice().asInteger()))).getPercentualCustoTotalDolar().setConteudo(parcela.getPercentualCustoTotalDolar());
                        }
                    }
                });
            }
        });
        this.getBemImovel().getAquisicao().getParcelasAquisicao().addObservador("ObjetoRemovido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParcelaAquisicao parcela = (ParcelaAquisicao)((Object)valorNovo);
                if (AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().size() > parcela.getIndice().asInteger()) {
                    AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().itens().remove(parcela.getIndice().asInteger());
                }
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().getParcelasAquisicao().isVazio()) {
                    AlienacaoBemImovel.this.getApuracao().getParcelasCustoAquisicao().clear();
                }
            }
        });
        Observador calculoReducoes = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().calcularReducoesAquisicaoSemReforma(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getDataAquisicao(), AlienacaoBemImovel.this.getDataAlienacao(), AlienacaoBemImovel.this.isPaisResidenciaBrasil());
                }
            }
        };
        this.getBemImovel().getAquisicao().getDataAquisicao().addObservador(calculoReducoes);
        this.getDataAlienacao().addObservador(calculoReducoes);
        this.getBemImovel().getAquisicao().getHouveReforma().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital1().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital1OrigemNacionalReal().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital1OrigemMEReal().addObservador(calculoReducoes);
        calculoReducoes = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().houveReforma()) {
                    AlienacaoBemImovel.this.getApuracao().calcularReducoesAquisicaoComReforma(AlienacaoBemImovel.this.getDataAlienacao(), AlienacaoBemImovel.this.isPaisResidenciaBrasil());
                }
            }
        };
        this.getDataAlienacao().addObservador(calculoReducoes);
        this.getBemImovel().getAquisicao().getHouveReforma().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital1().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital1OrigemNacionalReal().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital1OrigemMEReal().addObservador(calculoReducoes);
        final Observador obsCalculoReducoesAquisicaoComReforma = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel.this.getApuracao().calcularReducoesAquisicaoComReforma(AlienacaoBemImovel.this.getDataAlienacao(), AlienacaoBemImovel.this.isPaisResidenciaBrasil());
            }
        };
        this.getApuracao().getParcelasCustoAquisicao().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParcelaApuracaoCustoAquisicao parcela = (ParcelaApuracaoCustoAquisicao)((Object)valorNovo);
                parcela.getData().addObservador(obsCalculoReducoesAquisicaoComReforma);
                AlienacaoBemImovel.this.getApuracao().calcularReducoesAquisicaoComReforma(AlienacaoBemImovel.this.getDataAlienacao(), AlienacaoBemImovel.this.isPaisResidenciaBrasil());
            }
        });
        this.getApuracao().getParcelasCustoAquisicao().addObservador("ObjetoRemovido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParcelaApuracaoCustoAquisicao parcela = (ParcelaApuracaoCustoAquisicao)((Object)valorNovo);
                parcela.getData().removeObservador(obsCalculoReducoesAquisicaoComReforma);
                AlienacaoBemImovel.this.getApuracao().calcularReducoesAquisicaoComReforma(AlienacaoBemImovel.this.getDataAlienacao(), AlienacaoBemImovel.this.isPaisResidenciaBrasil());
            }
        });
        calculoReducoes = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PerguntasUtil.getInstancia().tratarExibicaoPerguntas(AlienacaoBemImovel.this);
                if (AlienacaoBemImovel.this.getPerguntas().isValorReaplicadoTotalmente()) {
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovel().setConteudo("100,000000");
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo("100,000000");
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo("100,000000");
                } else if (AlienacaoBemImovel.this.getPerguntas().isValorReaplicadoParcialmente()) {
                    ValorPositivo lPercentualAplicacaoOutroImovel;
                    if (AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacao().comparacao(">", "0,00")) {
                        lPercentualAplicacaoOutroImovel = new ValorPositivo(null, "", 12, 9);
                        lPercentualAplicacaoOutroImovel.append('+', AlienacaoBemImovel.this.getValorAplicado());
                        lPercentualAplicacaoOutroImovel.append('*', "100");
                        lPercentualAplicacaoOutroImovel.append('/', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacao());
                        lPercentualAplicacaoOutroImovel.converteQtdCasasDecimais(6);
                        AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovel().setConteudo(lPercentualAplicacaoOutroImovel);
                    }
                    if (AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoDolar().comparacao(">", "0,00") && AlienacaoBemImovel.this.getCotacaoDolarDataAlienacao().comparacao(">", "0,00")) {
                        lPercentualAplicacaoOutroImovel = new ValorPositivo(null, "", 12, 9);
                        lPercentualAplicacaoOutroImovel.append('+', AlienacaoBemImovel.this.getValorAplicado());
                        lPercentualAplicacaoOutroImovel.append('*', "100");
                        lPercentualAplicacaoOutroImovel.append('/', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoDolar());
                        lPercentualAplicacaoOutroImovel.append('/', AlienacaoBemImovel.this.getApuracao().getCotacaoDolarOrigemNacional());
                        lPercentualAplicacaoOutroImovel.converteQtdCasasDecimais(6);
                        AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(lPercentualAplicacaoOutroImovel);
                        AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(lPercentualAplicacaoOutroImovel);
                    }
                } else {
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovel().clear();
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
                }
                ValorPositivo lValorAplicacaoOutroImovel = new ValorPositivo(null, "", 12, 9);
                lValorAplicacaoOutroImovel.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4());
                lValorAplicacaoOutroImovel.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovel());
                lValorAplicacaoOutroImovel.append('/', "100");
                lValorAplicacaoOutroImovel.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoAplicacaoOutroImovel().setConteudo(lValorAplicacaoOutroImovel);
                lValorAplicacaoOutroImovel = new ValorPositivo(null, "", 12, 9);
                lValorAplicacaoOutroImovel.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4OrigemMNReal());
                lValorAplicacaoOutroImovel.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
                lValorAplicacaoOutroImovel.append('/', "100");
                lValorAplicacaoOutroImovel.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(lValorAplicacaoOutroImovel);
                lValorAplicacaoOutroImovel = new ValorPositivo(null, "", 12, 9);
                lValorAplicacaoOutroImovel.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4OrigemMEReal());
                lValorAplicacaoOutroImovel.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemME());
                lValorAplicacaoOutroImovel.append('/', "100");
                lValorAplicacaoOutroImovel.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(lValorAplicacaoOutroImovel);
                if (AlienacaoBemImovel.this.isBemPequenoValor() && AlienacaoBemImovel.this.isValorAlienacaoMenor35k()) {
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValor().setConteudo("100,000000");
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo("100,000000");
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValorOrigemME().setConteudo("100,000000");
                } else {
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValor().clear();
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValorOrigemMN().clear();
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValorOrigemME().clear();
                }
                ValorPositivo lValorReducaoBemPequenoValor = new ValorPositivo(null, "", 12, 9);
                lValorReducaoBemPequenoValor.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4());
                lValorReducaoBemPequenoValor.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValor());
                lValorReducaoBemPequenoValor.append('/', "100");
                lValorReducaoBemPequenoValor.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoBemPequenoValor().setConteudo(lValorReducaoBemPequenoValor);
                lValorReducaoBemPequenoValor = new ValorPositivo(null, "", 12, 9);
                lValorReducaoBemPequenoValor.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4OrigemMNReal());
                lValorReducaoBemPequenoValor.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValorOrigemMN());
                lValorReducaoBemPequenoValor.append('/', "100");
                lValorReducaoBemPequenoValor.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoBemPequenoValorOrigemMN().setConteudo(lValorReducaoBemPequenoValor);
                lValorReducaoBemPequenoValor = new ValorPositivo(null, "", 12, 9);
                lValorReducaoBemPequenoValor.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4OrigemMEReal());
                lValorReducaoBemPequenoValor.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoBemPequenoValorOrigemME());
                lValorReducaoBemPequenoValor.append('/', "100");
                lValorReducaoBemPequenoValor.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoBemPequenoValorOrigemME().setConteudo(lValorReducaoBemPequenoValor);
                if (AlienacaoBemImovel.this.getPerguntas().naoTemOutraAlienacao() && AlienacaoBemImovel.this.isValorAlienacaoMenor440k()) {
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovel().setConteudo("100,000000");
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovelOrigemMN().setConteudo("100,000000");
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovelOrigemME().setConteudo("100,000000");
                } else {
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovel().clear();
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovelOrigemMN().clear();
                    AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovelOrigemME().clear();
                }
                ValorPositivo lValorReducaoUnicoImovel = new ValorPositivo(null, "", 12, 9);
                lValorReducaoUnicoImovel.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4());
                lValorReducaoUnicoImovel.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovel());
                lValorReducaoUnicoImovel.append('/', "100");
                lValorReducaoUnicoImovel.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoUnicoImovel().setConteudo(lValorReducaoUnicoImovel);
                lValorReducaoUnicoImovel = new ValorPositivo(null, "", 12, 9);
                lValorReducaoUnicoImovel.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4OrigemMNReal());
                lValorReducaoUnicoImovel.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovelOrigemMN());
                lValorReducaoUnicoImovel.append('/', "100");
                lValorReducaoUnicoImovel.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoUnicoImovelOrigemMN().setConteudo(lValorReducaoUnicoImovel);
                lValorReducaoUnicoImovel = new ValorPositivo(null, "", 12, 9);
                lValorReducaoUnicoImovel.append('+', AlienacaoBemImovel.this.getApuracao().getGanhoCapital4OrigemMEReal());
                lValorReducaoUnicoImovel.append('*', AlienacaoBemImovel.this.getApuracao().getPercentualReducaoUnicoImovelOrigemME());
                lValorReducaoUnicoImovel.append('/', "100");
                lValorReducaoUnicoImovel.converteQtdCasasDecimais(2);
                AlienacaoBemImovel.this.getApuracao().getValorReducaoUnicoImovelOrigemME().setConteudo(lValorReducaoUnicoImovel);
            }
        };
        this.getApuracao().getGanhoCapital4().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital4OrigemMNReal().addObservador(calculoReducoes);
        this.getApuracao().getGanhoCapital4OrigemMEReal().addObservador(calculoReducoes);
        this.getValorAplicado().addObservador(calculoReducoes);
        this.getPerguntas().getImovelResidencial().addObservador(calculoReducoes);
        this.getPerguntas().getMP252().addObservador(calculoReducoes);
        this.getPerguntas().getMP252Parte2().addObservador(calculoReducoes);
        this.getBemGrandeValor().addObservador(calculoReducoes);
        this.getPerguntas().getOutraAlienacao().addObservador(calculoReducoes);
    }

    public void adicionarObservadoresCalculoImposto() {
        this.getDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                boolean dataValida = AlienacaoBemImovel.this.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido();
                if (dataValida) {
                    if (Integer.valueOf(AlienacaoBemImovel.this.getDataAlienacao().getAno()) == AplicacaoPropertiesUtil.getExercicioAsInt()) {
                        AlienacaoBemImovel.this.getValorLiquidoRecebidoAnosAnteriores().clear();
                    }
                } else {
                    AlienacaoBemImovel.this.getValorLiquidoRecebidoAnosAnteriores().clear();
                }
            }
        });
        this.apuracao.getGanhoCapital5().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.bemImovel.isAdquiridoNoBrasil()) {
                    AlienacaoBemImovel.this.getCalculoImposto().getGanhoCapitalTotal().setConteudo(AlienacaoBemImovel.this.apuracao.getGanhoCapital5());
                }
            }
        });
        this.getCalculoImposto().getGanhoCapitalTotal().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.isAlienacaoAPrazo()) {
                    if (AlienacaoBemImovel.this.isAlienacaoBrasil()) {
                        AlienacaoBemImovel.this.recalcularParcelasBrasil();
                    } else {
                        AlienacaoBemImovel.this.calcularParcelasExterior();
                    }
                }
            }
        });
        Observador obsCalculoGanhoCapitalExterior = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.bemImovel.isAdquiridoNoExterior()) {
                    AlienacaoBemImovel.this.getCalculoImposto().getGanhoCapitalTotal().setConteudo(AlienacaoBemImovel.this.apuracao.getGanhoCapital5OrigemMNReal().operacao('+', AlienacaoBemImovel.this.apuracao.getGanhoCapital5OrigemMEReal()));
                }
            }
        };
        this.apuracao.getGanhoCapital5OrigemMNReal().addObservador(obsCalculoGanhoCapitalExterior);
        this.apuracao.getGanhoCapital5OrigemMEReal().addObservador(obsCalculoGanhoCapitalExterior);
        ObservadorCalculoImpostoDevido obsCalculoImpostoDevido = new ObservadorCalculoImpostoDevido(this);
        this.getCalculoImposto().getGanhoCapitalTotal().addObservador(obsCalculoImpostoDevido);
        this.getAjuste().getGanhoCapitalTotal().addObservador(obsCalculoImpostoDevido);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsCalculoImpostoDevido);
        this.getDataAlienacao().addObservador((Observador)obsCalculoImpostoDevido);
        this.getBemGrandeValor().addObservador((Observador)obsCalculoImpostoDevido);
        this.getNatureza().addObservador((Observador)obsCalculoImpostoDevido);
        this.getBemGrandeValor().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.isBemPequenoValor()) {
                    AlienacaoBemImovel.this.getCalculoImposto().getImpostoPago().setReadOnly(true);
                } else {
                    AlienacaoBemImovel.this.getCalculoImposto().getImpostoPago().setReadOnly(false);
                }
            }
        });
        this.getCalculoImposto().getImpostoDevido().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel.this.getCalculoImposto().getImpostoDevido2().setConteudo(AlienacaoBemImovel.this.getCalculoImposto().getImpostoDevido().operacao('-', AlienacaoBemImovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao()));
            }
        });
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel.this.getCalculoImposto().getImpostoDevido2().setConteudo(AlienacaoBemImovel.this.getCalculoImposto().getImpostoDevido().operacao('-', AlienacaoBemImovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao()));
            }
        });
    }

    public void adicionarObservadoresCalculoImpostoAPrazo() {
        Observador obsRecalculaParcelas = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.isAlienacaoAPrazo()) {
                    if (AlienacaoBemImovel.this.isAlienacaoBrasil()) {
                        AlienacaoBemImovel.this.recalcularImpostoBrasil();
                    } else {
                        AlienacaoBemImovel.this.recalcularImpostoExterior();
                    }
                }
            }
        };
        this.getBemImovel().getAquisicao().getCustoAquisicao().addObservador(obsRecalculaParcelas);
        this.apuracao.getGanhoCapital5().addObservador(obsRecalculaParcelas);
        this.getValorLiquidoRecebidoAnosAnteriores().addObservador(obsRecalculaParcelas);
        this.getAlienacaoParcial().addObservador(obsRecalculaParcelas);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsRecalculaParcelas);
        this.getBemGrandeValor().addObservador(obsRecalculaParcelas);
        this.apuracao.getGanhoCapital5OrigemMNReal().addObservador(obsRecalculaParcelas);
        this.apuracao.getGanhoCapital5OrigemMEReal().addObservador(obsRecalculaParcelas);
        this.getPerguntas().getMP252().addObservador(obsRecalculaParcelas);
        this.getPerguntas().getOutraAlienacao().addObservador(obsRecalculaParcelas);
        this.getPerguntas().getImovelResidencial().addObservador(obsRecalculaParcelas);
        this.getPerguntas().getPropriedadeOutroImovel().addObservador(obsRecalculaParcelas);
        this.getCalculoImposto().getAliquotaMedia().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemImovel.this.isAlienacaoBrasil() && AlienacaoBemImovel.this.isAlienacaoAPrazo() && (AlienacaoBemImovel.this.isParaisoFiscal() || AlienacaoBemImovel.this.isTerritorioParaisoFiscal())) {
                    for (ParcelaAlienacaoBem parcela : AlienacaoBemImovel.this.getColecaoParcelaAlienacao().itens()) {
                        AlienacaoBemImovel.this.calcularParcelaBrasil(parcela);
                    }
                }
            }
        });
    }

    public void adicionaObservadoresConsolidacao() {
        ObservadorCalculoConsolidacaoBemImovel obsCalculoConsolidacao = new ObservadorCalculoConsolidacaoBemImovel(this);
        this.getBemGrandeValor().addObservador((Observador)obsCalculoConsolidacao);
        this.getDataAlienacao().addObservador((Observador)obsCalculoConsolidacao);
        this.getAlienacaoAPrazo().addObservador((Observador)obsCalculoConsolidacao);
        this.getTemUltimaParcela().addObservador((Observador)obsCalculoConsolidacao);
        this.getAlienacaoParcial().addObservador((Observador)obsCalculoConsolidacao);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsCalculoConsolidacao);
        this.getValorImpostoExteriorReal().addObservador(obsCalculoConsolidacao);
        this.getNatureza().addObservador((Observador)obsCalculoConsolidacao);
        this.getCalculoImposto().getGanhoCapitalTotal().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getImpostoPago().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getImpostoDevido2().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getImpostoPagoTotal().addObservador(obsCalculoConsolidacao);
        this.getConsolidacao().getImpostoDiferidoAnosAnteriores().addObservador(obsCalculoConsolidacao);
    }

    private void alterarOndeBemFoiAdquirido() {
        this.getBemImovel().getAquisicao().resetAquisicao(this.getBemImovel().isAdquiridoNoBrasil(), true);
        this.resetAlienacao(this.getBemImovel().isAdquiridoNoBrasil());
        this.getCalculoImposto().resetCalculoImposto();
        this.getConsolidacao().resetConsolidacao();
        this.getColecaoParcelaAlienacao().clear();
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            this.recalcularImpostoBrasil();
        } else {
            this.recalcularImpostoExterior();
        }
    }

    private void alterarOrigemRendimentos(String valorAntigo, String valorNovo) {
        if (this.getBemImovel().getAquisicao().isOrigemRendimentosValida(valorAntigo) && !valorAntigo.equals(valorNovo)) {
            this.getColecaoParcelaAlienacao().clear();
            this.getApuracaoFinal().clear();
        }
        this.getBemImovel().getAquisicao().resetAquisicao(this.getBemImovel().isAdquiridoNoBrasil(), false);
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            this.recalcularImpostoBrasil();
        } else {
            this.recalcularImpostoExterior();
        }
    }

    public void recalcularImpostoBrasil() {
        this.getCalculoImposto().getGanhoCapitalTotal().forcaDisparoObservadores();
        if (this.isAlienacaoAPrazo()) {
            for (ParcelaAlienacao parcela : this.getColecaoParcelaAlienacao().itens()) {
                parcela.getValorRecebido().forcaDisparoObservadores();
            }
        }
    }

    public void recalcularImpostoExterior() {
        if (this.isAlienacaoAPrazo()) {
            for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                parcela.getValorRecebidoDolar().forcaDisparoObservadores();
            }
        } else {
            this.getApuracao().getGanhoCapital1OrigemNacionalReal().forcaDisparoObservadores();
            this.getApuracao().getGanhoCapital1OrigemMEReal().forcaDisparoObservadores();
        }
    }

    public void adicionarValidadoresIdentificacao() {
        this.getBemImovel().getBemAdquiridoNoBrasil().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
        this.getBemImovel().getEspecificacao().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
        this.getBemImovel().getEndereco().getTipoLogradouro().addValidador((ValidadorIf)new ValidadorNaoNuloBrasil(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getTipoLogradouro().getNomeCampo()})));
        this.getBemImovel().getEndereco().getLogradouro().addValidador((ValidadorIf)new ValidadorNaoNuloBrasil(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getLogradouro().getNomeCampo()})));
        this.getBemImovel().getEndereco().getLogradouroEx().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getLogradouroEx().getNomeCampo()})));
        this.getBemImovel().getEndereco().getUf().addValidador((ValidadorIf)new ValidadorNaoNuloBrasil(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getUf().getNomeCampo()})));
        this.getBemImovel().getEndereco().getMunicipio().addValidador((ValidadorIf)new ValidadorNaoNuloBrasil(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getMunicipio().getNomeCampo()})));
        this.getBemImovel().getEndereco().getCep().addValidador((ValidadorIf)new ValidadorNaoNuloBrasil(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getCep().getNomeCampo()})));
        this.getBemImovel().getEndereco().getCep().addValidador((ValidadorIf)new ValidadorCEP(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno != null) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("ErroMsgCepInvalido"));
                }
                return retorno;
            }
        });
        this.getBemImovel().getEndereco().getCidadeEx().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getCidadeEx().getNomeCampo()})));
        this.getBemImovel().getEndereco().getCodigoPostalEx().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getCodigoPostalEx().getNomeCampo()})));
        this.getBemImovel().getEndereco().getPaisEx().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getBemImovel().getEndereco().getPaisEx().getNomeCampo()})));
    }

    public void adicionarValidadoresAquisicao() {
        this.getBemImovel().getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
        this.getBemImovel().getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorDataAquisicao(3));
        this.getBemImovel().getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorData(3));
        this.getBemImovel().getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorComparacaoData(3, -3, this.getDataAlienacao()));
        this.getBemImovel().getAquisicao().getOrigemRendimentos().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3));
        this.getBemImovel().getAquisicao().getHouveReforma().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
        this.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma() && !AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma() && AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && AlienacaoBemImovel.this.getBemImovel().getAquisicao().naoHouveReforma() && AlienacaoBemImovel.this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getParcelasAquisicao().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                final ParcelaAquisicao parcela = (ParcelaAquisicao)((Object)valorNovo);
                parcela.getData().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
                parcela.getData().addValidador((ValidadorIf)new ValidadorDataAquisicao(3));
                parcela.getData().addValidador((ValidadorIf)new ValidadorData(3));
                parcela.getData().addValidador((ValidadorIf)new ValidadorComparacaoData(3, -3, AlienacaoBemImovel.this.getDataAlienacao()));
                parcela.getData().addValidador((ValidadorIf)new ValidadorComparacaoData(3, 3, AlienacaoBemImovel.this.getBemImovel().getAquisicao().getDataAquisicao()));
                parcela.getCustoAquisicao().addValidador((ValidadorIf)new ValidadorNaoNuloBrasil(3));
                parcela.getCotacaoDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

                    @Override
                    public RetornoValidacao validarImplementado() {
                        if (!Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
                parcela.getCustoAquisicaoOrigemNacionalDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

                    @Override
                    public RetornoValidacao validarImplementado() {
                        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado()) || Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && parcela.getCustoAquisicaoOrigemMEDolar().isVazio()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
                parcela.getCustoAquisicaoOrigemMEDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

                    @Override
                    public RetornoValidacao validarImplementado() {
                        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado()) || Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && parcela.getCustoAquisicaoOrigemNacionalDolar().isVazio()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
            }
        });
        this.getBemImovel().getAquisicao().getParcelasAquisicao().addObservador("ObjetoRemovido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParcelaAquisicao parcela = (ParcelaAquisicao)((Object)valorNovo);
                parcela.getData().getListaValidadores().clear();
                parcela.getCotacaoDolar().getListaValidadores().clear();
                parcela.getCustoAquisicaoOrigemNacionalDolar().getListaValidadores().clear();
                parcela.getCustoAquisicaoOrigemMEDolar().getListaValidadores().clear();
            }
        });
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemImovel.this.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getMoedaEstrangeira().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoExterior() && AlienacaoBemImovel.this.getBemImovel().getAquisicao().getMoedaEstrangeira().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemImovel.this.getBemImovel().getAquisicao().getMoedaEstrangeira().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getBemImovel().getAquisicao().getBemAtualizado().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
        this.getBemImovel().getAquisicao().getBemAtualizado().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().bemAtualizado() && AlienacaoBemImovel.this.getDataAlienacao().validar().isTodosValidos() && AlienacaoBemImovel.this.getDataAlienacao().maisAntiga(ConstantesGlobaisGCAP.obterDataInicioPagamentoDARFLei14973())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("data_minima_lei_14973", new String[]{ConstantesGlobaisGCAP.DATA_INICIO_PAGAMENTO_DARF_LEI_14973}), 3);
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getValorDTA().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().bemAtualizado()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getDataDTA().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().bemAtualizado()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getDataDTA().addValidador((ValidadorIf)new ValidadorData(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().bemAtualizado()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemImovel().getAquisicao().getDataDTA().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().bemAtualizado()) {
                    Data inicio = new Data();
                    Data fim = new Data();
                    inicio.setConteudo(ConstantesGlobaisGCAP.DATA_INICIO_PAGAMENTO_DARF_LEI_14973);
                    fim.setConteudo(ConstantesGlobaisGCAP.DATA_FINAL_LEI_14973);
                    if (AlienacaoBemImovel.this.getBemImovel().getAquisicao().getDataDTA().maisAntiga(inicio) || AlienacaoBemImovel.this.getBemImovel().getAquisicao().getDataDTA().maisNova(fim)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("data_DTA_fora_periodo", new String[]{ConstantesGlobaisGCAP.DATA_INICIO_PAGAMENTO_DARF_LEI_14973, ConstantesGlobaisGCAP.DATA_FINAL_LEI_14973}));
                    }
                }
                return null;
            }
        });
    }

    public void adicionarValidadoresOperacao() {
        this.getAlienacaoParcial().addValidador((ValidadorIf)new ValidadorPerguntaAlienacaoParcial(this.getDataAlienacao(), this.getNatureza(), null));
        this.getNatureza().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getNatureza().getNomeCampo()})));
        this.getValorAlienacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.bemImovel.isAdquiridoNoBrasil() && AlienacaoBemImovel.this.getValorAlienacao().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemImovel.this.getValorAlienacao().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getCotacaoDolarDataAlienacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.bemImovel.isAdquiridoNoExterior() && AlienacaoBemImovel.this.getCotacaoDolarDataAlienacao().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemImovel.this.getCotacaoDolarDataAlienacao().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValorAlienacaoDolar().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.bemImovel.isAdquiridoNoExterior() && AlienacaoBemImovel.this.getValorAlienacaoDolar().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemImovel.this.getValorAlienacaoDolar().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getGanhoCapitalAlienacaoAnterior().addValidador((ValidadorIf)new ValidadorGanhoAlienacaoParcial(this.getAlienacaoParcial()));
        this.getValorCorretagemDolar().addValidador((ValidadorIf)new ValidadorComparacaoValor(3, -2, (Object)this.getValorAlienacaoDolar()));
        this.getCustoCorretagem().addValidador((ValidadorIf)new ValidadorComparacaoValor(3, -2, (Object)this.getValorAlienacao()));
        this.getCustoCorretagem().addValidador((ValidadorIf)new ValidadorCorretagemTotalExcedida("R$", this.getColecaoParcelaAlienacao().getCustoCorretagemTotal(), this.getCorretagemAnosAnteriores(), this.getCustoCorretagem(), this.getAlienacaoAPrazo()));
        this.getValorCorretagemDolar().addValidador((ValidadorIf)new ValidadorCorretagemTotalExcedida("XX$", this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal(), null, this.getValorCorretagemDolar(), this.getAlienacaoAPrazo()));
    }

    public void adicionarValidadoresCalculoImposto() {
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().comparacao(">", AlienacaoBemImovel.this.getValorImpostoExteriorReal())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("impostoPagoExteriorMaiorQuePermitido"));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                ValorPositivo impostoPagoTotal = new ValorPositivo();
                impostoPagoTotal.setConteudo(AlienacaoBemImovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao());
                impostoPagoTotal.append('+', AlienacaoBemImovel.this.getCalculoImposto().getImpostoPago());
                if (impostoPagoTotal.comparacao(">", AlienacaoBemImovel.this.getCalculoImposto().getImpostoDevido())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("somatorioImpostoPagoBrasilMaisExterior"));
                }
                return new RetornoValidacao(0);
            }
        });
    }

    public void adicionarValidadoresPerguntas() {
        this.getBemGrandeValor().addValidador((ValidadorIf)new ValidadorPerguntaBemGrandeValor(this));
        this.getPerguntas().getImovelResidencial().addValidador((ValidadorIf)new ValidadorPerguntaImovelResidencial(this));
        this.getPerguntas().getPropriedadeOutroImovel().addValidador((ValidadorIf)new ValidadorPerguntaOutroImovel(this));
        this.getPerguntas().getOutraAlienacao().addValidador((ValidadorIf)new ValidadorPerguntaOutraAlienacao(this));
        this.getPerguntas().getMP252().addValidador((ValidadorIf)new ValidadorPerguntaMP252(this));
        this.getPerguntas().getMP252Parte2().addValidador((ValidadorIf)new ValidadorPerguntaMP252Parte2(this));
        this.getValorAplicado().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getPerguntas().isValorReaplicadoParcialmente() && this.getInformacao().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getInformacao().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValorAplicado().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                ValorPositivo somatorio = new ValorPositivo();
                if (!AlienacaoBemImovel.this.isAlienacaoEmAnoAnterior() && AlienacaoBemImovel.this.isAlienacaoAPrazo() && AlienacaoBemImovel.this.getPerguntas().isValorReaplicadoParcialmente()) {
                    if (AlienacaoBemImovel.this.isAlienacaoBrasil()) {
                        this.setSeveridade((byte)3);
                        for (ParcelaAlienacaoBem parcela : AlienacaoBemImovel.this.getColecaoParcelaAlienacao().itens()) {
                            somatorio.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovel());
                        }
                    } else {
                        this.setSeveridade((byte)2);
                        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(AlienacaoBemImovel.this.obterCodigoOrigemRendimentos().naoFormatado())) {
                            for (ParcelaAlienacaoBem parcela : AlienacaoBemImovel.this.getColecaoParcelaAlienacao().itens()) {
                                somatorio.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovelMN());
                            }
                        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(AlienacaoBemImovel.this.obterCodigoOrigemRendimentos().naoFormatado())) {
                            for (ParcelaAlienacaoBem parcela : AlienacaoBemImovel.this.getColecaoParcelaAlienacao().itens()) {
                                somatorio.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovelME());
                            }
                        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemImovel.this.obterCodigoOrigemRendimentos().naoFormatado())) {
                            for (ParcelaAlienacaoBem parcela : AlienacaoBemImovel.this.getColecaoParcelaAlienacao().itens()) {
                                somatorio.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas());
                            }
                        }
                    }
                    if (AlienacaoBemImovel.this.getValorAplicado().comparacao("<", somatorio)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("valorAplicadoOutroImovelMaiorQueDeclarado", new String[]{somatorio.formatado(), AlienacaoBemImovel.this.getValorAplicado().formatado()}));
                    }
                    if (!AlienacaoBemImovel.this.getDataRecebimentoUltimaParcela().isVazio() && AlienacaoBemImovel.this.getValorAplicado().comparacao(">", somatorio)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("valorAplicadoOutroImovelMenorQueDeclarado", new String[]{somatorio.formatado(), AlienacaoBemImovel.this.getValorAplicado().formatado()}));
                    }
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValorAplicado().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                String fatorComparacao = ">";
                String codMensagemErro = "valorAplicadoOutroImovelMaiorQueValorAlienacao";
                if (AlienacaoBemImovel.this.getPerguntas().isValorReaplicadoParcialmente()) {
                    fatorComparacao = ">=";
                    codMensagemErro = "valorAplicadoOutroImovelMaiorIgualQueValorAlienacao";
                }
                if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoBrasil()) {
                    if (AlienacaoBemImovel.this.getValorAplicado().comparacao(fatorComparacao, AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacao())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem(codMensagemErro, new String[]{AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacao().formatado()}));
                    }
                } else if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoExterior()) {
                    ValorPositivo lValorLiquidoAlienacao = new ValorPositivo(null, "", 11, 2);
                    lValorLiquidoAlienacao.append('+', AlienacaoBemImovel.this.getApuracao().getValorLiquidoAlienacaoDolar());
                    lValorLiquidoAlienacao.append('*', AlienacaoBemImovel.this.getCotacaoDolarDataAlienacao());
                    if (AlienacaoBemImovel.this.getValorAplicado().comparacao(fatorComparacao, lValorLiquidoAlienacao)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem(codMensagemErro, new String[]{lValorLiquidoAlienacao.formatado()}));
                    }
                }
                return new RetornoValidacao(0);
            }
        });
        this.getPerguntas().getMP252PrimeiraAlienacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemImovel.this.getPerguntas().isValorReaplicado() && AlienacaoBemImovel.this.getPerguntas().getMP252PrimeiraAlienacao().isVazio()) {
                    return super.validarImplementado();
                }
                return new RetornoValidacao(0);
            }
        });
        this.getPerguntas().getMP252PrimeiraAlienacao().addValidador((ValidadorIf)new ValidadorIsencaoPergunta180Dias(this));
        this.getPerguntas().getDataPrimeiraAlienacao().addValidador((ValidadorIf)new ValidadorData(3));
        this.getPerguntas().getDataPrimeiraAlienacao().addValidador((ValidadorIf)new ValidadorIsencao180DiasDataPrimeiraAlienacao(this));
        this.getPerguntas().getOutraAlienacao().addValidador((ValidadorIf)new ValidadorIsencaoPerguntaImovelUnico(this));
    }

    public void adicionarValidadores() {
        this.adicionarValidadoresIdentificacao();
        this.adicionarValidadoresAquisicao();
        this.adicionarValidadoresOperacao();
        this.adicionarValidadoresPerguntas();
        this.adicionarValidadoresCalculoImposto();
    }

    public BemImovel getBemImovel() {
        return this.bemImovel;
    }

    public ValorPositivo getValorAplicado() {
        return this.valorAplicado;
    }

    public PerguntasImovel getPerguntas() {
        return this.perguntas;
    }

    @Override
    public boolean isAlienacaoBrasil() {
        return this.getBemImovel().isAdquiridoNoBrasil();
    }

    @Override
    public Aquisicao getAquisicao() {
        return this.getBemImovel().getAquisicao();
    }

    @Override
    public ApuracaoBemImovel getApuracao() {
        return this.apuracao;
    }

    @Override
    public ApuracaoBemImovel getApuracaoFinal() {
        return this.apuracaoFinal;
    }

    @Override
    public Codigo obterCodigoOrigemRendimentos() {
        return this.getBemImovel().getAquisicao().getOrigemRendimentos();
    }

    private ValorPositivo calcularPercentualValorReaplicacaoOutroImovel(ValorPositivo valorLiquidoAlienacaoReal, ValorPositivo ValorInformadoReducaoAplicacaoOutroImovel, ValorPositivo ganhoCapital4) {
        ValorPositivo valorAplicadoOutroImovel = new ValorPositivo(null, "", 11, 9);
        ValorPositivo percentualAplicadoOutroImovel = new ValorPositivo(null, "", 11, 6);
        if (this.criticarLei180Dias()) {
            if (!ValorInformadoReducaoAplicacaoOutroImovel.isVazio() && !valorLiquidoAlienacaoReal.isVazio()) {
                percentualAplicadoOutroImovel.setConteudo(ValorInformadoReducaoAplicacaoOutroImovel);
                percentualAplicadoOutroImovel.append('*', "100");
                percentualAplicadoOutroImovel.append('/', valorLiquidoAlienacaoReal);
                valorAplicadoOutroImovel.setConteudo(percentualAplicadoOutroImovel);
                valorAplicadoOutroImovel.append('/', "100");
                valorAplicadoOutroImovel.append('*', ganhoCapital4);
            } else {
                percentualAplicadoOutroImovel.clear();
                valorAplicadoOutroImovel.clear();
                valorAplicadoOutroImovel.clear();
            }
        }
        valorAplicadoOutroImovel.setCasasDecimais(2);
        return valorAplicadoOutroImovel;
    }

    private void calcularGanhoReducoesSemReformaBrasil(ParcelaAlienacao parcela) {
        ValorPositivo valorReducaoLei7713 = new ValorPositivo(null, "valorReducaoLei7713", 11, 9);
        ValorPositivo valorReducaoLei11196FR1 = new ValorPositivo(null, "valorReducaoLei11196FR1", 11, 9);
        ValorPositivo valorReducaoLei11196FR2 = new ValorPositivo(null, "valorReducaoLei11196FR2", 11, 9);
        ValorPositivo ganho2Proporcional = new ValorPositivo(null, "Ganho 2 Proporcional", 11, 9);
        ValorPositivo ganho3Proporcional = new ValorPositivo(null, "Ganho 3 Proporcional", 11, 9);
        ValorPositivo ganho4Proporcional = new ValorPositivo(null, "Ganho 4 Proporcional", 11, 9);
        parcela.getPercentualReducaoLei7713().setConteudo(this.getApuracao().getPercentualReducaoLei7713());
        parcela.getPercentualReducaoLei11196FR1().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR1());
        parcela.getPercentualReducaoLei11196FR2().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR2());
        valorReducaoLei7713.setConteudo(parcela.getGanhoCapital1Proporcional());
        valorReducaoLei7713.append('/', "100");
        valorReducaoLei7713.append('*', parcela.getPercentualReducaoLei7713());
        parcela.getValorReducaoLei7713().setConteudo(valorReducaoLei7713);
        ganho2Proporcional.setConteudo(parcela.getGanhoCapital1Proporcional());
        ganho2Proporcional.append('-', parcela.getValorReducaoLei7713());
        parcela.getGanhoCapital2Proporcional().setConteudo(ganho2Proporcional);
        valorReducaoLei11196FR1.setConteudo(parcela.getGanhoCapital2Proporcional());
        valorReducaoLei11196FR1.append('/', "100");
        valorReducaoLei11196FR1.append('*', parcela.getPercentualReducaoLei11196FR1());
        parcela.getValorReducaoLei11196FR1().setConteudo(valorReducaoLei11196FR1);
        ganho3Proporcional.setConteudo(parcela.getGanhoCapital2Proporcional());
        ganho3Proporcional.append('-', parcela.getValorReducaoLei11196FR1());
        parcela.getGanhoCapital3Proporcional().setConteudo(ganho3Proporcional);
        valorReducaoLei11196FR2.setConteudo(parcela.getGanhoCapital3Proporcional());
        valorReducaoLei11196FR2.append('/', "100");
        valorReducaoLei11196FR2.append('*', parcela.getPercentualReducaoLei11196FR2());
        parcela.getValorReducaoLei11196FR2().setConteudo(valorReducaoLei11196FR2);
        ganho4Proporcional.setConteudo(parcela.getGanhoCapital3Proporcional());
        ganho4Proporcional.append('-', parcela.getValorReducaoLei11196FR2());
        parcela.getGanhoCapital4Proporcional().setConteudo(ganho4Proporcional);
    }

    private void calcularGanhoReducoesComReformaBrasil(ParcelaAlienacao parcela) {
        ValorPositivo lValorTotalReducaoLei7713 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo lValorTotalReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo lValorTotalReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo ganho2Proporcional = new ValorPositivo(null, "Ganho 2 Proporcional", 11, 9);
        ValorPositivo ganho3Proporcional = new ValorPositivo(null, "Ganho 3 Proporcional", 11, 9);
        ValorPositivo ganho4Proporcional = new ValorPositivo(null, "Ganho 4 Proporcional", 11, 9);
        parcela.getPercentualReducaoLei7713().setConteudo(this.getApuracao().getPercentualReducaoLei7713());
        parcela.getPercentualReducaoLei11196FR1().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR1());
        parcela.getPercentualReducaoLei11196FR2().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR2());
        for (ParcelaApuracaoCustoAquisicao parcelaAquisicao : this.getApuracao().getParcelasCustoAquisicao().itens()) {
            ValorPositivo vpr = new ValorPositivo(null, "", 11, 9);
            vpr.append('+', parcela.getGanhoCapital1Proporcional());
            vpr.append('/', "100");
            vpr.append('*', parcelaAquisicao.getPercentualCustoTotal());
            vpr.converteQtdCasasDecimais(2);
            ValorPositivo lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei7713(parcelaAquisicao.getData());
            if (parcela.getPercentualReducaoLei7713().isVazio()) {
                lPercentualReducao.clear();
            }
            ValorPositivo lValorReducaoLei7713 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei7713.append('+', vpr);
            lValorReducaoLei7713.append('/', "100");
            lValorReducaoLei7713.append('*', lPercentualReducao);
            lValorTotalReducaoLei7713.append('+', lValorReducaoLei7713);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR1(parcelaAquisicao.getData());
            if (parcela.getPercentualReducaoLei11196FR1().isVazio()) {
                lPercentualReducao.clear();
            }
            ValorPositivo lValorReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei11196FR1.append('+', vpr);
            lValorReducaoLei11196FR1.append('-', lValorReducaoLei7713);
            lValorReducaoLei11196FR1.append('/', "100");
            lValorReducaoLei11196FR1.append('*', lPercentualReducao);
            lValorTotalReducaoLei11196FR1.append('+', lValorReducaoLei11196FR1);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR2(parcelaAquisicao.getData(), this.getDataAlienacao());
            if (parcela.getPercentualReducaoLei11196FR2().isVazio()) {
                lPercentualReducao.clear();
            }
            ValorPositivo lValorReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei11196FR2.append('+', vpr);
            lValorReducaoLei11196FR2.append('-', lValorReducaoLei7713);
            lValorReducaoLei11196FR2.append('-', lValorReducaoLei11196FR1);
            lValorReducaoLei11196FR2.append('/', "100");
            lValorReducaoLei11196FR2.append('*', lPercentualReducao);
            lValorTotalReducaoLei11196FR2.append('+', lValorReducaoLei11196FR2);
        }
        parcela.getValorReducaoLei7713().setConteudo(lValorTotalReducaoLei7713);
        parcela.getValorReducaoLei11196FR1().setConteudo(lValorTotalReducaoLei11196FR1);
        parcela.getValorReducaoLei11196FR2().setConteudo(lValorTotalReducaoLei11196FR2);
        ganho2Proporcional.setConteudo(parcela.getGanhoCapital1Proporcional());
        ganho2Proporcional.append('-', parcela.getValorReducaoLei7713());
        parcela.getGanhoCapital2Proporcional().setConteudo(ganho2Proporcional);
        ganho3Proporcional.setConteudo(parcela.getGanhoCapital2Proporcional());
        ganho3Proporcional.append('-', parcela.getValorReducaoLei11196FR1());
        parcela.getGanhoCapital3Proporcional().setConteudo(ganho3Proporcional);
        ganho4Proporcional.setConteudo(parcela.getGanhoCapital3Proporcional());
        ganho4Proporcional.append('-', parcela.getValorReducaoLei11196FR2());
        parcela.getGanhoCapital4Proporcional().setConteudo(ganho4Proporcional);
    }

    public void recalcularParcelasBrasil() {
        if (this.isAlienacaoBrasil() && this.isAlienacaoAPrazo()) {
            for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                this.calcularParcelaBrasil(parcela);
            }
        }
    }

    @Override
    public void calcularParcelaBrasil(ParcelaAlienacao parcela) {
        ValorPositivo valorLiquidoAlienacao = new ValorPositivo(null, "valorLiquidoAlienacao", 11, 9);
        ValorPositivo custoAquisicaoProporcional = new ValorPositivo(null, "custoAquisicaoProporcional", 11, 9);
        ValorPositivo ganho1Proporcional = new ValorPositivo(null, "Ganho 1 Proporcional", 11, 9);
        ValorPositivo ganho5Proporcional = new ValorPositivo(null, "Ganho 5 Proporcional", 11, 9);
        ValorPositivo impostoDevido = new ValorPositivo(null, "ImpostoDevido Parcela", 11, 9);
        ValorPositivo percentualAplicadoOutroImovel = new ValorPositivo(null, "percentualAplicadoOutroImovel", 11, 6);
        ValorPositivo valorAplicadoOutroImovel = new ValorPositivo(null, "valorAplicadoOutroImovel", 11, 9);
        ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 6);
        valorLiquidoAlienacao.setConteudo(parcela.getValorRecebido());
        valorLiquidoAlienacao.append('-', parcela.getCustoCorretagem());
        parcela.getValorLiquidoAlienacao().setConteudo(valorLiquidoAlienacao);
        if (parcela.getValorLiquidoAlienacao().isVazio() || this.getApuracao().getGanhoCapital5().isVazio()) {
            parcela.getCustoAquisicaoProporcional().clear();
            parcela.getCustoAquisicaoTornaProporcional().clear();
            parcela.getGanhoCapital1Proporcional().clear();
            parcela.getGanhoCapital2Proporcional().clear();
            parcela.getGanhoCapital3Proporcional().clear();
            parcela.getGanhoCapital4Proporcional().clear();
            parcela.getGanhoCapital5Proporcional().clear();
            parcela.getPercentualReducaoLei7713().clear();
            parcela.getPercentualReducaoLei11196FR1().clear();
            parcela.getPercentualReducaoLei11196FR2().clear();
            parcela.getPercentualReducaoAplicacaoOutroImovel().clear();
            parcela.getPercentualReducaoBemPequenoValor().clear();
            parcela.getPercentualReducaoUnicoImovel().clear();
            parcela.getValorReducaoLei7713().clear();
            parcela.getValorReducaoLei11196FR1().clear();
            parcela.getValorReducaoLei11196FR2().clear();
            parcela.getValorReducaoAplicacaoOutroImovel().clear();
            parcela.getValorReducaoBemPequenoValor().clear();
            parcela.getValorReducaoUnicoImovel().clear();
            parcela.getImpostoDevido().clear();
            parcela.getImpostoDevido2().clear();
        } else {
            if (this.isPermutaComTorna()) {
                custoAquisicaoProporcional.setConteudo(parcela.getValorLiquidoAlienacao());
                custoAquisicaoProporcional.append('*', this.getApuracao().getCustoAquisicaoTorna());
                custoAquisicaoProporcional.append('/', this.getApuracao().getValorLiquidoAlienacao());
                custoAquisicaoProporcional.converteQtdCasasDecimaisRoundUp(2);
                parcela.getCustoAquisicaoTornaProporcional().setConteudo(custoAquisicaoProporcional);
            } else {
                custoAquisicaoProporcional.setConteudo(parcela.getValorLiquidoAlienacao());
                custoAquisicaoProporcional.append('*', this.getApuracao().getCustoAquisicao());
                custoAquisicaoProporcional.append('/', this.getApuracao().getValorLiquidoAlienacao());
                custoAquisicaoProporcional.converteQtdCasasDecimaisRoundUp(2);
                parcela.getCustoAquisicaoProporcional().setConteudo(custoAquisicaoProporcional);
            }
            ganho1Proporcional.setConteudo(parcela.getValorLiquidoAlienacao());
            ganho1Proporcional.append('-', custoAquisicaoProporcional);
            parcela.getGanhoCapital1Proporcional().setConteudo(ganho1Proporcional);
            if (this.getBemImovel().getAquisicao().houveReforma()) {
                this.calcularGanhoReducoesComReformaBrasil(parcela);
            } else {
                this.calcularGanhoReducoesSemReformaBrasil(parcela);
            }
            parcela.getValorReducaoBemPequenoValor().clear();
            parcela.getValorReducaoUnicoImovel().clear();
            parcela.getValorReducaoAplicacaoOutroImovel().clear();
            if (this.isIsentoPorPequenoValor()) {
                parcela.getValorReducaoBemPequenoValor().setConteudo(parcela.getGanhoCapital4Proporcional());
                parcela.getGanhoCapital5Proporcional().clear();
            } else if (this.isIsentoPorUnicoImovel()) {
                parcela.getValorReducaoUnicoImovel().setConteudo(parcela.getGanhoCapital4Proporcional());
                parcela.getGanhoCapital5Proporcional().clear();
            } else {
                if (!this.getPerguntas().isValorReaplicado()) {
                    percentualAplicadoOutroImovel.clear();
                    valorAplicadoOutroImovel.clear();
                } else if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    percentualAplicadoOutroImovel.setConteudo("100,000000");
                    valorAplicadoOutroImovel.setConteudo(parcela.getGanhoCapital4Proporcional());
                } else if (this.getPerguntas().isValorReaplicadoParcialmente()) {
                    if (this.criticarLei180Dias()) {
                        if (!parcela.getValorInformadoReducaoAplicacaoOutroImovel().isVazio()) {
                            percentualAplicadoOutroImovel.setConteudo(parcela.getValorInformadoReducaoAplicacaoOutroImovel());
                            percentualAplicadoOutroImovel.append('*', "100");
                            percentualAplicadoOutroImovel.append('/', parcela.getValorLiquidoAlienacao());
                            valorAplicadoOutroImovel.setConteudo(percentualAplicadoOutroImovel);
                            valorAplicadoOutroImovel.append('/', "100");
                            valorAplicadoOutroImovel.append('*', parcela.getGanhoCapital4Proporcional());
                        } else {
                            percentualAplicadoOutroImovel.clear();
                            valorAplicadoOutroImovel.clear();
                        }
                    } else {
                        percentualAplicadoOutroImovel.setConteudo(this.getApuracao().getPercentualReducaoAplicacaoOutroImovel());
                        valorAplicadoOutroImovel.setConteudo(percentualAplicadoOutroImovel);
                        valorAplicadoOutroImovel.append('/', "100");
                        valorAplicadoOutroImovel.append('*', parcela.getGanhoCapital4Proporcional());
                    }
                }
                parcela.getPercentualReducaoAplicacaoOutroImovel().setConteudo(percentualAplicadoOutroImovel);
                parcela.getValorReducaoAplicacaoOutroImovel().setConteudo(valorAplicadoOutroImovel);
                if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    parcela.getGanhoCapital5Proporcional().clear();
                } else {
                    ganho5Proporcional.setConteudo(parcela.getGanhoCapital4Proporcional());
                    ganho5Proporcional.append('-', parcela.getValorReducaoAplicacaoOutroImovel());
                    parcela.getGanhoCapital5Proporcional().setConteudo(ganho5Proporcional);
                }
            }
            if (parcela.getGanhoCapital5Proporcional().isVazio() || this.getCalculoImposto().getGanhoCapitalTotal().isVazio()) {
                impostoDevido.clear();
                parcela.getAliquotaMedia().clear();
            } else {
                impostoDevidoTotal.setConteudo(this.getCalculoImposto().calcularImpostoDevidoTotal(this));
                parcela.getAliquotaMedia().setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(this.getCalculoImposto().getGanhoCapitalTotal(), impostoDevidoTotal));
                impostoDevido.setConteudo(parcela.getGanhoCapital5Proporcional());
                impostoDevido.append('*', impostoDevidoTotal);
                impostoDevido.append('/', this.getCalculoImposto().getGanhoCapitalTotal());
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            parcela.getImpostoDevido2().setConteudo(parcela.getImpostoDevido());
        }
    }

    private void calcularGanhoReducoesSemReformaExteriorMoedaNacional(ParcelaAlienacaoBem parcela) {
        ValorPositivo valorReducaoLei7713 = new ValorPositivo(null, "valorReducaoLei7713", 11, 9);
        ValorPositivo valorReducaoLei11196FR1 = new ValorPositivo(null, "valorReducaoLei11196FR1", 11, 9);
        ValorPositivo valorReducaoLei11196FR2 = new ValorPositivo(null, "valorReducaoLei11196FR2", 11, 9);
        ValorPositivo ganho2Proporcional = new ValorPositivo(null, "Ganho 2 Proporcional", 11, 9);
        ValorPositivo ganho3Proporcional = new ValorPositivo(null, "Ganho 3 Proporcional", 11, 9);
        ValorPositivo ganho4Proporcional = new ValorPositivo(null, "Ganho 4 Proporcional", 11, 9);
        parcela.getPercentualReducaoLei7713MN().setConteudo(this.getApuracao().getPercentualReducaoLei7713OrigemMN());
        parcela.getPercentualReducaoLei11196FR1MN().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR1OrigemMN());
        parcela.getPercentualReducaoLei11196FR2MN().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR2OrigemMN());
        valorReducaoLei7713.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        valorReducaoLei7713.append('/', "100");
        valorReducaoLei7713.append('*', parcela.getPercentualReducaoLei7713MN());
        parcela.getValorReducaoLei7713MN().setConteudo(valorReducaoLei7713);
        ganho2Proporcional.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        ganho2Proporcional.append('-', parcela.getValorReducaoLei7713MN());
        parcela.getGanhoCapital2ProporcionalMN().setConteudo(ganho2Proporcional);
        valorReducaoLei11196FR1.append('+', parcela.getGanhoCapital2ProporcionalMN());
        valorReducaoLei11196FR1.append('/', "100");
        valorReducaoLei11196FR1.append('*', parcela.getPercentualReducaoLei11196FR1MN());
        parcela.getValorReducaoLei11196FR1MN().setConteudo(valorReducaoLei11196FR1);
        ganho3Proporcional.setConteudo(parcela.getGanhoCapital2ProporcionalMN());
        ganho3Proporcional.append('-', parcela.getValorReducaoLei11196FR1MN());
        parcela.getGanhoCapital3ProporcionalMN().setConteudo(ganho3Proporcional);
        valorReducaoLei11196FR2.append('+', parcela.getGanhoCapital3ProporcionalMN());
        valorReducaoLei11196FR2.append('/', "100");
        valorReducaoLei11196FR2.append('*', parcela.getPercentualReducaoLei11196FR2MN());
        parcela.getValorReducaoLei11196FR2MN().setConteudo(valorReducaoLei11196FR2);
        ganho4Proporcional.setConteudo(parcela.getGanhoCapital3ProporcionalMN());
        ganho4Proporcional.append('-', parcela.getValorReducaoLei11196FR2MN());
        parcela.getGanhoCapital4ProporcionalMN().setConteudo(ganho4Proporcional);
    }

    private void calcularGanhoReducoesComReformaExteriorMoedaNacional(ParcelaAlienacaoBem parcela) {
        ValorPositivo lValorTotalReducaoLei7713 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo lValorTotalReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo lValorTotalReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo ganho2Proporcional = new ValorPositivo(null, "Ganho 2 Proporcional", 11, 9);
        ValorPositivo ganho3Proporcional = new ValorPositivo(null, "Ganho 3 Proporcional", 11, 9);
        ValorPositivo ganho4Proporcional = new ValorPositivo(null, "Ganho 4 Proporcional", 11, 9);
        for (ParcelaApuracaoCustoAquisicao parcelaAquisicao : this.getApuracao().getParcelasCustoAquisicao().itens()) {
            ValorPositivo vpr = new ValorPositivo(null, "", 11, 9);
            vpr.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
            vpr.append('/', "100");
            vpr.append('*', parcelaAquisicao.getPercentualCustoTotalReal());
            vpr.converteQtdCasasDecimais(2);
            ValorPositivo lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei7713(parcelaAquisicao.getData());
            ValorPositivo lValorReducaoLei7713 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei7713.append('+', vpr);
            lValorReducaoLei7713.append('/', "100");
            lValorReducaoLei7713.append('*', lPercentualReducao);
            lValorTotalReducaoLei7713.append('+', lValorReducaoLei7713);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR1(parcelaAquisicao.getData());
            ValorPositivo lValorReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei11196FR1.append('+', vpr);
            lValorReducaoLei11196FR1.append('-', lValorReducaoLei7713);
            lValorReducaoLei11196FR1.append('/', "100");
            lValorReducaoLei11196FR1.append('*', lPercentualReducao);
            lValorTotalReducaoLei11196FR1.append('+', lValorReducaoLei11196FR1);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR2(parcelaAquisicao.getData(), this.getDataAlienacao());
            ValorPositivo lValorReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei11196FR2.append('+', vpr);
            lValorReducaoLei11196FR2.append('-', lValorReducaoLei7713);
            lValorReducaoLei11196FR2.append('-', lValorReducaoLei11196FR1);
            lValorReducaoLei11196FR2.append('/', "100");
            lValorReducaoLei11196FR2.append('*', lPercentualReducao);
            lValorTotalReducaoLei11196FR2.append('+', lValorReducaoLei11196FR2);
        }
        parcela.getPercentualReducaoLei7713MN().setConteudo(this.getApuracao().getPercentualReducaoLei7713OrigemMN());
        parcela.getPercentualReducaoLei11196FR1MN().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR1OrigemMN());
        parcela.getPercentualReducaoLei11196FR2MN().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR2OrigemMN());
        parcela.getValorReducaoLei7713MN().setConteudo(lValorTotalReducaoLei7713);
        parcela.getValorReducaoLei11196FR1MN().setConteudo(lValorTotalReducaoLei11196FR1);
        parcela.getValorReducaoLei11196FR2MN().setConteudo(lValorTotalReducaoLei11196FR2);
        ganho2Proporcional.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        ganho2Proporcional.append('-', parcela.getValorReducaoLei7713MN());
        parcela.getGanhoCapital2ProporcionalMN().setConteudo(ganho2Proporcional);
        ganho3Proporcional.setConteudo(parcela.getGanhoCapital2ProporcionalMN());
        ganho3Proporcional.append('-', parcela.getValorReducaoLei11196FR1MN());
        parcela.getGanhoCapital3ProporcionalMN().setConteudo(ganho3Proporcional);
        ganho4Proporcional.setConteudo(parcela.getGanhoCapital3ProporcionalMN());
        ganho4Proporcional.append('-', parcela.getValorReducaoLei11196FR2MN());
        parcela.getGanhoCapital4ProporcionalMN().setConteudo(ganho4Proporcional);
    }

    private void calcularGanhoReducoesSemReformaExteriorMoedaEstrangeira(ParcelaAlienacaoBem parcela) {
        ValorPositivo valorReducaoLei7713 = new ValorPositivo(null, "valorReducaoLei7713", 11, 9);
        ValorPositivo valorReducaoLei11196FR1 = new ValorPositivo(null, "valorReducaoLei11196FR1", 11, 9);
        ValorPositivo valorReducaoLei11196FR2 = new ValorPositivo(null, "valorReducaoLei11196FR2", 11, 9);
        ValorPositivo ganho2Proporcional = new ValorPositivo(null, "Ganho 2 Proporcional", 11, 9);
        ValorPositivo ganho3Proporcional = new ValorPositivo(null, "Ganho 3 Proporcional", 11, 9);
        ValorPositivo ganho4Proporcional = new ValorPositivo(null, "Ganho 4 Proporcional", 11, 9);
        parcela.getPercentualReducaoLei7713ME().setConteudo(this.getApuracao().getPercentualReducaoLei7713OrigemME());
        parcela.getPercentualReducaoLei11196FR1ME().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR1OrigemME());
        parcela.getPercentualReducaoLei11196FR2ME().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR2OrigemME());
        valorReducaoLei7713.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        valorReducaoLei7713.append('/', "100");
        valorReducaoLei7713.append('*', parcela.getPercentualReducaoLei7713ME());
        parcela.getValorReducaoLei7713ME().setConteudo(valorReducaoLei7713);
        ganho2Proporcional.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        ganho2Proporcional.append('-', parcela.getValorReducaoLei7713ME());
        parcela.getGanhoCapital2ProporcionalME().setConteudo(ganho2Proporcional);
        valorReducaoLei11196FR1.append('+', parcela.getGanhoCapital2ProporcionalME());
        valorReducaoLei11196FR1.append('/', "100");
        valorReducaoLei11196FR1.append('*', parcela.getPercentualReducaoLei11196FR1ME());
        parcela.getValorReducaoLei11196FR1ME().setConteudo(valorReducaoLei11196FR1);
        ganho3Proporcional.setConteudo(parcela.getGanhoCapital2ProporcionalME());
        ganho3Proporcional.append('-', parcela.getValorReducaoLei11196FR1ME());
        parcela.getGanhoCapital3ProporcionalME().setConteudo(ganho3Proporcional);
        valorReducaoLei11196FR2.append('+', parcela.getGanhoCapital3ProporcionalME());
        valorReducaoLei11196FR2.append('/', "100");
        valorReducaoLei11196FR2.append('*', parcela.getPercentualReducaoLei11196FR2ME());
        parcela.getValorReducaoLei11196FR2ME().setConteudo(valorReducaoLei11196FR2);
        ganho4Proporcional.setConteudo(parcela.getGanhoCapital3ProporcionalME());
        ganho4Proporcional.append('-', parcela.getValorReducaoLei11196FR2ME());
        parcela.getGanhoCapital4ProporcionalME().setConteudo(ganho4Proporcional);
    }

    private void calcularGanhoReducoesComReformaExteriorMoedaEstrangeira(ParcelaAlienacaoBem parcela) {
        ValorPositivo lValorTotalReducaoLei7713 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo lValorTotalReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo lValorTotalReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 2);
        ValorPositivo ganho2Proporcional = new ValorPositivo(null, "Ganho 2 Proporcional", 11, 9);
        ValorPositivo ganho3Proporcional = new ValorPositivo(null, "Ganho 3 Proporcional", 11, 9);
        ValorPositivo ganho4Proporcional = new ValorPositivo(null, "Ganho 4 Proporcional", 11, 9);
        for (ParcelaApuracaoCustoAquisicao parcelaAquisicao : this.getApuracao().getParcelasCustoAquisicao().itens()) {
            ValorPositivo vpr = new ValorPositivo(null, "", 11, 9);
            vpr.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
            vpr.append('/', "100");
            vpr.append('*', parcelaAquisicao.getPercentualCustoTotalDolar());
            vpr.converteQtdCasasDecimais(2);
            ValorPositivo lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei7713(parcelaAquisicao.getData());
            ValorPositivo lValorReducaoLei7713 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei7713.append('+', vpr);
            lValorReducaoLei7713.append('/', "100");
            lValorReducaoLei7713.append('*', lPercentualReducao);
            lValorTotalReducaoLei7713.append('+', lValorReducaoLei7713);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR1(parcelaAquisicao.getData());
            ValorPositivo lValorReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei11196FR1.append('+', vpr);
            lValorReducaoLei11196FR1.append('-', lValorReducaoLei7713);
            lValorReducaoLei11196FR1.append('/', "100");
            lValorReducaoLei11196FR1.append('*', lPercentualReducao);
            lValorTotalReducaoLei11196FR1.append('+', lValorReducaoLei11196FR1);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR2(parcelaAquisicao.getData(), this.getDataAlienacao());
            ValorPositivo lValorReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 9);
            lValorReducaoLei11196FR2.append('+', vpr);
            lValorReducaoLei11196FR2.append('-', lValorReducaoLei7713);
            lValorReducaoLei11196FR2.append('-', lValorReducaoLei11196FR1);
            lValorReducaoLei11196FR2.append('/', "100");
            lValorReducaoLei11196FR2.append('*', lPercentualReducao);
            lValorTotalReducaoLei11196FR2.append('+', lValorReducaoLei11196FR2);
        }
        parcela.getPercentualReducaoLei7713ME().setConteudo(this.getApuracao().getPercentualReducaoLei7713OrigemME());
        parcela.getPercentualReducaoLei11196FR1ME().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR1OrigemME());
        parcela.getPercentualReducaoLei11196FR2ME().setConteudo(this.getApuracao().getPercentualReducaoLei11196FR2OrigemME());
        parcela.getValorReducaoLei7713ME().setConteudo(lValorTotalReducaoLei7713);
        parcela.getValorReducaoLei11196FR1ME().setConteudo(lValorTotalReducaoLei11196FR1);
        parcela.getValorReducaoLei11196FR2ME().setConteudo(lValorTotalReducaoLei11196FR2);
        ganho2Proporcional.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        ganho2Proporcional.append('-', parcela.getValorReducaoLei7713ME());
        parcela.getGanhoCapital2ProporcionalME().setConteudo(ganho2Proporcional);
        ganho3Proporcional.setConteudo(parcela.getGanhoCapital2ProporcionalME());
        ganho3Proporcional.append('-', parcela.getValorReducaoLei11196FR1ME());
        parcela.getGanhoCapital3ProporcionalME().setConteudo(ganho3Proporcional);
        ganho4Proporcional.setConteudo(parcela.getGanhoCapital3ProporcionalME());
        ganho4Proporcional.append('-', parcela.getValorReducaoLei11196FR2ME());
        parcela.getGanhoCapital4ProporcionalME().setConteudo(ganho4Proporcional);
    }

    @Override
    public void calcularParcelasExterior() {
        String origemRendimentos;
        if (GcapUtil.getEstadoSistema() == 0 && !this.podeResponderPerguntaBemIsentoPorPequenoValor()) {
            this.getBemGrandeValor().clear();
        }
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado())) {
            this.calcularParcelasOrigemNacional();
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
            this.calcularParcelasOrigemEstrangeira();
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
            this.calcularParcelasOrigemAmbas();
        }
    }

    @Override
    public void calcularParcelasOrigemNacional() {
        ValorPositivo saldoCustoAquisicaoProporcionalMNReal = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMNReal", 11, 9);
        ValorPositivo custoAquisicaoRealTotalUtilizado = new ValorPositivo(null, "custoAquisicaoTotalDolarUtilizado", 11, 9);
        if (this.isPermutaComTorna()) {
            saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal());
            custoAquisicaoRealTotalUtilizado.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal());
        } else if (this.getBemImovel().getAquisicao().houveReforma()) {
            saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal());
            custoAquisicaoRealTotalUtilizado.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal());
        } else {
            saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
            custoAquisicaoRealTotalUtilizado.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
        }
        Iterator itParcelas = this.getColecaoParcelaAlienacao().itens().iterator();
        while (itParcelas.hasNext()) {
            ValorPositivo valorRecebidoReal = new ValorPositivo(null, "valorRecebidoReal", 11, 9);
            ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(null, "valorLiquidoAlienacaoDolar", 11, 2);
            ValorPositivo valorLiquidoAlienacaoReal = new ValorPositivo(null, "valorLiquidoAlienacaoReal", 11, 2);
            ValorPositivo custoAquisicaoProporcionalMNReal = new ValorPositivo(null, "custoAquisicaoProporcionalMNReal", 11, 9);
            ValorPositivo ganho1Proporcional = new ValorPositivo(null, "ganhoProporcionalReal", 11, 9);
            ValorPositivo ganho5Proporcional = new ValorPositivo(null, "Ganho 5 Proporcional", 11, 9);
            ValorPositivo impostoDevido = new ValorPositivo(null, "ImpostoDevido Parcela", 11, 9);
            ValorPositivo percentualAplicadoOutroImovel = new ValorPositivo(null, "percentualAplicadoOutroImovel", 11, 6);
            ValorPositivo valorAplicadoOutroImovel = new ValorPositivo(null, "valorAplicadoOutroImovel", 11, 9);
            ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 6);
            ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)itParcelas.next());
            valorRecebidoReal.setConteudo(parcela.getValorRecebidoDolar());
            valorRecebidoReal.append('*', parcela.getCotacaoDolar());
            parcela.getValorRecebidoReal().setConteudo(valorRecebidoReal);
            valorLiquidoAlienacaoDolar.setConteudo(parcela.getValorRecebidoDolar());
            valorLiquidoAlienacaoDolar.append('-', parcela.getCustoCorretagemDolar());
            parcela.getValorLiquidoAlienacaoDolar().setConteudo(valorLiquidoAlienacaoDolar);
            valorLiquidoAlienacaoReal.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            valorLiquidoAlienacaoReal.append('*', parcela.getCotacaoDolar());
            parcela.getValorLiquidoAlienacaoReal().setConteudo(valorLiquidoAlienacaoReal);
            if (parcela.getValorLiquidoAlienacaoReal().isVazio()) {
                parcela.getCustoAquisicaoProporcionalOrigemNacionalReal().clear();
                parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().clear();
                parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().clear();
                parcela.getGanhoCapital2ProporcionalMN().clear();
                parcela.getGanhoCapital3ProporcionalMN().clear();
                parcela.getGanhoCapital4ProporcionalMN().clear();
                parcela.getGanhoCapital5ProporcionalMN().clear();
                parcela.getPercentualReducaoLei7713MN().clear();
                parcela.getPercentualReducaoLei11196FR1MN().clear();
                parcela.getPercentualReducaoLei11196FR2MN().clear();
                parcela.getPercentualReducaoAplicacaoOutroImovelMN().clear();
                parcela.getPercentualReducaoBemPequenoValorMN().clear();
                parcela.getPercentualReducaoUnicoImovelMN().clear();
                parcela.getValorReducaoLei7713MN().clear();
                parcela.getValorReducaoLei11196FR1MN().clear();
                parcela.getValorReducaoLei11196FR2MN().clear();
                parcela.getValorReducaoAplicacaoOutroImovelMN().clear();
                parcela.getValorReducaoBemPequenoValorMN().clear();
                parcela.getValorReducaoUnicoImovelMN().clear();
                parcela.getImpostoDevido().clear();
                parcela.getImpostoDevido2().clear();
                continue;
            }
            if (parcela.isUltimaParcela()) {
                custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
            } else {
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar().isVazio()) {
                    custoAquisicaoProporcionalMNReal.clear();
                } else {
                    custoAquisicaoProporcionalMNReal.setConteudo(custoAquisicaoRealTotalUtilizado);
                    custoAquisicaoProporcionalMNReal.append('*', parcela.getValorLiquidoAlienacaoDolar());
                    custoAquisicaoProporcionalMNReal.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar());
                    custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                }
                if (parcela.getValorLiquidoAlienacaoReal().comparacao("<", custoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(parcela.getValorLiquidoAlienacaoReal());
                }
                if (custoAquisicaoProporcionalMNReal.comparacao(">", saldoCustoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
                    custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                }
            }
            saldoCustoAquisicaoProporcionalMNReal.append('-', custoAquisicaoProporcionalMNReal);
            ganho1Proporcional.setConteudo(parcela.getValorLiquidoAlienacaoReal());
            if (this.isPermutaComTorna()) {
                parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().setConteudo(custoAquisicaoProporcionalMNReal);
                ganho1Proporcional.append('-', parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal());
            } else {
                parcela.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(custoAquisicaoProporcionalMNReal);
                ganho1Proporcional.append('-', parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
            }
            parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(ganho1Proporcional);
            if (this.getBemImovel().getAquisicao().houveReforma()) {
                this.calcularGanhoReducoesComReformaExteriorMoedaNacional(parcela);
            } else {
                this.calcularGanhoReducoesSemReformaExteriorMoedaNacional(parcela);
            }
            parcela.getValorReducaoBemPequenoValorMN().clear();
            parcela.getValorReducaoUnicoImovelMN().clear();
            parcela.getValorReducaoAplicacaoOutroImovelMN().clear();
            int enquadramento = REDUCAO_AUSENTE;
            enquadramento = parcela.isUltimaParcela() ? this.obterEnquadramentoFinal() : this.obterEnquadramentoInicial();
            if (enquadramento == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                parcela.getPercentualReducaoBemPequenoValorMN().setConteudo("100,000000");
                parcela.getValorReducaoBemPequenoValorMN().setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                parcela.getGanhoCapital5ProporcionalMN().clear();
            } else if (enquadramento == REDUCAO_UNICO_IMOVEL) {
                parcela.getPercentualReducaoUnicoImovelMN().setConteudo("100,000000");
                parcela.getValorReducaoUnicoImovelMN().setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                parcela.getGanhoCapital5ProporcionalMN().clear();
            } else {
                if (!this.getPerguntas().isValorReaplicado()) {
                    percentualAplicadoOutroImovel.clear();
                    valorAplicadoOutroImovel.clear();
                } else if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    percentualAplicadoOutroImovel.setConteudo("100,000000");
                    valorAplicadoOutroImovel.setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                } else if (this.getPerguntas().isValorReaplicadoParcialmente()) {
                    if (this.criticarLei180Dias()) {
                        if (!parcela.getValorInformadoReducaoAplicacaoOutroImovelMN().isVazio()) {
                            percentualAplicadoOutroImovel.setConteudo(parcela.getValorInformadoReducaoAplicacaoOutroImovelMN());
                            percentualAplicadoOutroImovel.append('*', "100");
                            percentualAplicadoOutroImovel.append('/', parcela.getValorLiquidoAlienacaoReal());
                            valorAplicadoOutroImovel.setConteudo(percentualAplicadoOutroImovel);
                            valorAplicadoOutroImovel.append('/', "100");
                            valorAplicadoOutroImovel.append('*', parcela.getGanhoCapital4ProporcionalMN());
                        } else {
                            percentualAplicadoOutroImovel.clear();
                            valorAplicadoOutroImovel.clear();
                        }
                    } else {
                        percentualAplicadoOutroImovel.setConteudo(this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
                        valorAplicadoOutroImovel.setConteudo(percentualAplicadoOutroImovel);
                        valorAplicadoOutroImovel.append('/', "100");
                        valorAplicadoOutroImovel.append('*', parcela.getGanhoCapital4ProporcionalMN());
                    }
                }
                parcela.getPercentualReducaoAplicacaoOutroImovelMN().setConteudo(percentualAplicadoOutroImovel);
                parcela.getValorReducaoAplicacaoOutroImovelMN().setConteudo(valorAplicadoOutroImovel);
                if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    parcela.getGanhoCapital5ProporcionalMN().clear();
                } else {
                    ganho5Proporcional.setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                    ganho5Proporcional.append('-', parcela.getValorReducaoAplicacaoOutroImovelMN());
                    parcela.getGanhoCapital5ProporcionalMN().setConteudo(ganho5Proporcional);
                }
            }
            if (parcela.getGanhoCapital5ProporcionalMN().isVazio()) {
                impostoDevido.clear();
                parcela.getAliquotaMedia().clear();
            } else if (this.isPrevisaoPrejuizo() && !parcela.getGanhoCapital5ProporcionalMN().isVazio()) {
                parcela.getAliquotaMedia().setConteudo("15,000000");
                impostoDevido.setConteudo(parcela.getGanhoCapital5ProporcionalMN());
                impostoDevido.append('*', "0,150000000");
            } else {
                impostoDevidoTotal.setConteudo(this.getCalculoImposto().calcularImpostoDevidoTotal(this, this.getApuracao().getGanhoCapital5OrigemMNReal()));
                parcela.getAliquotaMedia().setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(this.getApuracao().getGanhoCapital5OrigemMNReal(), impostoDevidoTotal));
                if (this.getApuracao().getGanhoCapital5OrigemMNReal().isVazio()) {
                    impostoDevido.clear();
                } else {
                    impostoDevido.setConteudo(parcela.getGanhoCapital5ProporcionalMN());
                    impostoDevido.append('*', impostoDevidoTotal);
                    impostoDevido.append('/', this.getApuracao().getGanhoCapital5OrigemMNReal());
                }
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            this.calcularApuracaoFinalOrigemNacional();
            if (!parcela.isUltimaParcela()) continue;
            this.calcularAjuste();
            this.calcularUltimaParcelaExterior(parcela);
            break;
        }
        if (this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            this.calcularApuracaoFinalOrigemNacional();
        }
        this.limparAjusteAlienacaoSemUltimaParcela();
        this.limparAjusteAlienacaoApuracaoFinalSemGanho(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal());
        this.getConsolidacao().calcularConsolidacaoImovel(this);
    }

    @Override
    public void calcularParcelasOrigemEstrangeira() {
        ValorPositivo saldoCustoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMEDolar", 11, 9);
        ValorPositivo custoAquisicaoDolarTotalUtilizado = new ValorPositivo(null, "custoAquisicaoDolarTotalUtilizado", 11, 9);
        if (this.isPermutaComTorna()) {
            saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar());
            custoAquisicaoDolarTotalUtilizado.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar());
        } else if (this.getBemImovel().getAquisicao().houveReforma()) {
            saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar());
            custoAquisicaoDolarTotalUtilizado.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar());
        } else {
            saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
            custoAquisicaoDolarTotalUtilizado.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
        }
        Iterator itParcelas = this.getColecaoParcelaAlienacao().itens().iterator();
        while (itParcelas.hasNext()) {
            ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(null, "valorLiquidoAlienacaoDolar", 11, 2);
            ValorPositivo valorLiquidoAlienacaoReal = new ValorPositivo(null, "valorLiquidoAlienacaoReal", 11, 2);
            ValorPositivo custoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "custoAquisicaoProporcionalMEDolar", 11, 9);
            ValorPositivo ganho1ProporcionalDolar = new ValorPositivo(null, "ganho1ProporcionalDolar", 11, 9);
            ValorPositivo ganho1ProporcionalReal = new ValorPositivo(null, "ganho1ProporcionalReal", 11, 9);
            ValorPositivo ganho5Proporcional = new ValorPositivo(null, "Ganho 5 Proporcional", 11, 9);
            ValorPositivo impostoDevido = new ValorPositivo(null, "ImpostoDevido Parcela", 11, 9);
            ValorPositivo percentualAplicadoOutroImovel = new ValorPositivo(null, "percentualAplicadoOutroImovel", 11, 6);
            ValorPositivo valorAplicadoOutroImovel = new ValorPositivo(null, "valorAplicadoOutroImovel", 11, 9);
            ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 6);
            ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)itParcelas.next());
            valorLiquidoAlienacaoDolar.setConteudo(parcela.getValorRecebidoDolar());
            valorLiquidoAlienacaoDolar.append('-', parcela.getCustoCorretagemDolar());
            parcela.getValorLiquidoAlienacaoDolar().setConteudo(valorLiquidoAlienacaoDolar);
            valorLiquidoAlienacaoReal.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            valorLiquidoAlienacaoReal.append('*', parcela.getCotacaoDolar());
            parcela.getValorLiquidoAlienacaoReal().setConteudo(valorLiquidoAlienacaoReal);
            if (parcela.getValorLiquidoAlienacaoDolar().isVazio()) {
                parcela.getCustoAquisicaoProporcionalOrigemMEDolar().clear();
                parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().clear();
                parcela.getGanhoCapital1ProporcionalOrigemMEDolar().clear();
                parcela.getGanhoCapital1ProporcionalOrigemMEReal().clear();
                parcela.getGanhoCapital2ProporcionalME().clear();
                parcela.getGanhoCapital3ProporcionalME().clear();
                parcela.getGanhoCapital4ProporcionalME().clear();
                parcela.getGanhoCapital5ProporcionalME().clear();
                parcela.getPercentualReducaoLei7713ME().clear();
                parcela.getPercentualReducaoLei11196FR1ME().clear();
                parcela.getPercentualReducaoLei11196FR2ME().clear();
                parcela.getPercentualReducaoAplicacaoOutroImovelME().clear();
                parcela.getPercentualReducaoBemPequenoValorME().clear();
                parcela.getPercentualReducaoUnicoImovelME().clear();
                parcela.getValorReducaoLei7713ME().clear();
                parcela.getValorReducaoLei11196FR1ME().clear();
                parcela.getValorReducaoLei11196FR2ME().clear();
                parcela.getValorReducaoAplicacaoOutroImovelME().clear();
                parcela.getValorReducaoBemPequenoValorME().clear();
                parcela.getValorReducaoUnicoImovelME().clear();
                parcela.getImpostoDevido().clear();
                parcela.getImpostoDevido2().clear();
                continue;
            }
            if (parcela.isUltimaParcela()) {
                custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
            } else {
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar().isVazio()) {
                    custoAquisicaoProporcionalMEDolar.clear();
                } else {
                    custoAquisicaoProporcionalMEDolar.setConteudo(custoAquisicaoDolarTotalUtilizado);
                    custoAquisicaoProporcionalMEDolar.append('*', parcela.getValorLiquidoAlienacaoDolar());
                    custoAquisicaoProporcionalMEDolar.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar());
                }
                custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                if (parcela.getValorLiquidoAlienacaoDolar().comparacao("<", custoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
                }
                if (custoAquisicaoProporcionalMEDolar.comparacao(">", saldoCustoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
                    custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                }
            }
            saldoCustoAquisicaoProporcionalMEDolar.append('-', custoAquisicaoProporcionalMEDolar);
            ganho1ProporcionalDolar.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            if (this.isPermutaComTorna()) {
                parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().setConteudo(custoAquisicaoProporcionalMEDolar);
                ganho1ProporcionalDolar.append('-', parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
            } else {
                parcela.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(custoAquisicaoProporcionalMEDolar);
                ganho1ProporcionalDolar.append('-', parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
            }
            parcela.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(ganho1ProporcionalDolar);
            ganho1ProporcionalReal.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
            ganho1ProporcionalReal.append('*', parcela.getCotacaoDolar());
            parcela.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(ganho1ProporcionalReal);
            if (this.getBemImovel().getAquisicao().houveReforma()) {
                this.calcularGanhoReducoesComReformaExteriorMoedaEstrangeira(parcela);
            } else {
                this.calcularGanhoReducoesSemReformaExteriorMoedaEstrangeira(parcela);
            }
            parcela.getValorReducaoBemPequenoValorME().clear();
            parcela.getValorReducaoUnicoImovelME().clear();
            parcela.getValorReducaoAplicacaoOutroImovelME().clear();
            int enquadramento = REDUCAO_AUSENTE;
            enquadramento = parcela.isUltimaParcela() ? this.obterEnquadramentoFinal() : this.obterEnquadramentoInicial();
            if (enquadramento == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                parcela.getPercentualReducaoBemPequenoValorME().setConteudo("100,000000");
                parcela.getValorReducaoBemPequenoValorME().setConteudo(parcela.getGanhoCapital4ProporcionalME());
                parcela.getGanhoCapital5ProporcionalME().clear();
            } else if (enquadramento == REDUCAO_UNICO_IMOVEL) {
                parcela.getPercentualReducaoUnicoImovelME().setConteudo("100,000000");
                parcela.getValorReducaoUnicoImovelME().setConteudo(parcela.getGanhoCapital4ProporcionalME());
                parcela.getGanhoCapital5ProporcionalME().clear();
            } else {
                if (!this.getPerguntas().isValorReaplicado()) {
                    percentualAplicadoOutroImovel.clear();
                    valorAplicadoOutroImovel.clear();
                } else if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    percentualAplicadoOutroImovel.setConteudo("100,000000");
                    valorAplicadoOutroImovel.setConteudo(parcela.getGanhoCapital4ProporcionalME());
                } else if (this.getPerguntas().isValorReaplicadoParcialmente()) {
                    if (this.criticarLei180Dias()) {
                        if (!parcela.getValorInformadoReducaoAplicacaoOutroImovelME().isVazio()) {
                            percentualAplicadoOutroImovel.setConteudo(parcela.getValorInformadoReducaoAplicacaoOutroImovelME());
                            percentualAplicadoOutroImovel.append('*', "100");
                            percentualAplicadoOutroImovel.append('/', parcela.getValorLiquidoAlienacaoReal());
                            valorAplicadoOutroImovel.setConteudo(percentualAplicadoOutroImovel);
                            valorAplicadoOutroImovel.append('/', "100");
                            valorAplicadoOutroImovel.append('*', parcela.getGanhoCapital4ProporcionalME());
                        } else {
                            percentualAplicadoOutroImovel.clear();
                            valorAplicadoOutroImovel.clear();
                        }
                    } else {
                        percentualAplicadoOutroImovel.setConteudo(this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemME());
                        valorAplicadoOutroImovel.setConteudo(percentualAplicadoOutroImovel);
                        valorAplicadoOutroImovel.append('/', "100");
                        valorAplicadoOutroImovel.append('*', parcela.getGanhoCapital4ProporcionalME());
                    }
                }
                parcela.getPercentualReducaoAplicacaoOutroImovelME().setConteudo(percentualAplicadoOutroImovel);
                parcela.getValorReducaoAplicacaoOutroImovelME().setConteudo(valorAplicadoOutroImovel);
                if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    parcela.getGanhoCapital5ProporcionalME().clear();
                } else {
                    ganho5Proporcional.setConteudo(parcela.getGanhoCapital4ProporcionalME());
                    ganho5Proporcional.append('-', parcela.getValorReducaoAplicacaoOutroImovelME());
                    parcela.getGanhoCapital5ProporcionalME().setConteudo(ganho5Proporcional);
                }
            }
            if (parcela.getGanhoCapital5ProporcionalME().isVazio()) {
                impostoDevido.clear();
                parcela.getAliquotaMedia().clear();
            } else if (this.isPrevisaoPrejuizo() && !parcela.getGanhoCapital5ProporcionalME().isVazio()) {
                parcela.getAliquotaMedia().setConteudo("15,000000");
                impostoDevido.setConteudo(parcela.getGanhoCapital5ProporcionalME());
                impostoDevido.append('*', "0,150000000");
            } else {
                impostoDevidoTotal.setConteudo(this.getCalculoImposto().calcularImpostoDevidoTotal(this, this.getApuracao().getGanhoCapital5OrigemMEReal()));
                parcela.getAliquotaMedia().setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(this.getApuracao().getGanhoCapital5OrigemMEReal(), impostoDevidoTotal));
                if (this.getApuracao().getGanhoCapital5OrigemMEReal().isVazio()) {
                    impostoDevido.clear();
                } else {
                    impostoDevido.setConteudo(parcela.getGanhoCapital5ProporcionalME());
                    impostoDevido.append('*', impostoDevidoTotal);
                    impostoDevido.append('/', this.getApuracao().getGanhoCapital5OrigemMEReal());
                }
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            this.calcularApuracaoFinalOrigemME();
            if (!parcela.isUltimaParcela()) continue;
            this.calcularAjuste();
            this.calcularUltimaParcelaExterior(parcela);
            break;
        }
        if (this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            this.calcularApuracaoFinalOrigemME();
        }
        this.limparAjusteAlienacaoSemUltimaParcela();
        this.limparAjusteAlienacaoApuracaoFinalSemGanho(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal());
        this.getConsolidacao().calcularConsolidacaoImovel(this);
    }

    @Override
    public void calcularParcelasOrigemAmbas() {
        ValorPositivo saldoCustoAquisicaoProporcionalMNReal = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMNReal", 11, 9);
        ValorPositivo custoAquisicaoRealTotalUtilizadoMN = new ValorPositivo(null, "custoAquisicaoRealTotalUtilizadoMN", 11, 9);
        ValorPositivo saldoCustoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMEDolar", 11, 9);
        ValorPositivo custoAquisicaoDolarTotalUtilizadoME = new ValorPositivo(null, "custoAquisicaoDolarTotalUtilizadoME", 11, 9);
        if (this.isPermutaComTorna()) {
            saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal());
            custoAquisicaoRealTotalUtilizadoMN.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal());
            saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar());
            custoAquisicaoDolarTotalUtilizadoME.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar());
        } else if (this.getBemImovel().getAquisicao().houveReforma()) {
            saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal());
            custoAquisicaoRealTotalUtilizadoMN.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal());
            saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar());
            custoAquisicaoDolarTotalUtilizadoME.setConteudo(this.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar());
        } else {
            saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
            custoAquisicaoRealTotalUtilizadoMN.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
            saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
            custoAquisicaoDolarTotalUtilizadoME.setConteudo(this.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
        }
        Iterator itParcelas = this.getColecaoParcelaAlienacao().itens().iterator();
        while (itParcelas.hasNext()) {
            ValorPositivo valorRecebidoReal = new ValorPositivo(null, "valorRecebidoReal", 11, 9);
            ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(null, "valorLiquidoAlienacaoDolar", 11, 9);
            ValorPositivo valorLiquidoAlienacaoReal = new ValorPositivo(null, "valorLiquidoAlienacaoReal", 11, 2);
            ValorPositivo valorLiquidoAlienacaoDolarMN = new ValorPositivo(null, "valorLiquidoAlienacaoDolarMN", 11, 9);
            ValorPositivo valorLiquidoAlienacaoDolarME = new ValorPositivo(null, "valorLiquidoAlienacaoDolarME", 11, 9);
            ValorPositivo valorLiquidoAlienacaoRealMN = new ValorPositivo(null, "valorLiquidoAlienacaoRealMN", 11, 9);
            ValorPositivo custoAquisicaoProporcionalMNReal = new ValorPositivo(null, "custoAquisicaoProporcionalMNReal", 11, 9);
            ValorPositivo custoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "custoAquisicaoProporcionalMEDolar", 11, 9);
            ValorPositivo ganho1ProporcionalMN = new ValorPositivo(null, "ganho1ProporcionalMN", 11, 9);
            ValorPositivo ganho1ProporcionalMEDolar = new ValorPositivo(null, "ganho1ProporcionalMEDolar", 11, 9);
            ValorPositivo ganho1ProporcionalMEReal = new ValorPositivo(null, "ganho1ProporcionalMEReal", 11, 9);
            ValorPositivo ganho5ProporcionalMN = new ValorPositivo(null, "ganho5ProporcionalMN", 11, 9);
            ValorPositivo ganho5ProporcionalME = new ValorPositivo(null, "ganho5ProporcionalME", 11, 9);
            ValorPositivo ganho5ProporcionalTotal = new ValorPositivo(null, "ganho5ProporcionalTotal", 11, 9);
            ValorPositivo impostoDevido = new ValorPositivo(null, "ImpostoDevido Parcela", 11, 9);
            ValorPositivo percentualAplicadoOutroImovel = new ValorPositivo(null, "percentualAplicadoOutroImovel", 11, 6);
            ValorPositivo valorAplicadoOutroImovelMN = new ValorPositivo(null, "valorAplicadoOutroImovelMN", 11, 9);
            ValorPositivo valorAplicadoOutroImovelME = new ValorPositivo(null, "valorAplicadoOutroImovelME", 11, 9);
            ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 6);
            ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)itParcelas.next());
            valorRecebidoReal.setConteudo(parcela.getValorRecebidoDolar());
            valorRecebidoReal.append('*', parcela.getCotacaoDolar());
            parcela.getValorRecebidoReal().setConteudo(valorRecebidoReal);
            valorLiquidoAlienacaoDolar.setConteudo(parcela.getValorRecebidoDolar());
            valorLiquidoAlienacaoDolar.append('-', parcela.getCustoCorretagemDolar());
            parcela.getValorLiquidoAlienacaoDolar().setConteudo(valorLiquidoAlienacaoDolar);
            valorLiquidoAlienacaoReal.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            valorLiquidoAlienacaoReal.append('*', parcela.getCotacaoDolar());
            parcela.getValorLiquidoAlienacaoReal().setConteudo(valorLiquidoAlienacaoReal);
            valorLiquidoAlienacaoDolarMN.setConteudo(this.getApuracao().getPercentualCustoAquisicaoOrigemMN());
            valorLiquidoAlienacaoDolarMN.append('/', "100,000000000");
            valorLiquidoAlienacaoDolarMN.append('*', parcela.getValorLiquidoAlienacaoDolar());
            valorLiquidoAlienacaoDolarMN.converteQtdCasasDecimais(2);
            parcela.getValorAlienacaoOrigemNacionalDolar().setConteudo(valorLiquidoAlienacaoDolarMN);
            valorLiquidoAlienacaoDolarME.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            valorLiquidoAlienacaoDolarME.append('-', parcela.getValorAlienacaoOrigemNacionalDolar());
            parcela.getValorAlienacaoOrigemMEDolar().setConteudo(valorLiquidoAlienacaoDolarME);
            valorLiquidoAlienacaoRealMN.setConteudo(parcela.getValorAlienacaoOrigemNacionalDolar());
            valorLiquidoAlienacaoRealMN.append('*', parcela.getCotacaoDolar());
            parcela.getValorAlienacaoOrigemNacionalReal().setConteudo(valorLiquidoAlienacaoRealMN);
            if (parcela.getValorLiquidoAlienacaoReal().isVazio()) {
                parcela.getCustoAquisicaoProporcionalOrigemNacionalReal().clear();
                parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().clear();
                parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().clear();
                parcela.getGanhoCapital2ProporcionalMN().clear();
                parcela.getGanhoCapital3ProporcionalMN().clear();
                parcela.getGanhoCapital4ProporcionalMN().clear();
                parcela.getGanhoCapital5ProporcionalMN().clear();
                parcela.getPercentualReducaoLei7713MN().clear();
                parcela.getPercentualReducaoLei11196FR1MN().clear();
                parcela.getPercentualReducaoLei11196FR2MN().clear();
                parcela.getPercentualReducaoAplicacaoOutroImovelMN().clear();
                parcela.getPercentualReducaoBemPequenoValorMN().clear();
                parcela.getPercentualReducaoUnicoImovelMN().clear();
                parcela.getValorReducaoLei7713MN().clear();
                parcela.getValorReducaoLei11196FR1MN().clear();
                parcela.getValorReducaoLei11196FR2MN().clear();
                parcela.getValorReducaoAplicacaoOutroImovelMN().clear();
                parcela.getValorReducaoBemPequenoValorMN().clear();
                parcela.getValorReducaoUnicoImovelMN().clear();
                parcela.getCustoAquisicaoProporcionalOrigemMEDolar().clear();
                parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().clear();
                parcela.getGanhoCapital1ProporcionalOrigemMEDolar().clear();
                parcela.getGanhoCapital1ProporcionalOrigemMEReal().clear();
                parcela.getGanhoCapital2ProporcionalME().clear();
                parcela.getGanhoCapital3ProporcionalME().clear();
                parcela.getGanhoCapital4ProporcionalME().clear();
                parcela.getGanhoCapital5ProporcionalME().clear();
                parcela.getPercentualReducaoLei7713ME().clear();
                parcela.getPercentualReducaoLei11196FR1ME().clear();
                parcela.getPercentualReducaoLei11196FR2ME().clear();
                parcela.getPercentualReducaoAplicacaoOutroImovelME().clear();
                parcela.getPercentualReducaoBemPequenoValorME().clear();
                parcela.getPercentualReducaoUnicoImovelME().clear();
                parcela.getValorReducaoLei7713ME().clear();
                parcela.getValorReducaoLei11196FR1ME().clear();
                parcela.getValorReducaoLei11196FR2ME().clear();
                parcela.getValorReducaoAplicacaoOutroImovelME().clear();
                parcela.getValorReducaoBemPequenoValorME().clear();
                parcela.getValorReducaoUnicoImovelME().clear();
                parcela.getImpostoDevido().clear();
                parcela.getImpostoDevido2().clear();
                continue;
            }
            if (parcela.isUltimaParcela()) {
                custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
                custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
            } else {
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar().isVazio()) {
                    custoAquisicaoProporcionalMNReal.clear();
                } else {
                    custoAquisicaoProporcionalMNReal.setConteudo(custoAquisicaoRealTotalUtilizadoMN);
                    custoAquisicaoProporcionalMNReal.append('*', parcela.getValorAlienacaoOrigemNacionalDolar());
                    custoAquisicaoProporcionalMNReal.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar());
                }
                custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                if (parcela.getValorAlienacaoOrigemNacionalReal().comparacao("<", custoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(parcela.getValorAlienacaoOrigemNacionalReal());
                }
                if (custoAquisicaoProporcionalMNReal.comparacao(">", saldoCustoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
                    custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                }
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar().isVazio()) {
                    custoAquisicaoProporcionalMEDolar.clear();
                } else {
                    custoAquisicaoProporcionalMEDolar.setConteudo(custoAquisicaoDolarTotalUtilizadoME);
                    custoAquisicaoProporcionalMEDolar.append('*', parcela.getValorAlienacaoOrigemMEDolar());
                    custoAquisicaoProporcionalMEDolar.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar());
                    custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                }
                if (parcela.getValorAlienacaoOrigemMEDolar().comparacao("<", custoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(parcela.getValorAlienacaoOrigemMEDolar());
                }
                if (custoAquisicaoProporcionalMEDolar.comparacao(">", saldoCustoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
                    custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                }
            }
            saldoCustoAquisicaoProporcionalMNReal.append('-', custoAquisicaoProporcionalMNReal);
            saldoCustoAquisicaoProporcionalMEDolar.append('-', custoAquisicaoProporcionalMEDolar);
            ganho1ProporcionalMN.setConteudo(parcela.getValorAlienacaoOrigemNacionalReal());
            ganho1ProporcionalMEDolar.setConteudo(parcela.getValorAlienacaoOrigemMEDolar());
            if (this.isPermutaComTorna()) {
                parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().setConteudo(custoAquisicaoProporcionalMNReal);
                ganho1ProporcionalMN.append('-', parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal());
                parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().setConteudo(custoAquisicaoProporcionalMEDolar);
                ganho1ProporcionalMEDolar.append('-', parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
            } else {
                parcela.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(custoAquisicaoProporcionalMNReal);
                ganho1ProporcionalMN.append('-', parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
                parcela.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(custoAquisicaoProporcionalMEDolar);
                ganho1ProporcionalMEDolar.append('-', parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
            }
            parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(ganho1ProporcionalMN);
            parcela.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(ganho1ProporcionalMEDolar);
            ganho1ProporcionalMEReal.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
            ganho1ProporcionalMEReal.append('*', parcela.getCotacaoDolar());
            parcela.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(ganho1ProporcionalMEReal);
            if (this.getBemImovel().getAquisicao().houveReforma()) {
                this.calcularGanhoReducoesComReformaExteriorMoedaNacional(parcela);
                this.calcularGanhoReducoesComReformaExteriorMoedaEstrangeira(parcela);
            } else {
                this.calcularGanhoReducoesSemReformaExteriorMoedaNacional(parcela);
                this.calcularGanhoReducoesSemReformaExteriorMoedaEstrangeira(parcela);
            }
            parcela.getValorReducaoBemPequenoValorMN().clear();
            parcela.getValorReducaoUnicoImovelMN().clear();
            parcela.getValorReducaoAplicacaoOutroImovelMN().clear();
            parcela.getValorReducaoBemPequenoValorME().clear();
            parcela.getValorReducaoUnicoImovelME().clear();
            parcela.getValorReducaoAplicacaoOutroImovelME().clear();
            int enquadramento = REDUCAO_AUSENTE;
            enquadramento = parcela.isUltimaParcela() ? this.obterEnquadramentoFinal() : this.obterEnquadramentoInicial();
            if (enquadramento == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                parcela.getPercentualReducaoBemPequenoValorMN().setConteudo("100,000000");
                parcela.getPercentualReducaoBemPequenoValorME().setConteudo("100,000000");
                parcela.getValorReducaoBemPequenoValorMN().setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                parcela.getGanhoCapital5ProporcionalMN().clear();
                parcela.getValorReducaoBemPequenoValorME().setConteudo(parcela.getGanhoCapital4ProporcionalME());
                parcela.getGanhoCapital5ProporcionalME().clear();
            } else if (enquadramento == REDUCAO_UNICO_IMOVEL) {
                parcela.getPercentualReducaoUnicoImovelMN().setConteudo("100,000000");
                parcela.getPercentualReducaoUnicoImovelME().setConteudo("100,000000");
                parcela.getValorReducaoUnicoImovelMN().setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                parcela.getGanhoCapital5ProporcionalMN().clear();
                parcela.getValorReducaoUnicoImovelME().setConteudo(parcela.getGanhoCapital4ProporcionalME());
                parcela.getGanhoCapital5ProporcionalME().clear();
            } else {
                if (!this.getPerguntas().isValorReaplicado()) {
                    percentualAplicadoOutroImovel.clear();
                    valorAplicadoOutroImovelMN.clear();
                    valorAplicadoOutroImovelMN.clear();
                } else if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    percentualAplicadoOutroImovel.setConteudo("100,000000");
                    valorAplicadoOutroImovelMN.setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                    valorAplicadoOutroImovelME.setConteudo(parcela.getGanhoCapital4ProporcionalME());
                } else if (this.getPerguntas().isValorReaplicadoParcialmente()) {
                    if (this.criticarLei180Dias()) {
                        if (!parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas().isVazio()) {
                            percentualAplicadoOutroImovel.setConteudo(parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas());
                            percentualAplicadoOutroImovel.append('*', "100");
                            percentualAplicadoOutroImovel.append('/', parcela.getValorLiquidoAlienacaoReal());
                            valorAplicadoOutroImovelMN.setConteudo(percentualAplicadoOutroImovel);
                            valorAplicadoOutroImovelMN.append('/', "100");
                            valorAplicadoOutroImovelMN.append('*', parcela.getGanhoCapital4ProporcionalMN());
                            valorAplicadoOutroImovelME.setConteudo(percentualAplicadoOutroImovel);
                            valorAplicadoOutroImovelME.append('/', "100");
                            valorAplicadoOutroImovelME.append('*', parcela.getGanhoCapital4ProporcionalME());
                        } else {
                            percentualAplicadoOutroImovel.clear();
                            valorAplicadoOutroImovelMN.clear();
                            valorAplicadoOutroImovelME.clear();
                        }
                    } else {
                        percentualAplicadoOutroImovel.setConteudo(this.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
                        valorAplicadoOutroImovelMN.setConteudo(percentualAplicadoOutroImovel);
                        valorAplicadoOutroImovelMN.append('/', "100");
                        valorAplicadoOutroImovelMN.append('*', parcela.getGanhoCapital4ProporcionalMN());
                        valorAplicadoOutroImovelME.setConteudo(percentualAplicadoOutroImovel);
                        valorAplicadoOutroImovelME.append('/', "100");
                        valorAplicadoOutroImovelME.append('*', parcela.getGanhoCapital4ProporcionalME());
                    }
                }
                parcela.getPercentualReducaoAplicacaoOutroImovelMN().setConteudo(percentualAplicadoOutroImovel);
                parcela.getPercentualReducaoAplicacaoOutroImovelME().setConteudo(percentualAplicadoOutroImovel);
                parcela.getValorReducaoAplicacaoOutroImovelMN().setConteudo(valorAplicadoOutroImovelMN);
                parcela.getValorReducaoAplicacaoOutroImovelME().setConteudo(valorAplicadoOutroImovelME);
                if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                    parcela.getGanhoCapital5ProporcionalMN().clear();
                    parcela.getGanhoCapital5ProporcionalME().clear();
                } else {
                    ganho5ProporcionalMN.setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                    ganho5ProporcionalMN.append('-', parcela.getValorReducaoAplicacaoOutroImovelMN());
                    parcela.getGanhoCapital5ProporcionalMN().setConteudo(ganho5ProporcionalMN);
                    ganho5ProporcionalME.setConteudo(parcela.getGanhoCapital4ProporcionalME());
                    ganho5ProporcionalME.append('-', parcela.getValorReducaoAplicacaoOutroImovelME());
                    parcela.getGanhoCapital5ProporcionalME().setConteudo(ganho5ProporcionalME);
                }
            }
            ganho5ProporcionalTotal.setConteudo(parcela.getGanhoCapital5ProporcionalMN());
            ganho5ProporcionalTotal.append('+', parcela.getGanhoCapital5ProporcionalME());
            parcela.getGanhoCapital5ProporcionalTotalReal().setConteudo(ganho5ProporcionalTotal);
            if (parcela.getGanhoCapital5ProporcionalTotalReal().isVazio()) {
                impostoDevido.clear();
                parcela.getAliquotaMedia().clear();
            } else if (this.isPrevisaoPrejuizo() && !parcela.getGanhoCapital5ProporcionalTotalReal().isVazio()) {
                parcela.getAliquotaMedia().setConteudo("15,000000");
                impostoDevido.setConteudo(parcela.getGanhoCapital5ProporcionalTotalReal());
                impostoDevido.append('*', "0,150000000");
            } else {
                ValorPositivo ganhoCapital5Total = new ValorPositivo();
                ganhoCapital5Total.setConteudo(this.getApuracao().getGanhoCapital5OrigemMNReal().operacao('+', this.getApuracao().getGanhoCapital5OrigemMEReal()));
                impostoDevidoTotal.setConteudo(this.getCalculoImposto().calcularImpostoDevidoTotal(this, ganhoCapital5Total));
                parcela.getAliquotaMedia().setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(ganhoCapital5Total, impostoDevidoTotal));
                if (ganhoCapital5Total.isVazio()) {
                    impostoDevido.clear();
                } else {
                    impostoDevido.setConteudo(parcela.getGanhoCapital5ProporcionalTotalReal());
                    impostoDevido.append('*', impostoDevidoTotal);
                    impostoDevido.append('/', ganhoCapital5Total);
                }
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            this.calcularApuracaoFinalOrigemAmbas();
            if (!parcela.isUltimaParcela()) continue;
            this.calcularAjuste();
            this.calcularUltimaParcelaExterior(parcela);
            break;
        }
        if (this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            this.calcularApuracaoFinalOrigemAmbas();
        }
        this.limparAjusteAlienacaoSemUltimaParcela();
        this.limparAjusteAlienacaoApuracaoFinalSemGanho(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalRealTotal());
        this.getConsolidacao().calcularConsolidacaoImovel(this);
    }

    private void calcularApuracaoFinalOrigemNacionalComGanhoReduzido(int enquadramentoFinal) {
        ValorPositivo reducao = new ValorPositivo(null, "reducao", 11, 9);
        ValorPositivo custoAquisicao = new ValorPositivo();
        if (this.isPermutaComTorna()) {
            custoAquisicao.setConteudo(this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMNReal().naoFormatado());
        } else {
            custoAquisicao.setConteudo(this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal().naoFormatado());
        }
        this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal().operacao('-', custoAquisicao));
        this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemMN());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
        this.getApuracaoFinal().getValorReducaoLei7713OrigemMN().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei7713OrigemMN()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemMN());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital2OrigemMNReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemMN());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital3OrigemMNReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN()));
        if (enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
        } else if (enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
        } else if (enquadramentoFinal == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
            if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
            } else {
                ValorPositivo percentualReaplicado = new ValorPositivo(null, "percentualReaplicado", 11, 6);
                ValorPositivo valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal(), this.getColecaoParcelaAlienacao().getValorInformadoReducaoAplicacaoOutroImovelOrigemMN(), this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                percentualReaplicado.setConteudo(valorReaplicado.naoFormatado());
                percentualReaplicado.append('*', "100,00");
                percentualReaplicado.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(percentualReaplicado.naoFormatado());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(valorReaplicado.naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().operacao('-', this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN()));
            }
        } else {
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
        }
    }

    private void calcularApuracaoFinalOrigemMEComGanhoReduzido(int enquadramentoFinal) {
        ValorPositivo reducao = new ValorPositivo(null, "reducao", 11, 9);
        ValorPositivo ganhoCapitalDolar = new ValorPositivo(null, "ganhoCapitalDolar", 11, 2);
        ValorPositivo custoAquisicao = new ValorPositivo();
        if (this.isPermutaComTorna()) {
            custoAquisicao.setConteudo(this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMEDolar());
        } else {
            custoAquisicao.setConteudo(this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar());
        }
        ganhoCapitalDolar.setConteudo(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar());
        ganhoCapitalDolar.append('-', custoAquisicao);
        this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().setConteudo(ganhoCapitalDolar);
        this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().setConteudo(this.calcularGanhoCapitalMEReais(this.isPermutaComTorna()));
        this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemME());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
        this.getApuracaoFinal().getValorReducaoLei7713OrigemME().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei7713OrigemME()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemME());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital2OrigemMEReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemME());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital3OrigemMEReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME()));
        if (enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
        } else if (enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
        } else if (enquadramentoFinal == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
            if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
            } else {
                ValorPositivo percentualReaplicado = new ValorPositivo(null, "percentualReaplicado", 11, 6);
                ValorPositivo valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal(), this.getColecaoParcelaAlienacao().getValorInformadoReducaoAplicacaoOutroImovelOrigemME(), this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                percentualReaplicado.setConteudo(valorReaplicado.naoFormatado());
                percentualReaplicado.append('*', "100,00");
                percentualReaplicado.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(percentualReaplicado.naoFormatado());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(valorReaplicado.naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME()));
            }
        } else {
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
        }
    }

    private void calcularApuracaoFinalOrigemAmbasComGanhoReduzido(int enquadramentoFinal) {
        ValorPositivo reducao = new ValorPositivo(null, "reducao", 11, 9);
        ValorPositivo custoAquisicaoMN = new ValorPositivo();
        ValorPositivo valorLiquidoAlienacaoMNReal = new ValorPositivo();
        ValorPositivo valorLiquidoAlienacaoMEReal = new ValorPositivo();
        if (this.isPermutaComTorna()) {
            custoAquisicaoMN.setConteudo(this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMNReal().naoFormatado());
        } else {
            custoAquisicaoMN.setConteudo(this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal().naoFormatado());
        }
        for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
            valorLiquidoAlienacaoMNReal.append('+', parcela.getValorAlienacaoOrigemNacionalReal());
            valorLiquidoAlienacaoMEReal.append('+', parcela.getValorAlienacaoOrigemMEDolar().operacao('*', parcela.getCotacaoDolar()));
        }
        this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().setConteudo(valorLiquidoAlienacaoMNReal.operacao('-', custoAquisicaoMN));
        this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemMN());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
        this.getApuracaoFinal().getValorReducaoLei7713OrigemMN().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei7713OrigemMN()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemMN());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital2OrigemMNReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemMN());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital3OrigemMNReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN()));
        ValorPositivo ganhoCapitalDolar = new ValorPositivo(null, "ganhoCapitalDolar", 11, 2);
        ValorPositivo custoAquisicaoME = new ValorPositivo();
        if (this.isPermutaComTorna()) {
            custoAquisicaoME.setConteudo(this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMEDolar());
        } else {
            custoAquisicaoME.setConteudo(this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar());
        }
        ganhoCapitalDolar.setConteudo(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar());
        ganhoCapitalDolar.append('-', custoAquisicaoME);
        this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().setConteudo(ganhoCapitalDolar);
        if (ganhoCapitalDolar.isVazio()) {
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().clear();
        } else {
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().setConteudo(this.calcularGanhoCapitalMEReais(this.isPermutaComTorna()));
        }
        this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemME());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
        this.getApuracaoFinal().getValorReducaoLei7713OrigemME().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei7713OrigemME()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemME());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital2OrigemMEReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME()));
        this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemME());
        reducao.setConteudo(this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME());
        reducao.append('/', "100");
        reducao.append('*', this.getApuracaoFinal().getGanhoCapital3OrigemMEReal());
        this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME().setConteudo(reducao);
        this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME()));
        if (enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
        } else if (enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo("100,00");
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
        } else if (enquadramentoFinal == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
            if (this.getPerguntas().isValorReaplicadoTotalmente()) {
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
            } else {
                ValorPositivo percentualReaplicado = new ValorPositivo(null, "percentualReaplicado", 11, 6);
                ValorPositivo valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal(), this.getColecaoParcelaAlienacao().getValorInformadoReducaoAplicacaoOutroImovelOrigemAmbas(), this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                percentualReaplicado.setConteudo(valorReaplicado.naoFormatado());
                percentualReaplicado.append('*', "100,00");
                percentualReaplicado.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().naoFormatado());
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(percentualReaplicado.naoFormatado());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(valorReaplicado.naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().operacao('-', this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN()));
                valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal(), this.getColecaoParcelaAlienacao().getValorInformadoReducaoAplicacaoOutroImovelOrigemAmbas(), this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                percentualReaplicado.setConteudo(valorReaplicado.naoFormatado());
                percentualReaplicado.append('*', "100,00");
                percentualReaplicado.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().naoFormatado());
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(percentualReaplicado.naoFormatado());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(valorReaplicado.naoFormatado());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().operacao('-', this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME()));
            }
        } else {
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
        }
    }

    @Override
    public void calcularApuracaoFinalOrigemNacional() {
        ParcelaAlienacaoBem ultimaParcela = (ParcelaAlienacaoBem)this.getColecaoParcelaAlienacao().obterUltimaParcela();
        boolean temUltimaParcela = ultimaParcela != null;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        int enquadramentoFinal = this.obterEnquadramentoFinal();
        ValorPositivo custoAquisicaoUltimaParcela = new ValorPositivo();
        if (temUltimaParcela) {
            if (this.isPermutaComTorna()) {
                custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().naoFormatado());
            } else {
                custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemNacionalReal().naoFormatado());
            }
        }
        this.getColecaoParcelaAlienacao().atualizarReducoesMN();
        this.getApuracaoFinal().getValorAlienacaoOrigemNacionalDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        this.getApuracaoFinal().getCustoCorretagemOrigemNacionalDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal());
        this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal());
        this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal());
        if (this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal().comparacao("<=", this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal())) {
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoLei7713OrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().clear();
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
        } else if (temUltimaParcela && ultimaParcela.getValorLiquidoAlienacaoReal().comparacao("<", custoAquisicaoUltimaParcela)) {
            this.calcularApuracaoFinalOrigemNacionalComGanhoReduzido(enquadramentoFinal);
        } else {
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalNacionalRealTotal());
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemMN());
            this.getApuracaoFinal().getValorReducaoLei7713OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei7713OrigemMN());
            this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital2ProporcionalOrigemMN());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemMN());
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR1OrigemMN());
            this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital3ProporcionalOrigemMN());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemMN());
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR2OrigemMN());
            this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital4ProporcionalOrigemMN());
            if (enquadramentoInicial == enquadramentoFinal || !temUltimaParcela) {
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemMN());
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoUnicoImovelOrigemMN());
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemMN());
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoBemPequenoValorOrigemMN());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal());
            } else {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().clear();
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().clear();
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().clear();
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().clear();
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal());
                ValorPositivo ganhoCapitalTotal = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
                if ((enquadramentoInicial == REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramentoInicial == REDUCAO_UNICO_IMOVEL) && enquadramentoFinal == REDUCAO_AUSENTE) {
                    for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                        if (parcela.isUltimaParcela()) {
                            ganhoCapitalTotal.append('+', parcela.getGanhoCapital5ProporcionalMN());
                            continue;
                        }
                        ganhoCapitalTotal.append('+', parcela.getGanhoCapital4ProporcionalMN());
                    }
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().clear();
                    this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(ganhoCapitalTotal);
                }
            }
            if (temUltimaParcela && enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
            } else if (temUltimaParcela && enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
            } else if (this.getPerguntas().isValorReaplicadoParcialmente() && this.getDataAlienacao().naoFormatado().length() == 8 && Integer.parseInt(this.getDataAlienacao().getAno()) >= ANO_TRANSICAO_LEI_180_DIAS) {
                int enquadramento = enquadramentoInicial;
                if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
                    enquadramento = enquadramentoFinal;
                }
                if (enquadramento == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                    ValorPositivo ganhoCapitalTotal = new ValorPositivo(null, "", 11, 9);
                    ValorPositivo ganhoCapitalParcela = new ValorPositivo();
                    ValorPositivo valorLiquidoTotal = new ValorPositivo();
                    ValorPositivo valorReaplicadoTotal = new ValorPositivo(null, "", 11, 2);
                    ValorPositivo percentualReaplicado = new ValorPositivo(null, "", 11, 6);
                    for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                        ValorPositivo valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(parcela.getValorLiquidoAlienacaoReal(), parcela.getValorInformadoReducaoAplicacaoOutroImovelMN(), parcela.getGanhoCapital4ProporcionalMN());
                        valorLiquidoTotal.append('+', parcela.getValorLiquidoAlienacaoReal());
                        valorReaplicadoTotal.append('+', valorReaplicado.naoFormatado());
                        ganhoCapitalParcela.setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                        ganhoCapitalParcela.append('-', valorReaplicado.naoFormatado());
                        ganhoCapitalTotal.append('+', ganhoCapitalParcela);
                    }
                    if (valorLiquidoTotal.isVazio()) {
                        percentualReaplicado.clear();
                    } else {
                        percentualReaplicado.setConteudo(valorReaplicadoTotal);
                        percentualReaplicado.append('*', "100,00");
                        percentualReaplicado.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                    }
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(percentualReaplicado);
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(valorReaplicadoTotal);
                    this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(ganhoCapitalTotal);
                }
            }
            int enquadramentoConsiderado = REDUCAO_AUSENTE;
            enquadramentoConsiderado = temUltimaParcela ? enquadramentoFinal : enquadramentoInicial;
            if (enquadramentoConsiderado == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo("100,000000");
            } else if (enquadramentoConsiderado == REDUCAO_UNICO_IMOVEL) {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo("100,000000");
            }
        }
    }

    @Override
    public void calcularApuracaoFinalOrigemME() {
        ParcelaAlienacaoBem ultimaParcela = (ParcelaAlienacaoBem)this.getColecaoParcelaAlienacao().obterUltimaParcela();
        boolean temUltimaParcela = ultimaParcela != null;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        int enquadramentoFinal = this.obterEnquadramentoFinal();
        ValorPositivo custoAquisicaoUltimaParcela = new ValorPositivo();
        if (temUltimaParcela) {
            if (this.isPermutaComTorna()) {
                custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().naoFormatado());
            } else {
                custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemMEDolar().naoFormatado());
            }
        }
        this.getColecaoParcelaAlienacao().atualizarReducoesME();
        this.getApuracaoFinal().getValorAlienacaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        this.getApuracaoFinal().getCustoCorretagemOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal());
        this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal());
        this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal());
        if (this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar().comparacao("<=", this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar())) {
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().clear();
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME().clear();
            this.getApuracaoFinal().getValorReducaoLei7713OrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().clear();
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
        } else if (temUltimaParcela && ultimaParcela.getValorLiquidoAlienacaoDolar().comparacao("<", custoAquisicaoUltimaParcela)) {
            this.calcularApuracaoFinalOrigemMEComGanhoReduzido(enquadramentoFinal);
        } else {
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal());
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal());
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemME());
            this.getApuracaoFinal().getValorReducaoLei7713OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei7713OrigemME());
            this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital2ProporcionalOrigemME());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemME());
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR1OrigemME());
            this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital3ProporcionalOrigemME());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemME());
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR2OrigemME());
            this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital4ProporcionalOrigemME());
            if (enquadramentoInicial == enquadramentoFinal || !temUltimaParcela) {
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemME());
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoUnicoImovelOrigemME());
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemME());
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoBemPequenoValorOrigemME());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal());
            } else {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().clear();
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().clear();
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().clear();
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().clear();
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal());
                ValorPositivo ganhoCapitalTotal = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
                if ((enquadramentoInicial == REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramentoInicial == REDUCAO_UNICO_IMOVEL) && enquadramentoFinal == REDUCAO_AUSENTE) {
                    for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                        if (parcela.isUltimaParcela()) {
                            ganhoCapitalTotal.append('+', parcela.getGanhoCapital5ProporcionalME());
                            continue;
                        }
                        ganhoCapitalTotal.append('+', parcela.getGanhoCapital4ProporcionalME());
                    }
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().clear();
                    this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(ganhoCapitalTotal);
                }
            }
            if (temUltimaParcela && enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
            } else if (ultimaParcela != null && enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
            } else if (this.getPerguntas().isValorReaplicadoParcialmente() && this.getDataAlienacao().naoFormatado().length() == 8 && Integer.parseInt(this.getDataAlienacao().getAno()) >= ANO_TRANSICAO_LEI_180_DIAS) {
                int enquadramento = enquadramentoInicial;
                if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
                    enquadramento = enquadramentoFinal;
                }
                if (enquadramento == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                    ValorPositivo ganhoCapitalTotal = new ValorPositivo(null, "", 11, 9);
                    ValorPositivo ganhoCapitalParcela = new ValorPositivo();
                    ValorPositivo valorLiquidoTotal = new ValorPositivo();
                    ValorPositivo valorReaplicadoTotal = new ValorPositivo(null, "", 11, 2);
                    ValorPositivo percentualReaplicado = new ValorPositivo(null, "", 11, 6);
                    for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                        ValorPositivo valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(parcela.getValorLiquidoAlienacaoReal(), parcela.getValorInformadoReducaoAplicacaoOutroImovelME(), parcela.getGanhoCapital4ProporcionalME());
                        valorLiquidoTotal.append('+', parcela.getValorLiquidoAlienacaoReal());
                        valorReaplicadoTotal.append('+', valorReaplicado.naoFormatado());
                        ganhoCapitalParcela.setConteudo(parcela.getGanhoCapital4ProporcionalME());
                        ganhoCapitalParcela.append('-', valorReaplicado.naoFormatado());
                        ganhoCapitalTotal.append('+', ganhoCapitalParcela);
                    }
                    if (valorLiquidoTotal.isVazio()) {
                        percentualReaplicado.clear();
                    } else {
                        percentualReaplicado.setConteudo(valorReaplicadoTotal);
                        percentualReaplicado.append('*', "100,00");
                        percentualReaplicado.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                    }
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(percentualReaplicado);
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(valorReaplicadoTotal);
                    this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(ganhoCapitalTotal);
                }
            }
            int enquadramentoConsiderado = REDUCAO_AUSENTE;
            enquadramentoConsiderado = temUltimaParcela ? enquadramentoFinal : enquadramentoInicial;
            if (enquadramentoConsiderado == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo("100,000000");
            } else if (enquadramentoConsiderado == REDUCAO_UNICO_IMOVEL) {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo("100,000000");
            }
        }
    }

    @Override
    public void calcularApuracaoFinalOrigemAmbas() {
        ParcelaAlienacaoBem ultimaParcela = (ParcelaAlienacaoBem)this.getColecaoParcelaAlienacao().obterUltimaParcela();
        boolean temUltimaParcela = ultimaParcela != null;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        int enquadramentoFinal = this.obterEnquadramentoFinal();
        ValorPositivo custoAquisicaoUltimaParcelaMN = new ValorPositivo();
        ValorPositivo custoAquisicaoUltimaParcelaME = new ValorPositivo();
        if (temUltimaParcela) {
            if (this.isPermutaComTorna()) {
                custoAquisicaoUltimaParcelaMN.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().naoFormatado());
                custoAquisicaoUltimaParcelaME.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().naoFormatado());
            } else {
                custoAquisicaoUltimaParcelaMN.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemNacionalReal().naoFormatado());
                custoAquisicaoUltimaParcelaME.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemMEDolar().naoFormatado());
            }
        }
        this.getColecaoParcelaAlienacao().atualizarReducoesMN();
        this.getColecaoParcelaAlienacao().atualizarReducoesME();
        ValorPositivo valorRecebidoDolarTotalMN = new ValorPositivo(null, "valorRecebidoDolarTotalMN", 11, 9);
        ValorPositivo valorRecebidoDolarTotalME = new ValorPositivo(null, "valorRecebidoDolarTotalME", 11, 9);
        ValorPositivo custoCorretagemDolarTotalMN = new ValorPositivo(null, "custoCorretagemDolarTotalMN", 11, 9);
        ValorPositivo custoCorretagemDolarTotalME = new ValorPositivo(null, "custoCorretagemDolarTotalME", 11, 9);
        ValorPositivo valorLiquidoDolarTotalMN = new ValorPositivo(null, "valorLiquidoDolarTotalMN", 11, 9);
        ValorPositivo valorLiquidoDolarTotalME = new ValorPositivo(null, "valorLiquidoDolarTotalME", 11, 9);
        ValorPositivo valorLiquidoAlienacaoRealTotalMN = new ValorPositivo(null, "valorLiquidoAlienacaoRealTotalMN", 11, 9);
        ValorPositivo ganhoCapitalRealMN = new ValorPositivo(null, "ganhoCapitalReaisMN", 11, 2);
        ValorPositivo ganhoCapitalDolarME = new ValorPositivo(null, "ganhoCapitalDolarME", 11, 2);
        valorRecebidoDolarTotalMN.setConteudo(this.getApuracao().getPercentualCustoAquisicaoOrigemMN());
        valorRecebidoDolarTotalMN.append('/', "100,000000000");
        valorRecebidoDolarTotalMN.append('*', this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        valorRecebidoDolarTotalMN.converteQtdCasasDecimais(2);
        valorRecebidoDolarTotalME.setConteudo(this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        valorRecebidoDolarTotalME.append('-', valorRecebidoDolarTotalMN);
        this.getApuracaoFinal().getValorAlienacaoOrigemNacionalDolar().setConteudo(valorRecebidoDolarTotalMN);
        this.getApuracaoFinal().getValorAlienacaoOrigemMEDolar().setConteudo(valorRecebidoDolarTotalME);
        custoCorretagemDolarTotalMN.setConteudo(this.getApuracao().getPercentualCustoAquisicaoOrigemMN());
        custoCorretagemDolarTotalMN.append('/', "100,000000000");
        custoCorretagemDolarTotalMN.append('*', this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        custoCorretagemDolarTotalMN.converteQtdCasasDecimais(2);
        custoCorretagemDolarTotalME.setConteudo(this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        custoCorretagemDolarTotalME.append('-', custoCorretagemDolarTotalMN);
        this.getApuracaoFinal().getCustoCorretagemOrigemNacionalDolar().setConteudo(custoCorretagemDolarTotalMN);
        this.getApuracaoFinal().getCustoCorretagemOrigemMEDolar().setConteudo(custoCorretagemDolarTotalME);
        valorLiquidoDolarTotalMN.setConteudo(valorRecebidoDolarTotalMN);
        valorLiquidoDolarTotalMN.append('-', custoCorretagemDolarTotalMN);
        valorLiquidoDolarTotalME.setConteudo(valorRecebidoDolarTotalME);
        valorLiquidoDolarTotalME.append('-', custoCorretagemDolarTotalME);
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalDolar().setConteudo(valorLiquidoDolarTotalMN);
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar().setConteudo(valorLiquidoDolarTotalME);
        valorLiquidoAlienacaoRealTotalMN.setConteudo(this.getColecaoParcelaAlienacao().obterValorLiquidoOrigemNacionalReal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal().setConteudo(valorLiquidoAlienacaoRealTotalMN);
        this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal());
        this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal());
        this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal());
        this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal());
        if (valorLiquidoAlienacaoRealTotalMN.comparacao("<=", this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal())) {
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().clear();
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().clear();
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoLei7713OrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().clear();
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().clear();
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().clear();
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().clear();
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME().clear();
            this.getApuracaoFinal().getValorReducaoLei7713OrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME().clear();
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().clear();
            this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().clear();
            this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().clear();
            this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().clear();
            this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().clear();
            this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
        } else if (temUltimaParcela && (ultimaParcela.getValorAlienacaoOrigemNacionalReal().comparacao("<", custoAquisicaoUltimaParcelaMN) || ultimaParcela.getValorAlienacaoOrigemMEDolar().comparacao("<", custoAquisicaoUltimaParcelaME))) {
            this.calcularApuracaoFinalOrigemAmbasComGanhoReduzido(enquadramentoFinal);
        } else {
            ganhoCapitalRealMN.setConteudo(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal());
            if (this.isPermutaComTorna()) {
                ganhoCapitalRealMN.append('-', this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMNReal());
            } else {
                ganhoCapitalRealMN.append('-', this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal());
            }
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().setConteudo(ganhoCapitalRealMN);
            ganhoCapitalDolarME.setConteudo(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar());
            if (this.isPermutaComTorna()) {
                ganhoCapitalDolarME.append('-', this.getApuracaoFinal().getCustoAquisicaoTornaOrigemMEDolar());
            } else {
                ganhoCapitalDolarME.append('-', this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar());
            }
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().setConteudo(ganhoCapitalDolarME);
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal());
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemMN());
            this.getApuracaoFinal().getValorReducaoLei7713OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei7713OrigemMN());
            this.getApuracaoFinal().getGanhoCapital2OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital2ProporcionalOrigemMN());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemMN());
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR1OrigemMN());
            this.getApuracaoFinal().getGanhoCapital3OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital3ProporcionalOrigemMN());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemMN());
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR2OrigemMN());
            this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital4ProporcionalOrigemMN());
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal());
            this.getApuracaoFinal().getPercentualReducaoLei7713OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemME());
            this.getApuracaoFinal().getValorReducaoLei7713OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei7713OrigemME());
            this.getApuracaoFinal().getGanhoCapital2OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital2ProporcionalOrigemME());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR1OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemME());
            this.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR1OrigemME());
            this.getApuracaoFinal().getGanhoCapital3OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital3ProporcionalOrigemME());
            this.getApuracaoFinal().getPercentualReducaoLei11196FR2OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemME());
            this.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoLei11196FR2OrigemME());
            this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital4ProporcionalOrigemME());
            if (enquadramentoInicial == enquadramentoFinal || this.getColecaoParcelaAlienacao().obterUltimaParcela() == null) {
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemMN());
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoUnicoImovelOrigemMN());
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemMN());
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoBemPequenoValorOrigemMN());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal());
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemME());
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoUnicoImovelOrigemME());
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemME());
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoBemPequenoValorOrigemME());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal());
            } else {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().clear();
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().clear();
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().clear();
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().clear();
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemMN());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalNacionalRealTotal());
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().clear();
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().clear();
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().clear();
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().clear();
                this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemME());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalMERealTotal());
                ValorPositivo ganhoCapitalTotalMN = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
                ValorPositivo ganhoCapitalTotalME = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
                if ((enquadramentoInicial == REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramentoInicial == REDUCAO_UNICO_IMOVEL) && enquadramentoFinal == REDUCAO_AUSENTE) {
                    for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                        if (parcela.isUltimaParcela()) {
                            ganhoCapitalTotalMN.append('+', parcela.getGanhoCapital5ProporcionalMN());
                            ganhoCapitalTotalME.append('+', parcela.getGanhoCapital5ProporcionalME());
                            continue;
                        }
                        ganhoCapitalTotalMN.append('+', parcela.getGanhoCapital4ProporcionalMN());
                        ganhoCapitalTotalME.append('+', parcela.getGanhoCapital4ProporcionalME());
                    }
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().clear();
                    this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(ganhoCapitalTotalMN);
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().clear();
                    this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(ganhoCapitalTotalME);
                }
            }
            if (temUltimaParcela && enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoBemPequenoValorOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
            } else if (temUltimaParcela && enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().clear();
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo("100,00");
                this.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().setConteudo(this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().clear();
            } else if (this.getPerguntas().isValorReaplicadoParcialmente() && this.getDataAlienacao().naoFormatado().length() == 8 && Integer.parseInt(this.getDataAlienacao().getAno()) >= ANO_TRANSICAO_LEI_180_DIAS) {
                int enquadramento = enquadramentoInicial;
                if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
                    enquadramento = enquadramentoFinal;
                }
                if (enquadramento == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                    ValorPositivo ganhoCapitalTotalMN = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
                    ValorPositivo ganhoCapitalTotalME = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
                    ValorPositivo ganhoCapitalParcela = new ValorPositivo();
                    ValorPositivo valorLiquidoTotal = new ValorPositivo();
                    ValorPositivo valorReaplicadoTotalMN = new ValorPositivo(null, "", 11, 2);
                    ValorPositivo valorReaplicadoTotalME = new ValorPositivo(null, "", 11, 2);
                    ValorPositivo percentualReaplicadoMN = new ValorPositivo(null, "", 11, 6);
                    ValorPositivo percentualReaplicadoME = new ValorPositivo(null, "", 11, 6);
                    for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                        valorLiquidoTotal.append('+', parcela.getValorLiquidoAlienacaoReal());
                        ValorPositivo valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(parcela.getValorLiquidoAlienacaoReal(), parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas(), parcela.getGanhoCapital4ProporcionalMN());
                        valorReaplicadoTotalMN.append('+', valorReaplicado.naoFormatado());
                        ganhoCapitalParcela.setConteudo(parcela.getGanhoCapital4ProporcionalMN());
                        ganhoCapitalParcela.append('-', valorReaplicado.naoFormatado());
                        ganhoCapitalTotalMN.append('+', ganhoCapitalParcela);
                        valorReaplicado = this.calcularPercentualValorReaplicacaoOutroImovel(parcela.getValorLiquidoAlienacaoReal(), parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas(), parcela.getGanhoCapital4ProporcionalME());
                        valorReaplicadoTotalME.append('+', valorReaplicado.naoFormatado());
                        ganhoCapitalParcela.setConteudo(parcela.getGanhoCapital4ProporcionalME());
                        ganhoCapitalParcela.append('-', valorReaplicado.naoFormatado());
                        ganhoCapitalTotalME.append('+', ganhoCapitalParcela);
                    }
                    if (valorLiquidoTotal.isVazio()) {
                        percentualReaplicadoMN.clear();
                        percentualReaplicadoME.clear();
                    } else {
                        if (this.getApuracaoFinal().getGanhoCapital4OrigemMNReal().isVazio()) {
                            percentualReaplicadoMN.clear();
                        } else {
                            percentualReaplicadoMN.setConteudo(valorReaplicadoTotalMN);
                            percentualReaplicadoMN.append('*', "100,00");
                            percentualReaplicadoMN.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
                        }
                        if (this.getApuracaoFinal().getGanhoCapital4OrigemMEReal().isVazio()) {
                            percentualReaplicadoME.clear();
                        } else {
                            percentualReaplicadoME.setConteudo(valorReaplicadoTotalME);
                            percentualReaplicadoME.append('*', "100,00");
                            percentualReaplicadoME.append('/', this.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
                        }
                    }
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(percentualReaplicadoMN);
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(valorReaplicadoTotalMN);
                    this.getApuracaoFinal().getGanhoCapital5OrigemMNReal().setConteudo(ganhoCapitalTotalMN);
                    this.getApuracaoFinal().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(percentualReaplicadoME);
                    this.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(valorReaplicadoTotalME);
                    this.getApuracaoFinal().getGanhoCapital5OrigemMEReal().setConteudo(ganhoCapitalTotalME);
                }
            }
            int enquadramentoConsiderado = REDUCAO_AUSENTE;
            enquadramentoConsiderado = temUltimaParcela ? enquadramentoFinal : enquadramentoInicial;
            if (enquadramentoConsiderado == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo("100,000000");
                this.getApuracaoFinal().getPercentualReducaoBemPequenoValorOrigemME().setConteudo("100,000000");
            } else if (enquadramentoConsiderado == REDUCAO_UNICO_IMOVEL) {
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemMN().setConteudo("100,000000");
                this.getApuracaoFinal().getPercentualReducaoUnicoImovelOrigemME().setConteudo("100,000000");
            }
        }
    }

    @Override
    public void calcularUltimaParcelaExterior(ParcelaAlienacaoBem parcela) {
        if (parcela != null) {
            ValorPositivo lImpostoDevido = new ValorPositivo(null, "lImpostoDevido", 11, 9);
            ValorPositivo lAliquotaMedia = new ValorPositivo(null, "lAliquotaMedia", 11, 9);
            ValorPositivo ganhoCapital = new ValorPositivo(null, "ganhoCapital", 11, 2);
            String origemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(parcela.getGanhoCapital5ProporcionalMN());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(parcela.getGanhoCapital5ProporcionalME());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(parcela.getGanhoCapital5ProporcionalTotalReal());
            }
            if (ganhoCapital.isVazio()) {
                lImpostoDevido.clear();
            } else {
                lImpostoDevido.setConteudo(this.getAjuste().getSaldoImpostoDevido());
            }
            if (!ganhoCapital.isVazio()) {
                lAliquotaMedia.setConteudo(lImpostoDevido);
                lAliquotaMedia.append('*', "100,000000000");
                lAliquotaMedia.append('/', ganhoCapital);
                if (lAliquotaMedia.comparacao("<", "15,00") && lAliquotaMedia.comparacao(">", "14,990000")) {
                    lAliquotaMedia.setConteudo("15,000000");
                }
            }
            parcela.getImpostoDevido().setConteudo(lImpostoDevido);
            parcela.getAliquotaMedia().setConteudo(lAliquotaMedia);
        }
    }

    @Override
    public void calcularAjuste() {
        if (this.getColecaoParcelaAlienacao().getDataRecebimentoUltimaParcela().isVazio()) {
            this.getAjuste().clear();
        } else {
            ValorPositivo ganhoCapitalTotal = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
            ValorPositivo ganhoCapitalAnterior = new ValorPositivo(null, "ganhoCapitalAnterior", 11, 9);
            ValorPositivo ganhoCapitalTotalMaisAnterior = new ValorPositivo(null, "ganhoCapitalTotalMaisAnterior", 11, 9);
            ValorPositivo impostoDevidoTotalMaisAnterior = new ValorPositivo(null, "impostoDevidoTotal", 11, 9);
            ValorPositivo impostoDevidoAnterior = new ValorPositivo(null, "impostoDevidoAnterior", 11, 9);
            ValorPositivo aliquotaMedia = new ValorPositivo(null, "aliquotaMedia", 11, 9);
            ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 9);
            ValorPositivo impostoDevido2Total = new ValorPositivo(null, "impostoDevido2Total", 11, 2);
            ValorPositivo impostoDevidoParcelasAnteriores = new ValorPositivo(null, "impostoDevidoParcelasAnteriores", 11, 9);
            ValorPositivo saldoImpostoDevido = new ValorPositivo(null, "saldoImpostoDevido", 11, 9);
            ValorPositivo impostoDevidoNoBrasilParcelasAnteriores = new ValorPositivo(null, "impostoDevidoNoBrasilParcelasAnteriores", 11, 9);
            ValorPositivo saldoImpostoDevidoNoBrasil = new ValorPositivo(null, "saldoImpostoDevidoNoBrasil", 11, 9);
            ganhoCapitalTotal.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
            ganhoCapitalTotal.append('+', this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
            if (ganhoCapitalTotal.isVazio()) {
                this.getAjuste().clear();
            } else {
                ganhoCapitalAnterior.setConteudo(this.getGanhoCapitalAlienacaoAnterior());
                ganhoCapitalTotalMaisAnterior.setConteudo(ganhoCapitalTotal);
                ganhoCapitalTotalMaisAnterior.append('+', ganhoCapitalAnterior);
                if (this.isIsento()) {
                    impostoDevidoTotal.clear();
                    impostoDevidoParcelasAnteriores.clear();
                    saldoImpostoDevido.clear();
                    aliquotaMedia.clear();
                } else {
                    String aliquotaFixa = this.obterAliquotaFixa();
                    if (aliquotaFixa != null) {
                        impostoDevidoTotalMaisAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(ganhoCapitalTotalMaisAnterior, aliquotaFixa);
                        impostoDevidoAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(ganhoCapitalAnterior, aliquotaFixa);
                    } else {
                        impostoDevidoTotalMaisAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevido(ganhoCapitalTotalMaisAnterior, this.getDataAlienacao());
                        impostoDevidoAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevido(ganhoCapitalAnterior, this.getDataAlienacao());
                    }
                    impostoDevidoTotal.setConteudo(impostoDevidoTotalMaisAnterior);
                    impostoDevidoTotal.append('-', impostoDevidoAnterior);
                    impostoDevido2Total.setConteudo(impostoDevidoTotal);
                    impostoDevido2Total.append('-', this.getColecaoParcelaAlienacao().obterImpostoPagoExterior());
                    impostoDevidoParcelasAnteriores.setConteudo(this.getColecaoParcelaAlienacao().obterImpostoDevidoSemUltimaParcela());
                    saldoImpostoDevido.setConteudo(impostoDevidoTotal);
                    saldoImpostoDevido.append('-', impostoDevidoParcelasAnteriores);
                    impostoDevidoNoBrasilParcelasAnteriores.setConteudo(this.getColecaoParcelaAlienacao().obterImpostoDevidoNoBrasilSemUltimaParcela());
                    if (impostoDevidoNoBrasilParcelasAnteriores.comparacao(">", impostoDevido2Total)) {
                        impostoDevidoNoBrasilParcelasAnteriores.setConteudo(impostoDevido2Total);
                        saldoImpostoDevido.clear();
                    }
                    saldoImpostoDevidoNoBrasil.setConteudo(impostoDevido2Total);
                    saldoImpostoDevidoNoBrasil.append('-', impostoDevidoNoBrasilParcelasAnteriores);
                    aliquotaMedia.setConteudo(impostoDevidoTotal);
                    aliquotaMedia.append('*', "100,000000000");
                    aliquotaMedia.append('/', ganhoCapitalTotal);
                }
                if (aliquotaMedia.comparacao("<", "15,00") && aliquotaMedia.comparacao(">", "14,990000")) {
                    aliquotaMedia.setConteudo("15,000000");
                }
                this.getAjuste().getGanhoCapitalTotal().setConteudo(ganhoCapitalTotal);
                this.getAjuste().getAliquotaMedia().setConteudo(aliquotaMedia);
                this.getAjuste().getImpostoDevido().setConteudo(impostoDevidoTotal);
                this.getAjuste().getImpostoPagoExterior().setConteudo(this.getColecaoParcelaAlienacao().obterImpostoPagoExterior());
                this.getAjuste().getImpostoDevidoNoBrasilRelativoParcelasAnteriores().setConteudo(impostoDevidoNoBrasilParcelasAnteriores);
                this.getAjuste().getSaldoImpostoDevidoNoBrasil().setConteudo(saldoImpostoDevidoNoBrasil);
                this.getAjuste().getImpostoDevido2().setConteudo(impostoDevido2Total);
                this.getAjuste().getImpostoDevidoRelativoParcelasAnteriores().setConteudo(impostoDevidoParcelasAnteriores);
                this.getAjuste().getSaldoImpostoDevido().setConteudo(saldoImpostoDevido);
                this.getAjuste().getImpostoPago().setConteudo(this.getColecaoParcelaAlienacao().getImpostoPagoTotal());
            }
        }
    }

    @Override
    public void ajustarFlagCobranca() {
        ParcelaAlienacao ultimaParcela;
        this.getInCobranca().setConteudo(Logico.SIM);
        if (!this.isAlienacaoBrasil() && !this.isAlienacaoAVista() && (ultimaParcela = this.getColecaoParcelaAlienacao().obterUltimaParcela()) != null && ultimaParcela.getDataRecebimento().naoFormatado().length() == 8 && this.getDataAlienacao().naoFormatado().length() == 8 && this.getDataAlienacao().getAno().equals(ultimaParcela.getDataRecebimento().getAno())) {
            ValorPositivo valorTributavelOperacao = new ValorPositivo();
            valorTributavelOperacao.setConteudo(this.getApuracao().getGanhoCapital5OrigemMNReal());
            valorTributavelOperacao.append('+', this.getApuracao().getGanhoCapital5OrigemMEReal());
            if (valorTributavelOperacao.comparacao(">", "0,00")) {
                ValorPositivo valorTributavelApuracaoFinal = new ValorPositivo();
                valorTributavelApuracaoFinal.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
                valorTributavelApuracaoFinal.append('+', this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
                if (valorTributavelApuracaoFinal.isVazio()) {
                    this.getInCobranca().setConteudo(Logico.NAO);
                }
            }
        }
    }

    public ValorBigDecimal getValorIsencaoUnicoImovel() {
        ValorBigDecimal valorIsencaoUnicoImovel = new ValorBigDecimal(null, null, 10, 2);
        valorIsencaoUnicoImovel.setConteudoCompleto(440000L);
        return valorIsencaoUnicoImovel;
    }

    private boolean isValorAlienacaoMenor35k() {
        ValorPositivo valorAlienacao = new ValorPositivo();
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            valorAlienacao.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacao.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        return valorAlienacao.ehMenorOuIgualA(this.getValorIsencao(), true);
    }

    public boolean isIsentoPorPequenoValor() {
        boolean isIsentoPorPequenoValor;
        boolean conjuntoBensInferiorLimiteIsencao = this.getBemGrandeValor().formatado().equals("0");
        boolean bl = isIsentoPorPequenoValor = this.isValorAlienacaoMenor35k() && conjuntoBensInferiorLimiteIsencao;
        return isIsentoPorPequenoValor;
    }

    private boolean isValorAlienacaoMenor440k() {
        ValorPositivo valorAlienacao = new ValorPositivo();
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            valorAlienacao.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacao.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        return valorAlienacao.ehMenorOuIgualA(this.getValorIsencaoUnicoImovel(), true);
    }

    @Override
    public boolean isIsento() {
        boolean isento = false;
        if (this.isAlienacaoBrasil()) {
            if (this.getApuracao().getGanhoCapital5().isVazio()) {
                isento = true;
            }
        } else if (this.isAlienacaoAVista()) {
            Codigo codigoOrigemRendimento = this.obterCodigoOrigemRendimentos();
            ValorPositivo ganho5 = new ValorPositivo();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(codigoOrigemRendimento.naoFormatado())) {
                ganho5.setConteudo(this.getApuracao().getGanhoCapital5OrigemMNReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(codigoOrigemRendimento.naoFormatado())) {
                ganho5.setConteudo(this.getApuracao().getGanhoCapital5OrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(codigoOrigemRendimento.naoFormatado())) {
                ganho5.setConteudo(this.getApuracao().getGanhoCapital5OrigemMNReal());
                ganho5.append('+', this.getApuracao().getGanhoCapital5OrigemMEReal());
            }
            if (ganho5.isVazio()) {
                isento = true;
            }
        } else {
            int enquadramento = REDUCAO_AUSENTE;
            if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
                enquadramento = this.obterEnquadramentoFinal();
            }
            if (enquadramento == REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == REDUCAO_UNICO_IMOVEL || this.getPerguntas().isValorReaplicadoTotalmente()) {
                isento = true;
            } else {
                Codigo codigoOrigemRendimento = this.obterCodigoOrigemRendimentos();
                ValorPositivo ganho5 = new ValorPositivo();
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(codigoOrigemRendimento.naoFormatado())) {
                    ganho5.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(codigoOrigemRendimento.naoFormatado())) {
                    ganho5.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(codigoOrigemRendimento.naoFormatado())) {
                    ganho5.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
                    ganho5.append('+', this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
                }
                if (ganho5.isVazio()) {
                    isento = true;
                }
            }
        }
        return isento;
    }

    public boolean isIsentoPorUnicoImovel() {
        boolean naoHouveOutraVenda5Anos = this.getPerguntas().naoTemOutraAlienacao();
        boolean naoEhProprietarioOutroImovel = this.getPerguntas().getPropriedadeOutroImovel().formatado().equals("0");
        return this.isValorOperacaoMaior35K() && this.isValorAlienacaoMenor440k() && naoHouveOutraVenda5Anos && naoEhProprietarioOutroImovel;
    }

    public boolean isIsentoPorDataAquisicao() {
        return !this.getAquisicao().getDataAquisicao().isVazio() && GcapUtil.isDeclaracaoBrasileira(this) && Integer.parseInt(this.getAquisicao().getDataAquisicao().getAno()) <= 1969 && !this.existeCustoAquisicaoPosterior1969();
    }

    public boolean isPermutaComTorna() {
        return String.valueOf(CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(this.getNatureza().naoFormatado());
    }

    public boolean isAlienacaoComLucroReduzido() {
        ParcelaAlienacaoBem ultimaParcela;
        boolean retorno = false;
        if (!this.isAlienacaoBrasil() && this.isAlienacaoAPrazo() && (ultimaParcela = (ParcelaAlienacaoBem)this.getColecaoParcelaAlienacao().obterUltimaParcela()) != null) {
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ValorPositivo custoAquisicaoUltimaParcela = new ValorPositivo();
                if (this.isPermutaComTorna()) {
                    custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().naoFormatado());
                } else {
                    custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemNacionalReal().naoFormatado());
                }
                if (ultimaParcela.getValorLiquidoAlienacaoReal().comparacao("<", custoAquisicaoUltimaParcela)) {
                    retorno = true;
                }
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ValorPositivo custoAquisicaoUltimaParcela = new ValorPositivo();
                if (this.isPermutaComTorna()) {
                    custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().naoFormatado());
                } else {
                    custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemMEDolar().naoFormatado());
                }
                if (ultimaParcela.getValorLiquidoAlienacaoDolar().comparacao("<", custoAquisicaoUltimaParcela)) {
                    retorno = true;
                }
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ValorPositivo custoAquisicaoUltimaParcelaMN = new ValorPositivo();
                ValorPositivo custoAquisicaoUltimaParcelaME = new ValorPositivo();
                if (this.isPermutaComTorna()) {
                    custoAquisicaoUltimaParcelaMN.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().naoFormatado());
                    custoAquisicaoUltimaParcelaME.setConteudo(ultimaParcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().naoFormatado());
                } else {
                    custoAquisicaoUltimaParcelaMN.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemNacionalReal().naoFormatado());
                    custoAquisicaoUltimaParcelaME.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemMEDolar().naoFormatado());
                }
                if (ultimaParcela.getValorAlienacaoOrigemNacionalReal().comparacao("<", custoAquisicaoUltimaParcelaMN) || ultimaParcela.getValorAlienacaoOrigemMEDolar().comparacao("<", custoAquisicaoUltimaParcelaME)) {
                    retorno = true;
                }
            }
        }
        return retorno;
    }

    public boolean podeResponderPerguntaPequenoValorNoExteriorPorParcelas() {
        boolean retorno = false;
        boolean residenteNoBrasil = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.getBemImovel().isAdquiridoNoExterior()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            if (valorAlienacaoReal.comparacao(">", "35.000,00") && !this.getDataRecebimentoUltimaParcela().isVazio()) {
                valorAlienacaoReal.clear();
                for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                    ValorPositivo somaParcela = new ValorPositivo();
                    somaParcela.setConteudo(p.getValorRecebidoDolar());
                    somaParcela.append('*', p.getCotacaoDolar());
                    valorAlienacaoReal.append('+', somaParcela);
                }
                if (residenteNoBrasil && valorAlienacaoReal.comparacao("<=", "35.000,00") && this.getDataAlienacao().naoFormatado().length() == 8 && AplicacaoPropertiesUtil.getExercicio().equals(this.getDataAlienacao().getAno())) {
                    retorno = true;
                }
            }
        }
        return retorno;
    }

    public boolean existeDesdobramentoNaDataAquisicao() {
        boolean retorno = false;
        if (!this.getAquisicao().getDataAquisicao().isVazio()) {
            for (ParcelaAquisicao parcAquis : this.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                if (!this.getAquisicao().getDataAquisicao().naoFormatado().equals(parcAquis.getData().naoFormatado())) continue;
                retorno = true;
                break;
            }
        }
        return retorno;
    }

    public boolean existeCustoAquisicaoPosterior1969() {
        try {
            if (!this.getAquisicao().getDataAquisicao().isVazio()) {
                boolean posterior1969;
                boolean bl = posterior1969 = 1969 < Integer.parseInt(this.getAquisicao().getDataAquisicao().getAno());
                if (posterior1969) {
                    return true;
                }
                for (ParcelaAquisicao parcAquis : this.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                    posterior1969 = 1969 < Integer.valueOf(parcAquis.getData().getAno());
                    if (!posterior1969) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void limparPerguntas() {
        this.getPerguntas().getOutraAlienacao().clear();
        this.getPerguntas().getPropriedadeOutroImovel().clear();
        this.getBemGrandeValor().clear();
    }

    public boolean existeGanhoDeCapitalSobreCustoAquisicao() {
        boolean retorno = true;
        if (this.isAlienacaoBrasil()) {
            if (this.getApuracao().getGanhoCapital1().isVazio()) {
                retorno = false;
            }
        } else if (this.getApuracao().getGanhoCapital1OrigemNacionalReal().isVazio() && this.getApuracao().getGanhoCapital1OrigemMEDolar().isVazio()) {
            retorno = false;
        }
        return retorno;
    }

    public boolean criticarLei180Dias() {
        int ano = -1;
        try {
            ano = Integer.valueOf(this.getDataAlienacao().getAno());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ano >= ANO_TRANSICAO_LEI_180_DIAS;
    }

    public boolean podePreencherCalculo() {
        boolean retorno = true;
        if (this.getAlienacaoAPrazo().isVazio() || this.getNatureza().isVazio() || !this.isAlienacaoBrasil() && this.getBemImovel().getAquisicao().getOrigemRendimentos().isVazio()) {
            retorno = false;
        }
        return retorno;
    }

    @Override
    public boolean podeResponderPerguntaBemIsentoPorPequenoValor() {
        boolean retorno = false;
        if (ControladorGui.getDemonstrativoAberto() != null && !GCAPFacade.getInstancia().verificaHabilitacaoAbaPerguntas(this, ControladorGui.getDemonstrativoAberto().getIdDemonstrativo())) {
            return false;
        }
        if (this.getDataAlienacao().naoFormatado().length() < 8) {
            return false;
        }
        if (this.isAlienacaoBrasil() || !AplicacaoPropertiesUtil.getExercicio().equals(this.getDataAlienacao().getAno())) {
            retorno = GCAPFacade.getInstancia().deveExibirPerguntaConjuntoBensSuperior35Mil(this);
        } else {
            boolean residenteNoBrasil = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
            ValorPositivo valorAlienacaoReal = new ValorPositivo();
            if (this.getBemImovel().isAdquiridoNoBrasil()) {
                valorAlienacaoReal.setConteudo(this.getValorAlienacao());
            } else if (this.getDataRecebimentoUltimaParcela().isVazio()) {
                valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            } else {
                for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                    ValorPositivo somaParcela = new ValorPositivo();
                    somaParcela.setConteudo(p.getValorRecebidoDolar());
                    somaParcela.append('*', p.getCotacaoDolar());
                    valorAlienacaoReal.append('+', somaParcela);
                }
            }
            if (residenteNoBrasil && valorAlienacaoReal.comparacao("<=", "35.000,00") && this.getDataAlienacao().naoFormatado().length() == 8 && AplicacaoPropertiesUtil.getExercicio().equals(this.getDataAlienacao().getAno())) {
                retorno = true;
                this.getBemGrandeValorOperacao().setConteudo(this.getBemGrandeValor());
            }
        }
        if (retorno) {
            this.getBemGrandeValorOperacao().setConteudo(this.getBemGrandeValor());
        }
        return retorno;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        ArrayList<Pendencia> listaPendencias = new ArrayList<Pendencia>();
        List<Object> informacoes = new ArrayList<Informacao>();
        informacoes.addAll(this.getBemImovel().recuperarListaCamposPendenciaAbaIdentificacao());
        informacoes.addAll(this.getBemImovel().getEndereco().recuperarListaCamposPendenciaAbaIdentificacao());
        String listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;Identifica\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_IDENTIFICACAO, listaPassosSelecaoTela);
        informacoes = this.getBemImovel().getAquisicao().recuperarListaCamposPendenciaAbaIdentificacao();
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;Aquisi\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_AQUISICAO, listaPassosSelecaoTela);
        if (this.getBemImovel().getAquisicao().houveReforma() && !this.existeDesdobramentoNaDataAquisicao()) {
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)2, MensagemUtil.getMensagem("aquisicaoEmPartesSemDesdobramentoNaAquisicao"), this.getClasseFicha(), NOME_ABA_AQUISICAO, listaPassosSelecaoTela, NOME_FICHA_BEM_IMOVEl));
        }
        List aquisicoes = this.getBemImovel().getAquisicao().getParcelasAquisicao().itens();
        for (int i = 0; i < aquisicoes.size(); ++i) {
            ParcelaAquisicao parcela = (ParcelaAquisicao)((Object)aquisicoes.get(i));
            String data = parcela.getData().isVazio() ? "(data n\u00e3o informada)" : parcela.getData().formatado();
            informacoes = parcela.recuperarListaCamposPendenciaAbaCalculo();
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;Aquisi\u00e7\u00e3o|Lista;" + (i + 1) + ";Parcela de Aquisi\u00e7\u00e3o/Reforma paga em " + data;
            GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_AQUISICAO, listaPassosSelecaoTela);
        }
        boolean isAdquirenteRequerido = this.isAdquirenteRequerido();
        if (!isAdquirenteRequerido) {
            this.getBemImovel().getAdquirentes().clear();
        }
        if (this.getBemImovel().getAdquirentes().isVazio() && isAdquirenteRequerido) {
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;Adquirentes";
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)3, MensagemUtil.getMensagem("alienacaoSemAdquirente"), this.getClasseFicha(), NOME_ABA_ADQUIRENTES, listaPassosSelecaoTela, NOME_FICHA_BEM_IMOVEl));
        } else {
            List adquirentes = this.getBemImovel().getAdquirentes().itens();
            for (int i = 0; i < adquirentes.size(); ++i) {
                Adquirente adquirente = (Adquirente)adquirentes.get(i);
                String cpf = adquirente.getCpfCnpj().isVazio() ? "(n\u00e3o informado)" : adquirente.getCpfCnpj().formatado();
                informacoes = adquirente.recuperarListaCamposPendenciaAbaAdquirentes();
                listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bem M\u00f3vel Item n\u00ba " + numeroItem + "|Aba;Adquirentes|Lista;" + (i + 1) + ";Adquirente CPF/CNPJ " + cpf;
                GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_ADQUIRENTES, listaPassosSelecaoTela);
            }
        }
        informacoes = this.recuperarListaCamposPendenciaAbaOperacao();
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;Opera\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_OPERACAO, listaPassosSelecaoTela);
        informacoes = new ArrayList();
        informacoes.addAll(this.getPerguntas().recuperarListaCamposPendenciaAbaPerguntas());
        informacoes.addAll(this.recuperarListaCamposPendenciaAbaPerguntas());
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;Perguntas";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_PERGUNTAS, listaPassosSelecaoTela);
        informacoes = new ArrayList();
        informacoes.addAll(this.getCalculoImposto().recuperarListaCamposPendenciaAbaCalculo());
        informacoes.addAll(this.recuperarListaCamposPendenciaAbaCalculo());
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;C\u00e1lculo do Imposto";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_CALCULO, listaPassosSelecaoTela);
        ValidadorSomatorioParcelas validadorSomatorio = new ValidadorSomatorioParcelas(this);
        RetornoValidacao retornoValidacao = validadorSomatorio.validarImplementado();
        listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo(retornoValidacao.getSeveridade(), retornoValidacao.getMensagemValidacao(), this.getClasseFicha(), NOME_ABA_CALCULO, listaPassosSelecaoTela, NOME_FICHA_BEM_IMOVEl));
        if (this.isAlienacaoAPrazo() && this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)2, MensagemUtil.getMensagem("alienacaoPrazoSemParcelas"), this.getClasseFicha(), NOME_ABA_CALCULO, listaPassosSelecaoTela, NOME_FICHA_BEM_IMOVEl));
        }
        List parcelas = this.getColecaoParcelaAlienacao().itens();
        for (int i = 0; i < parcelas.size(); ++i) {
            ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)parcelas.get(i));
            String data = parcela.getDataRecebimento().isVazio() ? "(data n\u00e3o informada)" : parcela.getDataRecebimento().formatado();
            informacoes = parcela.recuperarListaCamposPendenciaAbaCalculo();
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens Im\u00f3veis Item n\u00ba " + numeroItem + "|Aba;C\u00e1lculo do Imposto|Lista;" + (i + 1) + ";Parcela recebida em " + data;
            GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_IMOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_CALCULO, listaPassosSelecaoTela);
        }
        return listaPendencias;
    }

    private List<Informacao> recuperarListaCamposPendenciaAbaPerguntas() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getBemGrandeValor());
        lista.add(this.getValorAplicado());
        return lista;
    }

    private List<Informacao> recuperarListaCamposPendenciaAbaOperacao() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getNatureza());
        lista.add(this.getAlienacaoAPrazo());
        lista.add(this.getDataAlienacao());
        lista.add(this.getDataTransitoJulgado());
        lista.add(this.getCotacaoDolarDataAlienacao());
        lista.add(this.getValorAlienacao());
        lista.add(this.getValorAlienacaoDolar());
        lista.add(this.getCustoCorretagem());
        lista.add(this.getValorCorretagemDolar());
        lista.add(this.getAlienacaoParcial());
        lista.add(this.getGanhoCapitalAlienacaoAnterior());
        lista.add(this.getPaisAcordo());
        lista.add(this.getValorImpostoExteriorReal());
        return lista;
    }

    private List<Informacao> recuperarListaCamposPendenciaAbaCalculo() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getValorRecebidoAnosAnteriores());
        lista.add((Informacao)this.getCorretagemAnosAnteriores());
        return lista;
    }

    public String getClasseFicha() {
        return PainelListaBemImovel.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public int obterEnquadramentoInicial() {
        int retorno = REDUCAO_AUSENTE;
        if ((Logico.NAO.equals(this.getBemGrandeValor().formatado()) || Logico.NAO.equals(this.getBemGrandeValorOperacao().formatado())) && this.isValorAlienacaoMenor35k()) {
            retorno = REDUCAO_IMOVEL_PEQUENO_VALOR;
        } else if (this.getPerguntas().naoTemOutraAlienacao() && this.isValorAlienacaoMenor440k()) {
            retorno = REDUCAO_UNICO_IMOVEL;
        } else if (this.getPerguntas().isValorReaplicado()) {
            retorno = REDUCAO_APLICACAO_OUTRO_IMOVEL;
        }
        return retorno;
    }

    public int obterEnquadramentoFinal() {
        int retorno = REDUCAO_AUSENTE;
        ValorPositivo valorAlienacaoParcelas = new ValorPositivo();
        for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
            ValorPositivo somaParcela = new ValorPositivo();
            somaParcela.setConteudo(p.getValorRecebidoDolar());
            somaParcela.append('*', p.getCotacaoDolar());
            valorAlienacaoParcelas.append('+', somaParcela);
        }
        if (Logico.NAO.equals(this.getBemGrandeValor().formatado()) && valorAlienacaoParcelas.comparacao("<=", "35.000,00")) {
            retorno = REDUCAO_IMOVEL_PEQUENO_VALOR;
        } else if (this.getPerguntas().naoTemOutraAlienacao() && valorAlienacaoParcelas.comparacao("<=", this.getValorIsencaoUnicoImovel())) {
            retorno = REDUCAO_UNICO_IMOVEL;
        } else if (this.getPerguntas().isValorReaplicado()) {
            retorno = REDUCAO_APLICACAO_OUTRO_IMOVEL;
        }
        return retorno;
    }

    public int obterEnquadramentoAtual() {
        int enquadramento = this.obterEnquadramentoInicial();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
            enquadramento = this.obterEnquadramentoFinal();
        }
        return enquadramento;
    }

    public boolean mudouEnquadramento() {
        boolean retorno = false;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && enquadramentoInicial != this.obterEnquadramentoFinal()) {
            retorno = true;
        }
        return retorno;
    }

    public String obterMensagemMudancaEnquadramento() {
        String mensagem = null;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        int enquadramentoFinal = this.obterEnquadramentoFinal();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && enquadramentoInicial != enquadramentoFinal) {
            if (enquadramentoInicial == REDUCAO_AUSENTE) {
                if (enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.</html>";
                } else if (enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                }
            } else if (enquadramentoInicial == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                if (enquadramentoFinal == REDUCAO_AUSENTE) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
                } else if (enquadramentoFinal == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>Ser\u00e1 aplicada a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005.</html>";
                }
            } else if (enquadramentoInicial == REDUCAO_UNICO_IMOVEL) {
                if (enquadramentoFinal == REDUCAO_AUSENTE) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
                } else if (enquadramentoFinal == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.<br>Ser\u00e1 aplicada a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005.</html>";
                }
            } else if (enquadramentoInicial == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                if (enquadramentoFinal == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                } else if (enquadramentoFinal == REDUCAO_UNICO_IMOVEL) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.</html>";
                }
            }
        }
        return mensagem;
    }

    public boolean isNaturezaComMP252SemPermissao() {
        boolean retorno = false;
        if (this.getPerguntas().isValorReaplicavel()) {
            int natureza = -1;
            try {
                natureza = Integer.parseInt(this.getNatureza().naoFormatado());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (CODIGO_NATUREZA_VENDA != natureza && CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA != natureza && CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA != natureza && CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA != natureza) {
                retorno = true;
            }
        }
        return retorno;
    }

    public boolean isMP252PermitidaParaNaturezaSelecionada() {
        boolean retorno = false;
        int natureza = -1;
        try {
            natureza = Integer.parseInt(this.getNatureza().naoFormatado());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (CODIGO_NATUREZA_VENDA == natureza || CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA == natureza || CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA == natureza || CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA == natureza) {
            retorno = true;
        }
        return retorno;
    }

    public class ValidadorNaoNuloExterior
    extends ValidadorNaoNuloGCAP {
        public ValidadorNaoNuloExterior(byte severidade, String pMsg) {
            super(severidade, pMsg);
        }

        public ValidadorNaoNuloExterior(byte severidade) {
            super(severidade);
        }

        public RetornoValidacao validarImplementado() {
            if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoExterior()) {
                return super.validarImplementado();
            }
            return null;
        }
    }

    public class ValidadorNaoNuloBrasil
    extends ValidadorNaoNuloGCAP {
        public ValidadorNaoNuloBrasil(byte severidade, String pMsg) {
            super(severidade, pMsg);
        }

        public ValidadorNaoNuloBrasil(byte severidade) {
            super(severidade);
        }

        public RetornoValidacao validarImplementado() {
            if (AlienacaoBemImovel.this.getBemImovel().isAdquiridoNoBrasil()) {
                return super.validarImplementado();
            }
            return null;
        }
    }
}

