/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.apuracao.ApuracaoBemMovel;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.entidades.bensmoveis.BemMovel;
import br.gov.serpro.gcap.entidades.calculo.ObservadorRemovedorParcelasAnteriorAlienacaoBem;
import br.gov.serpro.gcap.entidades.calculo.ValidadorCorretagemTotalExcedida;
import br.gov.serpro.gcap.entidades.consolidacao.ObservadorCalculoConsolidacaoBemMovel;
import br.gov.serpro.gcap.gui.bensmoveis.PainelListaBemMovel;
import br.gov.serpro.gcap.negocio.CalculoImpostoDevidoUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.observador.ObservadorCalculoImpostoDevido;
import br.gov.serpro.gcap.observador.ObservadorCalculoPercentualCustoAquisicao;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorComparacaoData;
import br.gov.serpro.gcap.validador.ValidadorComparacaoValor;
import br.gov.serpro.gcap.validador.ValidadorData;
import br.gov.serpro.gcap.validador.ValidadorDataAquisicao;
import br.gov.serpro.gcap.validador.ValidadorGanhoAlienacaoParcial;
import br.gov.serpro.gcap.validador.ValidadorNaoNuloGCAP;
import br.gov.serpro.gcap.validador.ValidadorPerguntaAlienacaoParcial;
import br.gov.serpro.gcap.validador.ValidadorPerguntaBemGrandeValor;
import br.gov.serpro.gcap.validador.ValidadorSomatorioParcelas;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNegativo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class AlienacaoBemMovel
extends AlienacaoBem
implements ObjetoFicha {
    public static final String NOME_FICHA_BEM_MOVEl = "Bens M\u00f3veis";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static int REDUCAO_AUSENTE = 0;
    public static int REDUCAO_IMOVEL_PEQUENO_VALOR = 1;
    private BemMovel bemMovel = new BemMovel(this);
    private ApuracaoBemMovel apuracao = new ApuracaoBemMovel();
    private ApuracaoBemMovel apuracaoFinal = new ApuracaoBemMovel();

    public AlienacaoBemMovel() {
        this.adicionarValidadores();
        this.adicionarObservadores();
        this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalReal().setReadOnly(true);
        this.bemMovel.getAquisicao().getCustoAquisicaoTotalDolar().setReadOnly(true);
        this.getNatureza().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarNaturezaGCAPBemMovelDireitos());
    }

    public BemMovel getBemMovel() {
        return this.bemMovel;
    }

    public void adicionarValidadoresIdentificacao() {
        this.bemMovel.getBemAdquiridoNoBrasil().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.bemMovel.getBemAdquiridoNoBrasil().getNomeCampo()})));
        this.bemMovel.getSujeitoRegistroPublico().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.isAlienacaoBrasil() && AlienacaoBemMovel.this.bemMovel.getSujeitoRegistroPublico().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemMovel.this.bemMovel.getSujeitoRegistroPublico().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.bemMovel.getEspecificacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.bemMovel.getEspecificacao().getNomeCampo()})));
    }

    public void adicionarValidadoresAquisicao() {
        this.bemMovel.getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.bemMovel.getAquisicao().getDataAquisicao().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.isDataAquisicaoObrigatoria()) {
                    return super.validarImplementado();
                }
                return new RetornoValidacao(0);
            }
        });
        this.bemMovel.getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorDataAquisicao(3));
        this.bemMovel.getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorData(3));
        this.bemMovel.getAquisicao().getDataAquisicao().addValidador((ValidadorIf)new ValidadorComparacaoData(3, -3, this.getDataAlienacao()));
        this.bemMovel.getAquisicao().getOrigemRendimentos().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoExterior() && AlienacaoBemMovel.this.bemMovel.getAquisicao().getOrigemRendimentos().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemMovel.this.bemMovel.getAquisicao().getOrigemRendimentos().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getBemMovel().getAquisicao().getCotacaoDolarDataAquisicao().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && !AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().addValidador((ValidadorIf)new ValidadorNaoNuloExterior(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado()) && AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.bemMovel.getAquisicao().getMoedaEstrangeira().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoExterior() && AlienacaoBemMovel.this.bemMovel.getAquisicao().getMoedaEstrangeira().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemMovel.this.bemMovel.getAquisicao().getMoedaEstrangeira().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
    }

    public void adicionarValidadoresOperacao() {
        this.getAlienacaoParcial().addValidador((ValidadorIf)new ValidadorPerguntaAlienacaoParcial(this.getDataAlienacao(), this.getNatureza(), null));
        this.getNatureza().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getNatureza().getNomeCampo()})));
        this.getValorAlienacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoBrasil() && AlienacaoBemMovel.this.getValorAlienacao().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemMovel.this.getValorAlienacao().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getCotacaoDolarDataAlienacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoExterior() && AlienacaoBemMovel.this.getCotacaoDolarDataAlienacao().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemMovel.this.getCotacaoDolarDataAlienacao().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValorAlienacaoDolar().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoExterior() && AlienacaoBemMovel.this.getValorAlienacaoDolar().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoBemMovel.this.getValorAlienacaoDolar().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getGanhoCapitalAlienacaoAnterior().addValidador((ValidadorIf)new ValidadorGanhoAlienacaoParcial(this.getAlienacaoParcial()));
        this.getValorCorretagemDolar().addValidador((ValidadorIf)new ValidadorComparacaoValor(3, -2, (Object)this.getValorAlienacaoDolar()));
        this.getCustoCorretagem().addValidador((ValidadorIf)new ValidadorComparacaoValor(3, -2, (Object)this.getValorAlienacao()));
        this.getCustoCorretagem().addValidador((ValidadorIf)new ValidadorCorretagemTotalExcedida("R$", this.getColecaoParcelaAlienacao().getCustoCorretagemTotal(), this.getCorretagemAnosAnteriores(), this.getCustoCorretagem(), this.getAlienacaoAPrazo()));
        this.getValorCorretagemDolar().addValidador((ValidadorIf)new ValidadorCorretagemTotalExcedida("XX$", this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal(), null, this.getValorCorretagemDolar(), this.getAlienacaoAPrazo()));
        this.getBemGrandeValor().addValidador((ValidadorIf)new ValidadorPerguntaBemGrandeValor(this));
    }

    public void adicionarValidadoresCalculoImposto() {
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().comparacao(">", AlienacaoBemMovel.this.getValorImpostoExteriorReal())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("impostoPagoExteriorMaiorQuePermitido"));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                ValorPositivo impostoPagoTotal = new ValorPositivo();
                impostoPagoTotal.setConteudo(AlienacaoBemMovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao());
                impostoPagoTotal.append('+', AlienacaoBemMovel.this.getCalculoImposto().getImpostoPago());
                if (impostoPagoTotal.comparacao(">", AlienacaoBemMovel.this.getCalculoImposto().getImpostoDevido())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("somatorioImpostoPagoBrasilMaisExterior"));
                }
                return new RetornoValidacao(0);
            }
        });
    }

    public void adicionarValidadoresCalculoImpostoAPrazo() {
        this.getValorLiquidoRecebidoAnosAnteriores().addValidador((ValidadorIf)new ValidadorNaoNegativo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoBemMovel.this.isAlienacaoAPrazo() && AlienacaoBemMovel.this.getValorLiquidoRecebidoAnosAnteriores().comparacao(">", AlienacaoBemMovel.this.getValorAlienacao())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("valorAnosAnterioresMaiorQueAlienacao"));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValorLiquidoRecebidoAnosAnteriores().addValidador((ValidadorIf)new ValidadorNaoNegativo(3){

            public RetornoValidacao validarImplementado() {
                ValorPositivo totalParcelasMaisAnosAnteriores = new ValorPositivo(null, "totalParcelasMaisAnosAnteriores", 11, 9);
                totalParcelasMaisAnosAnteriores.setConteudo(AlienacaoBemMovel.this.getValorLiquidoRecebidoAnosAnteriores());
                totalParcelasMaisAnosAnteriores.append('+', AlienacaoBemMovel.this.getColecaoParcelaAlienacao().getValorRecebidoTotal());
                if (AlienacaoBemMovel.this.isAlienacaoAPrazo() && AlienacaoBemMovel.this.getValorLiquidoRecebidoAnosAnteriores().comparacao("<=", AlienacaoBemMovel.this.getValorAlienacao()) && totalParcelasMaisAnosAnteriores.comparacao(">", AlienacaoBemMovel.this.getValorAlienacao())) {
                    return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("valorParcelasMaisAnosAnterioresMaiorQueAlienacao"));
                }
                return new RetornoValidacao(0);
            }
        });
    }

    public void adicionarValidadores() {
        this.adicionarValidadoresAquisicao();
        this.adicionarValidadoresIdentificacao();
        this.adicionarValidadoresOperacao();
        this.adicionarValidadoresCalculoImposto();
        this.adicionarValidadoresCalculoImpostoAPrazo();
    }

    public void adicionarObservadoresZerarDadosAquisicao() {
        this.getBemMovel().getAquisicao().getOrigemRendimentos().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                    AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().clear();
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                    AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCotacaoDolarDataAquisicao().clear();
                    AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().clear();
                }
            }
        });
    }

    public void adicionarObservadoresAquisicao() {
        Observador obsCalculaCustoAquisicaoMNReal = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo custoAquisicaoDolar = AlienacaoBemMovel.this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalDolar();
                ValorPositivo cotacaoDolar = AlienacaoBemMovel.this.bemMovel.getAquisicao().getCotacaoDolarDataAquisicao();
                ValorPositivo custoAquisicaoReal = AlienacaoBemMovel.this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalReal();
                custoAquisicaoReal.setConteudo(custoAquisicaoDolar.operacao('*', cotacaoDolar));
            }
        };
        this.bemMovel.getAquisicao().getCotacaoDolarDataAquisicao().addObservador(obsCalculaCustoAquisicaoMNReal);
        this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addObservador(obsCalculaCustoAquisicaoMNReal);
        Observador obsCalculaCustoAquisicaoTotal = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo custoAquisicaoNacional = AlienacaoBemMovel.this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalDolar();
                ValorPositivo custoAquisicaoEstrangeira = AlienacaoBemMovel.this.bemMovel.getAquisicao().getCustoAquisicaoOrigemMEDolar();
                ValorPositivo custoAquisicaoTotal = AlienacaoBemMovel.this.bemMovel.getAquisicao().getCustoAquisicaoTotalDolar();
                custoAquisicaoTotal.setConteudo(custoAquisicaoNacional.operacao('+', custoAquisicaoEstrangeira));
            }
        };
        this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addObservador(obsCalculaCustoAquisicaoTotal);
        this.bemMovel.getAquisicao().getCustoAquisicaoOrigemMEDolar().addObservador(obsCalculaCustoAquisicaoTotal);
        this.bemMovel.getBemAdquiridoNoBrasil().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemMovel.this.getBemMovel().isAdquiridoNoExterior()) {
                    AlienacaoBemMovel.this.getAquisicao().getOrigemRendimentos().setConteudo(Aquisicao.CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL);
                } else {
                    AlienacaoBemMovel.this.getAquisicao().getResidenteBrasilAplicacaoExterior().setConteudo(Logico.NAO);
                    AlienacaoBemMovel.this.getAquisicao().getMoedaEstrangeira().clear();
                }
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoBrasil()) {
                    AlienacaoBemMovel.this.getNatureza().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarNaturezaGCAPBemMovelDireitos());
                } else {
                    AlienacaoBemMovel.this.getNatureza().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarNaturezaGCMEBemMovelDireitos());
                }
                if (((String)valorAntigo).trim().length() > 0) {
                    AlienacaoBemMovel.this.alterarOndeBemFoiAdquirido();
                }
            }
        });
        this.getBemMovel().getAquisicao().getCustoAquisicao().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoBemMovel.this.getApuracao().getCustoAquisicao().setConteudo(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicao());
            }
        });
        ObservadorCalculoPercentualCustoAquisicao obsCalculoPercentualCustoAquisicao = new ObservadorCalculoPercentualCustoAquisicao(this.getBemMovel().getAquisicao());
        this.getBemMovel().getAquisicao().getCustoAquisicaoTotalDolar().addObservador(obsCalculoPercentualCustoAquisicao);
        this.getBemMovel().getAquisicao().getOrigemRendimentos().addObservador((Observador)obsCalculoPercentualCustoAquisicao);
        this.getBemMovel().getAquisicao().getOrigemRendimentos().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemMovel.this.alterarOrigemRendimentos((String)valorAntigo, (String)valorNovo);
            }
        });
        this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO).equals(AlienacaoBemMovel.this.getNatureza().naoFormatado())) {
                    AlienacaoBemMovel.this.getValorAlienacaoDolar().setConteudo(AlienacaoBemMovel.this.getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
                    AlienacaoBemMovel.this.getValorAlienacaoDolar().setReadOnly(true);
                } else {
                    AlienacaoBemMovel.this.getValorAlienacaoDolar().setReadOnly(false);
                }
            }
        });
    }

    public void adicionarObservadoresOperacao() {
        Observador obsLimpaPequenoValor = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (GcapUtil.getEstadoSistema() == 0 && !AlienacaoBemMovel.this.podeResponderPerguntaBemIsentoPorPequenoValor()) {
                    AlienacaoBemMovel.this.getBemGrandeValor().clear();
                }
            }
        };
        this.getValorAlienacao().addObservador(obsLimpaPequenoValor);
        this.getValorAlienacaoReal().addObservador(obsLimpaPequenoValor);
        this.getNatureza().addObservador(obsLimpaPequenoValor);
        this.getValorAlienacao().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoBemMovel.this.getApuracao().getValorAlienacao().setConteudo(AlienacaoBemMovel.this.getValorAlienacao());
            }
        });
        this.getCustoCorretagem().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemMovel.this.getApuracao().getCustoCorretagem().setConteudo(AlienacaoBemMovel.this.getCustoCorretagem());
            }
        });
        this.getAlienacaoAPrazo().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (propriedade.equals(((Informacao)observado).getNomeCampo()) && ((String)valorAntigo).length() > 0) {
                    AlienacaoBemMovel.this.limparCalculoImposto();
                }
            }
        });
        this.getBemGrandeValor().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                String opcao = "";
                boolean operacaoMaior35k = AlienacaoBemMovel.this.isValorOperacaoMaior35K();
                try {
                    opcao = (String)valorNovo;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (operacaoMaior35k || !operacaoMaior35k && opcao.length() > 0) {
                    AlienacaoBemMovel.this.getBemGrandeValorOperacao().setConteudo(AlienacaoBemMovel.this.getBemGrandeValor());
                }
            }
        });
        this.getNatureza().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (!AlienacaoBemMovel.this.isAdquirenteRequerido()) {
                    AlienacaoBemMovel.this.getBemMovel().getAdquirentes().clear();
                }
            }
        });
        this.getNatureza().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO).equals(AlienacaoBemMovel.this.getNatureza().naoFormatado())) {
                    AlienacaoBemMovel.this.getValorAlienacaoDolar().setConteudo(AlienacaoBemMovel.this.getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
                    AlienacaoBemMovel.this.getValorAlienacaoDolar().setReadOnly(true);
                } else {
                    AlienacaoBemMovel.this.getValorAlienacaoDolar().setReadOnly(false);
                }
            }
        });
    }

    public void adicionarObservadoresCalculoImposto() {
        this.getDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                boolean dataValida = AlienacaoBemMovel.this.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido();
                if (dataValida) {
                    if (Integer.valueOf(AlienacaoBemMovel.this.getDataAlienacao().getAno()) == AplicacaoPropertiesUtil.getExercicioAsInt()) {
                        AlienacaoBemMovel.this.getValorLiquidoRecebidoAnosAnteriores().clear();
                    }
                } else {
                    AlienacaoBemMovel.this.getValorLiquidoRecebidoAnosAnteriores().clear();
                }
            }
        });
        this.apuracao.getGanhoCapital1().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoBrasil()) {
                    AlienacaoBemMovel.this.getCalculoImposto().getGanhoCapitalTotal().setConteudo(AlienacaoBemMovel.this.apuracao.getGanhoCapital1());
                }
            }
        });
        Observador obsCalculoGanhoCapitalExterior = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemMovel.this.bemMovel.isAdquiridoNoExterior()) {
                    AlienacaoBemMovel.this.getCalculoImposto().getGanhoCapitalTotal().setConteudo(AlienacaoBemMovel.this.apuracao.getGanhoCapital1OrigemNacionalReal().operacao('+', AlienacaoBemMovel.this.apuracao.getGanhoCapital1OrigemMEReal()));
                }
            }
        };
        this.apuracao.getGanhoCapital1OrigemNacionalReal().addObservador(obsCalculoGanhoCapitalExterior);
        this.apuracao.getGanhoCapital1OrigemMEReal().addObservador(obsCalculoGanhoCapitalExterior);
        ObservadorCalculoImpostoDevido obsCalculoImpostoDevido = new ObservadorCalculoImpostoDevido(this);
        this.getCalculoImposto().getGanhoCapitalTotal().addObservador(obsCalculoImpostoDevido);
        this.getAjuste().getGanhoCapitalTotal().addObservador(obsCalculoImpostoDevido);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsCalculoImpostoDevido);
        this.getDataAlienacao().addObservador((Observador)obsCalculoImpostoDevido);
        this.getBemGrandeValor().addObservador((Observador)obsCalculoImpostoDevido);
        this.getNatureza().addObservador((Observador)obsCalculoImpostoDevido);
        this.getBemGrandeValor().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemMovel.this.isBemPequenoValor()) {
                    AlienacaoBemMovel.this.getCalculoImposto().getImpostoPago().setReadOnly(true);
                } else {
                    AlienacaoBemMovel.this.getCalculoImposto().getImpostoPago().setReadOnly(false);
                }
            }
        });
        this.getCalculoImposto().getImpostoDevido().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemMovel.this.getCalculoImposto().getImpostoDevido2().setConteudo(AlienacaoBemMovel.this.getCalculoImposto().getImpostoDevido().operacao('-', AlienacaoBemMovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao()));
            }
        });
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemMovel.this.getCalculoImposto().getImpostoDevido2().setConteudo(AlienacaoBemMovel.this.getCalculoImposto().getImpostoDevido().operacao('-', AlienacaoBemMovel.this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao()));
            }
        });
    }

    public void adicionarObservadoresCalculoApuracao() {
        this.getValorAlienacaoDolar().addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                AlienacaoBemMovel.this.getApuracao().getValorAlienacaoDolar().setConteudo(AlienacaoBemMovel.this.getValorAlienacaoDolar());
            }
        });
        this.getValorCorretagemDolar().addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                AlienacaoBemMovel.this.getApuracao().getCustoCorretagemDolar().setConteudo(AlienacaoBemMovel.this.getValorCorretagemDolar());
            }
        });
        this.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional().addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                AlienacaoBemMovel.this.getApuracao().getPercentualCustoAquisicaoOrigemMN().setConteudo(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional());
            }
        });
        this.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemME().addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                AlienacaoBemMovel.this.getApuracao().getPercentualCustoAquisicaoOrigemME().setConteudo(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemME());
            }
        });
        this.getCotacaoDolarDataAlienacao().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoBemMovel.this.getApuracao().getCotacaoDolarOrigemNacional().setConteudo(AlienacaoBemMovel.this.getCotacaoDolarDataAlienacao());
                AlienacaoBemMovel.this.getApuracao().getCotacaoDolarOrigemME().setConteudo(AlienacaoBemMovel.this.getCotacaoDolarDataAlienacao());
            }
        });
        this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoBemMovel.this.getApuracao().getCustoAquisicaoOrigemNacionalReal().setConteudo(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
            }
        });
        this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoBemMovel.this.getApuracao().getCustoAquisicaoOrigemMEDolar().setConteudo(AlienacaoBemMovel.this.getBemMovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
            }
        });
        Observador observadorGanhoCapitalNacionalMaisMEReal = new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                AlienacaoBemMovel.this.getApuracao().getGanhoCapitalTotalExterior().setConteudo(AlienacaoBemMovel.this.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', AlienacaoBemMovel.this.getApuracao().getGanhoCapital1OrigemMEReal()));
            }
        };
        this.getApuracao().getGanhoCapital1OrigemNacionalReal().addObservador(observadorGanhoCapitalNacionalMaisMEReal);
        this.getApuracao().getGanhoCapital1OrigemMEReal().addObservador(observadorGanhoCapitalNacionalMaisMEReal);
    }

    public void adicionarObservadoresCalculoImpostoAPrazo() {
        Observador obsRecalculaParcelas = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemMovel.this.isAlienacaoAPrazo()) {
                    if (AlienacaoBemMovel.this.isAlienacaoBrasil()) {
                        AlienacaoBemMovel.this.recalcularImpostoBrasil();
                    } else {
                        AlienacaoBemMovel.this.recalcularImpostoExterior();
                    }
                }
            }
        };
        this.getBemMovel().getAquisicao().getCustoAquisicao().addObservador(obsRecalculaParcelas);
        this.apuracao.getGanhoCapital1().addObservador(obsRecalculaParcelas);
        this.getValorLiquidoRecebidoAnosAnteriores().addObservador(obsRecalculaParcelas);
        this.getAlienacaoParcial().addObservador(obsRecalculaParcelas);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsRecalculaParcelas);
        this.getBemGrandeValor().addObservador(obsRecalculaParcelas);
        this.apuracao.getGanhoCapital1OrigemNacionalReal().addObservador(obsRecalculaParcelas);
        this.apuracao.getGanhoCapital1OrigemMEReal().addObservador(obsRecalculaParcelas);
        this.getDataAlienacao().addObservador((Observador)new ObservadorRemovedorParcelasAnteriorAlienacaoBem(this.getDataAlienacao(), this.getColecaoParcelaAlienacao()));
        this.getCalculoImposto().getAliquotaMedia().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBemMovel.this.isAlienacaoBrasil() && AlienacaoBemMovel.this.isAlienacaoAPrazo() && (AlienacaoBemMovel.this.isParaisoFiscal() || AlienacaoBemMovel.this.isTerritorioParaisoFiscal())) {
                    for (ParcelaAlienacaoBem parcela : AlienacaoBemMovel.this.getColecaoParcelaAlienacao().itens()) {
                        AlienacaoBemMovel.this.calcularParcelaBrasil(parcela);
                    }
                }
            }
        });
    }

    public void adicionaObservadoresConsolidacao() {
        ObservadorCalculoConsolidacaoBemMovel obsCalculoConsolidacao = new ObservadorCalculoConsolidacaoBemMovel(this);
        this.getBemGrandeValor().addObservador((Observador)obsCalculoConsolidacao);
        this.getDataAlienacao().addObservador((Observador)obsCalculoConsolidacao);
        this.getAlienacaoAPrazo().addObservador((Observador)obsCalculoConsolidacao);
        this.getTemUltimaParcela().addObservador((Observador)obsCalculoConsolidacao);
        this.getAlienacaoParcial().addObservador((Observador)obsCalculoConsolidacao);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsCalculoConsolidacao);
        this.getValorImpostoExteriorReal().addObservador(obsCalculoConsolidacao);
        this.getNatureza().addObservador((Observador)obsCalculoConsolidacao);
        this.getCalculoImposto().getGanhoCapitalTotal().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getImpostoPago().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getImpostoDevido2().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalNacionalRealTotal().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getImpostoPagoTotal().addObservador(obsCalculoConsolidacao);
        this.getConsolidacao().getImpostoDiferidoAnosAnteriores().addObservador(obsCalculoConsolidacao);
    }

    public void adicionarObservadores() {
        this.adicionarObservadoresZerarDadosAquisicao();
        this.adicionarObservadoresAquisicao();
        this.adicionarObservadoresOperacao();
        this.adicionarObservadoresCalculoApuracao();
        this.adicionarObservadoresCalculoImposto();
        this.adicionarObservadoresCalculoImpostoAPrazo();
        this.adicionaObservadoresConsolidacao();
    }

    public boolean isDataAquisicaoObrigatoria() {
        boolean isObrigatorio = true;
        if (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA).equals(this.getNatureza().naoFormatado())) {
            isObrigatorio = false;
        }
        return isObrigatorio;
    }

    private void alterarOndeBemFoiAdquirido() {
        this.getBemMovel().getAquisicao().resetAquisicao(this.bemMovel.isAdquiridoNoBrasil(), true);
        this.resetAlienacao(this.bemMovel.isAdquiridoNoBrasil());
        this.getCalculoImposto().resetCalculoImposto();
        this.getConsolidacao().resetConsolidacao();
        this.getColecaoParcelaAlienacao().clear();
        if (this.bemMovel.isAdquiridoNoBrasil()) {
            this.recalcularImpostoBrasil();
        } else {
            this.recalcularImpostoExterior();
        }
    }

    public void recalcularImpostoBrasil() {
        this.getCalculoImposto().getGanhoCapitalTotal().forcaDisparoObservadores();
        if (this.isAlienacaoAPrazo()) {
            for (ParcelaAlienacao parcela : this.getColecaoParcelaAlienacao().itens()) {
                parcela.getValorRecebido().forcaDisparoObservadores();
            }
        }
    }

    public void recalcularImpostoExterior() {
        if (this.isAlienacaoAPrazo()) {
            for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
                parcela.getValorRecebidoDolar().forcaDisparoObservadores();
            }
        } else {
            this.getApuracao().getGanhoCapital1OrigemNacionalReal().forcaDisparoObservadores();
            this.getApuracao().getGanhoCapital1OrigemMEReal().forcaDisparoObservadores();
        }
    }

    private void alterarOrigemRendimentos(String valorAntigo, String valorNovo) {
        if (this.getBemMovel().getAquisicao().isOrigemRendimentosValida(valorAntigo) && !valorAntigo.equals(valorNovo)) {
            this.getColecaoParcelaAlienacao().clear();
            this.getApuracaoFinal().clear();
        }
        this.getBemMovel().getAquisicao().resetAquisicao(this.bemMovel.isAdquiridoNoBrasil(), false);
        if (this.bemMovel.isAdquiridoNoBrasil()) {
            this.recalcularImpostoBrasil();
        } else {
            this.recalcularImpostoExterior();
        }
    }

    @Override
    public Aquisicao getAquisicao() {
        return this.getBemMovel().getAquisicao();
    }

    @Override
    public ApuracaoBemMovel getApuracao() {
        return this.apuracao;
    }

    @Override
    public ApuracaoBemMovel getApuracaoFinal() {
        return this.apuracaoFinal;
    }

    @Override
    public Codigo obterCodigoOrigemRendimentos() {
        return this.getBemMovel().getAquisicao().getOrigemRendimentos();
    }

    public void limparCalculoImposto() {
        this.getCalculoImposto().getImpostoPago().clear();
        this.getValorLiquidoRecebidoAnosAnteriores().clear();
        this.getColecaoParcelaAlienacao().itens().clear();
    }

    @Override
    public boolean isAlienacaoBrasil() {
        return this.getBemMovel().isAdquiridoNoBrasil();
    }

    public boolean isVazio() {
        return this.getBemMovel().getBemAdquiridoNoBrasil().isVazio();
    }

    @Override
    public void calcularParcelasExterior() {
        String origemRendimentos;
        if (GcapUtil.getEstadoSistema() == 0 && !this.podeResponderPerguntaBemIsentoPorPequenoValor()) {
            this.getBemGrandeValor().clear();
        }
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado())) {
            this.calcularParcelasOrigemNacional();
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
            this.calcularParcelasOrigemEstrangeira();
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
            this.calcularParcelasOrigemAmbas();
        }
    }

    @Override
    public void calcularParcelasOrigemNacional() {
        ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 6);
        ValorPositivo saldoCustoAquisicaoProporcionalMNReal = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMNReal", 11, 9);
        saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getAquisicao().getCustoAquisicaoOrigemNacionalReal());
        Iterator itParcelas = this.getColecaoParcelaAlienacao().itens().iterator();
        while (itParcelas.hasNext()) {
            ValorPositivo valorRecebidoReal = new ValorPositivo(null, "valorRecebidoReal", 11, 9);
            ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(null, "valorLiquidoAlienacaoDolar", 11, 2);
            ValorPositivo valorLiquidoAlienacaoReal = new ValorPositivo(null, "valorLiquidoAlienacaoReal", 11, 2);
            ValorPositivo custoAquisicaoProporcionalMNReal = new ValorPositivo(null, "custoAquisicaoProporcionalMNReal", 11, 9);
            ValorPositivo custoAquisicaoProporcionalMNDolar = new ValorPositivo(null, "custoAquisicaoProporcionalMNDolar", 11, 9);
            ValorPositivo ganhoProporcionalReal = new ValorPositivo(null, "ganhoProporcionalReal", 11, 9);
            ValorPositivo impostoDevido = new ValorPositivo(null, "impostoDevido", 11, 9);
            ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)itParcelas.next());
            valorRecebidoReal.setConteudo(parcela.getValorRecebidoDolar());
            valorRecebidoReal.append('*', parcela.getCotacaoDolar());
            parcela.getValorRecebidoReal().setConteudo(valorRecebidoReal);
            valorLiquidoAlienacaoDolar.setConteudo(parcela.getValorRecebidoDolar());
            valorLiquidoAlienacaoDolar.append('-', parcela.getCustoCorretagemDolar());
            parcela.getValorLiquidoAlienacaoDolar().setConteudo(valorLiquidoAlienacaoDolar);
            valorLiquidoAlienacaoReal.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            valorLiquidoAlienacaoReal.append('*', parcela.getCotacaoDolar());
            parcela.getValorLiquidoAlienacaoReal().setConteudo(valorLiquidoAlienacaoReal);
            if (parcela.isUltimaParcela()) {
                custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
            } else {
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar().isVazio()) {
                    custoAquisicaoProporcionalMNDolar.clear();
                } else {
                    custoAquisicaoProporcionalMNDolar.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
                    custoAquisicaoProporcionalMNDolar.append('*', this.getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
                    custoAquisicaoProporcionalMNDolar.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar());
                }
                custoAquisicaoProporcionalMNDolar.converteQtdCasasDecimais(2);
                custoAquisicaoProporcionalMNReal.setConteudo(custoAquisicaoProporcionalMNDolar);
                custoAquisicaoProporcionalMNReal.append('*', this.getAquisicao().getCotacaoDolarDataAquisicao());
                custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                if (parcela.getValorLiquidoAlienacaoReal().comparacao("<", custoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(parcela.getValorLiquidoAlienacaoReal());
                }
                if (custoAquisicaoProporcionalMNReal.comparacao(">", saldoCustoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
                    custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                }
            }
            saldoCustoAquisicaoProporcionalMNReal.append('-', custoAquisicaoProporcionalMNReal);
            parcela.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(custoAquisicaoProporcionalMNReal);
            ganhoProporcionalReal.setConteudo(parcela.getValorLiquidoAlienacaoReal());
            ganhoProporcionalReal.append('-', parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
            parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(ganhoProporcionalReal);
            if (parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().isVazio() || this.isIsento() && !this.isValorOperacaoMaior35K() || Logico.NAO.equals(this.getBemGrandeValorOperacao().naoFormatado()) && this.isValorParcelasMaior35K()) {
                parcela.getAliquotaMedia().clear();
                impostoDevido.clear();
            } else if (this.isPrevisaoPrejuizo() && !parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().isVazio()) {
                parcela.getAliquotaMedia().setConteudo("15,000000");
                impostoDevido.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
                impostoDevido.append('*', "0,150000000");
            } else {
                impostoDevidoTotal.setConteudo(this.getCalculoImposto().calcularImpostoDevidoTotal(this, this.getApuracao().getGanhoCapital1OrigemNacionalReal()));
                parcela.getAliquotaMedia().setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(this.getApuracao().getGanhoCapital1OrigemNacionalReal(), impostoDevidoTotal));
                if (this.getApuracao().getGanhoCapital1OrigemNacionalReal().isVazio()) {
                    impostoDevido.clear();
                } else {
                    impostoDevido.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
                    impostoDevido.append('*', impostoDevidoTotal);
                    impostoDevido.append('/', this.getApuracao().getGanhoCapital1OrigemNacionalReal());
                }
            }
            if (impostoDevido.isVazio()) {
                parcela.getAliquotaMedia().clear();
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            this.calcularApuracaoFinalOrigemNacional();
            if (!parcela.isUltimaParcela()) continue;
            this.calcularAjuste();
            this.calcularUltimaParcelaExterior(parcela);
            break;
        }
        if (this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            this.calcularApuracaoFinalOrigemNacional();
        }
        this.limparAjusteAlienacaoSemUltimaParcela();
    }

    @Override
    public void calcularParcelasOrigemEstrangeira() {
        ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 6);
        ValorPositivo saldoCustoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMEDolar", 11, 9);
        saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getApuracao().getCustoAquisicaoOrigemMEDolar());
        Iterator itParcelas = this.getColecaoParcelaAlienacao().itens().iterator();
        while (itParcelas.hasNext()) {
            ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(null, "valorLiquidoAlienacaoDolar", 11, 2);
            ValorPositivo custoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "custoAquisicaoProporcionalMEDolar", 11, 9);
            ValorPositivo ganhoProporcionalReal = new ValorPositivo(null, "ganhoProporcionalReal", 11, 9);
            ValorPositivo ganhoProporcionalDolar = new ValorPositivo(null, "ganhoProporcionalDolar", 11, 9);
            ValorPositivo impostoDevido = new ValorPositivo(null, "impostoDevido", 11, 9);
            ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)itParcelas.next());
            valorLiquidoAlienacaoDolar.setConteudo(parcela.getValorRecebidoDolar());
            valorLiquidoAlienacaoDolar.append('-', parcela.getCustoCorretagemDolar());
            parcela.getValorLiquidoAlienacaoDolar().setConteudo(valorLiquidoAlienacaoDolar);
            if (parcela.isUltimaParcela()) {
                custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
            } else {
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar().isVazio()) {
                    custoAquisicaoProporcionalMEDolar.clear();
                } else {
                    custoAquisicaoProporcionalMEDolar.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
                    custoAquisicaoProporcionalMEDolar.append('*', this.getApuracao().getCustoAquisicaoOrigemMEDolar());
                    custoAquisicaoProporcionalMEDolar.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar());
                }
                custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                if (parcela.getValorLiquidoAlienacaoDolar().comparacao("<", custoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
                }
                if (custoAquisicaoProporcionalMEDolar.comparacao(">", saldoCustoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
                    custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                }
            }
            saldoCustoAquisicaoProporcionalMEDolar.append('-', custoAquisicaoProporcionalMEDolar);
            parcela.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(custoAquisicaoProporcionalMEDolar);
            ganhoProporcionalDolar.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            ganhoProporcionalDolar.append('-', parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
            parcela.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(ganhoProporcionalDolar);
            ganhoProporcionalReal.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
            ganhoProporcionalReal.append('*', parcela.getCotacaoDolar());
            parcela.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(ganhoProporcionalReal);
            if (parcela.getGanhoCapital1ProporcionalOrigemMEReal().isVazio() || this.isIsento() && !this.isValorOperacaoMaior35K() || Logico.NAO.equals(this.getBemGrandeValorOperacao().naoFormatado()) && this.isValorParcelasMaior35K()) {
                parcela.getAliquotaMedia().clear();
                impostoDevido.clear();
            } else if (this.isPrevisaoPrejuizo() && !parcela.getGanhoCapital1ProporcionalOrigemMEReal().isVazio()) {
                parcela.getAliquotaMedia().setConteudo("15,000000");
                impostoDevido.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEReal());
                impostoDevido.append('*', "0,150000000");
            } else {
                impostoDevidoTotal.setConteudo(this.getCalculoImposto().calcularImpostoDevidoTotal(this, this.getApuracao().getGanhoCapital1OrigemMEReal()));
                parcela.getAliquotaMedia().setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(this.getApuracao().getGanhoCapital1OrigemMEReal(), impostoDevidoTotal));
                if (this.getApuracao().getGanhoCapital1OrigemMEReal().isVazio()) {
                    impostoDevido.clear();
                } else {
                    impostoDevido.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEReal());
                    impostoDevido.append('*', impostoDevidoTotal);
                    impostoDevido.append('/', this.getApuracao().getGanhoCapital1OrigemMEReal());
                }
            }
            if (impostoDevido.isVazio()) {
                parcela.getAliquotaMedia().clear();
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            this.calcularApuracaoFinalOrigemME();
            if (!parcela.isUltimaParcela()) continue;
            this.calcularAjuste();
            this.calcularUltimaParcelaExterior(parcela);
            break;
        }
        if (this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            this.calcularApuracaoFinalOrigemME();
        }
        this.limparAjusteAlienacaoSemUltimaParcela();
    }

    @Override
    public void calcularParcelasOrigemAmbas() {
        ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 6);
        ValorPositivo saldoCustoAquisicaoProporcionalMNReal = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMNReal", 11, 9);
        saldoCustoAquisicaoProporcionalMNReal.setConteudo(this.getAquisicao().getCustoAquisicaoOrigemNacionalReal());
        ValorPositivo saldoCustoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "saldoCustoAquisicaoProporcionalMEDolar", 11, 9);
        saldoCustoAquisicaoProporcionalMEDolar.setConteudo(this.getApuracao().getCustoAquisicaoOrigemMEDolar());
        for (ParcelaAlienacaoBem parcela : this.getColecaoParcelaAlienacao().itens()) {
            ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(null, "valorLiquidoAlienacaoDolar", 11, 9);
            ValorPositivo valorLiquidoAlienacaoDolarMN = new ValorPositivo(null, "valorLiquidoAlienacaoDolarMN", 11, 9);
            ValorPositivo valorLiquidoAlienacaoDolarME = new ValorPositivo(null, "valorLiquidoAlienacaoDolarME", 11, 9);
            ValorPositivo valorLiquidoAlienacaoRealMN = new ValorPositivo(null, "valorLiquidoAlienacaoRealMN", 11, 9);
            ValorPositivo custoAquisicaoProporcionalMNReal = new ValorPositivo(null, "custoAquisicaoProporcionalMNReal", 11, 9);
            ValorPositivo custoAquisicaoProporcionalMNDolar = new ValorPositivo(null, "custoAquisicaoProporcionalMNDolar", 11, 9);
            ValorPositivo custoAquisicaoProporcionalMEDolar = new ValorPositivo(null, "custoAquisicaoProporcionalMEDolar", 11, 9);
            ValorPositivo ganhoProporcionalReal = new ValorPositivo(null, "ganhoProporcionalReal", 11, 9);
            ValorPositivo ganhoProporcionalRealMN = new ValorPositivo(null, "ganhoProporcionalRealMN", 11, 9);
            ValorPositivo ganhoProporcionalDolarME = new ValorPositivo(null, "ganhoProporcionalDolarME", 11, 9);
            ValorPositivo ganhoProporcionalRealME = new ValorPositivo(null, "ganhoProporcionalRealME", 11, 9);
            ValorPositivo impostoDevido = new ValorPositivo(null, "impostoDevido", 11, 9);
            valorLiquidoAlienacaoDolar.setConteudo(parcela.getValorRecebidoDolar());
            valorLiquidoAlienacaoDolar.append('-', parcela.getCustoCorretagemDolar());
            valorLiquidoAlienacaoDolarMN.setConteudo(this.getAquisicao().getPercentualCustoAquisicaoOrigemNacional());
            valorLiquidoAlienacaoDolarMN.append('/', "100,000000000");
            valorLiquidoAlienacaoDolarMN.append('*', valorLiquidoAlienacaoDolar);
            valorLiquidoAlienacaoDolarMN.converteQtdCasasDecimais(2);
            valorLiquidoAlienacaoDolarME.setConteudo(valorLiquidoAlienacaoDolar);
            valorLiquidoAlienacaoDolarME.append('-', valorLiquidoAlienacaoDolarMN);
            valorLiquidoAlienacaoRealMN.setConteudo(valorLiquidoAlienacaoDolarMN);
            valorLiquidoAlienacaoRealMN.append('*', parcela.getCotacaoDolar());
            parcela.getValorLiquidoAlienacaoDolar().setConteudo(valorLiquidoAlienacaoDolar);
            parcela.getValorAlienacaoOrigemNacionalDolar().setConteudo(valorLiquidoAlienacaoDolarMN);
            parcela.getValorAlienacaoOrigemMEDolar().setConteudo(valorLiquidoAlienacaoDolarME);
            parcela.getValorAlienacaoOrigemNacionalReal().setConteudo(valorLiquidoAlienacaoRealMN);
            if (parcela.isUltimaParcela()) {
                custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
            } else {
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar().isVazio()) {
                    custoAquisicaoProporcionalMNDolar.clear();
                } else {
                    custoAquisicaoProporcionalMNDolar.setConteudo(parcela.getValorAlienacaoOrigemNacionalDolar());
                    custoAquisicaoProporcionalMNDolar.append('*', this.getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
                    custoAquisicaoProporcionalMNDolar.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemNacionalDolar());
                }
                custoAquisicaoProporcionalMNDolar.converteQtdCasasDecimais(2);
                custoAquisicaoProporcionalMNReal.setConteudo(custoAquisicaoProporcionalMNDolar);
                custoAquisicaoProporcionalMNReal.append('*', this.getAquisicao().getCotacaoDolarDataAquisicao());
                custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                if (valorLiquidoAlienacaoRealMN.comparacao("<", custoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(valorLiquidoAlienacaoRealMN);
                }
                if (custoAquisicaoProporcionalMNReal.comparacao(">", saldoCustoAquisicaoProporcionalMNReal)) {
                    custoAquisicaoProporcionalMNReal.setConteudo(saldoCustoAquisicaoProporcionalMNReal);
                    custoAquisicaoProporcionalMNReal.converteQtdCasasDecimais(2);
                }
            }
            saldoCustoAquisicaoProporcionalMNReal.append('-', custoAquisicaoProporcionalMNReal);
            parcela.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(custoAquisicaoProporcionalMNReal);
            ganhoProporcionalRealMN.setConteudo(parcela.getValorAlienacaoOrigemNacionalReal());
            ganhoProporcionalRealMN.append('-', parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
            parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(ganhoProporcionalRealMN);
            if (parcela.isUltimaParcela()) {
                custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
            } else {
                if (this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar().isVazio()) {
                    custoAquisicaoProporcionalMEDolar.clear();
                } else {
                    custoAquisicaoProporcionalMEDolar.setConteudo(parcela.getValorAlienacaoOrigemMEDolar());
                    custoAquisicaoProporcionalMEDolar.append('*', this.getApuracao().getCustoAquisicaoOrigemMEDolar());
                    custoAquisicaoProporcionalMEDolar.append('/', this.getApuracao().getValorLiquidoAlienacaoOrigemMEDolar());
                    custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                }
                if (valorLiquidoAlienacaoDolarME.comparacao("<", custoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(valorLiquidoAlienacaoDolarME);
                }
                if (custoAquisicaoProporcionalMEDolar.comparacao(">", saldoCustoAquisicaoProporcionalMEDolar)) {
                    custoAquisicaoProporcionalMEDolar.setConteudo(saldoCustoAquisicaoProporcionalMEDolar);
                    custoAquisicaoProporcionalMEDolar.converteQtdCasasDecimais(2);
                }
            }
            saldoCustoAquisicaoProporcionalMEDolar.append('-', custoAquisicaoProporcionalMEDolar);
            parcela.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(custoAquisicaoProporcionalMEDolar);
            ganhoProporcionalDolarME.setConteudo(parcela.getValorAlienacaoOrigemMEDolar());
            ganhoProporcionalDolarME.append('-', parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
            parcela.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(ganhoProporcionalDolarME);
            ganhoProporcionalRealME.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
            ganhoProporcionalRealME.append('*', parcela.getCotacaoDolar());
            parcela.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(ganhoProporcionalRealME);
            ganhoProporcionalReal.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
            ganhoProporcionalReal.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
            if (ganhoProporcionalReal.isVazio() || this.isIsento() && !this.isValorOperacaoMaior35K() || Logico.NAO.equals(this.getBemGrandeValorOperacao().naoFormatado()) && this.isValorParcelasMaior35K()) {
                parcela.getAliquotaMedia().clear();
                impostoDevido.clear();
            } else if (this.isPrevisaoPrejuizo() && !ganhoProporcionalReal.isVazio()) {
                parcela.getAliquotaMedia().setConteudo("15,000000");
                impostoDevido.setConteudo(ganhoProporcionalReal);
                impostoDevido.append('*', "0,150000000");
            } else {
                ValorPositivo ganhoCapital1Total = new ValorPositivo();
                ganhoCapital1Total.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', this.getApuracao().getGanhoCapital1OrigemMEReal()));
                impostoDevidoTotal.setConteudo(this.getCalculoImposto().calcularImpostoDevidoTotal(this, ganhoCapital1Total));
                parcela.getAliquotaMedia().setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(ganhoCapital1Total, impostoDevidoTotal));
                if (ganhoCapital1Total.isVazio()) {
                    impostoDevido.clear();
                } else {
                    impostoDevido.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
                    impostoDevido.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
                    impostoDevido.append('*', impostoDevidoTotal);
                    impostoDevido.append('/', ganhoCapital1Total);
                }
            }
            if (impostoDevido.isVazio()) {
                parcela.getAliquotaMedia().clear();
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            this.calcularApuracaoFinalOrigemAmbas();
            if (!parcela.isUltimaParcela()) continue;
            this.calcularAjuste();
            this.calcularUltimaParcelaExterior(parcela);
            break;
        }
        if (this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            this.calcularApuracaoFinalOrigemAmbas();
        }
        this.limparAjusteAlienacaoSemUltimaParcela();
    }

    @Override
    public void calcularApuracaoFinalOrigemNacional() {
        this.getApuracaoFinal().getValorAlienacaoOrigemNacionalDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        this.getApuracaoFinal().getCustoCorretagemOrigemNacionalDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal());
        this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal());
        if (this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal().comparacao("<=", this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal())) {
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().clear();
        } else {
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal());
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().append('-', this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal());
        }
    }

    @Override
    public void calcularApuracaoFinalOrigemME() {
        this.getApuracaoFinal().getValorAlienacaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        this.getApuracaoFinal().getCustoCorretagemOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal());
        this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal());
        if (this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar().comparacao("<=", this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar())) {
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().clear();
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().clear();
        } else {
            ValorPositivo ganhoCapitalDolar = new ValorPositivo(null, "ganhoCapitalDolar", 11, 2);
            ganhoCapitalDolar.setConteudo(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar());
            ganhoCapitalDolar.append('-', this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar());
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().setConteudo(ganhoCapitalDolar);
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().setConteudo(this.calcularGanhoCapitalMEReais(false));
        }
    }

    @Override
    public void calcularApuracaoFinalOrigemAmbas() {
        ValorPositivo valorRecebidoDolarTotalMN = new ValorPositivo(null, "valorRecebidoDolarTotalMN", 11, 9);
        ValorPositivo valorRecebidoDolarTotalME = new ValorPositivo(null, "valorRecebidoDolarTotalME", 11, 9);
        ValorPositivo custoCorretagemDolarTotalMN = new ValorPositivo(null, "custoCorretagemDolarTotalMN", 11, 9);
        ValorPositivo custoCorretagemDolarTotalME = new ValorPositivo(null, "custoCorretagemDolarTotalME", 11, 9);
        ValorPositivo valorLiquidoDolarTotalMN = new ValorPositivo(null, "valorLiquidoDolarTotalMN", 11, 9);
        ValorPositivo valorLiquidoDolarTotalME = new ValorPositivo(null, "valorLiquidoDolarTotalME", 11, 9);
        ValorPositivo valorLiquidoAlienacaoRealTotalMN = new ValorPositivo(null, "valorLiquidoAlienacaoRealTotalMN", 11, 9);
        ValorPositivo ganhoCapitalRealMN = new ValorPositivo(null, "ganhoCapitalReaisMN", 11, 2);
        ValorPositivo ganhoCapitalDolarME = new ValorPositivo(null, "ganhoCapitalDolarME", 11, 2);
        valorRecebidoDolarTotalMN.setConteudo(this.getAquisicao().getPercentualCustoAquisicaoOrigemNacional());
        valorRecebidoDolarTotalMN.append('/', "100,000000000");
        valorRecebidoDolarTotalMN.append('*', this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        valorRecebidoDolarTotalMN.converteQtdCasasDecimais(2);
        valorRecebidoDolarTotalME.setConteudo(this.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
        valorRecebidoDolarTotalME.append('-', valorRecebidoDolarTotalMN);
        this.getApuracaoFinal().getValorAlienacaoOrigemNacionalDolar().setConteudo(valorRecebidoDolarTotalMN);
        this.getApuracaoFinal().getValorAlienacaoOrigemMEDolar().setConteudo(valorRecebidoDolarTotalME);
        custoCorretagemDolarTotalMN.setConteudo(this.getAquisicao().getPercentualCustoAquisicaoOrigemNacional());
        custoCorretagemDolarTotalMN.append('/', "100,000000000");
        custoCorretagemDolarTotalMN.append('*', this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        custoCorretagemDolarTotalMN.converteQtdCasasDecimais(2);
        custoCorretagemDolarTotalME.setConteudo(this.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
        custoCorretagemDolarTotalME.append('-', custoCorretagemDolarTotalMN);
        this.getApuracaoFinal().getCustoCorretagemOrigemNacionalDolar().setConteudo(custoCorretagemDolarTotalMN);
        this.getApuracaoFinal().getCustoCorretagemOrigemMEDolar().setConteudo(custoCorretagemDolarTotalME);
        valorLiquidoDolarTotalMN.setConteudo(valorRecebidoDolarTotalMN);
        valorLiquidoDolarTotalMN.append('-', custoCorretagemDolarTotalMN);
        valorLiquidoDolarTotalME.setConteudo(valorRecebidoDolarTotalME);
        valorLiquidoDolarTotalME.append('-', custoCorretagemDolarTotalME);
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalDolar().setConteudo(valorLiquidoDolarTotalMN);
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar().setConteudo(valorLiquidoDolarTotalME);
        valorLiquidoAlienacaoRealTotalMN.setConteudo(this.getColecaoParcelaAlienacao().obterValorLiquidoOrigemNacionalReal());
        this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal().setConteudo(valorLiquidoAlienacaoRealTotalMN);
        this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal());
        this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar().setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal());
        if (valorLiquidoAlienacaoRealTotalMN.comparacao("<=", this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal())) {
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().clear();
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().clear();
            this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().clear();
        } else {
            ganhoCapitalRealMN.setConteudo(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemNacionalReal());
            ganhoCapitalRealMN.append('-', this.getApuracaoFinal().getCustoAquisicaoOrigemNacionalReal());
            this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal().setConteudo(ganhoCapitalRealMN);
            ganhoCapitalDolarME.setConteudo(this.getApuracaoFinal().getValorLiquidoAlienacaoOrigemMEDolar());
            ganhoCapitalDolarME.append('-', this.getApuracaoFinal().getCustoAquisicaoOrigemMEDolar());
            this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().setConteudo(ganhoCapitalDolarME);
            if (ganhoCapitalDolarME.isVazio()) {
                this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().clear();
            } else {
                this.getApuracaoFinal().getGanhoCapital1OrigemMEReal().setConteudo(this.calcularGanhoCapitalMEReais(false));
            }
        }
    }

    @Override
    public void calcularAjuste() {
        if (this.getColecaoParcelaAlienacao().getDataRecebimentoUltimaParcela().isVazio()) {
            this.getAjuste().clear();
        } else {
            ValorPositivo ganhoCapitalTotal = new ValorPositivo(null, "ganhoCapitalTotal", 11, 9);
            ValorPositivo ganhoCapitalAnterior = new ValorPositivo(null, "ganhoCapitalAnterior", 11, 9);
            ValorPositivo ganhoCapitalTotalMaisAnterior = new ValorPositivo(null, "ganhoCapitalTotalMaisAnterior", 11, 9);
            ValorPositivo impostoDevidoTotalMaisAnterior = new ValorPositivo(null, "impostoDevidoTotal", 11, 9);
            ValorPositivo impostoDevidoAnterior = new ValorPositivo(null, "impostoDevidoAnterior", 11, 9);
            ValorPositivo aliquotaMedia = new ValorPositivo(null, "aliquotaMedia", 11, 9);
            ValorPositivo impostoDevidoTotal = new ValorPositivo(null, "impostoDevidoTotal", 11, 9);
            ValorPositivo impostoDevido2Total = new ValorPositivo(null, "impostoDevido2Total", 11, 2);
            ValorPositivo impostoDevidoParcelasAnteriores = new ValorPositivo(null, "impostoDevidoParcelasAnteriores", 11, 9);
            ValorPositivo saldoImpostoDevido = new ValorPositivo(null, "saldoImpostoDevido", 11, 9);
            ValorPositivo impostoDevidoNoBrasilParcelasAnteriores = new ValorPositivo(null, "impostoDevidoNoBrasilParcelasAnteriores", 11, 9);
            ValorPositivo saldoImpostoDevidoNoBrasil = new ValorPositivo(null, "saldoImpostoDevidoNoBrasil", 11, 9);
            ganhoCapitalTotal.setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
            ganhoCapitalTotal.append('+', this.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
            if (ganhoCapitalTotal.isVazio()) {
                this.getAjuste().clear();
            } else {
                ganhoCapitalAnterior.setConteudo(this.getGanhoCapitalAlienacaoAnterior());
                ganhoCapitalTotalMaisAnterior.setConteudo(ganhoCapitalTotal);
                ganhoCapitalTotalMaisAnterior.append('+', ganhoCapitalAnterior);
                if (this.isIsento()) {
                    impostoDevidoTotal.clear();
                    impostoDevidoParcelasAnteriores.clear();
                    saldoImpostoDevido.clear();
                    aliquotaMedia.clear();
                } else {
                    String aliquotaFixa = this.obterAliquotaFixa();
                    if (aliquotaFixa != null) {
                        impostoDevidoTotalMaisAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(ganhoCapitalTotalMaisAnterior, aliquotaFixa);
                        impostoDevidoAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(ganhoCapitalAnterior, aliquotaFixa);
                    } else {
                        impostoDevidoTotalMaisAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevido(ganhoCapitalTotalMaisAnterior, this.getDataAlienacao());
                        impostoDevidoAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevido(ganhoCapitalAnterior, this.getDataAlienacao());
                    }
                    impostoDevidoTotal.setConteudo(impostoDevidoTotalMaisAnterior);
                    impostoDevidoTotal.append('-', impostoDevidoAnterior);
                    impostoDevido2Total.setConteudo(impostoDevidoTotal);
                    impostoDevido2Total.append('-', this.getColecaoParcelaAlienacao().obterImpostoPagoExterior());
                    impostoDevidoParcelasAnteriores.setConteudo(this.getColecaoParcelaAlienacao().obterImpostoDevidoSemUltimaParcela());
                    saldoImpostoDevido.setConteudo(impostoDevidoTotal);
                    saldoImpostoDevido.append('-', impostoDevidoParcelasAnteriores);
                    impostoDevidoNoBrasilParcelasAnteriores.setConteudo(this.getColecaoParcelaAlienacao().obterImpostoDevidoNoBrasilSemUltimaParcela());
                    if (impostoDevidoNoBrasilParcelasAnteriores.comparacao(">", impostoDevido2Total)) {
                        impostoDevidoNoBrasilParcelasAnteriores.setConteudo(impostoDevido2Total);
                        saldoImpostoDevido.clear();
                    }
                    saldoImpostoDevidoNoBrasil.setConteudo(impostoDevido2Total);
                    saldoImpostoDevidoNoBrasil.append('-', impostoDevidoNoBrasilParcelasAnteriores);
                    aliquotaMedia.setConteudo(impostoDevidoTotal);
                    aliquotaMedia.append('*', "100,000000000");
                    aliquotaMedia.append('/', ganhoCapitalTotal);
                }
                if (aliquotaMedia.comparacao("<", "15,00") && aliquotaMedia.comparacao(">", "14,990000")) {
                    aliquotaMedia.setConteudo("15,000000");
                }
                this.getAjuste().getGanhoCapitalTotal().setConteudo(ganhoCapitalTotal);
                this.getAjuste().getAliquotaMedia().setConteudo(aliquotaMedia);
                this.getAjuste().getImpostoDevido().setConteudo(impostoDevidoTotal);
                this.getAjuste().getImpostoPagoExterior().setConteudo(this.getColecaoParcelaAlienacao().obterImpostoPagoExterior());
                this.getAjuste().getImpostoDevidoNoBrasilRelativoParcelasAnteriores().setConteudo(impostoDevidoNoBrasilParcelasAnteriores);
                this.getAjuste().getSaldoImpostoDevidoNoBrasil().setConteudo(saldoImpostoDevidoNoBrasil);
                this.getAjuste().getImpostoDevido2().setConteudo(impostoDevido2Total);
                this.getAjuste().getImpostoDevidoRelativoParcelasAnteriores().setConteudo(impostoDevidoParcelasAnteriores);
                this.getAjuste().getSaldoImpostoDevido().setConteudo(saldoImpostoDevido);
                this.getAjuste().getImpostoPago().setConteudo(this.getColecaoParcelaAlienacao().getImpostoPagoTotal());
            }
        }
    }

    @Override
    public void ajustarFlagCobranca() {
        ParcelaAlienacao ultimaParcela;
        this.getInCobranca().setConteudo(Logico.SIM);
        if (!this.isAlienacaoBrasil() && !this.isAlienacaoAVista() && (ultimaParcela = this.getColecaoParcelaAlienacao().obterUltimaParcela()) != null && ultimaParcela.getDataRecebimento().naoFormatado().length() == 8 && this.getDataAlienacao().naoFormatado().length() == 8 && this.getDataAlienacao().getAno().equals(ultimaParcela.getDataRecebimento().getAno())) {
            ValorPositivo valorTributavelOperacao = new ValorPositivo();
            valorTributavelOperacao.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal());
            valorTributavelOperacao.append('+', this.getApuracao().getGanhoCapital1OrigemMEReal());
            if (valorTributavelOperacao.comparacao(">", "0,00") && this.getAjuste().getImpostoDevido().isVazio()) {
                this.getInCobranca().setConteudo(Logico.NAO);
            }
        }
    }

    @Override
    public void calcularUltimaParcelaExterior(ParcelaAlienacaoBem parcela) {
        if (parcela != null) {
            ValorPositivo lImpostoDevido = new ValorPositivo(null, "lImpostoDevido", 11, 9);
            ValorPositivo lAliquotaMedia = new ValorPositivo(null, "lAliquotaMedia", 11, 9);
            ValorPositivo ganhoCapital = new ValorPositivo(null, "ganhoCapital", 11, 2);
            String origemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(parcela.getGanhoCapital1ProporcionalTotalReal());
            }
            lImpostoDevido.setConteudo(this.getAjuste().getSaldoImpostoDevido());
            if (!ganhoCapital.isVazio()) {
                lAliquotaMedia.setConteudo(lImpostoDevido);
                lAliquotaMedia.append('*', "100,000000000");
                lAliquotaMedia.append('/', ganhoCapital);
                if (lAliquotaMedia.comparacao("<", "15,00") && lAliquotaMedia.comparacao(">", "14,990000")) {
                    lAliquotaMedia.setConteudo("15,000000");
                }
            }
            parcela.getImpostoDevido().setConteudo(lImpostoDevido);
            parcela.getAliquotaMedia().setConteudo(lAliquotaMedia);
        }
    }

    public String getClasseFicha() {
        return PainelListaBemMovel.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public boolean isAlienacaoComLucroReduzido() {
        ParcelaAlienacaoBem ultimaParcela;
        boolean retorno = false;
        if (!this.isAlienacaoBrasil() && this.isAlienacaoAPrazo() && (ultimaParcela = (ParcelaAlienacaoBem)this.getColecaoParcelaAlienacao().obterUltimaParcela()) != null) {
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ValorPositivo custoAquisicaoUltimaParcela = new ValorPositivo();
                custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemNacionalReal().naoFormatado());
                if (ultimaParcela.getValorLiquidoAlienacaoReal().comparacao("<", custoAquisicaoUltimaParcela)) {
                    retorno = true;
                }
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ValorPositivo custoAquisicaoUltimaParcela = new ValorPositivo();
                custoAquisicaoUltimaParcela.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemMEDolar().naoFormatado());
                if (ultimaParcela.getValorLiquidoAlienacaoDolar().comparacao("<", custoAquisicaoUltimaParcela)) {
                    retorno = true;
                }
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ValorPositivo custoAquisicaoUltimaParcelaMN = new ValorPositivo();
                ValorPositivo custoAquisicaoUltimaParcelaME = new ValorPositivo();
                custoAquisicaoUltimaParcelaMN.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemNacionalReal().naoFormatado());
                custoAquisicaoUltimaParcelaME.setConteudo(ultimaParcela.getCustoAquisicaoProporcionalOrigemMEDolar().naoFormatado());
                if (ultimaParcela.getValorAlienacaoOrigemNacionalReal().comparacao("<", custoAquisicaoUltimaParcelaMN) || ultimaParcela.getValorAlienacaoOrigemMEDolar().comparacao("<", custoAquisicaoUltimaParcelaME)) {
                    retorno = true;
                }
            }
        }
        return retorno;
    }

    public boolean isAlienacaoComImpostoARestituir() {
        boolean retorno = false;
        if (!this.isAlienacaoBrasil() && !this.getDataRecebimentoUltimaParcela().isVazio()) {
            String strOrigemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado();
            ValorPositivo liquidoRecebido = new ValorPositivo();
            ValorPositivo custoAquisicao = new ValorPositivo();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(strOrigemRendimentos)) {
                liquidoRecebido.setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal());
                custoAquisicao.setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(strOrigemRendimentos)) {
                liquidoRecebido.setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal());
                custoAquisicao.setConteudo(this.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal());
            }
            if (custoAquisicao.comparacao(">", liquidoRecebido)) {
                retorno = true;
            }
        }
        return retorno;
    }

    public boolean podePreencherCalculo() {
        boolean retorno = true;
        if (this.getAlienacaoAPrazo().isVazio() || this.getNatureza().isVazio() || !this.isAlienacaoBrasil() && this.getAquisicao().getOrigemRendimentos().isVazio()) {
            retorno = false;
        }
        return retorno;
    }

    @Override
    public boolean podeResponderPerguntaBemIsentoPorPequenoValor() {
        boolean retorno = false;
        if (!String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA).equals(this.getNatureza().naoFormatado()) && !String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO).equals(this.getNatureza().naoFormatado())) {
            boolean residenteNoBrasil = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
            ValorPositivo valorAlienacaoReal = new ValorPositivo();
            if (this.getBemMovel().isAdquiridoNoBrasil()) {
                valorAlienacaoReal.setConteudo(this.getValorAlienacao());
            } else if (this.getColecaoParcelaAlienacao().obterUltimaParcela() == null) {
                valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            } else {
                for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                    ValorPositivo somaParcela = new ValorPositivo();
                    somaParcela.setConteudo(p.getValorRecebidoDolar());
                    somaParcela.append('*', p.getCotacaoDolar());
                    valorAlienacaoReal.append('+', somaParcela);
                }
            }
            if (residenteNoBrasil && valorAlienacaoReal.comparacao("<=", this.getValorIsencaoAsString()) && this.getPaisResidencia().naoFormatado().equals("105")) {
                retorno = true;
                this.getBemGrandeValorOperacao().setConteudo(this.getBemGrandeValor());
            }
        }
        return retorno;
    }

    public boolean podeResponderPerguntaPequenoValorNoExteriorPorParcelas() {
        boolean retorno = false;
        boolean residenteNoBrasil = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.getBemMovel().isAdquiridoNoExterior()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            if (valorAlienacaoReal.comparacao(">", this.getValorIsencaoAsString()) && !this.getDataRecebimentoUltimaParcela().isVazio()) {
                valorAlienacaoReal.clear();
                for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                    ValorPositivo somaParcela = new ValorPositivo();
                    somaParcela.setConteudo(p.getValorRecebidoDolar());
                    somaParcela.append('*', p.getCotacaoDolar());
                    valorAlienacaoReal.append('+', somaParcela);
                }
                if (residenteNoBrasil && valorAlienacaoReal.comparacao("<=", this.getValorIsencaoAsString()) && this.getDataAlienacao().naoFormatado().length() == 8 && AplicacaoPropertiesUtil.getExercicio().equals(this.getDataAlienacao().getAno())) {
                    retorno = true;
                }
            }
        }
        return retorno;
    }

    public int obterEnquadramentoInicial() {
        int retorno = REDUCAO_AUSENTE;
        if (!this.isValorOperacaoMaior35K() && (Logico.NAO.equals(this.getBemGrandeValor().formatado()) || Logico.NAO.equals(this.getBemGrandeValorOperacao().formatado()))) {
            retorno = REDUCAO_IMOVEL_PEQUENO_VALOR;
        }
        return retorno;
    }

    public int obterEnquadramentoFinal() {
        int retorno = REDUCAO_AUSENTE;
        if (!this.isValorParcelasMaior35K() && Logico.NAO.equals(this.getBemGrandeValor().formatado())) {
            retorno = REDUCAO_IMOVEL_PEQUENO_VALOR;
        }
        return retorno;
    }

    public String obterMensagemMudancaEnquadramento() {
        String mensagem = null;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        int enquadramentoFinal = this.obterEnquadramentoFinal();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && enquadramentoInicial != enquadramentoFinal) {
            if (enquadramentoInicial == AlienacaoBemImovel.REDUCAO_AUSENTE) {
                if (enquadramentoFinal == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                }
            } else if (enquadramentoInicial == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR && enquadramentoFinal == AlienacaoBemImovel.REDUCAO_AUSENTE) {
                mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
            }
        }
        return mensagem;
    }

    @Override
    public boolean isAdquirenteRequerido() {
        boolean requerido = super.isAdquirenteRequerido();
        if (requerido && !this.isAlienacaoBrasil() && (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA).equals(this.getNatureza().naoFormatado()) || String.valueOf(AlienacaoBem.CODIGO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES).equals(this.getNatureza().naoFormatado()) || String.valueOf(AlienacaoBem.CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA).equals(this.getNatureza().naoFormatado()))) {
            requerido = false;
        }
        return requerido;
    }

    protected List<Informacao> recuperarListaCamposPendenciaAbaOperacao() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getNatureza());
        lista.add(this.getAlienacaoAPrazo());
        lista.add(this.getCotacaoDolarDataAlienacao());
        lista.add(this.getDataAlienacao());
        lista.add(this.getDataTransitoJulgado());
        lista.add(this.getValorAlienacao());
        lista.add(this.getValorAlienacaoDolar());
        lista.add(this.getCustoCorretagem());
        lista.add(this.getValorCorretagemDolar());
        lista.add(this.getAlienacaoParcial());
        lista.add(this.getGanhoCapitalAlienacaoAnterior());
        lista.add(this.getBemGrandeValor());
        lista.add(this.getPaisAcordo());
        lista.add(this.getValorImpostoExteriorReal());
        return lista;
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaCalculo() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getValorRecebidoAnosAnteriores());
        lista.add(this.getCorretagemAnosAnteriores());
        return lista;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        ArrayList<Pendencia> listaPendencias = new ArrayList<Pendencia>();
        List<Object> informacoes = new ArrayList<Informacao>();
        informacoes.addAll(this.getBemMovel().recuperarListaCamposPendenciaAbaIdentificacao());
        informacoes.addAll(this.getBemMovel().getAquisicao().recuperarListaCamposPendenciaAbaIdentificacao());
        String listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bem M\u00f3vel Item n\u00ba " + numeroItem + "|Aba;Identifica\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_MOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_IDENTIFICACAO, listaPassosSelecaoTela);
        boolean isAdquirenteRequerido = this.isAdquirenteRequerido();
        if (!isAdquirenteRequerido) {
            this.getBemMovel().getAdquirentes().clear();
        }
        if (this.getBemMovel().getAdquirentes().isVazio() && isAdquirenteRequerido) {
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bens M\u00f3veis Item n\u00ba " + numeroItem + "|Aba;Adquirentes";
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)3, MensagemUtil.getMensagem("alienacaoSemAdquirente"), this.getClasseFicha(), NOME_ABA_ADQUIRENTES, listaPassosSelecaoTela, NOME_FICHA_BEM_MOVEl));
        } else {
            List adquirentes = this.getBemMovel().getAdquirentes().itens();
            for (int i = 0; i < adquirentes.size(); ++i) {
                Adquirente adquirente = (Adquirente)adquirentes.get(i);
                String cpf = adquirente.getCpfCnpj().isVazio() ? "(n\u00e3o informado)" : adquirente.getCpfCnpj().formatado();
                informacoes = adquirente.recuperarListaCamposPendenciaAbaAdquirentes();
                listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bem M\u00f3vel Item n\u00ba " + numeroItem + "|Aba;Adquirentes|Lista;" + (i + 1) + ";Adquirente CPF/CNPJ " + cpf;
                GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_MOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_ADQUIRENTES, listaPassosSelecaoTela);
            }
        }
        informacoes = this.recuperarListaCamposPendenciaAbaOperacao();
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bem M\u00f3vel Item n\u00ba " + numeroItem + "|Aba;Opera\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_MOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_OPERACAO, listaPassosSelecaoTela);
        informacoes = new ArrayList();
        informacoes.addAll(this.getCalculoImposto().recuperarListaCamposPendenciaAbaCalculo());
        informacoes.addAll(this.recuperarListaCamposPendenciaAbaCalculo());
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bem M\u00f3vel Item n\u00ba " + numeroItem + "|Aba;C\u00e1lculo do Imposto";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_MOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_CALCULO, listaPassosSelecaoTela);
        ValidadorSomatorioParcelas validadorSomatorio = new ValidadorSomatorioParcelas(this);
        RetornoValidacao retornoValidacao = validadorSomatorio.validarImplementado();
        listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo(retornoValidacao.getSeveridade(), retornoValidacao.getMensagemValidacao(), this.getClasseFicha(), NOME_ABA_CALCULO, listaPassosSelecaoTela, NOME_FICHA_BEM_MOVEl));
        if (this.isAlienacaoAPrazo() && this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)2, MensagemUtil.getMensagem("alienacaoPrazoSemParcelas"), this.getClasseFicha(), NOME_ABA_CALCULO, listaPassosSelecaoTela, NOME_FICHA_BEM_MOVEl));
        }
        List parcelas = this.getColecaoParcelaAlienacao().itens();
        for (int i = 0; i < parcelas.size(); ++i) {
            ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)parcelas.get(i));
            String data = parcela.getDataRecebimento().isVazio() ? "(data n\u00e3o informada)" : parcela.getDataRecebimento().formatado();
            informacoes = parcela.recuperarListaCamposPendenciaAbaCalculo();
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Bem M\u00f3vel Item n\u00ba " + numeroItem + "|Aba;C\u00e1lculo do Imposto|Lista;" + (i + 1) + ";Parcela recebida em " + data;
            GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_BEM_MOVEl, this.getClasseFicha(), numeroItem, NOME_ABA_CALCULO, listaPassosSelecaoTela);
        }
        return listaPendencias;
    }

    public class ValidadorNaoNuloExterior
    extends ValidadorNaoNuloGCAP {
        public ValidadorNaoNuloExterior(byte severidade, String pMsg) {
            super(severidade, pMsg);
        }

        public ValidadorNaoNuloExterior(byte severidade) {
            super(severidade);
        }

        public RetornoValidacao validarImplementado() {
            if (AlienacaoBemMovel.this.getBemMovel().isAdquiridoNoExterior()) {
                return super.validarImplementado();
            }
            return null;
        }
    }
}

