/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.calculo.ObservadorAjusteDataRecebimentoParcelaParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.calculo.ObservadorCalculoValoresApuracao;
import br.gov.serpro.gcap.entidades.calculo.ObservadorCalculoValoresParcelaBrasil;
import br.gov.serpro.gcap.entidades.consolidacao.ObservadorCalculoConsolidacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.observador.ObservadorCalculoTotaisParcelas;
import br.gov.serpro.gcap.observador.ObservadorCalculoTotaisParcelasPSocietarias;
import br.gov.serpro.gcap.observador.ObservadorUltimaParcelaInformada;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorData;
import br.gov.serpro.gcap.validador.ValidadorDataRecebimentoParcela;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ColecaoParcelaAlienacao
extends Colecao<ParcelaAlienacao> {
    private ValorPositivo valorRecebidoTotal = new ValorPositivo();
    private ValorPositivo custoCorretagemTotal = new ValorPositivo();
    private ValorPositivo valorLiquidoAlienacaoTotal = new ValorPositivo();
    private ValorPositivo ganhoProporcionalTotal = new ValorPositivo();
    private ValorPositivo impostoDevidoTotal = new ValorPositivo();
    private ValorPositivo impostoPagoTotal = new ValorPositivo();
    private ValorPositivo impostoDevido2Total = new ValorPositivo();
    private ValorPositivo irrfLei110332004Total = new ValorPositivo();
    private ValorPositivo custoAquisicaoProporcionalTotal = new ValorPositivo();
    private WeakReference<Alienacao> weakAlienacao = null;

    public ColecaoParcelaAlienacao(Alienacao weakAlienacao) {
        super(ParcelaAlienacao.class.getName());
        this.weakAlienacao = new WeakReference<Alienacao>(weakAlienacao);
        this.valorRecebidoTotal.setReadOnly(true);
        this.custoCorretagemTotal.setReadOnly(true);
        this.valorLiquidoAlienacaoTotal.setReadOnly(true);
        this.ganhoProporcionalTotal.setReadOnly(true);
        this.impostoDevidoTotal.setReadOnly(true);
        this.impostoPagoTotal.setReadOnly(true);
        this.custoAquisicaoProporcionalTotal.setReadOnly(true);
        this.adicionarObservadoresColecaoParcelaAlienacao();
    }

    private void adicionarObservadoresColecaoParcelaAlienacao() {
        this.addObservador(new ObservadorCalculoTotaisParcelasPSocietarias(this));
        this.addObservador(new ObservadorUltimaParcelaInformada((Alienacao)((Object)this.weakAlienacao.get())));
        this.impostoDevidoTotal.addObservador(new ObservadorCalculoConsolidacaoParticipacaoSocietaria((Alienacao)((Object)this.weakAlienacao.get())));
        this.impostoDevidoTotal.addObservador(new ObservadorCalculoValoresApuracao((Alienacao)((Object)this.weakAlienacao.get())));
    }

    public void objetoInserido(ParcelaAlienacao parcela) {
        this.adicionarObservadoresParcela(parcela);
        this.adicionarValidadoresParcela(parcela);
    }

    private void adicionarObservadoresParcela(ParcelaAlienacao parcela) {
        parcela.addObservador(new ObservadorCalculoTotaisParcelas(this));
        parcela.getValorRecebido().addObservador(new ObservadorCalculoValoresParcelaBrasil((Alienacao)((Object)this.weakAlienacao.get()), parcela));
        parcela.getCustoCorretagem().addObservador(new ObservadorCalculoValoresParcelaBrasil((Alienacao)((Object)this.weakAlienacao.get()), parcela));
        parcela.getIrrfLei110332004().addObservador(new ObservadorCalculoValoresParcelaBrasil((Alienacao)((Object)this.weakAlienacao.get()), parcela));
        parcela.getDataRecebimento().addObservador((Observador)new ObservadorAjusteDataRecebimentoParcelaParticipacaoSocietaria((AlienacaoParticipacaoSocietaria)((Object)this.weakAlienacao.get()), parcela));
        ObservadorUltimaParcelaInformada obsUltimaParcela = new ObservadorUltimaParcelaInformada((Alienacao)((Object)this.weakAlienacao.get()));
        parcela.getUltimaParcela().addObservador((Observador)obsUltimaParcela);
        parcela.getDataRecebimento().addObservador((Observador)obsUltimaParcela);
    }

    private void adicionarValidadoresParcela(ParcelaAlienacao parcela) {
        parcela.getDataRecebimento().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{parcela.getDataRecebimento().getNomeCampo()})));
        parcela.getDataRecebimento().addValidador((ValidadorIf)new ValidadorData(3));
        parcela.getDataRecebimento().addValidador((ValidadorIf)new ValidadorDataRecebimentoParcela((Alienacao)((Object)this.weakAlienacao.get()), parcela));
        parcela.getValorRecebido().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
    }

    public void ajustarPosicaoParcela(ParcelaAlienacao parcela) {
        if (parcela.getDataRecebimento().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
            parcela.setEmReordenacao(true);
            this.itens().remove((Object)parcela);
            int posicao = 0;
            Iterator itParcelas = this.itens().iterator();
            while (itParcelas.hasNext() && !((ParcelaAlienacao)((Object)itParcelas.next())).getDataRecebimento().maisNova(parcela.getDataRecebimento())) {
                ++posicao;
            }
            this.itens().add(posicao, parcela);
            parcela.setEmReordenacao(false);
        }
    }

    public Data getDataRecebimentoUltimaParcela() {
        Data dataUltimaParcela = new Data();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            dataUltimaParcela.setConteudo(parcela.getDataRecebimento());
        }
        return dataUltimaParcela;
    }

    public boolean jaTemUltimaParcela() {
        int counter = 0;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            ++counter;
        }
        return counter > 1;
    }

    public ValorPositivo obterImpostoPagoUltimaParcela() {
        ValorPositivo valorPago = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            valorPago.setConteudo(parcela.getImpostoPago());
            break;
        }
        return valorPago;
    }

    public ValorPositivo obterGanhoCapitalRealTotalSemUltimaParcela() {
        ValorPositivo ganhoCapital = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (parcela.isUltimaParcela()) continue;
            ganhoCapital.append('+', parcela.getGanhoCapital1Proporcional());
        }
        return ganhoCapital;
    }

    public ValorPositivo obterImpostoDevidoSemUltimaParcela() {
        ValorPositivo impostoDevido = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (parcela.isUltimaParcela()) continue;
            impostoDevido.append('+', parcela.getImpostoDevido());
        }
        return impostoDevido;
    }

    public ParcelaAlienacao obterUltimaParcela() {
        ParcelaAlienacao lparcela = null;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            lparcela = parcela;
        }
        return lparcela;
    }

    public ValorPositivo obterTotalSomatorioImpostoDevidoNoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getImpostoDevido());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioImpostoDevido2NoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacao parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getImpostoDevido2());
        }
        return somatorio;
    }

    public boolean existeParcelaAposUltima(ParcelaAlienacao pParcela) {
        boolean retorno = false;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!pParcela.isUltimaParcela() || parcela.isUltimaParcela() || parcela.getDataRecebimento().isVazio() || !pParcela.getDataRecebimento().maisAntiga(parcela.getDataRecebimento())) continue;
            retorno = true;
        }
        return retorno;
    }

    public boolean parcelaPosteriorUltima(Data data) {
        boolean retorno = false;
        Data dataUltimaParcela = this.getDataRecebimentoUltimaParcela();
        if (!dataUltimaParcela.isVazio() && data.maisNova(dataUltimaParcela)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean parcelaAnteriorPeriodoDemonstrativo(Data data) {
        boolean retorno = false;
        Data dataInicioPeriodo = ControladorGui.getDemonstrativoAberto().getIdDemonstrativo().getDataInicioPermanencia();
        if (data.maisAntiga(dataInicioPeriodo)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean existeParcelaNaMesmaData(ParcelaAlienacao pParcela) {
        boolean retorno = false;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (pParcela == parcela || pParcela.getDataRecebimento().isVazio() || !pParcela.getDataRecebimento().igual(parcela.getDataRecebimento())) continue;
            retorno = true;
        }
        return retorno;
    }

    public ValorPositivo getValorRecebidoTotal() {
        return this.valorRecebidoTotal;
    }

    public ValorPositivo getGanhoProporcionalTotal() {
        return this.ganhoProporcionalTotal;
    }

    public ValorPositivo getImpostoDevidoTotal() {
        return this.impostoDevidoTotal;
    }

    public ValorPositivo getImpostoPagoTotal() {
        return this.impostoPagoTotal;
    }

    public ValorPositivo getCustoCorretagemTotal() {
        return this.custoCorretagemTotal;
    }

    public ValorPositivo getValorLiquidoAlienacaoTotal() {
        return this.valorLiquidoAlienacaoTotal;
    }

    public ValorPositivo getImpostoDevido2Total() {
        return this.impostoDevido2Total;
    }

    public ValorPositivo getIrrfLei110332004Total() {
        return this.irrfLei110332004Total;
    }

    public ValorPositivo getCustoAquisicaoProporcionalTotal() {
        return this.custoAquisicaoProporcionalTotal;
    }
}

