/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.entidades.calculo.ObservadorAjusteDataRecebimentoParcela;
import br.gov.serpro.gcap.entidades.calculo.ObservadorCalculoValoresParcelaBrasil;
import br.gov.serpro.gcap.entidades.calculo.ObservadorCalculoValoresParcelaExterior;
import br.gov.serpro.gcap.entidades.consolidacao.ObservadorCalculoConsolidacaoBemImovel;
import br.gov.serpro.gcap.entidades.consolidacao.ObservadorCalculoConsolidacaoBemMovel;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.observador.ObservadorUltimaParcelaInformada;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorData;
import br.gov.serpro.gcap.validador.ValidadorDataRecebimentoParcela;
import br.gov.serpro.gcap.validador.ValidadorImpostoPagoExteriorMaiorQueImpostoDevido;
import br.gov.serpro.gcap.validador.ValidadorSomatorioImpostoPagoExterior;
import br.gov.serpro.gcap.validador.ValidadorValorInformadoParcelaMP2521Apos180Dias;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ColecaoParcelaAlienacaoBem
extends Colecao<ParcelaAlienacaoBem> {
    private ValorPositivo valorRecebidoTotal = new ValorPositivo();
    private ValorPositivo custoCorretagemTotal = new ValorPositivo();
    private ValorPositivo valorLiquidoAlienacaoTotal = new ValorPositivo();
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovel = new ValorPositivo();
    private ValorPositivo ganho1ProporcionalTotal = new ValorPositivo();
    private ValorPositivo ganho5ProporcionalTotal = new ValorPositivo();
    private ValorPositivo impostoDevidoTotal = new ValorPositivo();
    private ValorPositivo impostoDevido2Total = new ValorPositivo();
    private ValorPositivo impostoPagoTotal = new ValorPositivo();
    private ValorPositivo impostoPagoExteriorTotal = new ValorPositivo();
    private ValorPositivo valorRecebidoDolarTotal = new ValorPositivo();
    private ValorPositivo valorRecebidoRealTotal = new ValorPositivo();
    private ValorPositivo custoCorretagemDolarTotal = new ValorPositivo();
    private ValorPositivo valorLiquidoAlienacaoDolarTotal = new ValorPositivo();
    private ValorPositivo valorLiquidoAlienacaoRealTotal = new ValorPositivo();
    private ValorPositivo ganhoCapital1ProporcionalNacionalRealTotal = new ValorPositivo();
    private ValorPositivo ganhoCapital1ProporcionalMERealTotal = new ValorPositivo();
    private ValorPositivo ganhoCapital1ProporcionalMEDolarTotal = new ValorPositivo();
    private ValorPositivo ganhoCapital1ProporcionalRealTotal = new ValorPositivo();
    private ValorPositivo percentualReducaoLei7713OrigemMN = new ValorPositivo(null, "percentualReducaoLei7713OrigemMN", 3, 6);
    private ValorPositivo valorReducaoLei7713OrigemMN = new ValorPositivo();
    private ValorPositivo ganhoCapital2ProporcionalOrigemMN = new ValorPositivo();
    private ValorPositivo percentualReducaoLei11196FR1OrigemMN = new ValorPositivo(null, "percentualReducaoLei11196FR1OrigemMN", 3, 6);
    private ValorPositivo valorReducaoLei11196FR1OrigemMN = new ValorPositivo();
    private ValorPositivo ganhoCapital3ProporcionalOrigemMN = new ValorPositivo();
    private ValorPositivo percentualReducaoLei11196FR2OrigemMN = new ValorPositivo(null, "percentualReducaoLei11196FR2OrigemMN", 3, 6);
    private ValorPositivo valorReducaoLei11196FR2OrigemMN = new ValorPositivo();
    private ValorPositivo ganhoCapital4ProporcionalOrigemMN = new ValorPositivo();
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovelOrigemMN = new ValorPositivo();
    private ValorPositivo percentualReducaoAplicacaoOutroImovelOrigemMN = new ValorPositivo(null, "percentualReducaoAplicacaoOutroImovelOrigemMN", 3, 6);
    private ValorPositivo valorReducaoAplicacaoOutroImovelOrigemMN = new ValorPositivo();
    private ValorPositivo percentualReducaoUnicoImovelOrigemMN = new ValorPositivo(null, "percentualReducaoUnicoImovelOrigemMN", 3, 6);
    private ValorPositivo valorReducaoUnicoImovelOrigemMN = new ValorPositivo();
    private ValorPositivo percentualReducaoBemPequenoValorOrigemMN = new ValorPositivo(null, "percentualReducaoBemPequenoValorOrigemMN", 3, 6);
    private ValorPositivo valorReducaoBemPequenoValorOrigemMN = new ValorPositivo();
    private ValorPositivo percentualReducaoLei7713OrigemME = new ValorPositivo(null, "percentualReducaoLei7713OrigemME", 3, 6);
    private ValorPositivo valorReducaoLei7713OrigemME = new ValorPositivo();
    private ValorPositivo ganhoCapital2ProporcionalOrigemME = new ValorPositivo();
    private ValorPositivo percentualReducaoLei11196FR1OrigemME = new ValorPositivo(null, "percentualReducaoLei11196FR1OrigemME", 3, 6);
    private ValorPositivo valorReducaoLei11196FR1OrigemME = new ValorPositivo();
    private ValorPositivo ganhoCapital3ProporcionalOrigemME = new ValorPositivo();
    private ValorPositivo percentualReducaoLei11196FR2OrigemME = new ValorPositivo(null, "percentualReducaoLei11196FR2OrigemME", 3, 6);
    private ValorPositivo valorReducaoLei11196FR2OrigemME = new ValorPositivo();
    private ValorPositivo ganhoCapital4ProporcionalOrigemME = new ValorPositivo();
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovelOrigemME = new ValorPositivo();
    private ValorPositivo percentualReducaoAplicacaoOutroImovelOrigemME = new ValorPositivo(null, "percentualReducaoAplicacaoOutroImovelOrigemME", 3, 6);
    private ValorPositivo valorReducaoAplicacaoOutroImovelOrigemME = new ValorPositivo();
    private ValorPositivo percentualReducaoUnicoImovelOrigemME = new ValorPositivo(null, "percentualReducaoUnicoImovelOrigemME", 3, 6);
    private ValorPositivo valorReducaoUnicoImovelOrigemME = new ValorPositivo();
    private ValorPositivo percentualReducaoBemPequenoValorOrigemME = new ValorPositivo(null, "percentualReducaoBemPequenoValorOrigemME", 3, 6);
    private ValorPositivo valorReducaoBemPequenoValorOrigemME = new ValorPositivo();
    private ValorPositivo ganhoCapital5ProporcionalNacionalRealTotal = new ValorPositivo();
    private ValorPositivo ganhoCapital5ProporcionalMERealTotal = new ValorPositivo();
    private ValorPositivo ganhoCapital5ProporcionalRealTotal = new ValorPositivo();
    private ValorPositivo custoAquisicaoProporcionalTotal = new ValorPositivo();
    private ValorPositivo custoAquisicaoTornaProporcionalTotal = new ValorPositivo();
    private ValorPositivo custoAquisicaoProporcionalOrigemNacionalRealTotal = new ValorPositivo();
    private ValorPositivo custoAquisicaoTornaProporcionalOrigemNacionalRealTotal = new ValorPositivo();
    private ValorPositivo custoAquisicaoProporcionalOrigemMEDolarTotal = new ValorPositivo();
    private ValorPositivo custoAquisicaoTornaProporcionalOrigemMEDolarTotal = new ValorPositivo();
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovelOrigemAmbas = new ValorPositivo();
    private ValorPositivo valorReducaoAplicacaoOutroImovelOrigemAmbas = new ValorPositivo();
    private WeakReference<AlienacaoBem> weakAlienacao = null;

    public ColecaoParcelaAlienacaoBem(AlienacaoBem weakAlienacao) {
        super(ParcelaAlienacaoBem.class.getName());
        this.weakAlienacao = new WeakReference<AlienacaoBem>(weakAlienacao);
        this.valorRecebidoTotal.setReadOnly(true);
        this.custoCorretagemTotal.setReadOnly(true);
        this.valorLiquidoAlienacaoTotal.setReadOnly(true);
        this.ganho1ProporcionalTotal.setReadOnly(true);
        this.ganho5ProporcionalTotal.setReadOnly(true);
        this.impostoDevidoTotal.setReadOnly(true);
        this.impostoDevido2Total.setReadOnly(true);
        this.impostoPagoTotal.setReadOnly(true);
        this.impostoPagoExteriorTotal.setReadOnly(true);
        this.valorRecebidoRealTotal.setReadOnly(true);
        this.valorRecebidoDolarTotal.setReadOnly(true);
        this.custoCorretagemDolarTotal.setReadOnly(true);
        this.valorLiquidoAlienacaoDolarTotal.setReadOnly(true);
        this.valorLiquidoAlienacaoRealTotal.setReadOnly(true);
        this.ganhoCapital1ProporcionalNacionalRealTotal.setReadOnly(true);
        this.ganhoCapital1ProporcionalMERealTotal.setReadOnly(true);
        this.ganhoCapital1ProporcionalMEDolarTotal.setReadOnly(true);
        this.ganhoCapital1ProporcionalRealTotal.setReadOnly(true);
        this.custoAquisicaoProporcionalTotal.setReadOnly(true);
        this.custoAquisicaoTornaProporcionalTotal.setReadOnly(true);
        this.custoAquisicaoProporcionalOrigemNacionalRealTotal.setReadOnly(true);
        this.custoAquisicaoTornaProporcionalOrigemNacionalRealTotal.setReadOnly(true);
        this.custoAquisicaoProporcionalOrigemMEDolarTotal.setReadOnly(true);
        this.custoAquisicaoTornaProporcionalOrigemMEDolarTotal.setReadOnly(true);
        this.adicionarObservadoresColecaoParcelaAlienacaoBem();
    }

    private void adicionarObservadoresColecaoParcelaAlienacaoBem() {
        this.addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
        this.addObservador(new ObservadorUltimaParcelaInformada((Alienacao)((Object)this.weakAlienacao.get())));
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel) {
            this.impostoDevidoTotal.addObservador(new ObservadorCalculoConsolidacaoBemImovel((AlienacaoBemImovel)((Object)this.weakAlienacao.get())));
            this.impostoDevido2Total.addObservador(new ObservadorCalculoConsolidacaoBemImovel((AlienacaoBemImovel)((Object)this.weakAlienacao.get())));
        } else if (this.weakAlienacao.get() instanceof AlienacaoBemMovel) {
            this.impostoDevidoTotal.addObservador(new ObservadorCalculoConsolidacaoBemMovel((AlienacaoBemMovel)((Object)this.weakAlienacao.get())));
            this.impostoDevido2Total.addObservador(new ObservadorCalculoConsolidacaoBemMovel((AlienacaoBemMovel)((Object)this.weakAlienacao.get())));
        }
        this.valorRecebidoRealTotal.addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (GcapUtil.getEstadoSistema() == 0) {
                    if (ColecaoParcelaAlienacaoBem.this.weakAlienacao.get() instanceof AlienacaoBemImovel) {
                        AlienacaoBemImovel imovel = (AlienacaoBemImovel)((Object)ColecaoParcelaAlienacaoBem.this.weakAlienacao.get());
                        if (!imovel.podeResponderPerguntaBemIsentoPorPequenoValor()) {
                            imovel.getBemGrandeValor().clear();
                        }
                    } else {
                        AlienacaoBemMovel movel = (AlienacaoBemMovel)((Object)ColecaoParcelaAlienacaoBem.this.weakAlienacao.get());
                        if (!movel.podeResponderPerguntaBemIsentoPorPequenoValor()) {
                            movel.getBemGrandeValor().clear();
                        }
                    }
                }
            }
        });
    }

    public void objetoInserido(ParcelaAlienacaoBem parcela) {
        if (!parcela.getEmReordenacao()) {
            this.adicionarObservadoresParcelaBem(parcela);
            this.adicionarValidadoresParcelaBem(parcela);
        }
    }

    private void adicionarObservadoresParcelaBem(final ParcelaAlienacaoBem parcela) {
        parcela.getDataRecebimento().addObservador((Observador)new ObservadorAjusteDataRecebimentoParcela((AlienacaoBem)((Object)this.weakAlienacao.get()), parcela));
        if (((AlienacaoBem)((Object)this.weakAlienacao.get())).isAlienacaoBrasil()) {
            parcela.getValorRecebido().addObservador(new ObservadorCalculoValoresParcelaBrasil((AlienacaoBem)((Object)this.weakAlienacao.get()), parcela));
            parcela.getCustoCorretagem().addObservador(new ObservadorCalculoValoresParcelaBrasil((AlienacaoBem)((Object)this.weakAlienacao.get()), parcela));
            parcela.getValorInformadoReducaoAplicacaoOutroImovel().addObservador(new ObservadorCalculoValoresParcelaBrasil((AlienacaoBem)((Object)this.weakAlienacao.get()), parcela));
        } else {
            parcela.getUltimaParcela().addObservador((Observador)new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getValorRecebidoDolar().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getCustoCorretagemDolar().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getCotacaoDolar().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getValorInformadoReducaoAplicacaoOutroImovelMN().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getValorInformadoReducaoAplicacaoOutroImovelME().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getImpostoPagoExterior().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            parcela.getImpostoPago().addObservador(new ObservadorCalculoValoresParcelaExterior((AlienacaoBem)((Object)this.weakAlienacao.get())));
            Observador obsGanhoCapital1Total = new Observador(){

                public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                    ValorPositivo total = new ValorPositivo();
                    total.setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
                    total.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
                    parcela.getGanhoCapital1ProporcionalTotalReal().setConteudo(total);
                }
            };
            parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().addObservador(obsGanhoCapital1Total);
            parcela.getGanhoCapital1ProporcionalOrigemMEReal().addObservador(obsGanhoCapital1Total);
            Observador obsGanhoCapital5Total = new Observador(){

                public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                    ValorPositivo total = new ValorPositivo();
                    total.setConteudo(parcela.getGanhoCapital5ProporcionalMN());
                    total.append('+', parcela.getGanhoCapital5ProporcionalME());
                    parcela.getGanhoCapital5ProporcionalTotalReal().setConteudo(total);
                }
            };
            parcela.getGanhoCapital5ProporcionalMN().addObservador(obsGanhoCapital5Total);
            parcela.getGanhoCapital5ProporcionalME().addObservador(obsGanhoCapital5Total);
            Observador obsImpostoDevido2 = new Observador(){

                public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                    ValorPositivo impostoDevido2 = new ValorPositivo();
                    impostoDevido2.setConteudo(parcela.getImpostoDevido());
                    impostoDevido2.append('-', parcela.getImpostoPagoExterior());
                    parcela.getImpostoDevido2().setConteudo(impostoDevido2);
                    if (((AlienacaoBem)((Object)ColecaoParcelaAlienacaoBem.this.weakAlienacao.get())).isAlienacaoAPrazo() && !((AlienacaoBem)((Object)ColecaoParcelaAlienacaoBem.this.weakAlienacao.get())).getDataRecebimentoUltimaParcela().isVazio()) {
                        ((AlienacaoBem)((Object)ColecaoParcelaAlienacaoBem.this.weakAlienacao.get())).calcularAjuste();
                    }
                }
            };
            parcela.getImpostoPagoExterior().addObservador(obsImpostoDevido2);
            parcela.getImpostoDevido().addObservador(obsImpostoDevido2);
            if (!parcela.getImpostoDevido().isVazio() && parcela.getImpostoDevido2().isVazio()) {
                parcela.getImpostoDevido().forcaDisparoObservadores();
            }
        }
        ObservadorUltimaParcelaInformada obsUltimaParcela = new ObservadorUltimaParcelaInformada((Alienacao)((Object)this.weakAlienacao.get()));
        parcela.getUltimaParcela().addObservador((Observador)obsUltimaParcela);
        parcela.getDataRecebimento().addObservador((Observador)obsUltimaParcela);
    }

    private void adicionarValidadoresParcelaBem(ParcelaAlienacaoBem parcela) {
        parcela.getDataRecebimento().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{parcela.getDataRecebimento().getNomeCampo()})));
        parcela.getDataRecebimento().addValidador((ValidadorIf)new ValidadorData(3));
        parcela.getDataRecebimento().addValidador((ValidadorIf)new ValidadorDataRecebimentoParcela((Alienacao)((Object)this.weakAlienacao.get()), parcela));
        if (((AlienacaoBem)((Object)this.weakAlienacao.get())).isAlienacaoBrasil()) {
            parcela.getValorRecebido().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        } else {
            parcela.getValorRecebidoDolar().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
            parcela.getCotacaoDolar().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
            parcela.getImpostoPagoExterior().addValidador((ValidadorIf)new ValidadorImpostoPagoExteriorMaiorQueImpostoDevido(parcela));
            parcela.getImpostoPagoExterior().addValidador((ValidadorIf)new ValidadorSomatorioImpostoPagoExterior((AlienacaoBem)((Object)this.weakAlienacao.get()), parcela));
        }
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel) {
            AlienacaoBemImovel alienacaoBemImovel = (AlienacaoBemImovel)((Object)this.weakAlienacao.get());
            parcela.getValorInformadoReducaoAplicacaoOutroImovel().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP2521Apos180Dias(alienacaoBemImovel, parcela));
            parcela.getValorInformadoReducaoAplicacaoOutroImovelMN().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP2521Apos180Dias(alienacaoBemImovel, parcela));
            parcela.getValorInformadoReducaoAplicacaoOutroImovelME().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP2521Apos180Dias(alienacaoBemImovel, parcela));
            parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP2521Apos180Dias(alienacaoBemImovel, parcela));
        }
    }

    public void ajustarPosicaoParcela(ParcelaAlienacaoBem parcela) {
        if (parcela.getDataRecebimento().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
            parcela.setEmReordenacao(true);
            this.itens().remove((Object)parcela);
            int posicao = 0;
            Iterator itParcelas = this.itens().iterator();
            while (itParcelas.hasNext() && !((ParcelaAlienacaoBem)((Object)itParcelas.next())).getDataRecebimento().maisNova(parcela.getDataRecebimento())) {
                ++posicao;
            }
            this.itens().add(posicao, parcela);
            parcela.setEmReordenacao(false);
        }
    }

    public Data getDataRecebimentoUltimaParcela() {
        Data dataUltimaParcela = new Data();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            dataUltimaParcela.setConteudo(parcela.getDataRecebimento());
        }
        return dataUltimaParcela;
    }

    public boolean jaTemUltimaParcela() {
        int counter = 0;
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            ++counter;
        }
        return counter > 1;
    }

    public ValorPositivo obterImpostoPagoUltimaParcela() {
        ValorPositivo valorPago = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            valorPago.setConteudo(parcela.getImpostoPago());
            break;
        }
        return valorPago;
    }

    public ValorPositivo obterImpostoPagoExterior() {
        ValorPositivo valorPago = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            valorPago.append('+', parcela.getImpostoPagoExterior());
        }
        return valorPago;
    }

    public ValorPositivo obterImpostoDevidoNoBrasilSemUltimaParcela() {
        ValorPositivo valorPago = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.isUltimaParcela()) continue;
            valorPago.append('+', parcela.getImpostoDevido2());
        }
        return valorPago;
    }

    public ValorPositivo obterValorLiquidoOrigemNacionalReal() {
        ValorPositivo valorLiquido = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            valorLiquido.append('+', parcela.getValorAlienacaoOrigemNacionalReal());
        }
        return valorLiquido;
    }

    public ValorPositivo obterGanhoCapitalRealTotalSemUltimaParcela(boolean brasil) {
        ParcelaAlienacaoBem parcela;
        ValorPositivo ganhoCapital = new ValorPositivo();
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext() && !(parcela = (ParcelaAlienacaoBem)((Object)iterator.next())).isUltimaParcela()) {
            if (brasil) {
                ganhoCapital.append('+', parcela.getGanhoCapital1Proporcional());
                continue;
            }
            ganhoCapital.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
            ganhoCapital.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        }
        return ganhoCapital;
    }

    public ValorPositivo obterGanhoCapitalRealExteriorSemUltimaParcela(boolean OrigemNacional) {
        ParcelaAlienacaoBem parcela;
        ValorPositivo ganhoCapital = new ValorPositivo();
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext() && !(parcela = (ParcelaAlienacaoBem)((Object)iterator.next())).isUltimaParcela()) {
            if (OrigemNacional) {
                ganhoCapital.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
                continue;
            }
            ganhoCapital.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        }
        return ganhoCapital;
    }

    public ValorPositivo obterGanhoCapitalDolarTotalSemUltimaParcela() {
        ParcelaAlienacaoBem parcela;
        ValorPositivo ganhoCapital = new ValorPositivo();
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext() && !(parcela = (ParcelaAlienacaoBem)((Object)iterator.next())).isUltimaParcela()) {
            ganhoCapital.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
        }
        return ganhoCapital;
    }

    public ValorPositivo obterImpostoDevidoSemUltimaParcela() {
        ParcelaAlienacaoBem parcela;
        ValorPositivo impostoDevido = new ValorPositivo();
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext() && !(parcela = (ParcelaAlienacaoBem)((Object)iterator.next())).isUltimaParcela()) {
            impostoDevido.append('+', parcela.getImpostoDevido());
        }
        return impostoDevido;
    }

    public ParcelaAlienacao obterUltimaParcela() {
        ParcelaAlienacao lparcela = null;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!parcela.isUltimaParcela()) continue;
            lparcela = parcela;
        }
        return lparcela;
    }

    public ValorPositivo obterGanhoCapitalProporcionalNacionalRealTotalNoExercicio() {
        ValorPositivo ganhoProporcional = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            ganhoProporcional.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        }
        return ganhoProporcional;
    }

    public ValorPositivo obterGanhoCapitalProporcionalMERealTotalNoExercicio() {
        ValorPositivo ganhoProporcional = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            ganhoProporcional.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        }
        return ganhoProporcional;
    }

    public ValorPositivo obterImpostoPagoTotalNoExercicio() {
        ValorPositivo ganhoProporcional = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            ganhoProporcional.append('+', parcela.getImpostoPago());
        }
        return ganhoProporcional;
    }

    public boolean existeParcelaAposUltima(ParcelaAlienacao pParcela) {
        boolean retorno = false;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (!pParcela.isUltimaParcela() || parcela.isUltimaParcela() || parcela.getDataRecebimento().isVazio() || !pParcela.getDataRecebimento().maisAntiga(parcela.getDataRecebimento())) continue;
            retorno = true;
        }
        return retorno;
    }

    public boolean parcelaPosteriorUltima(Data data) {
        boolean retorno = false;
        Data dataUltimaParcela = this.getDataRecebimentoUltimaParcela();
        if (!dataUltimaParcela.isVazio() && data.maisNova(dataUltimaParcela)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean parcelaAnteriorPeriodoDemonstrativo(Data data) {
        boolean retorno = false;
        Data dataInicioPeriodo = ControladorGui.getDemonstrativoAberto().getIdDemonstrativo().getDataInicioPermanencia();
        if (data.maisAntiga(dataInicioPeriodo)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean existeParcelaNaMesmaData(ParcelaAlienacao pParcela) {
        boolean retorno = false;
        for (ParcelaAlienacao parcela : this.itens()) {
            if (pParcela == parcela || pParcela.getDataRecebimento().isVazio() || !pParcela.getDataRecebimento().igual(parcela.getDataRecebimento())) continue;
            retorno = true;
        }
        return retorno;
    }

    public ValorPositivo calcularCustoMedioDolar1() {
        ValorPositivo lValorLiquidoDolarTotal = new ValorPositivo(null, "lValorLiquidoDolarTotal", 11, 9);
        ValorPositivo lValorLiquidoRealParcela = new ValorPositivo(null, "lValorLiquidoRealParcela", 11, 9);
        ValorPositivo lValorLiquidoRealTotal = new ValorPositivo(null, "lValorLiquidoRealTotal", 11, 9);
        ValorPositivo cotacaoMediaDolar = new ValorPositivo(null, "cotacaoMediaDolar", 11, 9);
        lValorLiquidoRealTotal.clear();
        lValorLiquidoDolarTotal.clear();
        cotacaoMediaDolar.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            lValorLiquidoDolarTotal.append('+', parcela.getValorLiquidoAlienacaoDolar());
            lValorLiquidoRealParcela.setConteudo(parcela.getValorLiquidoAlienacaoDolar());
            lValorLiquidoRealParcela.append('*', parcela.getCotacaoDolar());
            lValorLiquidoRealTotal.append('+', lValorLiquidoRealParcela);
        }
        if (!lValorLiquidoDolarTotal.isVazio()) {
            cotacaoMediaDolar.setConteudo(lValorLiquidoRealTotal);
            cotacaoMediaDolar.append('/', lValorLiquidoDolarTotal);
        }
        return cotacaoMediaDolar;
    }

    public ValorPositivo obterSaldoCustoAquisicaoProporcionalDisponivel(ParcelaAlienacaoBem pParcela, ValorPositivo custoAquisicao, boolean origemNacional) {
        ValorPositivo total = new ValorPositivo();
        ValorPositivo saldo = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (pParcela == parcela || pParcela.getDataRecebimento().isVazio() || !parcela.getDataRecebimento().maisAntiga(pParcela.getDataRecebimento())) continue;
            if (origemNacional) {
                total.append('+', parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
                continue;
            }
            total.append('+', parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
        }
        if (custoAquisicao.comparacao(">", total)) {
            saldo.setConteudo(custoAquisicao);
            saldo.append('-', total);
        }
        return saldo;
    }

    public ValorPositivo getValorRecebidoTotal() {
        return this.valorRecebidoTotal;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovel() {
        return this.valorInformadoReducaoAplicacaoOutroImovel;
    }

    public ValorPositivo getGanho1ProporcionalTotal() {
        return this.ganho1ProporcionalTotal;
    }

    public ValorPositivo getGanho5ProporcionalTotal() {
        return this.ganho5ProporcionalTotal;
    }

    public ValorPositivo getImpostoDevidoTotal() {
        return this.impostoDevidoTotal;
    }

    public ValorPositivo getImpostoDevido2Total() {
        return this.impostoDevido2Total;
    }

    public ValorPositivo getImpostoPagoTotal() {
        return this.impostoPagoTotal;
    }

    public ValorPositivo getImpostoPagoExteriorTotal() {
        return this.impostoPagoExteriorTotal;
    }

    public ValorPositivo getValorRecebidoDolarTotal() {
        return this.valorRecebidoDolarTotal;
    }

    public ValorPositivo getValorRecebidoRealTotal() {
        return this.valorRecebidoRealTotal;
    }

    public ValorPositivo getCustoCorretagemDolarTotal() {
        return this.custoCorretagemDolarTotal;
    }

    public ValorPositivo getValorLiquidoAlienacaoDolarTotal() {
        return this.valorLiquidoAlienacaoDolarTotal;
    }

    public ValorPositivo getValorLiquidoAlienacaoRealTotal() {
        return this.valorLiquidoAlienacaoRealTotal;
    }

    public ValorPositivo getGanhoCapital1ProporcionalNacionalRealTotal() {
        return this.ganhoCapital1ProporcionalNacionalRealTotal;
    }

    public ValorPositivo getGanhoCapital1ProporcionalMERealTotal() {
        return this.ganhoCapital1ProporcionalMERealTotal;
    }

    public ValorPositivo getGanhoCapital1ProporcionalMEDolarTotal() {
        return this.ganhoCapital1ProporcionalMEDolarTotal;
    }

    public ValorPositivo getGanhoCapital1ProporcionalRealTotal() {
        return this.ganhoCapital1ProporcionalRealTotal;
    }

    public ValorPositivo getGanhoCapital5ProporcionalNacionalRealTotal() {
        return this.ganhoCapital5ProporcionalNacionalRealTotal;
    }

    public ValorPositivo getGanhoCapital5ProporcionalMERealTotal() {
        return this.ganhoCapital5ProporcionalMERealTotal;
    }

    public ValorPositivo getGanhoCapital5ProporcionalRealTotal() {
        return this.ganhoCapital5ProporcionalRealTotal;
    }

    public ValorPositivo getCustoCorretagemTotal() {
        return this.custoCorretagemTotal;
    }

    public ValorPositivo getValorLiquidoAlienacaoTotal() {
        return this.valorLiquidoAlienacaoTotal;
    }

    public ValorPositivo getCustoAquisicaoProporcionalTotal() {
        return this.custoAquisicaoProporcionalTotal;
    }

    public ValorPositivo getCustoAquisicaoTornaProporcionalTotal() {
        return this.custoAquisicaoTornaProporcionalTotal;
    }

    public ValorPositivo getCustoAquisicaoProporcionalOrigemNacionalRealTotal() {
        return this.custoAquisicaoProporcionalOrigemNacionalRealTotal;
    }

    public ValorPositivo getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal() {
        return this.custoAquisicaoTornaProporcionalOrigemNacionalRealTotal;
    }

    public ValorPositivo getCustoAquisicaoProporcionalOrigemMEDolarTotal() {
        return this.custoAquisicaoProporcionalOrigemMEDolarTotal;
    }

    public ValorPositivo getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal() {
        return this.custoAquisicaoTornaProporcionalOrigemMEDolarTotal;
    }

    public ValorPositivo getPercentualReducaoLei7713OrigemMN() {
        return this.percentualReducaoLei7713OrigemMN;
    }

    public ValorPositivo getValorReducaoLei7713OrigemMN() {
        return this.valorReducaoLei7713OrigemMN;
    }

    public ValorPositivo getGanhoCapital2ProporcionalOrigemMN() {
        return this.ganhoCapital2ProporcionalOrigemMN;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1OrigemMN() {
        return this.percentualReducaoLei11196FR1OrigemMN;
    }

    public ValorPositivo getValorReducaoLei11196FR1OrigemMN() {
        return this.valorReducaoLei11196FR1OrigemMN;
    }

    public ValorPositivo getGanhoCapital3ProporcionalOrigemMN() {
        return this.ganhoCapital3ProporcionalOrigemMN;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2OrigemMN() {
        return this.percentualReducaoLei11196FR2OrigemMN;
    }

    public ValorPositivo getValorReducaoLei11196FR2OrigemMN() {
        return this.valorReducaoLei11196FR2OrigemMN;
    }

    public ValorPositivo getGanhoCapital4ProporcionalOrigemMN() {
        return this.ganhoCapital4ProporcionalOrigemMN;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovelOrigemMN() {
        return this.valorInformadoReducaoAplicacaoOutroImovelOrigemMN;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovelOrigemMN() {
        return this.percentualReducaoAplicacaoOutroImovelOrigemMN;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovelOrigemMN() {
        return this.valorReducaoAplicacaoOutroImovelOrigemMN;
    }

    public ValorPositivo getPercentualReducaoUnicoImovelOrigemMN() {
        return this.percentualReducaoUnicoImovelOrigemMN;
    }

    public ValorPositivo getValorReducaoUnicoImovelOrigemMN() {
        return this.valorReducaoUnicoImovelOrigemMN;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValorOrigemMN() {
        return this.percentualReducaoBemPequenoValorOrigemMN;
    }

    public ValorPositivo getValorReducaoBemPequenoValorOrigemMN() {
        return this.valorReducaoBemPequenoValorOrigemMN;
    }

    public ValorPositivo getPercentualReducaoLei7713OrigemME() {
        return this.percentualReducaoLei7713OrigemME;
    }

    public ValorPositivo getValorReducaoLei7713OrigemME() {
        return this.valorReducaoLei7713OrigemME;
    }

    public ValorPositivo getGanhoCapital2ProporcionalOrigemME() {
        return this.ganhoCapital2ProporcionalOrigemME;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1OrigemME() {
        return this.percentualReducaoLei11196FR1OrigemME;
    }

    public ValorPositivo getValorReducaoLei11196FR1OrigemME() {
        return this.valorReducaoLei11196FR1OrigemME;
    }

    public ValorPositivo getGanhoCapital3ProporcionalOrigemME() {
        return this.ganhoCapital3ProporcionalOrigemME;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2OrigemME() {
        return this.percentualReducaoLei11196FR2OrigemME;
    }

    public ValorPositivo getValorReducaoLei11196FR2OrigemME() {
        return this.valorReducaoLei11196FR2OrigemME;
    }

    public ValorPositivo getGanhoCapital4ProporcionalOrigemME() {
        return this.ganhoCapital4ProporcionalOrigemME;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovelOrigemME() {
        return this.valorInformadoReducaoAplicacaoOutroImovelOrigemME;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovelOrigemME() {
        return this.percentualReducaoAplicacaoOutroImovelOrigemME;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovelOrigemME() {
        return this.valorReducaoAplicacaoOutroImovelOrigemME;
    }

    public ValorPositivo getPercentualReducaoUnicoImovelOrigemME() {
        return this.percentualReducaoUnicoImovelOrigemME;
    }

    public ValorPositivo getValorReducaoUnicoImovelOrigemME() {
        return this.valorReducaoUnicoImovelOrigemME;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValorOrigemME() {
        return this.percentualReducaoBemPequenoValorOrigemME;
    }

    public ValorPositivo getValorReducaoBemPequenoValorOrigemME() {
        return this.valorReducaoBemPequenoValorOrigemME;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovelOrigemAmbas() {
        return this.valorInformadoReducaoAplicacaoOutroImovelOrigemAmbas;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovelOrigemAmbas() {
        return this.valorReducaoAplicacaoOutroImovelOrigemAmbas;
    }

    public ValorPositivo obterTotalSomatorioReducoesMN() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            somatorio.append('+', parcela.obterSomatorioReducoesMN());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioReducoesMNNoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.obterSomatorioReducoesMN());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioReducoesMNForaDoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.obterSomatorioReducoesMN());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioReducoesME() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            somatorio.append('+', parcela.obterSomatorioReducoesME());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioReducoesMENoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.obterSomatorioReducoesME());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioReducoesMEForaDoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.obterSomatorioReducoesME());
        }
        return somatorio;
    }

    private void recuperarPercentuaisReducaoMN() {
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel) {
            AlienacaoBemImovel imovel = (AlienacaoBemImovel)((Object)this.weakAlienacao.get());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemMN().setConteudo(imovel.getApuracao().getPercentualReducaoLei7713OrigemMN());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemMN().setConteudo(imovel.getApuracao().getPercentualReducaoLei11196FR1OrigemMN());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemMN().setConteudo(imovel.getApuracao().getPercentualReducaoLei11196FR2OrigemMN());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemMN().setConteudo(imovel.getApuracao().getPercentualReducaoBemPequenoValorOrigemMN());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemMN().setConteudo(imovel.getApuracao().getPercentualReducaoUnicoImovelOrigemMN());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(imovel.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemMN());
            if (imovel.getColecaoParcelaAlienacao().itens().isEmpty()) {
                this.limparPercentuaisReducao();
            }
        } else {
            this.limparPercentuaisReducao();
        }
    }

    private void recuperarPercentuaisReducaoME() {
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel) {
            AlienacaoBemImovel imovel = (AlienacaoBemImovel)((Object)this.weakAlienacao.get());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemME().setConteudo(imovel.getApuracao().getPercentualReducaoLei7713OrigemME());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemME().setConteudo(imovel.getApuracao().getPercentualReducaoLei11196FR1OrigemME());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemME().setConteudo(imovel.getApuracao().getPercentualReducaoLei11196FR2OrigemME());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemME().setConteudo(imovel.getApuracao().getPercentualReducaoBemPequenoValorOrigemME());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemME().setConteudo(imovel.getApuracao().getPercentualReducaoUnicoImovelOrigemME());
            ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(imovel.getApuracao().getPercentualReducaoAplicacaoOutroImovelOrigemME());
            if (imovel.getColecaoParcelaAlienacao().itens().isEmpty()) {
                this.limparPercentuaisReducao();
            }
        } else {
            this.limparPercentuaisReducao();
        }
    }

    public void limparPercentuaisReducao() {
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemMN().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemMN().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemMN().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemMN().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemMN().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemMN().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei7713OrigemME().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR1OrigemME().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoLei11196FR2OrigemME().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoBemPequenoValorOrigemME().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoUnicoImovelOrigemME().clear();
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getPercentualReducaoAplicacaoOutroImovelOrigemME().clear();
    }

    public void atualizarReducoesMN() {
        this.recuperarPercentuaisReducaoMN();
        this.calculaValorReducaoLei7713OrigemMN();
        this.calculaGanhoCapital2ProporcionalOrigemMN();
        this.calculaValorReducaoLei11196FR1OrigemMN();
        this.calculaGanhoCapital3ProporcionalOrigemMN();
        this.calculaValorReducaoLei11196FR2OrigemMN();
        this.calculaGanhoCapital4ProporcionalOrigemMN();
        this.calculaValorInformadoReducaoAplicacaoOutroImovelOrigemMN();
        this.calculaValorReducaoAplicacaoOutroImovelOrigemMN();
        this.calculaValorReducaoUnicoImovelOrigemMN();
        this.calculaValorReducaoBemPequenoValorOrigemMN();
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel && Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            this.calculaValorInformadoReducaoAplicacaoOutroImovelOrigemAmbas();
            this.calculaValorReducaoAplicacaoOutroImovelOrigemAmbas();
        }
    }

    public void atualizarReducoesME() {
        this.recuperarPercentuaisReducaoME();
        this.calculaValorReducaoLei7713OrigemME();
        this.calculaGanhoCapital2ProporcionalOrigemME();
        this.calculaValorReducaoLei11196FR1OrigemME();
        this.calculaGanhoCapital3ProporcionalOrigemME();
        this.calculaValorReducaoLei11196FR2OrigemME();
        this.calculaGanhoCapital4ProporcionalOrigemME();
        this.calculaValorInformadoReducaoAplicacaoOutroImovelOrigemME();
        this.calculaValorReducaoAplicacaoOutroImovelOrigemME();
        this.calculaValorReducaoUnicoImovelOrigemME();
        this.calculaValorReducaoBemPequenoValorOrigemME();
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel && Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            this.calculaValorInformadoReducaoAplicacaoOutroImovelOrigemAmbas();
            this.calculaValorReducaoAplicacaoOutroImovelOrigemAmbas();
        }
    }

    private void calculaValorReducaoLei7713OrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoLei7713MN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoLei7713OrigemMN().setConteudo(total);
    }

    private void calculaGanhoCapital2ProporcionalOrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital2ProporcionalMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital2ProporcionalOrigemMN().setConteudo(total);
    }

    private void calculaValorReducaoLei11196FR1OrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoLei11196FR1MN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoLei11196FR1OrigemMN().setConteudo(total);
    }

    private void calculaGanhoCapital3ProporcionalOrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital3ProporcionalMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital3ProporcionalOrigemMN().setConteudo(total);
    }

    private void calculaValorReducaoLei11196FR2OrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoLei11196FR2MN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoLei11196FR2OrigemMN().setConteudo(total);
    }

    private void calculaGanhoCapital4ProporcionalOrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital4ProporcionalMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital4ProporcionalOrigemMN().setConteudo(total);
    }

    private void calculaValorInformadoReducaoAplicacaoOutroImovelOrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovelMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorInformadoReducaoAplicacaoOutroImovelOrigemMN().setConteudo(total);
    }

    private void calculaValorReducaoAplicacaoOutroImovelOrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoAplicacaoOutroImovelMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(total);
    }

    private void calculaValorReducaoAplicacaoOutroImovelOrigemAmbas() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoAplicacaoOutroImovelMN());
            total.append('+', parcela.getValorReducaoAplicacaoOutroImovelME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemAmbas().setConteudo(total);
    }

    private void calculaValorReducaoUnicoImovelOrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoUnicoImovelMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoUnicoImovelOrigemMN().setConteudo(total);
    }

    private void calculaValorReducaoBemPequenoValorOrigemMN() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoBemPequenoValorMN());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoBemPequenoValorOrigemMN().setConteudo(total);
    }

    private void calculaValorReducaoLei7713OrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoLei7713ME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoLei7713OrigemME().setConteudo(total);
    }

    private void calculaGanhoCapital2ProporcionalOrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital2ProporcionalME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital2ProporcionalOrigemME().setConteudo(total);
    }

    private void calculaValorReducaoLei11196FR1OrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoLei11196FR1ME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoLei11196FR1OrigemME().setConteudo(total);
    }

    private void calculaGanhoCapital3ProporcionalOrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital3ProporcionalME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital3ProporcionalOrigemME().setConteudo(total);
    }

    private void calculaValorReducaoLei11196FR2OrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoLei11196FR2ME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoLei11196FR2OrigemME().setConteudo(total);
    }

    private void calculaGanhoCapital4ProporcionalOrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getGanhoCapital4ProporcionalME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getGanhoCapital4ProporcionalOrigemME().setConteudo(total);
    }

    private void calculaValorInformadoReducaoAplicacaoOutroImovelOrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovelME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorInformadoReducaoAplicacaoOutroImovelOrigemME().setConteudo(total);
    }

    private void calculaValorReducaoAplicacaoOutroImovelOrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoAplicacaoOutroImovelME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(total);
    }

    private void calculaValorReducaoUnicoImovelOrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoUnicoImovelME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoUnicoImovelOrigemME().setConteudo(total);
    }

    private void calculaValorReducaoBemPequenoValorOrigemME() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorReducaoBemPequenoValorME());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorReducaoBemPequenoValorOrigemME().setConteudo(total);
    }

    private void calculaValorInformadoReducaoAplicacaoOutroImovelOrigemAmbas() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().itens()) {
            total.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas());
        }
        ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().getValorInformadoReducaoAplicacaoOutroImovelOrigemAmbas().setConteudo(total);
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital1MNNoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital1MNForaDoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital1MENoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital1MEForaDoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital5MNNoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital5ProporcionalMN());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital5MNForaDoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital5ProporcionalMN());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital5MENoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital5ProporcionalME());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioGanhoCapital5MEForaDoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getGanhoCapital5ProporcionalME());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioImpostoDevidoNoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getImpostoDevido());
        }
        return somatorio;
    }

    public ValorPositivo obterTotalSomatorioImpostoDevido2NoExercicio() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        for (ParcelaAlienacaoBem parcela : this.itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            somatorio.append('+', parcela.getImpostoDevido2());
        }
        return somatorio;
    }
}

