/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorComparacaoValor;
import br.gov.serpro.gcap.validador.ValidadorValorInformadoParcelaMP252;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ParcelaAlienacaoBem
extends ParcelaAlienacao
implements ObjetoFicha {
    private ValorPositivo valorRecebidoDolar = new ValorPositivo(this, CAMPO_VALOR_RECEBIDO_DOLAR);
    private ValorPositivo valorRecebidoReal = new ValorPositivo(this, CAMPO_VALOR_RECEBIDO_REAL);
    private ValorPositivo custoCorretagemDolar = new ValorPositivo(this, CAMPO_CUSTO_CORRETAGEM_DOLAR);
    private ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(this, CAMPO_VALOR_LIQUIDO_ALIENACAO_DOLAR);
    private ValorPositivo valorLiquidoAlienacaoReal = new ValorPositivo(this, CAMPO_VALOR_LIQUIDO_ALIENACAO_REAL);
    private ValorPositivo valorAlienacaoOrigemNacionalDolar = new ValorPositivo(this, "Valor da Aliena\u00e7\u00e3o Proporcional - Rendimentos em Reais (XX$)");
    private ValorPositivo valorAlienacaoOrigemNacionalReal = new ValorPositivo(this, "Valor da Aliena\u00e7\u00e3o Proporcional - Rendimentos em Reais (R$)");
    private ValorPositivo percentualGanhoOrigemNacional = new ValorPositivo(this, "% Ganho sobre Valor Aliena\u00e7\u00e3o - Rendimentos em Reais", 11, 6);
    private ValorPositivo ganhoCapital1ProporcionalOrigemNacionalReal = new ValorPositivo(this, CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_NACIONAL_REAL);
    private ValorPositivo valorAlienacaoOrigemMEDolar = new ValorPositivo(this, "Valor da Aliena\u00e7\u00e3o Proporcional - Rendimentos em ME (US$)");
    private ValorPositivo percentualGanhoOrigemME = new ValorPositivo(this, "% Ganho sobre Valor Aliena\u00e7\u00e3o - Rendimentos em ME", 11, 6);
    private ValorPositivo ganhoCapital1ProporcionalOrigemMEDolar = new ValorPositivo(this, CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_ME_DOLAR);
    private ValorPositivo ganhoCapital1ProporcionalOrigemMEReal = new ValorPositivo(this, CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_ME_REAL);
    private ValorPositivo cotacaoDolar = new ValorPositivo(this, "Cota\u00e7\u00e3o da moeda estrangeira na Data do Recebimento da Parcela", 11, 4);
    private Valor valorAjuste = new Valor((ObjetoNegocio)this, "Valor de Ajuste");
    private ValorPositivo impostoPagoExterior = new ValorPositivo(this, CAMPO_IMPOSTO_PAGO_EXTERIOR_PASSIVEL_COMPENSACAO);
    private ValorPositivo custoAquisicaoProporcionalOrigemNacionalReal = new ValorPositivo(this, CAMPO_CUSTO_AQUISICAO_PROPORCIONAL_NACIONAL_REAL);
    private ValorPositivo custoAquisicaoTornaProporcionalOrigemNacionalReal = new ValorPositivo(this, CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL_NACIONAL_REAL);
    private ValorPositivo custoAquisicaoProporcionalOrigemMEDolar = new ValorPositivo(this, CAMPO_CUSTO_AQUISICAO_PROPORCIONAL_ME_DOLAR);
    private ValorPositivo custoAquisicaoTornaProporcionalOrigemMEDolar = new ValorPositivo(this, CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL_ME_DOLAR);
    private ValorPositivo ganhoCapital1ProporcionalTotalReal = new ValorPositivo(this, CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_TOTAL_REAL);
    private ValorPositivo percentualReducaoLei7713MN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 7.713, de 1988)", 3, 6);
    private ValorPositivo valorReducaoLei7713MN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - (R$)");
    private ValorPositivo ganhoCapital2ProporcionalMN = new ValorPositivo(this, CAMPO_GANHO_2_PROPORCIONAL_MN);
    private ValorPositivo percentualReducaoLei11196FR1MN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR1", 3, 6);
    private ValorPositivo valorReducaoLei11196FR1MN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR1 - (R$)");
    private ValorPositivo ganhoCapital3ProporcionalMN = new ValorPositivo(this, CAMPO_GANHO_3_PROPORCIONAL_MN);
    private ValorPositivo percentualReducaoLei11196FR2MN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR2", 3, 6);
    private ValorPositivo valorReducaoLei11196FR2MN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR2 - (R$)");
    private ValorPositivo ganhoCapital4ProporcionalMN = new ValorPositivo(this, CAMPO_GANHO_4_PROPORCIONAL_MN);
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovelMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo percentualReducaoAplicacaoOutroImovelMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel", 3, 6);
    private ValorPositivo valorReducaoAplicacaoOutroImovelMN = new ValorPositivo(this, "Valor calculado de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo percentualReducaoUnicoImovelMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo valorReducaoUnicoImovelMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo percentualReducaoBemPequenoValorMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo valorReducaoBemPequenoValorMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo ganhoCapital5ProporcionalMN = new ValorPositivo(this, CAMPO_GANHO_5_PROPORCIONAL_MN);
    private ValorPositivo percentualReducaoLei7713ME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 7.713, de 1988)", 3, 6);
    private ValorPositivo valorReducaoLei7713ME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - (R$)");
    private ValorPositivo ganhoCapital2ProporcionalME = new ValorPositivo(this, CAMPO_GANHO_2_PROPORCIONAL_ME);
    private ValorPositivo percentualReducaoLei11196FR1ME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR1", 3, 6);
    private ValorPositivo valorReducaoLei11196FR1ME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR1 - (R$)");
    private ValorPositivo ganhoCapital3ProporcionalME = new ValorPositivo(this, CAMPO_GANHO_3_PROPORCIONAL_ME);
    private ValorPositivo percentualReducaoLei11196FR2ME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR2", 3, 6);
    private ValorPositivo valorReducaoLei11196FR2ME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR2 - (R$)");
    private ValorPositivo ganhoCapital4ProporcionalME = new ValorPositivo(this, CAMPO_GANHO_4_PROPORCIONAL_ME);
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovelME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo percentualReducaoAplicacaoOutroImovelME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel", 3, 6);
    private ValorPositivo valorReducaoAplicacaoOutroImovelME = new ValorPositivo(this, "Valor calculado de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo percentualReducaoUnicoImovelME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo valorReducaoUnicoImovelME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo percentualReducaoBemPequenoValorME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo valorReducaoBemPequenoValorME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo ganhoCapital5ProporcionalME = new ValorPositivo(this, CAMPO_GANHO_5_PROPORCIONAL_ME);
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovelAmbas = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo ganhoCapital5ProporcionalTotalReal = new ValorPositivo(this, CAMPO_GANHO_CAPITAL_5_PROPORCIONAL_TOTAL_REAL);

    public ParcelaAlienacaoBem() {
        this.getUltimaParcela().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getUltimaParcela().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getValorLiquidoAlienacao().setReadOnly(true);
        this.getPercentualGanho().setReadOnly(true);
        this.getGanhoCapital1Proporcional().setReadOnly(true);
        this.getAliquotaMedia().setReadOnly(true);
        this.getImpostoDevido().setReadOnly(true);
        this.percentualGanhoOrigemNacional.setReadOnly(true);
        this.percentualGanhoOrigemME.setReadOnly(true);
        this.valorLiquidoAlienacaoDolar.setReadOnly(true);
        this.valorLiquidoAlienacaoReal.setReadOnly(true);
        this.ganhoCapital1ProporcionalOrigemNacionalReal.setReadOnly(true);
        this.ganhoCapital1ProporcionalOrigemMEReal.setReadOnly(true);
        this.ganhoCapital1ProporcionalOrigemMEDolar.setReadOnly(true);
        this.valorAlienacaoOrigemNacionalDolar.setReadOnly(true);
        this.valorAlienacaoOrigemMEDolar.setReadOnly(true);
        this.valorAlienacaoOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoProporcionalOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoTornaProporcionalOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoProporcionalOrigemMEDolar.setReadOnly(true);
        this.custoAquisicaoTornaProporcionalOrigemMEDolar.setReadOnly(true);
        this.ganhoCapital1ProporcionalTotalReal.setReadOnly(true);
        this.percentualReducaoLei7713MN.setReadOnly(true);
        this.valorReducaoLei7713MN.setReadOnly(true);
        this.ganhoCapital2ProporcionalMN.setReadOnly(true);
        this.percentualReducaoLei11196FR1MN.setReadOnly(true);
        this.valorReducaoLei11196FR1MN.setReadOnly(true);
        this.ganhoCapital3ProporcionalMN.setReadOnly(true);
        this.percentualReducaoLei11196FR2MN.setReadOnly(true);
        this.valorReducaoLei11196FR2MN.setReadOnly(true);
        this.ganhoCapital4ProporcionalMN.setReadOnly(true);
        this.percentualReducaoAplicacaoOutroImovelMN.setReadOnly(true);
        this.valorReducaoAplicacaoOutroImovelMN.setReadOnly(true);
        this.percentualReducaoUnicoImovelMN.setReadOnly(true);
        this.valorReducaoUnicoImovelMN.setReadOnly(true);
        this.percentualReducaoBemPequenoValorMN.setReadOnly(true);
        this.valorReducaoBemPequenoValorMN.setReadOnly(true);
        this.ganhoCapital5ProporcionalMN.setReadOnly(true);
        this.percentualReducaoLei7713ME.setReadOnly(true);
        this.valorReducaoLei7713ME.setReadOnly(true);
        this.ganhoCapital2ProporcionalME.setReadOnly(true);
        this.percentualReducaoLei11196FR1ME.setReadOnly(true);
        this.valorReducaoLei11196FR1ME.setReadOnly(true);
        this.ganhoCapital3ProporcionalME.setReadOnly(true);
        this.percentualReducaoLei11196FR2ME.setReadOnly(true);
        this.valorReducaoLei11196FR2ME.setReadOnly(true);
        this.ganhoCapital4ProporcionalME.setReadOnly(true);
        this.percentualReducaoAplicacaoOutroImovelME.setReadOnly(true);
        this.valorReducaoAplicacaoOutroImovelME.setReadOnly(true);
        this.percentualReducaoUnicoImovelME.setReadOnly(true);
        this.valorReducaoUnicoImovelME.setReadOnly(true);
        this.percentualReducaoBemPequenoValorME.setReadOnly(true);
        this.valorReducaoBemPequenoValorME.setReadOnly(true);
        this.ganhoCapital5ProporcionalME.setReadOnly(true);
        this.ganhoCapital5ProporcionalTotalReal.setReadOnly(true);
        this.adicionarValidadoresParcelaAlienacao();
    }

    private void adicionarValidadoresParcelaAlienacao() {
        this.getUltimaParcela().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("perguntaEmBranco", new String[]{this.getUltimaParcela().getNomeCampo()})));
        this.getCustoCorretagemDolar().addValidador((ValidadorIf)new ValidadorComparacaoValor(3, -3, (Object)this.getValorRecebidoDolar()));
        this.getValorInformadoReducaoAplicacaoOutroImovel().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP252(3, "valorAplicadoOutroImovelExcedido", false, this.getValorInformadoReducaoAplicacaoOutroImovel(), this.getValorLiquidoAlienacao()));
        this.getValorInformadoReducaoAplicacaoOutroImovelMN().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP252(3, "valorAplicadoOutroImovelExcedido", false, this.getValorInformadoReducaoAplicacaoOutroImovelMN(), this.getValorLiquidoAlienacaoReal()));
        this.getValorInformadoReducaoAplicacaoOutroImovelME().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP252(3, "valorAplicadoOutroImovelExcedidoME", true, this.getValorInformadoReducaoAplicacaoOutroImovelME(), this.getValorLiquidoAlienacaoReal()));
        this.getValorInformadoReducaoAplicacaoOutroImovelAmbas().addValidador((ValidadorIf)new ValidadorValorInformadoParcelaMP252(3, "valorAplicadoOutroImovelExcedidoME", true, this.getValorInformadoReducaoAplicacaoOutroImovelAmbas(), this.getValorLiquidoAlienacaoReal()));
    }

    public ValorPositivo getValorRecebidoDolar() {
        return this.valorRecebidoDolar;
    }

    public ValorPositivo getValorRecebidoReal() {
        return this.valorRecebidoReal;
    }

    public ValorPositivo getCustoCorretagemDolar() {
        return this.custoCorretagemDolar;
    }

    public ValorPositivo getValorLiquidoAlienacaoDolar() {
        return this.valorLiquidoAlienacaoDolar;
    }

    public ValorPositivo getValorLiquidoAlienacaoReal() {
        return this.valorLiquidoAlienacaoReal;
    }

    public ValorPositivo getValorAlienacaoOrigemNacionalDolar() {
        return this.valorAlienacaoOrigemNacionalDolar;
    }

    public ValorPositivo getValorAlienacaoOrigemNacionalReal() {
        return this.valorAlienacaoOrigemNacionalReal;
    }

    public ValorPositivo getPercentualGanhoOrigemNacional() {
        return this.percentualGanhoOrigemNacional;
    }

    public ValorPositivo getGanhoCapital1ProporcionalOrigemNacionalReal() {
        return this.ganhoCapital1ProporcionalOrigemNacionalReal;
    }

    public ValorPositivo getValorAlienacaoOrigemMEDolar() {
        return this.valorAlienacaoOrigemMEDolar;
    }

    public ValorPositivo getPercentualGanhoOrigemME() {
        return this.percentualGanhoOrigemME;
    }

    public ValorPositivo getGanhoCapital1ProporcionalOrigemMEDolar() {
        return this.ganhoCapital1ProporcionalOrigemMEDolar;
    }

    public ValorPositivo getGanhoCapital1ProporcionalOrigemMEReal() {
        return this.ganhoCapital1ProporcionalOrigemMEReal;
    }

    public ValorPositivo getCotacaoDolar() {
        return this.cotacaoDolar;
    }

    public Valor getValorAjuste() {
        return this.valorAjuste;
    }

    public ValorPositivo getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public String getClasseFicha() {
        return null;
    }

    public String getNomeAba() {
        return null;
    }

    @Override
    public boolean isUltimaParcela() {
        return Logico.SIM.equals(this.getUltimaParcela().naoFormatado());
    }

    @Override
    public ParcelaAlienacaoBem obterCopia() {
        ParcelaAlienacaoBem clone = new ParcelaAlienacaoBem();
        clone.getUltimaParcela().setConteudo(this.getUltimaParcela());
        clone.getDataRecebimento().setConteudo(this.getDataRecebimento());
        clone.getValorRecebido().setConteudo(this.getValorRecebido());
        clone.getPercentualGanho().setConteudo(this.getPercentualGanho());
        clone.getGanhoCapital1Proporcional().setConteudo(this.getGanhoCapital1Proporcional());
        clone.getValorRecebidoDolar().setConteudo(this.getValorRecebidoDolar());
        clone.getCustoCorretagemDolar().setConteudo(this.getCustoCorretagemDolar());
        clone.getValorLiquidoAlienacaoDolar().setConteudo(this.getValorLiquidoAlienacaoDolar());
        clone.getValorAlienacaoOrigemNacionalDolar().setConteudo(this.getValorAlienacaoOrigemNacionalDolar());
        clone.getValorAlienacaoOrigemNacionalReal().setConteudo(this.getValorAlienacaoOrigemNacionalReal());
        clone.getPercentualGanhoOrigemNacional().setConteudo(this.getPercentualGanhoOrigemNacional());
        clone.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(this.getGanhoCapital1ProporcionalOrigemNacionalReal());
        clone.getValorAlienacaoOrigemMEDolar().setConteudo(this.getValorAlienacaoOrigemMEDolar());
        clone.getPercentualGanhoOrigemME().setConteudo(this.getPercentualGanhoOrigemME());
        clone.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(this.getGanhoCapital1ProporcionalOrigemMEDolar());
        clone.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(this.getGanhoCapital1ProporcionalOrigemMEReal());
        clone.getGanhoCapitalTotal().setConteudo(this.getGanhoCapitalTotal());
        clone.getAliquotaMedia().setConteudo(this.getAliquotaMedia());
        clone.getCotacaoDolar().setConteudo(this.getCotacaoDolar());
        clone.getImpostoDevido().setConteudo(this.getImpostoDevido());
        clone.getValorAjuste().setConteudo(this.getValorAjuste());
        clone.getImpostoPagoExterior().setConteudo(this.getImpostoPagoExterior());
        clone.getImpostoDevido2().setConteudo(this.getImpostoDevido2());
        clone.getImpostoPago().setConteudo(this.getImpostoPago());
        clone.getCustoAquisicaoProporcional().setConteudo(this.getCustoAquisicaoProporcional());
        clone.getCustoAquisicaoTornaProporcional().setConteudo(this.getCustoAquisicaoTornaProporcional());
        clone.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(this.getCustoAquisicaoProporcionalOrigemNacionalReal());
        clone.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().setConteudo(this.getCustoAquisicaoTornaProporcionalOrigemNacionalReal());
        clone.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(this.getCustoAquisicaoProporcionalOrigemMEDolar());
        clone.getCustoAquisicaoTornaProporcionalOrigemMEDolar().setConteudo(this.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
        clone.getPercentualReducaoLei7713().setConteudo(this.getPercentualReducaoLei7713());
        clone.getValorReducaoLei7713().setConteudo(this.getValorReducaoLei7713());
        clone.getGanhoCapital2Proporcional().setConteudo(this.getGanhoCapital2Proporcional());
        clone.getPercentualReducaoLei11196FR1().setConteudo(this.getPercentualReducaoLei11196FR1());
        clone.getValorReducaoLei11196FR1().setConteudo(this.getValorReducaoLei11196FR1());
        clone.getGanhoCapital3Proporcional().setConteudo(this.getGanhoCapital3Proporcional());
        clone.getPercentualReducaoLei11196FR2().setConteudo(this.getPercentualReducaoLei11196FR2());
        clone.getValorReducaoLei11196FR2().setConteudo(this.getValorReducaoLei11196FR2());
        clone.getGanhoCapital4Proporcional().setConteudo(this.getGanhoCapital4Proporcional());
        clone.getPercentualReducaoAplicacaoOutroImovel().setConteudo(this.getPercentualReducaoAplicacaoOutroImovel());
        clone.getValorReducaoAplicacaoOutroImovel().setConteudo(this.getValorReducaoAplicacaoOutroImovel());
        clone.getPercentualReducaoUnicoImovel().setConteudo(this.getPercentualReducaoUnicoImovel());
        clone.getValorReducaoUnicoImovel().setConteudo(this.getValorReducaoUnicoImovel());
        clone.getPercentualReducaoBemPequenoValor().setConteudo(this.getPercentualReducaoBemPequenoValor());
        clone.getValorReducaoBemPequenoValor().setConteudo(this.getValorReducaoBemPequenoValor());
        clone.getGanhoCapital5Proporcional().setConteudo(this.getGanhoCapital5Proporcional());
        clone.getPercentualReducaoLei7713MN().setConteudo(this.getPercentualReducaoLei7713MN());
        clone.getValorReducaoLei7713MN().setConteudo(this.getValorReducaoLei7713MN());
        clone.getGanhoCapital2ProporcionalMN().setConteudo(this.getGanhoCapital2ProporcionalMN());
        clone.getPercentualReducaoLei11196FR1MN().setConteudo(this.getPercentualReducaoLei11196FR1MN());
        clone.getValorReducaoLei11196FR1MN().setConteudo(this.getValorReducaoLei11196FR1MN());
        clone.getGanhoCapital3ProporcionalMN().setConteudo(this.getGanhoCapital3ProporcionalMN());
        clone.getPercentualReducaoLei11196FR2MN().setConteudo(this.getPercentualReducaoLei11196FR2MN());
        clone.getValorReducaoLei11196FR2MN().setConteudo(this.getValorReducaoLei11196FR2MN());
        clone.getGanhoCapital4ProporcionalMN().setConteudo(this.getGanhoCapital4ProporcionalMN());
        clone.getPercentualReducaoAplicacaoOutroImovelMN().setConteudo(this.getPercentualReducaoAplicacaoOutroImovelMN());
        clone.getValorReducaoAplicacaoOutroImovelMN().setConteudo(this.getValorReducaoAplicacaoOutroImovelMN());
        clone.getPercentualReducaoUnicoImovelMN().setConteudo(this.getPercentualReducaoUnicoImovelMN());
        clone.getValorReducaoUnicoImovelMN().setConteudo(this.getValorReducaoUnicoImovelMN());
        clone.getPercentualReducaoBemPequenoValorMN().setConteudo(this.getPercentualReducaoBemPequenoValorMN());
        clone.getValorReducaoBemPequenoValorMN().setConteudo(this.getValorReducaoBemPequenoValorMN());
        clone.getGanhoCapital5ProporcionalMN().setConteudo(this.getGanhoCapital5ProporcionalMN());
        clone.getPercentualReducaoLei7713ME().setConteudo(this.getPercentualReducaoLei7713ME());
        clone.getValorReducaoLei7713ME().setConteudo(this.getValorReducaoLei7713ME());
        clone.getGanhoCapital2ProporcionalME().setConteudo(this.getGanhoCapital2ProporcionalME());
        clone.getPercentualReducaoLei11196FR1ME().setConteudo(this.getPercentualReducaoLei11196FR1ME());
        clone.getValorReducaoLei11196FR1ME().setConteudo(this.getValorReducaoLei11196FR1ME());
        clone.getGanhoCapital3ProporcionalME().setConteudo(this.getGanhoCapital3ProporcionalME());
        clone.getPercentualReducaoLei11196FR2ME().setConteudo(this.getPercentualReducaoLei11196FR2ME());
        clone.getValorReducaoLei11196FR2ME().setConteudo(this.getValorReducaoLei11196FR2ME());
        clone.getGanhoCapital4ProporcionalME().setConteudo(this.getGanhoCapital4ProporcionalME());
        clone.getPercentualReducaoAplicacaoOutroImovelME().setConteudo(this.getPercentualReducaoAplicacaoOutroImovelME());
        clone.getValorReducaoAplicacaoOutroImovelME().setConteudo(this.getValorReducaoAplicacaoOutroImovelME());
        clone.getPercentualReducaoUnicoImovelME().setConteudo(this.getPercentualReducaoUnicoImovelME());
        clone.getValorReducaoUnicoImovelME().setConteudo(this.getValorReducaoUnicoImovelME());
        clone.getPercentualReducaoBemPequenoValorME().setConteudo(this.getPercentualReducaoBemPequenoValorME());
        clone.getValorReducaoBemPequenoValorME().setConteudo(this.getValorReducaoBemPequenoValorME());
        clone.getGanhoCapital5ProporcionalME().setConteudo(this.getGanhoCapital5ProporcionalME());
        clone.getGanhoCapital5ProporcionalTotalReal().setConteudo(this.getGanhoCapital5ProporcionalTotalReal());
        return clone;
    }

    public void restaurar(ParcelaAlienacaoBem parcela) {
        this.getUltimaParcela().setConteudo(parcela.getUltimaParcela());
        this.getDataRecebimento().setConteudo(parcela.getDataRecebimento());
        this.getValorRecebido().setConteudo(parcela.getValorRecebido());
        this.getPercentualGanho().setConteudo(parcela.getPercentualGanho());
        this.getGanhoCapital1Proporcional().setConteudo(parcela.getGanhoCapital1Proporcional());
        this.getValorRecebidoDolar().setConteudo(parcela.getValorRecebidoDolar());
        this.getCustoCorretagemDolar().setConteudo(parcela.getCustoCorretagemDolar());
        this.getValorLiquidoAlienacaoDolar().setConteudo(parcela.getValorLiquidoAlienacaoDolar());
        this.getValorAlienacaoOrigemNacionalDolar().setConteudo(parcela.getValorAlienacaoOrigemNacionalDolar());
        this.getValorAlienacaoOrigemNacionalReal().setConteudo(parcela.getValorAlienacaoOrigemNacionalReal());
        this.getPercentualGanhoOrigemNacional().setConteudo(parcela.getPercentualGanhoOrigemNacional());
        this.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        this.getValorAlienacaoOrigemMEDolar().setConteudo(parcela.getValorAlienacaoOrigemMEDolar());
        this.getPercentualGanhoOrigemME().setConteudo(parcela.getPercentualGanhoOrigemME());
        this.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
        this.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        this.getGanhoCapitalTotal().setConteudo(parcela.getGanhoCapitalTotal());
        this.getAliquotaMedia().setConteudo(parcela.getAliquotaMedia());
        this.getCotacaoDolar().setConteudo(parcela.getCotacaoDolar());
        this.getImpostoDevido().setConteudo(parcela.getImpostoDevido());
        this.getValorAjuste().setConteudo(parcela.getValorAjuste());
        this.getImpostoPagoExterior().setConteudo(parcela.getImpostoPagoExterior());
        this.getImpostoDevido2().setConteudo(parcela.getImpostoDevido2());
        this.getImpostoPago().setConteudo(parcela.getImpostoPago());
        this.getCustoAquisicaoProporcional().setConteudo(parcela.getCustoAquisicaoProporcional());
        this.getCustoAquisicaoTornaProporcional().setConteudo(parcela.getCustoAquisicaoTornaProporcional());
        this.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
        this.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().setConteudo(parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal());
        this.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
        this.getCustoAquisicaoTornaProporcionalOrigemMEDolar().setConteudo(parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
        this.getPercentualReducaoLei7713().setConteudo(parcela.getPercentualReducaoLei7713());
        this.getValorReducaoLei7713().setConteudo(parcela.getValorReducaoLei7713());
        this.getGanhoCapital2Proporcional().setConteudo(parcela.getGanhoCapital2Proporcional());
        this.getPercentualReducaoLei11196FR1().setConteudo(parcela.getPercentualReducaoLei11196FR1());
        this.getValorReducaoLei11196FR1().setConteudo(parcela.getValorReducaoLei11196FR1());
        this.getGanhoCapital3Proporcional().setConteudo(parcela.getGanhoCapital3Proporcional());
        this.getPercentualReducaoLei11196FR2().setConteudo(parcela.getPercentualReducaoLei11196FR2());
        this.getValorReducaoLei11196FR2().setConteudo(parcela.getValorReducaoLei11196FR2());
        this.getGanhoCapital4Proporcional().setConteudo(parcela.getGanhoCapital4Proporcional());
        this.getPercentualReducaoAplicacaoOutroImovel().setConteudo(parcela.getPercentualReducaoAplicacaoOutroImovel());
        this.getValorReducaoAplicacaoOutroImovel().setConteudo(parcela.getValorReducaoAplicacaoOutroImovel());
        this.getPercentualReducaoUnicoImovel().setConteudo(parcela.getPercentualReducaoUnicoImovel());
        this.getValorReducaoUnicoImovel().setConteudo(parcela.getValorReducaoUnicoImovel());
        this.getPercentualReducaoBemPequenoValor().setConteudo(parcela.getPercentualReducaoBemPequenoValor());
        this.getValorReducaoBemPequenoValor().setConteudo(parcela.getValorReducaoBemPequenoValor());
        this.getGanhoCapital5Proporcional().setConteudo(parcela.getGanhoCapital5Proporcional());
        this.getPercentualReducaoLei7713MN().setConteudo(parcela.getPercentualReducaoLei7713MN());
        this.getValorReducaoLei7713MN().setConteudo(parcela.getValorReducaoLei7713MN());
        this.getGanhoCapital2ProporcionalMN().setConteudo(parcela.getGanhoCapital2ProporcionalMN());
        this.getPercentualReducaoLei11196FR1MN().setConteudo(parcela.getPercentualReducaoLei11196FR1MN());
        this.getValorReducaoLei11196FR1MN().setConteudo(parcela.getValorReducaoLei11196FR1MN());
        this.getGanhoCapital3ProporcionalMN().setConteudo(parcela.getGanhoCapital3ProporcionalMN());
        this.getPercentualReducaoLei11196FR2MN().setConteudo(parcela.getPercentualReducaoLei11196FR2MN());
        this.getValorReducaoLei11196FR2MN().setConteudo(parcela.getValorReducaoLei11196FR2MN());
        this.getGanhoCapital4ProporcionalMN().setConteudo(parcela.getGanhoCapital4ProporcionalMN());
        this.getPercentualReducaoAplicacaoOutroImovelMN().setConteudo(parcela.getPercentualReducaoAplicacaoOutroImovelMN());
        this.getValorReducaoAplicacaoOutroImovelMN().setConteudo(parcela.getValorReducaoAplicacaoOutroImovelMN());
        this.getPercentualReducaoUnicoImovelMN().setConteudo(parcela.getPercentualReducaoUnicoImovelMN());
        this.getValorReducaoUnicoImovelMN().setConteudo(parcela.getValorReducaoUnicoImovelMN());
        this.getPercentualReducaoBemPequenoValorMN().setConteudo(parcela.getPercentualReducaoBemPequenoValorMN());
        this.getValorReducaoBemPequenoValorMN().setConteudo(parcela.getValorReducaoBemPequenoValorMN());
        this.getGanhoCapital5ProporcionalMN().setConteudo(parcela.getGanhoCapital5ProporcionalMN());
        this.getPercentualReducaoLei7713ME().setConteudo(parcela.getPercentualReducaoLei7713ME());
        this.getValorReducaoLei7713ME().setConteudo(parcela.getValorReducaoLei7713ME());
        this.getGanhoCapital2ProporcionalME().setConteudo(parcela.getGanhoCapital2ProporcionalME());
        this.getPercentualReducaoLei11196FR1ME().setConteudo(parcela.getPercentualReducaoLei11196FR1ME());
        this.getValorReducaoLei11196FR1ME().setConteudo(parcela.getValorReducaoLei11196FR1ME());
        this.getGanhoCapital3ProporcionalME().setConteudo(parcela.getGanhoCapital3ProporcionalME());
        this.getPercentualReducaoLei11196FR2ME().setConteudo(parcela.getPercentualReducaoLei11196FR2ME());
        this.getValorReducaoLei11196FR2ME().setConteudo(parcela.getValorReducaoLei11196FR2ME());
        this.getGanhoCapital4ProporcionalME().setConteudo(parcela.getGanhoCapital4ProporcionalME());
        this.getPercentualReducaoAplicacaoOutroImovelME().setConteudo(parcela.getPercentualReducaoAplicacaoOutroImovelME());
        this.getValorReducaoAplicacaoOutroImovelME().setConteudo(parcela.getValorReducaoAplicacaoOutroImovelME());
        this.getPercentualReducaoUnicoImovelME().setConteudo(parcela.getPercentualReducaoUnicoImovelME());
        this.getValorReducaoUnicoImovelME().setConteudo(parcela.getValorReducaoUnicoImovelME());
        this.getPercentualReducaoBemPequenoValorME().setConteudo(parcela.getPercentualReducaoBemPequenoValorME());
        this.getValorReducaoBemPequenoValorME().setConteudo(parcela.getValorReducaoBemPequenoValorME());
        this.getGanhoCapital5ProporcionalME().setConteudo(parcela.getGanhoCapital5ProporcionalME());
        this.getGanhoCapital5ProporcionalTotalReal().setConteudo(parcela.getGanhoCapital5ProporcionalTotalReal());
    }

    @Override
    public void addObservador(Observador obs) {
        this.getValorRecebido().addObservador(obs);
        this.getCustoCorretagem().addObservador(obs);
        this.getValorLiquidoAlienacao().addObservador(obs);
        this.getCustoAquisicaoTornaProporcional().addObservador(obs);
        this.getGanhoCapital1Proporcional().addObservador(obs);
        this.getPercentualReducaoLei7713().addObservador(obs);
        this.getValorReducaoLei7713().addObservador(obs);
        this.getGanhoCapital2Proporcional().addObservador(obs);
        this.getPercentualReducaoLei11196FR1().addObservador(obs);
        this.getValorReducaoLei11196FR1().addObservador(obs);
        this.getGanhoCapital3Proporcional().addObservador(obs);
        this.getPercentualReducaoLei11196FR2().addObservador(obs);
        this.getValorReducaoLei11196FR2().addObservador(obs);
        this.getGanhoCapital4Proporcional().addObservador(obs);
        this.getPercentualReducaoAplicacaoOutroImovel().addObservador(obs);
        this.getValorReducaoAplicacaoOutroImovel().addObservador(obs);
        this.getPercentualReducaoUnicoImovel().addObservador(obs);
        this.getValorReducaoUnicoImovel().addObservador(obs);
        this.getPercentualReducaoBemPequenoValor().addObservador(obs);
        this.getValorReducaoBemPequenoValor().addObservador(obs);
        this.getGanhoCapital5Proporcional().addObservador(obs);
        this.getImpostoDevido().addObservador(obs);
        this.getImpostoPagoExterior().addObservador(obs);
        this.getImpostoDevido2().addObservador(obs);
        this.getImpostoPago().addObservador(obs);
        this.getValorRecebidoDolar().addObservador(obs);
        this.getValorRecebidoReal().addObservador(obs);
        this.getCustoCorretagemDolar().addObservador(obs);
        this.getValorLiquidoAlienacaoDolar().addObservador(obs);
        this.getValorLiquidoAlienacaoReal().addObservador(obs);
        this.getGanhoCapital1ProporcionalOrigemNacionalReal().addObservador(obs);
        this.getGanhoCapital1ProporcionalOrigemMEDolar().addObservador(obs);
        this.getGanhoCapital1ProporcionalOrigemMEReal().addObservador(obs);
        this.getGanhoCapital1ProporcionalTotalReal().addObservador(obs);
        this.getCustoAquisicaoProporcional().addObservador(obs);
        this.getCustoAquisicaoProporcionalOrigemNacionalReal().addObservador(obs);
        this.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().addObservador(obs);
        this.getCustoAquisicaoProporcionalOrigemMEDolar().addObservador(obs);
        this.getCustoAquisicaoTornaProporcionalOrigemMEDolar().addObservador(obs);
        this.percentualReducaoLei7713MN.addObservador(obs);
        this.valorReducaoLei7713MN.addObservador(obs);
        this.ganhoCapital2ProporcionalMN.addObservador(obs);
        this.percentualReducaoLei11196FR1MN.addObservador(obs);
        this.valorReducaoLei11196FR1MN.addObservador(obs);
        this.ganhoCapital3ProporcionalMN.addObservador(obs);
        this.percentualReducaoLei11196FR2MN.addObservador(obs);
        this.valorReducaoLei11196FR2MN.addObservador(obs);
        this.ganhoCapital4ProporcionalMN.addObservador(obs);
        this.percentualReducaoAplicacaoOutroImovelMN.addObservador(obs);
        this.valorReducaoAplicacaoOutroImovelMN.addObservador(obs);
        this.percentualReducaoUnicoImovelMN.addObservador(obs);
        this.valorReducaoUnicoImovelMN.addObservador(obs);
        this.percentualReducaoBemPequenoValorMN.addObservador(obs);
        this.valorReducaoBemPequenoValorMN.addObservador(obs);
        this.ganhoCapital5ProporcionalMN.addObservador(obs);
        this.percentualReducaoLei7713ME.addObservador(obs);
        this.valorReducaoLei7713ME.addObservador(obs);
        this.ganhoCapital2ProporcionalME.addObservador(obs);
        this.percentualReducaoLei11196FR1ME.addObservador(obs);
        this.valorReducaoLei11196FR1ME.addObservador(obs);
        this.ganhoCapital3ProporcionalME.addObservador(obs);
        this.percentualReducaoLei11196FR2ME.addObservador(obs);
        this.valorReducaoLei11196FR2ME.addObservador(obs);
        this.ganhoCapital4ProporcionalME.addObservador(obs);
        this.percentualReducaoAplicacaoOutroImovelME.addObservador(obs);
        this.valorReducaoAplicacaoOutroImovelME.addObservador(obs);
        this.percentualReducaoUnicoImovelME.addObservador(obs);
        this.valorReducaoUnicoImovelME.addObservador(obs);
        this.percentualReducaoBemPequenoValorME.addObservador(obs);
        this.valorReducaoBemPequenoValorME.addObservador(obs);
        this.ganhoCapital5ProporcionalME.addObservador(obs);
        this.ganhoCapital5ProporcionalTotalReal.addObservador(obs);
    }

    @Override
    public void removeObservador(Observador obs) {
        this.getValorRecebido().removeObservador(obs);
        this.getCustoCorretagem().removeObservador(obs);
        this.getValorLiquidoAlienacao().removeObservador(obs);
        this.getCustoAquisicaoTornaProporcional().removeObservador(obs);
        this.getGanhoCapital1Proporcional().removeObservador(obs);
        this.getPercentualReducaoLei7713().removeObservador(obs);
        this.getValorReducaoLei7713().removeObservador(obs);
        this.getGanhoCapital2Proporcional().removeObservador(obs);
        this.getPercentualReducaoLei11196FR1().removeObservador(obs);
        this.getValorReducaoLei11196FR1().removeObservador(obs);
        this.getGanhoCapital3Proporcional().removeObservador(obs);
        this.getPercentualReducaoLei11196FR2().removeObservador(obs);
        this.getValorReducaoLei11196FR2().removeObservador(obs);
        this.getGanhoCapital4Proporcional().removeObservador(obs);
        this.getPercentualReducaoAplicacaoOutroImovel().removeObservador(obs);
        this.getValorReducaoAplicacaoOutroImovel().removeObservador(obs);
        this.getPercentualReducaoUnicoImovel().removeObservador(obs);
        this.getValorReducaoUnicoImovel().removeObservador(obs);
        this.getPercentualReducaoBemPequenoValor().removeObservador(obs);
        this.getValorReducaoBemPequenoValor().removeObservador(obs);
        this.getGanhoCapital5Proporcional().removeObservador(obs);
        this.getImpostoDevido().removeObservador(obs);
        this.getImpostoPagoExterior().addObservador(obs);
        this.getImpostoDevido2().addObservador(obs);
        this.getImpostoPago().removeObservador(obs);
        this.getValorRecebidoDolar().removeObservador(obs);
        this.getValorRecebidoReal().removeObservador(obs);
        this.getCustoCorretagemDolar().removeObservador(obs);
        this.getValorLiquidoAlienacaoDolar().removeObservador(obs);
        this.getValorLiquidoAlienacaoReal().removeObservador(obs);
        this.getGanhoCapital1ProporcionalOrigemNacionalReal().removeObservador(obs);
        this.getGanhoCapital1ProporcionalOrigemMEDolar().removeObservador(obs);
        this.getGanhoCapital1ProporcionalOrigemMEReal().removeObservador(obs);
        this.getGanhoCapital1ProporcionalTotalReal().removeObservador(obs);
        this.getCustoAquisicaoProporcional().removeObservador(obs);
        this.getCustoAquisicaoProporcionalOrigemNacionalReal().removeObservador(obs);
        this.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().removeObservador(obs);
        this.getCustoAquisicaoProporcionalOrigemMEDolar().removeObservador(obs);
        this.getCustoAquisicaoTornaProporcionalOrigemMEDolar().removeObservador(obs);
        this.percentualReducaoLei7713MN.removeObservador(obs);
        this.valorReducaoLei7713MN.removeObservador(obs);
        this.ganhoCapital2ProporcionalMN.removeObservador(obs);
        this.percentualReducaoLei11196FR1MN.removeObservador(obs);
        this.valorReducaoLei11196FR1MN.removeObservador(obs);
        this.ganhoCapital3ProporcionalMN.removeObservador(obs);
        this.percentualReducaoLei11196FR2MN.removeObservador(obs);
        this.valorReducaoLei11196FR2MN.removeObservador(obs);
        this.ganhoCapital4ProporcionalMN.removeObservador(obs);
        this.percentualReducaoAplicacaoOutroImovelMN.removeObservador(obs);
        this.valorReducaoAplicacaoOutroImovelMN.removeObservador(obs);
        this.percentualReducaoUnicoImovelMN.removeObservador(obs);
        this.valorReducaoUnicoImovelMN.removeObservador(obs);
        this.percentualReducaoBemPequenoValorMN.removeObservador(obs);
        this.valorReducaoBemPequenoValorMN.removeObservador(obs);
        this.ganhoCapital5ProporcionalMN.removeObservador(obs);
        this.percentualReducaoLei7713ME.removeObservador(obs);
        this.valorReducaoLei7713ME.removeObservador(obs);
        this.ganhoCapital2ProporcionalME.removeObservador(obs);
        this.percentualReducaoLei11196FR1ME.removeObservador(obs);
        this.valorReducaoLei11196FR1ME.removeObservador(obs);
        this.ganhoCapital3ProporcionalME.removeObservador(obs);
        this.percentualReducaoLei11196FR2ME.removeObservador(obs);
        this.valorReducaoLei11196FR2ME.removeObservador(obs);
        this.ganhoCapital4ProporcionalME.removeObservador(obs);
        this.percentualReducaoAplicacaoOutroImovelME.removeObservador(obs);
        this.valorReducaoAplicacaoOutroImovelME.removeObservador(obs);
        this.percentualReducaoUnicoImovelME.removeObservador(obs);
        this.valorReducaoUnicoImovelME.removeObservador(obs);
        this.percentualReducaoBemPequenoValorME.removeObservador(obs);
        this.valorReducaoBemPequenoValorME.removeObservador(obs);
        this.ganhoCapital5ProporcionalME.removeObservador(obs);
        this.ganhoCapital5ProporcionalTotalReal.removeObservador(obs);
    }

    @Override
    public boolean isVazio() {
        return this.getDataRecebimento().isVazio() && this.getValorRecebido().isVazio() && this.getValorRecebidoDolar().isVazio();
    }

    public ValorPositivo getCustoAquisicaoProporcionalOrigemNacionalReal() {
        return this.custoAquisicaoProporcionalOrigemNacionalReal;
    }

    public ValorPositivo getCustoAquisicaoTornaProporcionalOrigemNacionalReal() {
        return this.custoAquisicaoTornaProporcionalOrigemNacionalReal;
    }

    public ValorPositivo getCustoAquisicaoProporcionalOrigemMEDolar() {
        return this.custoAquisicaoProporcionalOrigemMEDolar;
    }

    public ValorPositivo getCustoAquisicaoTornaProporcionalOrigemMEDolar() {
        return this.custoAquisicaoTornaProporcionalOrigemMEDolar;
    }

    @Override
    public List<Informacao> recuperarListaCamposPendenciaAbaCalculo() {
        ArrayList<Informacao> campos = new ArrayList<Informacao>();
        campos.add((Informacao)this.getUltimaParcela());
        campos.add((Informacao)this.getDataRecebimento());
        campos.add((Informacao)this.getValorRecebido());
        campos.add((Informacao)this.getValorRecebidoDolar());
        campos.add((Informacao)this.getCustoCorretagem());
        campos.add((Informacao)this.getCustoCorretagemDolar());
        campos.add((Informacao)this.getCotacaoDolar());
        campos.add((Informacao)this.getValorInformadoReducaoAplicacaoOutroImovel());
        campos.add((Informacao)this.getValorInformadoReducaoAplicacaoOutroImovelMN());
        campos.add((Informacao)this.getValorInformadoReducaoAplicacaoOutroImovelME());
        campos.add((Informacao)this.getImpostoPagoExterior());
        return campos;
    }

    public ValorPositivo getGanhoCapital1ProporcionalTotalReal() {
        return this.ganhoCapital1ProporcionalTotalReal;
    }

    public ValorPositivo getPercentualReducaoLei7713MN() {
        return this.percentualReducaoLei7713MN;
    }

    public ValorPositivo getValorReducaoLei7713MN() {
        return this.valorReducaoLei7713MN;
    }

    public ValorPositivo getGanhoCapital2ProporcionalMN() {
        return this.ganhoCapital2ProporcionalMN;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1MN() {
        return this.percentualReducaoLei11196FR1MN;
    }

    public ValorPositivo getValorReducaoLei11196FR1MN() {
        return this.valorReducaoLei11196FR1MN;
    }

    public ValorPositivo getGanhoCapital3ProporcionalMN() {
        return this.ganhoCapital3ProporcionalMN;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2MN() {
        return this.percentualReducaoLei11196FR2MN;
    }

    public ValorPositivo getValorReducaoLei11196FR2MN() {
        return this.valorReducaoLei11196FR2MN;
    }

    public ValorPositivo getGanhoCapital4ProporcionalMN() {
        return this.ganhoCapital4ProporcionalMN;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovelMN() {
        return this.valorInformadoReducaoAplicacaoOutroImovelMN;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovelMN() {
        return this.percentualReducaoAplicacaoOutroImovelMN;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovelMN() {
        return this.valorReducaoAplicacaoOutroImovelMN;
    }

    public ValorPositivo getPercentualReducaoUnicoImovelMN() {
        return this.percentualReducaoUnicoImovelMN;
    }

    public ValorPositivo getValorReducaoUnicoImovelMN() {
        return this.valorReducaoUnicoImovelMN;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValorMN() {
        return this.percentualReducaoBemPequenoValorMN;
    }

    public ValorPositivo getValorReducaoBemPequenoValorMN() {
        return this.valorReducaoBemPequenoValorMN;
    }

    public ValorPositivo getGanhoCapital5ProporcionalMN() {
        return this.ganhoCapital5ProporcionalMN;
    }

    public ValorPositivo getPercentualReducaoLei7713ME() {
        return this.percentualReducaoLei7713ME;
    }

    public ValorPositivo getValorReducaoLei7713ME() {
        return this.valorReducaoLei7713ME;
    }

    public ValorPositivo getGanhoCapital2ProporcionalME() {
        return this.ganhoCapital2ProporcionalME;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1ME() {
        return this.percentualReducaoLei11196FR1ME;
    }

    public ValorPositivo getValorReducaoLei11196FR1ME() {
        return this.valorReducaoLei11196FR1ME;
    }

    public ValorPositivo getGanhoCapital3ProporcionalME() {
        return this.ganhoCapital3ProporcionalME;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2ME() {
        return this.percentualReducaoLei11196FR2ME;
    }

    public ValorPositivo getValorReducaoLei11196FR2ME() {
        return this.valorReducaoLei11196FR2ME;
    }

    public ValorPositivo getGanhoCapital4ProporcionalME() {
        return this.ganhoCapital4ProporcionalME;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovelME() {
        return this.valorInformadoReducaoAplicacaoOutroImovelME;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovelME() {
        return this.percentualReducaoAplicacaoOutroImovelME;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovelME() {
        return this.valorReducaoAplicacaoOutroImovelME;
    }

    public ValorPositivo getPercentualReducaoUnicoImovelME() {
        return this.percentualReducaoUnicoImovelME;
    }

    public ValorPositivo getValorReducaoUnicoImovelME() {
        return this.valorReducaoUnicoImovelME;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValorME() {
        return this.percentualReducaoBemPequenoValorME;
    }

    public ValorPositivo getValorReducaoBemPequenoValorME() {
        return this.valorReducaoBemPequenoValorME;
    }

    public ValorPositivo getGanhoCapital5ProporcionalME() {
        return this.ganhoCapital5ProporcionalME;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovelAmbas() {
        return this.valorInformadoReducaoAplicacaoOutroImovelAmbas;
    }

    public ValorPositivo getGanhoCapital5ProporcionalTotalReal() {
        return this.ganhoCapital5ProporcionalTotalReal;
    }

    public ValorPositivo obterSomatorioReducoesMN() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        somatorio.append('+', this.getValorReducaoLei7713MN());
        somatorio.append('+', this.getValorReducaoLei11196FR1MN());
        somatorio.append('+', this.getValorReducaoLei11196FR2MN());
        somatorio.append('+', this.getValorReducaoBemPequenoValorMN());
        somatorio.append('+', this.getValorReducaoUnicoImovelMN());
        somatorio.append('+', this.getValorReducaoAplicacaoOutroImovelMN());
        return somatorio;
    }

    public ValorPositivo obterSomatorioReducoesME() {
        ValorPositivo somatorio = new ValorPositivo();
        somatorio.clear();
        somatorio.append('+', this.getValorReducaoLei7713ME());
        somatorio.append('+', this.getValorReducaoLei11196FR1ME());
        somatorio.append('+', this.getValorReducaoLei11196FR2ME());
        somatorio.append('+', this.getValorReducaoBemPequenoValorME());
        somatorio.append('+', this.getValorReducaoUnicoImovelME());
        somatorio.append('+', this.getValorReducaoAplicacaoOutroImovelME());
        return somatorio;
    }
}

