/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.apuracao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.apuracao.ApuracaoBem;
import br.gov.serpro.gcap.entidades.apuracao.ColecaoParcelaApuracaoCustoAquisicao;
import br.gov.serpro.gcap.entidades.apuracao.ParcelaApuracaoCustoAquisicao;
import br.gov.serpro.gcap.negocio.CalculoImpostoDevidoUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.GcapUtil;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Observador;

public class ApuracaoBemImovel
extends ApuracaoBem {
    private ValorPositivo custoAquisicaoTorna = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o da torna (R$)");
    private ValorPositivo custoAquisicaoTornaOrigemMNReal = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o da torna - Origem em Moeda Nacional (R$)");
    private ValorPositivo custoAquisicaoTornaOrigemMEDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o da torna - Origem em Moeda Estrangeira (US$)");
    private ValorPositivo percentualReducaoLei7713 = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 7.713, de 1988)", 3, 6);
    private ValorPositivo percentualReducaoLei7713OrigemMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 7.713, de 1988) - Origem em Moeda Nacional", 3, 6);
    private ValorPositivo percentualReducaoLei7713OrigemME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 7.713, de 1988) - Origem em Moeda Estrangeira", 3, 6);
    private ValorPositivo valorReducaoLei7713 = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - (R$)");
    private ValorPositivo valorReducaoLei7713OrigemMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - Origem em Moeda Nacional - (R$)");
    private ValorPositivo valorReducaoLei7713OrigemME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo ganhoCapital2 = new ValorPositivo(this, "Ganho de capital - Resultado 2 - (R$)");
    private ValorPositivo ganhoCapital2OrigemMNReal = new ValorPositivo(this, "Ganho de capital - Resultado 2 - Origem em Moeda Nacional - (R$)");
    private ValorPositivo ganhoCapital2OrigemMEReal = new ValorPositivo(this, "Ganho de capital - Resultado 2 - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo percentualReducaoLei11196FR1 = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR1", 3, 6);
    private ValorPositivo percentualReducaoLei11196FR1OrigemMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR1 - Origem em Moeda Nacional", 3, 6);
    private ValorPositivo percentualReducaoLei11196FR1OrigemME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR1 - Origem em Moeda Estrangeira", 3, 6);
    private ValorPositivo valorReducaoLei11196FR1 = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR1 - (R$)");
    private ValorPositivo valorReducaoLei11196FR1OrigemMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR1 - Origem em Moeda Nacional - (R$)");
    private ValorPositivo valorReducaoLei11196FR1OrigemME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR1 - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo ganhoCapital3 = new ValorPositivo(this, "Ganho de capital - Resultado 3 - (R$)");
    private ValorPositivo ganhoCapital3OrigemMNReal = new ValorPositivo(this, "Ganho de capital - Resultado 3 - Origem em Moeda Nacional - (R$)");
    private ValorPositivo ganhoCapital3OrigemMEReal = new ValorPositivo(this, "Ganho de capital - Resultado 3 - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo percentualReducaoLei11196FR2 = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR2", 3, 6);
    private ValorPositivo percentualReducaoLei11196FR2OrigemMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR2 - Origem em Moeda Nacional", 3, 6);
    private ValorPositivo percentualReducaoLei11196FR2OrigemME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR2 - Origem em Moeda Estrangeira", 3, 6);
    private ValorPositivo valorReducaoLei11196FR2 = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR2 - (R$)");
    private ValorPositivo valorReducaoLei11196FR2OrigemMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR2 - Origem em Moeda Nacional - (R$)");
    private ValorPositivo valorReducaoLei11196FR2OrigemME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR2 - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo ganhoCapital4 = new ValorPositivo(this, "Ganho de capital - Resultado 4 - (R$)");
    private ValorPositivo ganhoCapital4OrigemMNReal = new ValorPositivo(this, "Ganho de capital - Resultado 4 - Origem em Moeda Nacional - (R$)");
    private ValorPositivo ganhoCapital4OrigemMEReal = new ValorPositivo(this, "Ganho de capital - Resultado 4 - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo percentualReducaoAplicacaoOutroImovel = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel", 3, 6);
    private ValorPositivo percentualReducaoAplicacaoOutroImovelOrigemMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - Origem em Moeda Nacional", 3, 6);
    private ValorPositivo percentualReducaoAplicacaoOutroImovelOrigemME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - Origem em Moeda Estrangeira", 3, 6);
    private ValorPositivo valorReducaoAplicacaoOutroImovel = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo valorReducaoAplicacaoOutroImovelOrigemMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - Origem em Moeda Nacional - (R$)");
    private ValorPositivo valorReducaoAplicacaoOutroImovelOrigemME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo percentualReducaoUnicoImovel = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo percentualReducaoUnicoImovelOrigemMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Nacional", 3, 6);
    private ValorPositivo percentualReducaoUnicoImovelOrigemME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Estrangeira", 3, 6);
    private ValorPositivo valorReducaoUnicoImovel = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo valorReducaoUnicoImovelOrigemMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Nacional - (R$)");
    private ValorPositivo valorReducaoUnicoImovelOrigemME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo percentualReducaoBemPequenoValor = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo percentualReducaoBemPequenoValorOrigemMN = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Nacional", 3, 6);
    private ValorPositivo percentualReducaoBemPequenoValorOrigemME = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Estrangeira", 3, 6);
    private ValorPositivo valorReducaoBemPequenoValor = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo valorReducaoBemPequenoValorOrigemMN = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Nacional - (R$)");
    private ValorPositivo valorReducaoBemPequenoValorOrigemME = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - Origem em Moeda Estrangeira - (R$)");
    private ValorPositivo ganhoCapital5 = new ValorPositivo(this, "Ganho de capital - Resultado 5 - (R$)");
    private ValorPositivo ganhoCapital5OrigemMNReal = new ValorPositivo(this, "Ganho de capital - Resultado 5 - Origem em Moeda Nacional - (R$)");
    private ValorPositivo ganhoCapital5OrigemMEReal = new ValorPositivo(this, "Ganho de capital - Resultado 5 - Origem em Moeda Estrangeira - (R$)");
    private ColecaoParcelaApuracaoCustoAquisicao parcelasCustoAquisicao = new ColecaoParcelaApuracaoCustoAquisicao();
    private ValorPositivo ganhoCapitalTotalExterior = new ValorPositivo(this, "Ganho de capital total (R$)");

    public ApuracaoBemImovel() {
        this.custoAquisicaoTorna.setReadOnly(true);
        this.custoAquisicaoTornaOrigemMNReal.setReadOnly(true);
        this.custoAquisicaoTornaOrigemMEDolar.setReadOnly(true);
        this.percentualReducaoLei7713.setReadOnly(true);
        this.percentualReducaoLei7713OrigemMN.setReadOnly(true);
        this.percentualReducaoLei7713OrigemME.setReadOnly(true);
        this.valorReducaoLei7713.setReadOnly(true);
        this.valorReducaoLei7713OrigemMN.setReadOnly(true);
        this.valorReducaoLei7713OrigemME.setReadOnly(true);
        this.ganhoCapital2.setReadOnly(true);
        this.ganhoCapital2OrigemMNReal.setReadOnly(true);
        this.ganhoCapital2OrigemMEReal.setReadOnly(true);
        this.percentualReducaoLei11196FR1.setReadOnly(true);
        this.percentualReducaoLei11196FR1OrigemMN.setReadOnly(true);
        this.percentualReducaoLei11196FR1OrigemME.setReadOnly(true);
        this.valorReducaoLei11196FR1.setReadOnly(true);
        this.valorReducaoLei11196FR1OrigemMN.setReadOnly(true);
        this.valorReducaoLei11196FR1OrigemME.setReadOnly(true);
        this.ganhoCapital3.setReadOnly(true);
        this.ganhoCapital3OrigemMNReal.setReadOnly(true);
        this.ganhoCapital3OrigemMEReal.setReadOnly(true);
        this.percentualReducaoLei11196FR2.setReadOnly(true);
        this.percentualReducaoLei11196FR2OrigemMN.setReadOnly(true);
        this.percentualReducaoLei11196FR2OrigemME.setReadOnly(true);
        this.valorReducaoLei11196FR2.setReadOnly(true);
        this.valorReducaoLei11196FR2OrigemMN.setReadOnly(true);
        this.valorReducaoLei11196FR2OrigemME.setReadOnly(true);
        this.ganhoCapital4.setReadOnly(true);
        this.ganhoCapital4OrigemMNReal.setReadOnly(true);
        this.ganhoCapital4OrigemMEReal.setReadOnly(true);
        this.percentualReducaoAplicacaoOutroImovel.setReadOnly(true);
        this.percentualReducaoAplicacaoOutroImovelOrigemMN.setReadOnly(true);
        this.percentualReducaoAplicacaoOutroImovelOrigemME.setReadOnly(true);
        this.valorReducaoAplicacaoOutroImovel.setReadOnly(true);
        this.valorReducaoAplicacaoOutroImovelOrigemMN.setReadOnly(true);
        this.valorReducaoAplicacaoOutroImovelOrigemME.setReadOnly(true);
        this.percentualReducaoUnicoImovel.setReadOnly(true);
        this.percentualReducaoUnicoImovelOrigemMN.setReadOnly(true);
        this.percentualReducaoUnicoImovelOrigemME.setReadOnly(true);
        this.valorReducaoUnicoImovel.setReadOnly(true);
        this.valorReducaoUnicoImovelOrigemMN.setReadOnly(true);
        this.valorReducaoUnicoImovelOrigemME.setReadOnly(true);
        this.percentualReducaoBemPequenoValor.setReadOnly(true);
        this.percentualReducaoBemPequenoValorOrigemMN.setReadOnly(true);
        this.percentualReducaoBemPequenoValorOrigemME.setReadOnly(true);
        this.valorReducaoBemPequenoValor.setReadOnly(true);
        this.valorReducaoBemPequenoValorOrigemMN.setReadOnly(true);
        this.valorReducaoBemPequenoValorOrigemME.setReadOnly(true);
        this.ganhoCapital5.setReadOnly(true);
        this.ganhoCapital5OrigemMNReal.setReadOnly(true);
        this.ganhoCapital5OrigemMEReal.setReadOnly(true);
        this.ganhoCapitalTotalExterior.setReadOnly(true);
        this.adicionarObservadoresCalculoApuracaoBemImovel();
    }

    public void adicionarObservadoresCalculoApuracaoBemImovel() {
        this.getCustoAquisicaoTorna().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.calcularGanhoCapital1(ApuracaoBemImovel.this.getValorLiquidoAlienacao(), ApuracaoBemImovel.this.getCustoAquisicao(), ApuracaoBemImovel.this.getCustoAquisicaoTorna());
            }
        });
        this.getCustoAquisicaoTornaOrigemMNReal().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.calcularGanhoCapital1OrigemMNReal(ApuracaoBemImovel.this.getValorLiquidoAlienacaoOrigemNacionalReal(), ApuracaoBemImovel.this.getCustoAquisicaoOrigemNacionalReal(), ApuracaoBemImovel.this.getCustoAquisicaoTornaOrigemMNReal());
            }
        });
        this.getCustoAquisicaoTornaOrigemMEDolar().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.calcularGanhoCapital1OrigemMEDolar(ApuracaoBemImovel.this.getValorLiquidoAlienacaoOrigemMEDolar(), ApuracaoBemImovel.this.getCustoAquisicaoOrigemMEDolar(), ApuracaoBemImovel.this.getCustoAquisicaoTornaOrigemMEDolar());
            }
        });
        Observador obsCalculoGanhoCapital2 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital2().setConteudo(ApuracaoBemImovel.this.getGanhoCapital1().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei7713()));
            }
        };
        this.getGanhoCapital1().addObservador(obsCalculoGanhoCapital2);
        this.getValorReducaoLei7713().addObservador(obsCalculoGanhoCapital2);
        Observador obsCalculaGanhoCapital2OrigemMN = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital2OrigemMNReal().setConteudo(ApuracaoBemImovel.this.getGanhoCapital1OrigemNacionalReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei7713OrigemMN()));
            }
        };
        this.getGanhoCapital1OrigemNacionalReal().addObservador(obsCalculaGanhoCapital2OrigemMN);
        this.getValorReducaoLei7713OrigemMN().addObservador(obsCalculaGanhoCapital2OrigemMN);
        Observador obsCalculaGanhoCapital1MEReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital2OrigemMEReal().setConteudo(ApuracaoBemImovel.this.getGanhoCapital1OrigemMEReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei7713OrigemME()));
            }
        };
        this.getGanhoCapital1OrigemMEReal().addObservador(obsCalculaGanhoCapital1MEReal);
        this.getValorReducaoLei7713OrigemME().addObservador(obsCalculaGanhoCapital1MEReal);
        Observador obsCalculoGanhoCapital3 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital3().setConteudo(ApuracaoBemImovel.this.getGanhoCapital2().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei11196FR1()));
            }
        };
        this.getGanhoCapital2().addObservador(obsCalculoGanhoCapital3);
        this.getValorReducaoLei11196FR1().addObservador(obsCalculoGanhoCapital3);
        Observador obsCalculaGanhoCapital3MNReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital3OrigemMNReal().setConteudo(ApuracaoBemImovel.this.getGanhoCapital2OrigemMNReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei11196FR1OrigemMN()));
            }
        };
        this.getGanhoCapital2OrigemMNReal().addObservador(obsCalculaGanhoCapital3MNReal);
        this.getValorReducaoLei11196FR1OrigemMN().addObservador(obsCalculaGanhoCapital3MNReal);
        Observador obsCalculaGanhoCapital3MEReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital3OrigemMEReal().setConteudo(ApuracaoBemImovel.this.getGanhoCapital2OrigemMEReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei11196FR1OrigemME()));
            }
        };
        this.getGanhoCapital2OrigemMEReal().addObservador(obsCalculaGanhoCapital3MEReal);
        this.getValorReducaoLei11196FR1OrigemME().addObservador(obsCalculaGanhoCapital3MEReal);
        Observador obsCalculoGanhoCapital4 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital4().setConteudo(ApuracaoBemImovel.this.getGanhoCapital3().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei11196FR2()));
            }
        };
        this.getGanhoCapital3().addObservador(obsCalculoGanhoCapital4);
        this.getValorReducaoLei11196FR2().addObservador(obsCalculoGanhoCapital4);
        Observador obsCalculaGanhoCapital4MNReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital4OrigemMNReal().setConteudo(ApuracaoBemImovel.this.getGanhoCapital3OrigemMNReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei11196FR2OrigemMN()));
            }
        };
        this.getGanhoCapital3OrigemMNReal().addObservador(obsCalculaGanhoCapital4MNReal);
        this.getValorReducaoLei11196FR2OrigemMN().addObservador(obsCalculaGanhoCapital4MNReal);
        Observador obsCalculaGanhoCapital4MEReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBemImovel.this.getGanhoCapital4OrigemMEReal().setConteudo(ApuracaoBemImovel.this.getGanhoCapital3OrigemMEReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoLei11196FR2OrigemME()));
            }
        };
        this.getGanhoCapital3OrigemMEReal().addObservador(obsCalculaGanhoCapital4MEReal);
        this.getValorReducaoLei11196FR2OrigemME().addObservador(obsCalculaGanhoCapital4MEReal);
        Observador obsCalculoGanhoCapital5 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ValorPositivo lValor = new ValorPositivo(null, "", 11, 2);
                lValor.setConteudo(ApuracaoBemImovel.this.getGanhoCapital4().operacao('-', ApuracaoBemImovel.this.getValorReducaoBemPequenoValor().operacao('+', ApuracaoBemImovel.this.getValorReducaoAplicacaoOutroImovel().operacao('+', ApuracaoBemImovel.this.getValorReducaoUnicoImovel()))));
                if (lValor.comparacao(">", "0,00")) {
                    ApuracaoBemImovel.this.getGanhoCapital5().setConteudo(lValor);
                } else {
                    ApuracaoBemImovel.this.getGanhoCapital5().clear();
                }
            }
        };
        this.getGanhoCapital4().addObservador(obsCalculoGanhoCapital5);
        this.getValorReducaoBemPequenoValor().addObservador(obsCalculoGanhoCapital5);
        this.getValorReducaoAplicacaoOutroImovel().addObservador(obsCalculoGanhoCapital5);
        this.getValorReducaoUnicoImovel().addObservador(obsCalculoGanhoCapital5);
        Observador obsCalculaGanhoCapital5MNReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ValorPositivo lValor = new ValorPositivo(null, "", 11, 2);
                lValor.setConteudo(ApuracaoBemImovel.this.getGanhoCapital4OrigemMNReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoBemPequenoValorOrigemMN().operacao('+', ApuracaoBemImovel.this.getValorReducaoAplicacaoOutroImovelOrigemMN().operacao('+', ApuracaoBemImovel.this.getValorReducaoUnicoImovelOrigemMN()))));
                if (lValor.comparacao(">", "0,00")) {
                    ApuracaoBemImovel.this.getGanhoCapital5OrigemMNReal().setConteudo(lValor);
                } else {
                    ApuracaoBemImovel.this.getGanhoCapital5OrigemMNReal().clear();
                }
            }
        };
        this.getGanhoCapital4OrigemMNReal().addObservador(obsCalculaGanhoCapital5MNReal);
        this.getValorReducaoBemPequenoValorOrigemMN().addObservador(obsCalculaGanhoCapital5MNReal);
        this.getValorReducaoAplicacaoOutroImovelOrigemMN().addObservador(obsCalculaGanhoCapital5MNReal);
        this.getValorReducaoUnicoImovelOrigemMN().addObservador(obsCalculaGanhoCapital5MNReal);
        Observador obsCalculaGanhoCapital5MEReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ValorPositivo lValor = new ValorPositivo(null, "", 11, 2);
                lValor.setConteudo(ApuracaoBemImovel.this.getGanhoCapital4OrigemMEReal().operacao('-', ApuracaoBemImovel.this.getValorReducaoBemPequenoValorOrigemME().operacao('+', ApuracaoBemImovel.this.getValorReducaoAplicacaoOutroImovelOrigemME().operacao('+', ApuracaoBemImovel.this.getValorReducaoUnicoImovelOrigemME()))));
                if (lValor.comparacao(">", "0,00")) {
                    ApuracaoBemImovel.this.getGanhoCapital5OrigemMEReal().setConteudo(lValor);
                } else {
                    ApuracaoBemImovel.this.getGanhoCapital5OrigemMEReal().clear();
                }
            }
        };
        this.getGanhoCapital4OrigemMEReal().addObservador(obsCalculaGanhoCapital5MEReal);
        this.getValorReducaoBemPequenoValorOrigemME().addObservador(obsCalculaGanhoCapital5MEReal);
        this.getValorReducaoAplicacaoOutroImovelOrigemME().addObservador(obsCalculaGanhoCapital5MEReal);
        this.getValorReducaoUnicoImovelOrigemME().addObservador(obsCalculaGanhoCapital5MEReal);
    }

    @Override
    public void calcularGanhoCapital1(ValorPositivo pValorLiquidoAlienacao, ValorPositivo pCustoAquisicao) {
        this.calcularGanhoCapital1(pValorLiquidoAlienacao, pCustoAquisicao, this.getCustoAquisicaoTorna());
    }

    public void calcularGanhoCapital1(ValorPositivo pValorLiquidoAlienacao, ValorPositivo pCustoAquisicao, ValorPositivo pCustoAquisicaoTorna) {
        if (pCustoAquisicaoTorna.comparacao(">", "0,00")) {
            if (pValorLiquidoAlienacao.comparacao(">", pCustoAquisicaoTorna)) {
                this.getGanhoCapital1().setConteudo(pValorLiquidoAlienacao.operacao('-', pCustoAquisicaoTorna));
            } else {
                this.getGanhoCapital1().clear();
            }
        } else {
            super.calcularGanhoCapital1(pValorLiquidoAlienacao, pCustoAquisicao);
        }
    }

    @Override
    public void calcularGanhoCapital1OrigemMNReal(ValorPositivo pValorLiquidoAlienacaoOrigemMNReal, ValorPositivo pCustoAquisicaoOrigemMNReal) {
        this.calcularGanhoCapital1OrigemMNReal(pValorLiquidoAlienacaoOrigemMNReal, pCustoAquisicaoOrigemMNReal, this.getCustoAquisicaoTornaOrigemMNReal());
    }

    public void calcularGanhoCapital1OrigemMNReal(ValorPositivo pValorLiquidoAlienacaoOrigemMNReal, ValorPositivo pCustoAquisicaoOrigemMNReal, ValorPositivo pCustoAquisicaoTornaOrigemMNReal) {
        if (pCustoAquisicaoTornaOrigemMNReal.comparacao(">", "0,00")) {
            if (pValorLiquidoAlienacaoOrigemMNReal.comparacao(">", pCustoAquisicaoTornaOrigemMNReal)) {
                this.getGanhoCapital1OrigemNacionalReal().setConteudo(pValorLiquidoAlienacaoOrigemMNReal.operacao('-', pCustoAquisicaoTornaOrigemMNReal));
            } else {
                this.getGanhoCapital1OrigemNacionalReal().clear();
            }
        } else {
            super.calcularGanhoCapital1OrigemMNReal(pValorLiquidoAlienacaoOrigemMNReal, pCustoAquisicaoOrigemMNReal);
        }
    }

    @Override
    public void calcularGanhoCapital1OrigemMEDolar(ValorPositivo pValorLiquidoAlienacaoOrigemMEDolar, ValorPositivo pCustoAquisicaoOrigemMEDolar) {
        this.calcularGanhoCapital1OrigemMEDolar(pValorLiquidoAlienacaoOrigemMEDolar, pCustoAquisicaoOrigemMEDolar, this.getCustoAquisicaoTornaOrigemMEDolar());
    }

    public void calcularGanhoCapital1OrigemMEDolar(ValorPositivo pValorLiquidoAlienacaoOrigemMEDolar, ValorPositivo pCustoAquisicaoOrigemMEDolar, ValorPositivo pCustoAquisicaoTornaOrigemMEDolar) {
        if (pCustoAquisicaoTornaOrigemMEDolar.comparacao(">", "0,00")) {
            if (pValorLiquidoAlienacaoOrigemMEDolar.comparacao(">", pCustoAquisicaoTornaOrigemMEDolar)) {
                this.getGanhoCapital1OrigemMEDolar().setConteudo(pValorLiquidoAlienacaoOrigemMEDolar.operacao('-', pCustoAquisicaoTornaOrigemMEDolar));
            } else {
                this.getGanhoCapital1OrigemMEDolar().clear();
            }
        } else {
            super.calcularGanhoCapital1OrigemMEDolar(pValorLiquidoAlienacaoOrigemMEDolar, pCustoAquisicaoOrigemMEDolar);
        }
    }

    public void calcularReducoesAquisicaoComReforma(Data dataAlienacao, boolean residenciaAlienacaoBrasil) {
        if (GCAPFacade.getInstancia().getDeclaracao() != null && residenciaAlienacaoBrasil) {
            ValorPositivo lPercentualReducao;
            ValorPositivo lValorTotalReducaoLei7713 = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei7713MN = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei7713ME = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei11196FR1MN = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei11196FR1ME = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei11196FR2MN = new ValorPositivo(null, "", 11, 2);
            ValorPositivo lValorTotalReducaoLei11196FR2ME = new ValorPositivo(null, "", 11, 2);
            for (ParcelaApuracaoCustoAquisicao parcela : this.getParcelasCustoAquisicao().itens()) {
                ValorPositivo vpr = new ValorPositivo(null, "", 11, 9);
                vpr.append('+', this.getGanhoCapital1());
                vpr.append('/', "100");
                vpr.append('*', parcela.getPercentualCustoTotal());
                vpr.converteQtdCasasDecimais(2);
                parcela.getValorPassivelReducao().setConteudo(vpr);
                vpr = new ValorPositivo(null, "", 11, 9);
                vpr.append('+', this.getGanhoCapital1OrigemNacionalReal());
                vpr.append('/', "100");
                vpr.append('*', parcela.getPercentualCustoTotalReal());
                vpr.converteQtdCasasDecimais(2);
                parcela.getValorPassivelReducaoOrigemMN().setConteudo(vpr);
                vpr = new ValorPositivo(null, "", 11, 9);
                vpr.append('+', this.getGanhoCapital1OrigemMEReal());
                vpr.append('/', "100");
                vpr.append('*', parcela.getPercentualCustoTotalDolar());
                vpr.converteQtdCasasDecimais(2);
                parcela.getValorPassivelReducaoOrigemME().setConteudo(vpr);
                lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei7713(parcela.getData());
                parcela.getPercentualReducaoLei7713().setConteudo(lPercentualReducao);
                ValorPositivo lValorReducaoLei7713 = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei7713.append('+', parcela.getValorPassivelReducao());
                lValorReducaoLei7713.append('/', "100");
                lValorReducaoLei7713.append('*', lPercentualReducao);
                lValorTotalReducaoLei7713.append('+', lValorReducaoLei7713);
                ValorPositivo lValorReducaoLei7713MN = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei7713MN.append('+', parcela.getValorPassivelReducaoOrigemMN());
                lValorReducaoLei7713MN.append('/', "100");
                lValorReducaoLei7713MN.append('*', lPercentualReducao);
                lValorTotalReducaoLei7713MN.append('+', lValorReducaoLei7713MN);
                ValorPositivo lValorReducaoLei7713ME = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei7713ME.append('+', parcela.getValorPassivelReducaoOrigemME());
                lValorReducaoLei7713ME.append('/', "100");
                lValorReducaoLei7713ME.append('*', lPercentualReducao);
                lValorTotalReducaoLei7713ME.append('+', lValorReducaoLei7713ME);
                lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR1(parcela.getData());
                parcela.getPercentualReducaoLei11196FR1().setConteudo(lPercentualReducao);
                ValorPositivo lValorReducaoLei11196FR1 = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei11196FR1.append('+', parcela.getValorPassivelReducao());
                lValorReducaoLei11196FR1.append('-', lValorReducaoLei7713);
                lValorReducaoLei11196FR1.append('/', "100");
                lValorReducaoLei11196FR1.append('*', lPercentualReducao);
                lValorTotalReducaoLei11196FR1.append('+', lValorReducaoLei11196FR1);
                ValorPositivo lValorReducaoLei11196FR1MN = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei11196FR1MN.append('+', parcela.getValorPassivelReducaoOrigemMN());
                lValorReducaoLei11196FR1MN.append('-', lValorReducaoLei7713MN);
                lValorReducaoLei11196FR1MN.append('/', "100");
                lValorReducaoLei11196FR1MN.append('*', lPercentualReducao);
                lValorTotalReducaoLei11196FR1MN.append('+', lValorReducaoLei11196FR1MN);
                ValorPositivo lValorReducaoLei11196FR1ME = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei11196FR1ME.append('+', parcela.getValorPassivelReducaoOrigemME());
                lValorReducaoLei11196FR1ME.append('-', lValorReducaoLei7713ME);
                lValorReducaoLei11196FR1ME.append('/', "100");
                lValorReducaoLei11196FR1ME.append('*', lPercentualReducao);
                lValorTotalReducaoLei11196FR1ME.append('+', lValorReducaoLei11196FR1ME);
                lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR2(parcela.getData(), dataAlienacao);
                parcela.getPercentualReducaoLei11196FR2().setConteudo(lPercentualReducao);
                ValorPositivo lValorReducaoLei11196FR2 = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei11196FR2.append('+', parcela.getValorPassivelReducao());
                lValorReducaoLei11196FR2.append('-', lValorReducaoLei7713);
                lValorReducaoLei11196FR2.append('-', lValorReducaoLei11196FR1);
                lValorReducaoLei11196FR2.append('/', "100");
                lValorReducaoLei11196FR2.append('*', lPercentualReducao);
                lValorTotalReducaoLei11196FR2.append('+', lValorReducaoLei11196FR2);
                ValorPositivo lValorReducaoLei11196FR2MN = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei11196FR2MN.append('+', parcela.getValorPassivelReducaoOrigemMN());
                lValorReducaoLei11196FR2MN.append('-', lValorReducaoLei7713MN);
                lValorReducaoLei11196FR2MN.append('-', lValorReducaoLei11196FR1MN);
                lValorReducaoLei11196FR2MN.append('/', "100");
                lValorReducaoLei11196FR2MN.append('*', lPercentualReducao);
                lValorTotalReducaoLei11196FR2MN.append('+', lValorReducaoLei11196FR2MN);
                ValorPositivo lValorReducaoLei11196FR2ME = new ValorPositivo(null, "", 11, 9);
                lValorReducaoLei11196FR2ME.append('+', parcela.getValorPassivelReducaoOrigemME());
                lValorReducaoLei11196FR2ME.append('-', lValorReducaoLei7713ME);
                lValorReducaoLei11196FR2ME.append('-', lValorReducaoLei11196FR1ME);
                lValorReducaoLei11196FR2ME.append('/', "100");
                lValorReducaoLei11196FR2ME.append('*', lPercentualReducao);
                lValorTotalReducaoLei11196FR2ME.append('+', lValorReducaoLei11196FR2ME);
            }
            this.getValorReducaoLei7713().setConteudo(lValorTotalReducaoLei7713);
            this.getValorReducaoLei7713OrigemMN().setConteudo(lValorTotalReducaoLei7713MN);
            this.getValorReducaoLei7713OrigemME().setConteudo(lValorTotalReducaoLei7713ME);
            this.getValorReducaoLei11196FR1().setConteudo(lValorTotalReducaoLei11196FR1);
            this.getValorReducaoLei11196FR1OrigemMN().setConteudo(lValorTotalReducaoLei11196FR1MN);
            this.getValorReducaoLei11196FR1OrigemME().setConteudo(lValorTotalReducaoLei11196FR1ME);
            this.getValorReducaoLei11196FR2().setConteudo(lValorTotalReducaoLei11196FR2);
            this.getValorReducaoLei11196FR2OrigemMN().setConteudo(lValorTotalReducaoLei11196FR2MN);
            this.getValorReducaoLei11196FR2OrigemME().setConteudo(lValorTotalReducaoLei11196FR2ME);
            if (this.getGanhoCapital1().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei7713);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital1());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei7713().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei7713().clear();
            }
            if (this.getGanhoCapital1OrigemNacionalReal().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei7713MN);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital1OrigemNacionalReal());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei7713OrigemMN().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei7713OrigemMN().clear();
            }
            if (this.getGanhoCapital1OrigemMEReal().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei7713ME);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital1OrigemMEReal());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei7713OrigemME().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei7713OrigemME().clear();
            }
            if (this.getGanhoCapital2().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei11196FR1);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital2());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei11196FR1().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei11196FR1().clear();
            }
            if (this.getGanhoCapital2OrigemMNReal().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei11196FR1MN);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital2OrigemMNReal());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei11196FR1OrigemMN().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei11196FR1OrigemMN().clear();
            }
            if (this.getGanhoCapital2OrigemMEReal().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei11196FR1ME);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital2OrigemMEReal());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei11196FR1OrigemME().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei11196FR1OrigemME().clear();
            }
            if (this.getGanhoCapital3().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei11196FR2);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital3());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei11196FR2().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei11196FR2().clear();
            }
            if (this.getGanhoCapital3OrigemMNReal().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei11196FR2MN);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital3OrigemMNReal());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei11196FR2OrigemMN().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei11196FR2OrigemMN().clear();
            }
            if (this.getGanhoCapital3OrigemMEReal().comparacao(">", "0,00")) {
                lPercentualReducao = new ValorPositivo(null, "", 13, 9);
                lPercentualReducao.append('+', lValorTotalReducaoLei11196FR2ME);
                lPercentualReducao.append('*', "100");
                lPercentualReducao.append('/', this.getGanhoCapital3OrigemMEReal());
                lPercentualReducao.converteQtdCasasDecimais(6);
                this.getPercentualReducaoLei11196FR2OrigemME().setConteudo(lPercentualReducao);
            } else {
                this.getPercentualReducaoLei11196FR2OrigemME().clear();
            }
        } else if (GcapUtil.getEstadoSistema() != 2) {
            this.limparValoresPercentuaisReducao();
        }
    }

    public void calcularReducoesAquisicaoSemReforma(Data dataAquisicao, Data dataAlienacao, boolean residenciaAlienacaoBrasil) {
        if (GCAPFacade.getInstancia().getDeclaracao() != null && residenciaAlienacaoBrasil) {
            ValorPositivo lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei7713(dataAquisicao);
            this.getPercentualReducaoLei7713().setConteudo(lPercentualReducao);
            this.getPercentualReducaoLei7713OrigemMN().setConteudo(lPercentualReducao);
            this.getPercentualReducaoLei7713OrigemME().setConteudo(lPercentualReducao);
            ValorPositivo lValorReducao = new ValorPositivo(null, "", 11, 9);
            lValorReducao.append('+', this.getGanhoCapital1());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei7713().setConteudo(lValorReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital1OrigemNacionalReal());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei7713OrigemMN().setConteudo(lValorReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital1OrigemMEReal());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei7713OrigemME().setConteudo(lValorReducao);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR1(dataAquisicao);
            this.getPercentualReducaoLei11196FR1().setConteudo(lPercentualReducao);
            this.getPercentualReducaoLei11196FR1OrigemMN().setConteudo(lPercentualReducao);
            this.getPercentualReducaoLei11196FR1OrigemME().setConteudo(lPercentualReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital2());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei11196FR1().setConteudo(lValorReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital2OrigemMNReal());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei11196FR1OrigemMN().setConteudo(lValorReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital2OrigemMEReal());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei11196FR1OrigemME().setConteudo(lValorReducao);
            lPercentualReducao = CalculoImpostoDevidoUtil.calcularPercentualReducaoLei11196FR2(dataAquisicao, dataAlienacao);
            this.getPercentualReducaoLei11196FR2().setConteudo(lPercentualReducao);
            this.getPercentualReducaoLei11196FR2OrigemMN().setConteudo(lPercentualReducao);
            this.getPercentualReducaoLei11196FR2OrigemME().setConteudo(lPercentualReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital3());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei11196FR2().setConteudo(lValorReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital3OrigemMNReal());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei11196FR2OrigemMN().setConteudo(lValorReducao);
            lValorReducao.clear();
            lValorReducao.append('+', this.getGanhoCapital3OrigemMEReal());
            lValorReducao.append('/', "100");
            lValorReducao.append('*', lPercentualReducao);
            this.getValorReducaoLei11196FR2OrigemME().setConteudo(lValorReducao);
        } else {
            this.limparValoresPercentuaisReducao();
        }
    }

    public void limparValoresPercentuaisReducao() {
        this.getPercentualReducaoLei7713().clear();
        this.getPercentualReducaoLei7713OrigemMN().clear();
        this.getPercentualReducaoLei7713OrigemME().clear();
        this.getValorReducaoLei7713().clear();
        this.getValorReducaoLei7713OrigemMN().clear();
        this.getValorReducaoLei7713OrigemME().clear();
        this.getPercentualReducaoLei11196FR1().clear();
        this.getPercentualReducaoLei11196FR1OrigemMN().clear();
        this.getPercentualReducaoLei11196FR1OrigemME().clear();
        this.getValorReducaoLei11196FR1().clear();
        this.getValorReducaoLei11196FR1OrigemMN().clear();
        this.getValorReducaoLei11196FR1OrigemME().clear();
        this.getPercentualReducaoLei11196FR2().clear();
        this.getPercentualReducaoLei11196FR2OrigemMN().clear();
        this.getPercentualReducaoLei11196FR2OrigemME().clear();
        this.getValorReducaoLei11196FR2().clear();
        this.getValorReducaoLei11196FR2OrigemMN().clear();
        this.getValorReducaoLei11196FR2OrigemME().clear();
    }

    public ValorPositivo getGanhoCapitalTotalExterior() {
        return this.ganhoCapitalTotalExterior;
    }

    public ValorPositivo getPercentualReducaoLei7713() {
        return this.percentualReducaoLei7713;
    }

    public ValorPositivo getPercentualReducaoLei7713OrigemMN() {
        return this.percentualReducaoLei7713OrigemMN;
    }

    public ValorPositivo getPercentualReducaoLei7713OrigemME() {
        return this.percentualReducaoLei7713OrigemME;
    }

    public ValorPositivo getValorReducaoLei7713() {
        return this.valorReducaoLei7713;
    }

    public ValorPositivo getValorReducaoLei7713OrigemMN() {
        return this.valorReducaoLei7713OrigemMN;
    }

    public ValorPositivo getValorReducaoLei7713OrigemME() {
        return this.valorReducaoLei7713OrigemME;
    }

    public ValorPositivo getGanhoCapital2() {
        return this.ganhoCapital2;
    }

    public ValorPositivo getGanhoCapital2OrigemMNReal() {
        return this.ganhoCapital2OrigemMNReal;
    }

    public ValorPositivo getGanhoCapital2OrigemMEReal() {
        return this.ganhoCapital2OrigemMEReal;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1() {
        return this.percentualReducaoLei11196FR1;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1OrigemMN() {
        return this.percentualReducaoLei11196FR1OrigemMN;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1OrigemME() {
        return this.percentualReducaoLei11196FR1OrigemME;
    }

    public ValorPositivo getValorReducaoLei11196FR1() {
        return this.valorReducaoLei11196FR1;
    }

    public ValorPositivo getValorReducaoLei11196FR1OrigemMN() {
        return this.valorReducaoLei11196FR1OrigemMN;
    }

    public ValorPositivo getValorReducaoLei11196FR1OrigemME() {
        return this.valorReducaoLei11196FR1OrigemME;
    }

    public ValorPositivo getGanhoCapital3() {
        return this.ganhoCapital3;
    }

    public ValorPositivo getGanhoCapital3OrigemMNReal() {
        return this.ganhoCapital3OrigemMNReal;
    }

    public ValorPositivo getGanhoCapital3OrigemMEReal() {
        return this.ganhoCapital3OrigemMEReal;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2() {
        return this.percentualReducaoLei11196FR2;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2OrigemMN() {
        return this.percentualReducaoLei11196FR2OrigemMN;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2OrigemME() {
        return this.percentualReducaoLei11196FR2OrigemME;
    }

    public ValorPositivo getValorReducaoLei11196FR2() {
        return this.valorReducaoLei11196FR2;
    }

    public ValorPositivo getValorReducaoLei11196FR2OrigemMN() {
        return this.valorReducaoLei11196FR2OrigemMN;
    }

    public ValorPositivo getValorReducaoLei11196FR2OrigemME() {
        return this.valorReducaoLei11196FR2OrigemME;
    }

    public ValorPositivo getGanhoCapital4() {
        return this.ganhoCapital4;
    }

    public ValorPositivo getGanhoCapital4OrigemMNReal() {
        return this.ganhoCapital4OrigemMNReal;
    }

    public ValorPositivo getGanhoCapital4OrigemMEReal() {
        return this.ganhoCapital4OrigemMEReal;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovel() {
        return this.percentualReducaoAplicacaoOutroImovel;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovelOrigemMN() {
        return this.percentualReducaoAplicacaoOutroImovelOrigemMN;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovelOrigemME() {
        return this.percentualReducaoAplicacaoOutroImovelOrigemME;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovel() {
        return this.valorReducaoAplicacaoOutroImovel;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovelOrigemMN() {
        return this.valorReducaoAplicacaoOutroImovelOrigemMN;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovelOrigemME() {
        return this.valorReducaoAplicacaoOutroImovelOrigemME;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValor() {
        return this.percentualReducaoBemPequenoValor;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValorOrigemMN() {
        return this.percentualReducaoBemPequenoValorOrigemMN;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValorOrigemME() {
        return this.percentualReducaoBemPequenoValorOrigemME;
    }

    public ValorPositivo getValorReducaoBemPequenoValor() {
        return this.valorReducaoBemPequenoValor;
    }

    public ValorPositivo getValorReducaoBemPequenoValorOrigemMN() {
        return this.valorReducaoBemPequenoValorOrigemMN;
    }

    public ValorPositivo getValorReducaoBemPequenoValorOrigemME() {
        return this.valorReducaoBemPequenoValorOrigemME;
    }

    public ValorPositivo getGanhoCapital5() {
        return this.ganhoCapital5;
    }

    public ValorPositivo getGanhoCapital5OrigemMNReal() {
        return this.ganhoCapital5OrigemMNReal;
    }

    public ValorPositivo getGanhoCapital5OrigemMEReal() {
        return this.ganhoCapital5OrigemMEReal;
    }

    public ColecaoParcelaApuracaoCustoAquisicao getParcelasCustoAquisicao() {
        return this.parcelasCustoAquisicao;
    }

    public ValorPositivo getPercentualReducaoUnicoImovel() {
        return this.percentualReducaoUnicoImovel;
    }

    public ValorPositivo getPercentualReducaoUnicoImovelOrigemMN() {
        return this.percentualReducaoUnicoImovelOrigemMN;
    }

    public ValorPositivo getPercentualReducaoUnicoImovelOrigemME() {
        return this.percentualReducaoUnicoImovelOrigemME;
    }

    public ValorPositivo getValorReducaoUnicoImovel() {
        return this.valorReducaoUnicoImovel;
    }

    public ValorPositivo getValorReducaoUnicoImovelOrigemMN() {
        return this.valorReducaoUnicoImovelOrigemMN;
    }

    public ValorPositivo getValorReducaoUnicoImovelOrigemME() {
        return this.valorReducaoUnicoImovelOrigemME;
    }

    public ValorPositivo getCustoAquisicaoTorna() {
        return this.custoAquisicaoTorna;
    }

    public ValorPositivo getCustoAquisicaoTornaOrigemMNReal() {
        return this.custoAquisicaoTornaOrigemMNReal;
    }

    public ValorPositivo getCustoAquisicaoTornaOrigemMEDolar() {
        return this.custoAquisicaoTornaOrigemMEDolar;
    }
}

