/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.aquisicao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class Aquisicao
extends ObjetoNegocio {
    public static int CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL = 1;
    public static int CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA = 2;
    public static int CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA = 3;
    public static String STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL = "1";
    public static String STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA = "2";
    public static String STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA = "3";
    public static String DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL = "Rendimentos auferidos em moeda nacional";
    public static String DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA = "Rendimentos auferidos em moeda estrangeira";
    public static String DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA = "Rendimentos auferidos em moeda nacional e moeda estrangeira";
    public static final String CODIGO_DOLAR_AMERICANO = "USA";
    private Data dataAquisicao = new Data((ObjetoNegocio)this, "Data de Aquisi\u00e7\u00e3o");
    private ValorPositivo custoAquisicao = new ValorPositivo(this, "Custo de Aquisi\u00e7\u00e3o");
    private Codigo origemRendimentos = new Codigo((ObjetoNegocio)this, "Origem dos Rendimentos", CadastroTabelasGCAP.recuperarTiposOrigemRendimentos());
    private ValorPositivo cotacaoDolarDataAquisicao = new ValorPositivo(this, "Cota\u00e7\u00e3o da moeda estrangeira na data de aquisi\u00e7\u00e3o", 11, 4);
    private ValorPositivo custoAquisicaoOrigemNacionalReal = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o - (R$)");
    private ValorPositivo custoAquisicaoOrigemNacionalDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o - (XX$)");
    private ValorPositivo custoAquisicaoOrigemMEDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o - (US$)");
    private ValorPositivo custoAquisicaoTotalDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o total - (XX$)");
    private ValorPositivo percentualCustoAquisicaoOrigemNacional = new ValorPositivo(this, "Percentual do custo de Aquisi\u00e7\u00e3o - Origem moeda nacional", 3, 9);
    private ValorPositivo percentualCustoAquisicaoOrigemME = new ValorPositivo(this, "Percentual do custo de Aquisi\u00e7\u00e3o - Origem moeda estrangeira", 3, 9);
    private Codigo moedaEstrangeira = new Codigo((ObjetoNegocio)this, "Moeda Estrangeira", CadastroTabelasGCAP.recuperarMoedas());
    private Logico residenteBrasilAplicacaoExterior = new Logico((ObjetoNegocio)this, "Contribuinte \u00e9 Pessoa f\u00edsica residente no Pa\u00eds e o bem \u00e9 aplica\u00e7\u00e3o financeira, entidade controlada ou trust no exterior?");

    public Aquisicao() {
        this.custoAquisicaoOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoTotalDolar.setReadOnly(true);
        this.percentualCustoAquisicaoOrigemME.setReadOnly(true);
        this.percentualCustoAquisicaoOrigemNacional.setReadOnly(true);
        this.residenteBrasilAplicacaoExterior.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.residenteBrasilAplicacaoExterior.addOpcao(Logico.NAO, Logico.LABEL_NAO);
    }

    public ValorPositivo getCustoAquisicao() {
        return this.custoAquisicao;
    }

    public Data getDataAquisicao() {
        return this.dataAquisicao;
    }

    public Codigo getOrigemRendimentos() {
        return this.origemRendimentos;
    }

    public ValorPositivo getCotacaoDolarDataAquisicao() {
        return this.cotacaoDolarDataAquisicao;
    }

    public ValorPositivo getCustoAquisicaoOrigemNacionalReal() {
        return this.custoAquisicaoOrigemNacionalReal;
    }

    public ValorPositivo getCustoAquisicaoOrigemNacionalDolar() {
        return this.custoAquisicaoOrigemNacionalDolar;
    }

    public ValorPositivo getCustoAquisicaoOrigemMEDolar() {
        return this.custoAquisicaoOrigemMEDolar;
    }

    public ValorPositivo getCustoAquisicaoTotalDolar() {
        return this.custoAquisicaoTotalDolar;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemNacional() {
        return this.percentualCustoAquisicaoOrigemNacional;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemME() {
        return this.percentualCustoAquisicaoOrigemME;
    }

    public Codigo getMoedaEstrangeira() {
        return this.moedaEstrangeira;
    }

    public Logico getResidenteBrasilAplicacaoExterior() {
        return this.residenteBrasilAplicacaoExterior;
    }

    public void resetAquisicao(boolean adquiridoNoBrasil, boolean limparOrigemRendimentos) {
        if (adquiridoNoBrasil) {
            this.getCotacaoDolarDataAquisicao().clear();
            this.getCustoAquisicaoOrigemNacionalReal().clear();
            this.getCustoAquisicaoOrigemNacionalDolar().clear();
            this.getCustoAquisicaoOrigemMEDolar().clear();
            if (limparOrigemRendimentos) {
                this.getOrigemRendimentos().clear();
            }
        } else {
            this.getCustoAquisicao().clear();
        }
    }

    public boolean isOrigemRendimentosValida(String origemRendimentos) {
        boolean retorno = false;
        if (STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos) || STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos) || STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
            retorno = true;
        }
        return retorno;
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaIdentificacao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getDataAquisicao());
        lista.add((Informacao)this.getOrigemRendimentos());
        lista.add((Informacao)this.getMoedaEstrangeira());
        lista.add((Informacao)this.getCotacaoDolarDataAquisicao());
        lista.add((Informacao)this.getCustoAquisicao());
        lista.add((Informacao)this.getCustoAquisicaoOrigemNacionalDolar());
        lista.add((Informacao)this.getCustoAquisicaoOrigemMEDolar());
        return lista;
    }
}

