/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.bensmoveis;

import br.gov.serpro.gcap.entidades.Bem;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class BemMovel
extends Bem {
    private Aquisicao aquisicao = new Aquisicao();
    private Logico sujeitoRegistroPublico = new Logico((ObjetoNegocio)this, "Sujeito a registro p\u00fablico?");
    private transient Alfa sujeitoRegistroPublicoAux = new Alfa((ObjetoNegocio)this, "Sujeito a registro p\u00fablico?", 1);
    private WeakReference<Alienacao> weakAlienacao;

    public BemMovel(Alienacao alienacao) {
        super(alienacao);
        this.weakAlienacao = new WeakReference<Alienacao>(alienacao);
        this.getSujeitoRegistroPublico().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getSujeitoRegistroPublico().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.adicionarObservadoresBemMovel();
    }

    public void adicionarObservadoresBemMovel() {
        this.getSujeitoRegistroPublicoAux().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (BemMovel.this.sujeitoRegistroPublicoAux.formatado().equals("S")) {
                    BemMovel.this.sujeitoRegistroPublico.setConteudo(Logico.SIM);
                } else {
                    BemMovel.this.sujeitoRegistroPublico.setConteudo(Logico.NAO);
                }
            }
        });
        this.getBemAdquiridoNoBrasil().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (BemMovel.this.isAdquiridoNoExterior()) {
                    BemMovel.this.getAquisicao().getOrigemRendimentos().setConteudo(Aquisicao.CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL);
                }
            }
        });
    }

    public Aquisicao getAquisicao() {
        return this.aquisicao;
    }

    public Logico getSujeitoRegistroPublico() {
        return this.sujeitoRegistroPublico;
    }

    public Alfa getSujeitoRegistroPublicoAux() {
        return this.sujeitoRegistroPublicoAux;
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaIdentificacao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getBemAdquiridoNoBrasil());
        lista.add((Informacao)this.getEspecificacao());
        lista.add((Informacao)this.getSujeitoRegistroPublico());
        return lista;
    }
}

