/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.calculo;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.negocio.CalculoImpostoDevidoUtil;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class CalculoImposto
extends ObjetoNegocio {
    private ValorPositivo ganhoCapitalTotal = new ValorPositivo(this, "Ganho Capital - Resultado 5");
    private ValorPositivo impostoDevido = new ValorPositivo(this, "Imposto Devido - (R$)");
    private ValorPositivo aliquotaMedia = new ValorPositivo(this, "Al\u00edquota M\u00e9dia - (%)", 3, 6);
    private ValorPositivo totalImpostoPagoExteriorPassivelCompensacao = new ValorPositivo(this, "Imposto Pago no Exterior Pass\u00edvel de Compesa\u00e7\u00e3o (R$)");
    private ValorPositivo impostoDevido2 = new ValorPositivo(this, "Imposto Devido II - (R$)");
    private ValorPositivo impostoPago = new ValorPositivo(this, "Imposto pago - (R$)");
    private ValorPositivo iRRFLei110332004 = new ValorPositivo(this, "Imposto de renda na Fonte (Lei n\u00b011.033, de 2004) - (R$)");
    private Alfa faixasCalculoImposto = new Alfa((ObjetoNegocio)this, "Faixas de C\u00e1lculo do Imposto");

    public CalculoImposto() {
        this.ganhoCapitalTotal.setReadOnly(true);
        this.impostoDevido.setReadOnly(true);
        this.aliquotaMedia.setReadOnly(true);
        this.impostoDevido2.setReadOnly(true);
    }

    public Alfa getFaixasCalculoImposto() {
        return this.faixasCalculoImposto;
    }

    public ValorPositivo getGanhoCapitalTotal() {
        return this.ganhoCapitalTotal;
    }

    public ValorPositivo getImpostoDevido() {
        return this.impostoDevido;
    }

    public ValorPositivo getAliquotaMedia() {
        return this.aliquotaMedia;
    }

    public ValorPositivo getTotalImpostoPagoExteriorPassivelCompensacao() {
        return this.totalImpostoPagoExteriorPassivelCompensacao;
    }

    public ValorPositivo getImpostoDevido2() {
        return this.impostoDevido2;
    }

    public ValorPositivo getImpostoPago() {
        return this.impostoPago;
    }

    public ValorPositivo getIRRFLei110332004() {
        return this.iRRFLei110332004;
    }

    public void resetCalculoImposto() {
        this.ganhoCapitalTotal.clear();
        this.aliquotaMedia.clear();
        this.impostoDevido.clear();
        this.totalImpostoPagoExteriorPassivelCompensacao.clear();
        this.impostoDevido2.clear();
        this.impostoPago.clear();
        this.iRRFLei110332004.clear();
    }

    public ValorPositivo calcularImpostoDevidoTotal(Alienacao alienacao) {
        ValorPositivo lGanhoCapitalTotal = new ValorPositivo(null, "Ganho de Capital Total", 11, 9);
        ValorPositivo lImpostoDevidoTotal = new ValorPositivo(null, "Imposto Devido Total", 11, 9);
        lGanhoCapitalTotal.setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
        lGanhoCapitalTotal.append('+', alienacao.getGanhoCapitalAlienacaoAnterior());
        String aliquotaFixa = alienacao.obterAliquotaFixa();
        lImpostoDevidoTotal = aliquotaFixa != null ? CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(lGanhoCapitalTotal, alienacao.obterAliquotaFixa()) : CalculoImpostoDevidoUtil.calcularImpostoDevido(lGanhoCapitalTotal, alienacao.getDataAlienacao());
        if (!alienacao.getGanhoCapitalAlienacaoAnterior().isVazio()) {
            ValorPositivo lImpostoDevidoAnterior = new ValorPositivo(null, "Imposto Devido sobre Aliena\u00e7\u00e3o Anterior", 11, 9);
            lImpostoDevidoAnterior = aliquotaFixa != null ? CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(alienacao.getGanhoCapitalAlienacaoAnterior(), alienacao.obterAliquotaFixa()) : CalculoImpostoDevidoUtil.calcularImpostoDevido(alienacao.getGanhoCapitalAlienacaoAnterior(), alienacao.getDataAlienacao());
            lImpostoDevidoTotal.append('-', lImpostoDevidoAnterior);
        }
        return lImpostoDevidoTotal;
    }

    public ValorPositivo calcularImpostoDevidoTotal(AlienacaoBem alienacao, ValorPositivo ganhoCapital) {
        ValorPositivo lGanhoCapitalTotal = new ValorPositivo(null, "Ganho de Capital Total", 11, 9);
        ValorPositivo lImpostoDevidoTotal = new ValorPositivo(null, "Imposto Devido Total", 11, 9);
        lGanhoCapitalTotal.setConteudo(ganhoCapital);
        lGanhoCapitalTotal.append('+', alienacao.getGanhoCapitalAlienacaoAnterior());
        String aliquotaFixa = alienacao.obterAliquotaFixa();
        lImpostoDevidoTotal = aliquotaFixa != null ? CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(lGanhoCapitalTotal, alienacao.obterAliquotaFixa()) : CalculoImpostoDevidoUtil.calcularImpostoDevido(lGanhoCapitalTotal, alienacao.getDataAlienacao());
        if (!alienacao.getGanhoCapitalAlienacaoAnterior().isVazio()) {
            ValorPositivo lImpostoDevidoAnterior = new ValorPositivo(null, "Imposto Devido sobre Aliena\u00e7\u00e3o Anterior", 11, 9);
            lImpostoDevidoAnterior = aliquotaFixa != null ? CalculoImpostoDevidoUtil.calcularImpostoDevidoAliquotaFixa(alienacao.getGanhoCapitalAlienacaoAnterior(), alienacao.obterAliquotaFixa()) : CalculoImpostoDevidoUtil.calcularImpostoDevido(alienacao.getGanhoCapitalAlienacaoAnterior(), alienacao.getDataAlienacao());
            lImpostoDevidoTotal.append('-', lImpostoDevidoAnterior);
        }
        return lImpostoDevidoTotal;
    }

    public void atualizarCalculoFaixasImposto(ValorPositivo ganhoCapitalAnterior, ValorPositivo ganhoCapital) {
        ValorPositivo[] faixas = null;
        ValorPositivo[] faixasAnterior = null;
        ValorPositivo[] faixasTotal = null;
        ValorPositivo valorGanhoCapitalTotal = new ValorPositivo();
        StringBuilder faixasGanhoCapital = new StringBuilder();
        faixas = CalculoImpostoDevidoUtil.calcularFaixasDeImpostoDevido(ganhoCapital);
        valorGanhoCapitalTotal.setConteudo(ganhoCapital.add(ganhoCapitalAnterior));
        faixasTotal = CalculoImpostoDevidoUtil.calcularFaixasDeImpostoDevido(valorGanhoCapitalTotal);
        faixasAnterior = CalculoImpostoDevidoUtil.calcularFaixasDeImpostoDevido(ganhoCapitalAnterior);
        ValorBigDecimal valorGanhoCapitalSemAnterior = null;
        for (int i = 0; i < faixas.length; ++i) {
            valorGanhoCapitalSemAnterior = new ValorBigDecimal(null, null, 11, 9);
            valorGanhoCapitalSemAnterior.setConteudo(faixasTotal[i].obterCloneBigDecimalParaCalculo());
            valorGanhoCapitalSemAnterior.subtrair(faixasAnterior[i].obterCloneBigDecimalParaCalculo());
            faixasTotal[i].converteQtdCasasDecimais(2);
            faixasGanhoCapital.append(faixasTotal[i].getConteudoFormatado() + ";");
            faixasAnterior[i].converteQtdCasasDecimais(2);
            faixasGanhoCapital.append(faixasAnterior[i].getConteudoFormatado() + ";");
            valorGanhoCapitalSemAnterior.converteQtdCasasDecimais(2);
            faixasGanhoCapital.append(valorGanhoCapitalSemAnterior.getConteudoFormatado() + "|");
        }
        valorGanhoCapitalTotal.converteQtdCasasDecimais(2);
        faixasGanhoCapital.append(valorGanhoCapitalTotal.getConteudoFormatado() + ";");
        faixasGanhoCapital.append(ganhoCapitalAnterior.getConteudoFormatado() + ";");
        faixasGanhoCapital.append(ganhoCapital.getConteudoFormatado());
        this.getFaixasCalculoImposto().setConteudo(faixasGanhoCapital.toString());
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaCalculo() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getTotalImpostoPagoExteriorPassivelCompensacao());
        lista.add(this.getImpostoPago());
        lista.add(this.getIRRFLei110332004());
        return lista;
    }
}

