/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.consolidacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;

public class ObservadorCalculoConsolidacaoParticipacaoSocietaria
extends Observador {
    private Alienacao alienacao;

    public ObservadorCalculoConsolidacaoParticipacaoSocietaria(Alienacao alienacao) {
        this.alienacao = alienacao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calcularConsolidacao((AlienacaoParticipacaoSocietaria)this.alienacao);
    }

    private void calcularConsolidacao(AlienacaoParticipacaoSocietaria alienacao) {
        if (alienacao.isAlienacaoBrasil()) {
            if (alienacao.isAlienacaoAVista()) {
                this.calcularConsolidacaoBrasilAVista(alienacao);
            } else if (alienacao.isAlienacaoAPrazo()) {
                if (alienacao.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
                    if (AplicacaoPropertiesUtil.getExercicio().equals(alienacao.getDataAlienacao().getAno())) {
                        this.calcularConsolidacaoBrasilAPrazo(alienacao);
                    } else {
                        this.calcularConsolidacaoBrasilAPrazoExercicioAnterior(alienacao);
                    }
                } else {
                    alienacao.getConsolidacao().clear();
                }
            }
        }
    }

    private void calcularConsolidacaoBrasilAVista(AlienacaoParticipacaoSocietaria alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(true);
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().clear();
        if (alienacao.isBemPequenoValor()) {
            alienacao.getConsolidacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
        } else {
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(alienacao.getCalculoImposto().getImpostoDevido());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getCalculoImposto().getImpostoDevido2());
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
            alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getCalculoImposto().getImpostoPago());
            alienacao.getConsolidacao().getValorIRF().setConteudo(alienacao.getCalculoImposto().getIRRFLei110332004());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().append('-', alienacao.getConsolidacao().getTotalImpostoPago());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().append('-', alienacao.getConsolidacao().getValorIRF());
        }
    }

    private void calcularConsolidacaoBrasilAPrazo(AlienacaoParticipacaoSocietaria alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(true);
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().clear();
        if (alienacao.isBemPequenoValor()) {
            alienacao.getConsolidacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
        } else {
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(alienacao.getCalculoImposto().getImpostoDevido());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioImpostoDevido2NoExercicio());
            alienacao.getConsolidacao().getValorIRF().setConteudo(alienacao.getColecaoParcelaAlienacao().getIrrfLei110332004Total());
            if (alienacao.getTemUltimaParcela().formatado().equals(Logico.NAO)) {
                ValorPositivo resultado = new ValorPositivo();
                resultado.setConteudo(alienacao.getConsolidacao().getImpostoTotal().naoFormatado());
                resultado.append('-', alienacao.getConsolidacao().getImpostoDevidoAnoAtual().naoFormatado());
                resultado.append('-', alienacao.getConsolidacao().getValorIRF().naoFormatado());
                alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(resultado);
            } else {
                alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
            }
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
            ValorPositivo totalRendSujeitosTributacao = new ValorPositivo();
            totalRendSujeitosTributacao.setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
            totalRendSujeitosTributacao.append('-', alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
            totalRendSujeitosTributacao.append('-', alienacao.getColecaoParcelaAlienacao().getIrrfLei110332004Total());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(totalRendSujeitosTributacao);
        }
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
    }

    private void calcularConsolidacaoBrasilAPrazoExercicioAnterior(AlienacaoParticipacaoSocietaria alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(false);
        alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().clear();
        alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
        alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioImpostoDevido2NoExercicio());
        alienacao.getConsolidacao().getValorIRF().setConteudo(alienacao.getColecaoParcelaAlienacao().getIrrfLei110332004Total());
        if (alienacao.getTemUltimaParcela().formatado().equals(Logico.NAO)) {
            ValorPositivo resultado = new ValorPositivo();
            resultado.setConteudo(alienacao.getConsolidacao().getImpostoTotal().naoFormatado());
            resultado.append('-', alienacao.getConsolidacao().getImpostoDevidoAnoAtual().naoFormatado());
            resultado.append('-', alienacao.getConsolidacao().getValorIRF().naoFormatado());
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(resultado);
        } else {
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
        }
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
        alienacao.getConsolidacao().getTotalRendSujeitosTributacao().clear();
        alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
    }
}

