/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.especie;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.especie.MoedaAlienada;
import br.gov.serpro.gcap.negocio.CalculoImpostoDevidoUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;

public class ColecaoMoedaAlienada
extends Colecao<MoedaAlienada> {
    private ValorPositivo ganhoCapitalTotal = new ValorPositivo((ObjetoNegocio)this, "Ganho de capital total (R$)", 11, 2);
    private ValorPositivo impostoDevido = new ValorPositivo((ObjetoNegocio)this, "Imposto devido (R$)", 11, 2);
    private ValorPositivo aliquotaMedia = new ValorPositivo((ObjetoNegocio)this, "Al\u00edquota m\u00e9dia %", 11, 6);
    private Observador obsCalculaImpostoDevido = new Observador(){

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            ColecaoMoedaAlienada.this.calcularImpostoDevido();
        }
    };

    public ColecaoMoedaAlienada() {
        this.ganhoCapitalTotal.setReadOnly(true);
        this.impostoDevido.setReadOnly(true);
        this.aliquotaMedia.setReadOnly(true);
    }

    public void objetoInserido(MoedaAlienada moeda) {
        this.calcularImpostoDevido();
        this.adicionarValidadores(moeda);
        this.adicionarObservadores(moeda);
    }

    public void objetoRemovido(Object o) {
        ((MoedaAlienada)((Object)o)).getOperacoesEspecie().getTotalGanhoCapital().removeObservador(this.obsCalculaImpostoDevido);
        this.calcularImpostoDevido();
        GCAPFacade.getInstancia().getDeclaracao().getTotalizacaoMoedasAlienadas().recalcular();
    }

    private void adicionarValidadores(MoedaAlienada moeda) {
        moeda.getMoeda().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                boolean informada = false;
                for (MoedaAlienada m : ColecaoMoedaAlienada.this.itens()) {
                    if (!m.getMoeda().naoFormatado().equals(this.getInformacao().naoFormatado())) continue;
                    if (informada) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("especieMoedaDuplicada"), this.getSeveridade());
                    }
                    informada = true;
                }
                return null;
            }
        });
    }

    private void adicionarObservadores(MoedaAlienada moeda) {
        moeda.getOperacoesEspecie().getTotalGanhoCapital().addObservador(this.obsCalculaImpostoDevido);
    }

    private void calcularImpostoDevido() {
        ValorPositivo ganhoCapital = new ValorPositivo(null, "Al\u00edquota m\u00e9dia", 11, 2);
        ganhoCapital.setConteudo("0,00");
        for (MoedaAlienada moeda : this.itens()) {
            ganhoCapital.append('+', moeda.getOperacoesEspecie().getTotalGanhoCapital());
        }
        ValorPositivo impDevido = new ValorPositivo(null, "Imposto devido (R$)", 11, 2);
        ValorPositivo aliquotaMedia = new ValorPositivo(null, "Al\u00edquota m\u00e9dia", 11, 6);
        if (ganhoCapital.comparacao(">", "0,00")) {
            Data exercicio = new Data();
            exercicio.setConteudo("01/01/" + ConstantesGlobais.EXERCICIO);
            impDevido.setConteudo(CalculoImpostoDevidoUtil.calcularImpostoDevido(ganhoCapital, exercicio));
            aliquotaMedia.setConteudo(CalculoImpostoDevidoUtil.calcularAliquotaEfetivaDeImposto(ganhoCapital, impDevido));
        }
        this.getGanhoCapitalTotal().setConteudo(ganhoCapital);
        this.getImpostoDevido().setConteudo(impDevido);
        this.getAliquotaMedia().setConteudo(aliquotaMedia);
    }

    public ValorPositivo getGanhoCapitalTotal() {
        return this.ganhoCapitalTotal;
    }

    public ValorPositivo getImpostoDevido() {
        return this.impostoDevido;
    }

    public ValorPositivo getAliquotaMedia() {
        return this.aliquotaMedia;
    }

    public String nomeRelatorio() {
        return "Opera\u00e7\u00e3o e Consolida\u00e7\u00e3o";
    }
}

