/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.especie;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import java.util.List;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.util.Validador;

public class ColecaoOperacaoEspecie
extends Colecao<OperacaoEspecie> {
    private ValorPositivo estoqueInicial = new ValorPositivo((ObjetoNegocio)this, "Estoque inicial de moeda estrangeira", 11, 2);
    private ValorPositivo saldoInicial = new ValorPositivo((ObjetoNegocio)this, "Saldo inicial (R$)", 11, 2);
    private ValorPositivo custoMedioInicial = new ValorPositivo((ObjetoNegocio)this, "Custo m\u00e9dio inicial", 11, 6);
    private ValorPositivo totalGanhoCapital = new ValorPositivo((ObjetoNegocio)this, "Ganho de capital total (R$)", 11, 2);
    private ValorPositivo totalQtdAdquirida = new ValorPositivo((ObjetoNegocio)this, "Quantidade total adquirida", 11, 2);
    private ValorPositivo totalQtdAlienada = new ValorPositivo((ObjetoNegocio)this, "Quantidade total alienada", 11, 2);
    private boolean estoqueNegativo = false;
    private Observador obsCalculoGanhoCapital = new Observador(){

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            ColecaoOperacaoEspecie.this.calcularGanhoTotal();
        }
    };
    private Observador obsRecalculoOperacoes = new Observador(){

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            GCAPFacade.getInstancia().getDeclaracao().getTotalizacaoMoedasAlienadas().recalcular();
        }
    };

    public static void main(String[] args) {
        System.out.println("cnta:" + new ValorBigDecimal("300,00").operacao('-', new ValorBigDecimal("500,00")).naoFormatado());
    }

    public ColecaoOperacaoEspecie() {
        this.getTotalGanhoCapital().setReadOnly(true);
        Observador obsCalcularCustoMedioInicial = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ColecaoOperacaoEspecie.this.calcularGanhoTotal();
            }
        };
        this.getEstoqueInicial().addObservador(obsCalcularCustoMedioInicial);
        this.getSaldoInicial().addObservador(obsCalcularCustoMedioInicial);
        this.getCustoMedioInicial().addObservador(obsCalcularCustoMedioInicial);
    }

    public ColecaoOperacaoEspecie(String pNomeCampo, String pNomeFicha, String pNomeAba) {
        super(pNomeCampo, pNomeFicha, pNomeAba);
    }

    public ColecaoOperacaoEspecie(String pNomeCampo) {
        super(pNomeCampo);
    }

    public ColecaoOperacaoEspecie(int tamanho) {
        super(tamanho);
    }

    public ValorPositivo getTotalGanhoCapital() {
        return this.totalGanhoCapital;
    }

    public ValorPositivo getEstoqueInicial() {
        return this.estoqueInicial;
    }

    public ValorPositivo getSaldoInicial() {
        return this.saldoInicial;
    }

    public ValorPositivo getCustoMedioInicial() {
        return this.custoMedioInicial;
    }

    public int obterOrdemOperacaoEspecie(OperacaoEspecie operacaoEspecie) {
        int ordem;
        boolean tipoOperacaoNovaValido;
        List listaOperacoesOrdenada = this.itens();
        boolean dataOperacaoNovaValida = Validador.verificaData((String)operacaoEspecie.getData().formatado()) == 0;
        boolean bl = tipoOperacaoNovaValido = operacaoEspecie.getTipo().naoFormatado().equals("1") || operacaoEspecie.getTipo().naoFormatado().equals("2");
        for (ordem = 0; ordem < listaOperacoesOrdenada.size(); ++ordem) {
            String chaveOperacao;
            String chaveOperacaoNova;
            OperacaoEspecie op = (OperacaoEspecie)((Object)listaOperacoesOrdenada.get(ordem));
            boolean dataOperacaoValida = Validador.verificaData((String)op.getData().formatado()) == 0;
            boolean tipoOperacaoValido = op.getTipo().naoFormatado().equals("1") || op.getTipo().naoFormatado().equals("2");
            Object dataOperacaoNova = "99999999";
            String tipoOperacaoNova = "9";
            Object dataOperacao = "99999999";
            String tipoOperacao = "9";
            if (dataOperacaoNovaValida) {
                dataOperacaoNova = operacaoEspecie.getData().getAno() + operacaoEspecie.getData().getMes() + operacaoEspecie.getData().getDia();
            }
            if (tipoOperacaoNovaValido) {
                tipoOperacaoNova = operacaoEspecie.getTipo().naoFormatado();
            }
            if (dataOperacaoValida) {
                dataOperacao = op.getData().getAno() + op.getData().getMes() + op.getData().getDia();
            }
            if (tipoOperacaoValido) {
                tipoOperacao = op.getTipo().naoFormatado();
            }
            if ((chaveOperacaoNova = (String)dataOperacaoNova + tipoOperacaoNova).compareTo(chaveOperacao = (String)dataOperacao + tipoOperacao) < 0) break;
        }
        return ordem;
    }

    public int alterarOrdemOperacaoEspecie(int ordem) {
        OperacaoEspecie op = (OperacaoEspecie)((Object)this.itens().remove(ordem));
        int retorno = this.inserirOperacaoEspecie(op);
        GCAPFacade.getInstancia().getDeclaracao().getTotalizacaoMoedasAlienadas().recalcular();
        return retorno;
    }

    public int inserirOperacaoEspecie(OperacaoEspecie operacaoEspecie) {
        int ordem = this.obterOrdemOperacaoEspecie(operacaoEspecie);
        this.itens().add(ordem, operacaoEspecie);
        operacaoEspecie.getData().addObservador(this.obsRecalculoOperacoes);
        operacaoEspecie.getQuantidade().addObservador(this.obsRecalculoOperacoes);
        operacaoEspecie.getValor().addObservador(this.obsRecalculoOperacoes);
        operacaoEspecie.getCotacaoDolar().addObservador(this.obsRecalculoOperacoes);
        return ordem;
    }

    public int inserirNovaOperacaoCompra() {
        OperacaoEspecie op = new OperacaoEspecie();
        op.getTipo().setConteudo("1");
        return this.inserirOperacaoEspecie(op);
    }

    public int inserirNovaOperacaoVenda() {
        OperacaoEspecie op = new OperacaoEspecie();
        op.getTipo().setConteudo("2");
        return this.inserirOperacaoEspecie(op);
    }

    public void calcularSaldo(OperacaoEspecie operacaoEspecie, String estoqueAnterior, String saldoAnterior, String custoMedioAnterior) {
        ValorBigDecimal estoque = new ValorBigDecimal(estoqueAnterior);
        ValorPositivo saldo = new ValorPositivo(saldoAnterior);
        ValorPositivo custoMedio = new ValorPositivo(custoMedioAnterior);
        ValorPositivo custoAlienacao = new ValorPositivo("0,00");
        ValorPositivo ganhoCapital = new ValorPositivo("0,00");
        if (Validador.verificaData((String)operacaoEspecie.getData().formatado()) == 0) {
            if (operacaoEspecie.getTipo().naoFormatado().equals("1")) {
                estoque.append('+', operacaoEspecie.getQuantidade());
                if (estoque.comparacao(">", "0,00")) {
                    saldo.append('+', operacaoEspecie.getValor());
                } else {
                    saldo.clear();
                }
                custoMedio.setConteudo(this.calcularCustoMedio(estoque, saldo));
            } else if (operacaoEspecie.getTipo().naoFormatado().equals("2")) {
                custoAlienacao.setConteudo(operacaoEspecie.getQuantidade().operacao('*', custoMedio));
                if (operacaoEspecie.getValor().comparacao(">", custoAlienacao)) {
                    ganhoCapital.setConteudo(operacaoEspecie.getValor().operacao('-', custoAlienacao));
                }
                estoque.append('-', operacaoEspecie.getQuantidade());
                if (estoque.comparacao(">", "0,00") && saldo.comparacao(">", custoAlienacao)) {
                    saldo.append('-', custoAlienacao);
                } else {
                    saldo.clear();
                }
            }
        }
        operacaoEspecie.getCustoAlienacao().setConteudo(custoAlienacao);
        operacaoEspecie.getGanhoCapital().setConteudo(ganhoCapital);
        operacaoEspecie.getEstoque().setConteudo(estoque);
        operacaoEspecie.getSaldo().setConteudo(saldo);
        operacaoEspecie.getCustoMedio().setConteudo(custoMedio);
    }

    public ValorPositivo calcularCustoMedio(ValorBigDecimal estoque, ValorPositivo saldo) {
        ValorPositivo custoMedio = new ValorPositivo("0,000000");
        if (estoque.comparacao(">", "0,00")) {
            custoMedio.setConteudo(saldo.operacao('/', estoque));
        } else {
            custoMedio.clear();
        }
        return custoMedio;
    }

    private void calcularGanhoTotal() {
        ValorBigDecimal estoque = new ValorBigDecimal(this.getEstoqueInicial().naoFormatado());
        ValorPositivo saldo = new ValorPositivo(this.getSaldoInicial().naoFormatado());
        ValorPositivo custoMedio = new ValorPositivo(this.getCustoMedioInicial().naoFormatado());
        ValorPositivo totalQuantidadeAdquirida = new ValorPositivo("0,00");
        ValorPositivo totalQuantidadeAlienada = new ValorPositivo("0,00");
        ValorPositivo totalGanhoCapital = new ValorPositivo("0,00");
        this.estoqueNegativo = false;
        for (OperacaoEspecie op : this.itens()) {
            this.calcularSaldo(op, estoque.naoFormatado(), saldo.naoFormatado(), custoMedio.naoFormatado());
            estoque.setConteudo(op.getEstoque());
            saldo.setConteudo(op.getSaldo());
            custoMedio.setConteudo(op.getCustoMedio());
            if (op.getTipo().naoFormatado().equals("1")) {
                totalQuantidadeAdquirida.append('+', op.getQuantidade());
            } else if (op.getTipo().naoFormatado().equals("2")) {
                totalQuantidadeAlienada.append('+', op.getQuantidade());
                totalGanhoCapital.append('+', op.getGanhoCapital());
            }
            this.estoqueNegativo = this.estoqueNegativo || estoque.comparacao("<", "0,00");
        }
        this.getTotalQtdAdquirida().setConteudo(totalQuantidadeAdquirida);
        this.getTotalQtdAlienada().setConteudo(totalQuantidadeAlienada);
        this.getTotalGanhoCapital().setConteudo(totalGanhoCapital);
    }

    public void objetoInserido(OperacaoEspecie operacaoEspecie) {
        this.calcularGanhoTotal();
        operacaoEspecie.getQuantidade().addObservador(this.obsCalculoGanhoCapital);
        operacaoEspecie.getValor().addObservador(this.obsCalculoGanhoCapital);
    }

    public void objetoRemovido(Object o) {
        OperacaoEspecie op = (OperacaoEspecie)((Object)o);
        this.calcularGanhoTotal();
        op.getQuantidade().removeObservador(this.obsCalculoGanhoCapital);
        op.getValor().removeObservador(this.obsCalculoGanhoCapital);
        op.getData().removeObservador(this.obsRecalculoOperacoes);
        op.getQuantidade().removeObservador(this.obsRecalculoOperacoes);
        op.getValor().removeObservador(this.obsRecalculoOperacoes);
        op.getCotacaoDolar().removeObservador(this.obsRecalculoOperacoes);
        GCAPFacade.getInstancia().getDeclaracao().getTotalizacaoMoedasAlienadas().recalcular();
    }

    public ValorPositivo getTotalQtdAdquirida() {
        return this.totalQtdAdquirida;
    }

    public ValorPositivo getTotalQtdAlienada() {
        return this.totalQtdAlienada;
    }

    public OperacaoEspecie instanciaNovoObjeto() {
        return new OperacaoEspecie();
    }

    public boolean isEstoqueNegativo() {
        return this.estoqueNegativo;
    }
}

