/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.especie;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.especie.ColecaoOperacaoEspecie;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.gui.especie.PainelDadosMoedas;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class MoedaAlienada
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_ABA_MOEDAS_ALIENADAS = "Moedas Alienadas";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_OPERACOES = "Opera\u00e7\u00f5es";
    public static final String NOME_FICHA_ESPECIE = "Moedas em Esp\u00e9cie";
    private Codigo moeda = new Codigo((ObjetoNegocio)this, "Moeda estrangeira", CadastroTabelasGCAP.recuperarMoedas());
    private ValorPositivo estoqueInicial = new ValorPositivo(this, "Quantidade de moeda estrangeira", 11, 2);
    private ValorPositivo saldoInicial = new ValorPositivo(this, "Valor total (R$)", 11, 2);
    private ValorPositivo custoMedioInicial = new ValorPositivo(this, "Custo m\u00e9dio inicial (R$)", 11, 6);
    private ColecaoOperacaoEspecie operacoesEspecie = new ColecaoOperacaoEspecie();
    private Alfa numeroItem = new Alfa((ObjetoNegocio)this, "N\u00famero do Item");

    public MoedaAlienada() {
        this.adicionarValidadores();
        this.adicionarObesrvadores();
    }

    private void adicionarValidadores() {
        this.getMoeda().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getEstoqueInicial().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getEstoqueInicial().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (!MoedaAlienada.this.getSaldoInicial().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getSaldoInicial().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getSaldoInicial().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (!MoedaAlienada.this.getEstoqueInicial().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
    }

    private void adicionarObesrvadores() {
        this.getEstoqueInicial().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                MoedaAlienada.this.getOperacoesEspecie().getEstoqueInicial().setConteudo(MoedaAlienada.this.getEstoqueInicial());
            }
        });
        this.getSaldoInicial().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                MoedaAlienada.this.getOperacoesEspecie().getSaldoInicial().setConteudo(MoedaAlienada.this.getSaldoInicial());
            }
        });
        this.getCustoMedioInicial().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                MoedaAlienada.this.getOperacoesEspecie().getCustoMedioInicial().setConteudo(MoedaAlienada.this.getCustoMedioInicial());
            }
        });
        Observador obsCalcularCustoMedioInicial = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                MoedaAlienada.this.getCustoMedioInicial().setConteudo(MoedaAlienada.this.getOperacoesEspecie().calcularCustoMedio(MoedaAlienada.this.getEstoqueInicial(), MoedaAlienada.this.getSaldoInicial()));
            }
        };
        this.getEstoqueInicial().addObservador(obsCalcularCustoMedioInicial);
        this.getSaldoInicial().addObservador(obsCalcularCustoMedioInicial);
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaIdentificacao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getMoeda());
        lista.add((Informacao)this.getEstoqueInicial());
        lista.add((Informacao)this.getSaldoInicial());
        return lista;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        ArrayList<Pendencia> listaPendencias = new ArrayList<Pendencia>();
        List<Informacao> informacoes = this.recuperarListaCamposPendenciaAbaIdentificacao();
        String listaPassosSelecaoTela = "Aba;Moedas Alienadas|Lista;" + numeroItem + ";Moedas em Esp\u00e9cie Item n\u00ba " + numeroItem + "|Aba;Identifica\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_ESPECIE, this.getClasseFicha(), numeroItem, NOME_ABA_IDENTIFICACAO, listaPassosSelecaoTela);
        List operacoes = this.getOperacoesEspecie().itens();
        for (int i = 0; i < operacoes.size(); ++i) {
            OperacaoEspecie operacaoEspecie = (OperacaoEspecie)((Object)operacoes.get(i));
            informacoes = operacaoEspecie.recuperarListaCamposPendenciaAbaIdentificacao();
            listaPassosSelecaoTela = "Aba;Moedas Alienadas|Lista;" + numeroItem + ";Moedas em Esp\u00e9cie Item n\u00ba " + numeroItem + "|Aba;Opera\u00e7\u00f5es|Lista;" + (i + 1) + ";Opera\u00e7\u00e3o " + (operacaoEspecie.getTipo().naoFormatado().equals("2") ? "de Venda " : (operacaoEspecie.getTipo().naoFormatado().equals("1") ? "de Compra " : "")) + "realizada em " + (operacaoEspecie.getData().isVazio() ? "(data n\u00e3o informada)" : operacaoEspecie.getData().formatado());
            GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_ESPECIE, this.getClasseFicha(), numeroItem, NOME_ABA_OPERACOES, listaPassosSelecaoTela);
        }
        return listaPendencias;
    }

    public Codigo getMoeda() {
        return this.moeda;
    }

    public ValorPositivo getEstoqueInicial() {
        return this.estoqueInicial;
    }

    public ValorPositivo getSaldoInicial() {
        return this.saldoInicial;
    }

    public ColecaoOperacaoEspecie getOperacoesEspecie() {
        return this.operacoesEspecie;
    }

    public ValorPositivo getCustoMedioInicial() {
        return this.custoMedioInicial;
    }

    public Alfa getNumeroItem() {
        return this.numeroItem;
    }

    public String getClasseFicha() {
        return PainelDadosMoedas.class.getName();
    }

    public String getNomeAba() {
        return null;
    }
}

