/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.especie;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorData;
import br.gov.serpro.gcap.validador.ValidadorDataNoExercicio;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class OperacaoEspecie
extends ObjetoNegocio {
    public static final String TIPO_COMPRA = "1";
    public static final String TIPO_VENDA = "2";
    private Alfa tipo = new Alfa((ObjetoNegocio)this, "Tipo de opera\u00e7\u00e3o");
    private Data data = new Data((ObjetoNegocio)this, "Data da opera\u00e7\u00e3o");
    private NI niAdquirente = new NI((ObjetoNegocio)this, "CPF/CNPJ adquirente");
    private Alfa nomeAdquirente = new Alfa((ObjetoNegocio)this, "Nome do adquirente", 60);
    private ValorPositivo quantidade = new ValorPositivo(this, "Quantidade", 11, 2);
    private ValorPositivo valor = new ValorPositivo(this, "Valor (R$)", 11, 2);
    private ValorPositivo custoAlienacao = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o (R$)", 11, 2);
    private ValorPositivo ganhoCapital = new ValorPositivo(this, "Ganho de capital (R$)", 11, 2);
    private ValorPositivo saldo = new ValorPositivo(this, "Valor acumulado (R$)", 11, 2);
    private ValorPositivo custoMedio = new ValorPositivo(this, "Custo m\u00e9dio", 11, 6);
    private ValorBigDecimal estoque = new ValorBigDecimal(this, "Quantidade de moeda em estoque", 11, 2);
    private ValorPositivo cotacaoDolar = new ValorPositivo(this, "Cota\u00e7\u00e3o do D\u00f3lar (US$) em moeda nacional na data da aliena\u00e7\u00e3o:", 11, 7);

    public OperacaoEspecie() {
        this.getCustoAlienacao().setReadOnly(true);
        this.getGanhoCapital().setReadOnly(true);
        this.getCustoMedio().setReadOnly(true);
        this.adicionarValidadores();
    }

    private void adicionarValidadores() {
        this.getTipo().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!OperacaoEspecie.this.getTipo().naoFormatado().equals(OperacaoEspecie.TIPO_COMPRA) && !OperacaoEspecie.this.getTipo().naoFormatado().equals(OperacaoEspecie.TIPO_VENDA)) {
                    return new RetornoValidacao(3);
                }
                return null;
            }
        });
        this.getData().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getData().addValidador((ValidadorIf)new ValidadorData(3));
        this.getData().addValidador((ValidadorIf)new ValidadorDataNoExercicio(3));
        this.getNiAdquirente().addValidador((ValidadorIf)new ValidadorNI(3));
        this.getNomeAdquirente().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getNomeAdquirente().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (OperacaoEspecie.this.getTipo().naoFormatado().equals(OperacaoEspecie.TIPO_VENDA)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getQuantidade().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getValor().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getEstoque().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (OperacaoEspecie.this.getEstoque().comparacao("<", "0,00")) {
                    return new RetornoValidacao("A quantidade de moeda estrangeira correspondente ao saldo da opera\u00e7\u00e3o n\u00e3o pode ser negativa.", this.getSeveridade());
                }
                return null;
            }
        });
        this.getCotacaoDolar().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (OperacaoEspecie.this.getTipo().naoFormatado().equals(OperacaoEspecie.TIPO_VENDA)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
    }

    public NI getNiAdquirente() {
        return this.niAdquirente;
    }

    public Alfa getNomeAdquirente() {
        return this.nomeAdquirente;
    }

    public Data getData() {
        return this.data;
    }

    public ValorPositivo getQuantidade() {
        return this.quantidade;
    }

    public ValorPositivo getValor() {
        return this.valor;
    }

    public ValorPositivo getGanhoCapital() {
        return this.ganhoCapital;
    }

    public ValorBigDecimal getEstoque() {
        return this.estoque;
    }

    public ValorPositivo getSaldo() {
        return this.saldo;
    }

    public ValorPositivo getCustoMedio() {
        return this.custoMedio;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public ValorPositivo getCustoAlienacao() {
        return this.custoAlienacao;
    }

    public ValorPositivo getCotacaoDolar() {
        return this.cotacaoDolar;
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaIdentificacao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getTipo());
        lista.add((Informacao)this.getData());
        lista.add((Informacao)this.getQuantidade());
        lista.add((Informacao)this.getValor());
        lista.add((Informacao)this.getNiAdquirente());
        lista.add((Informacao)this.getNomeAdquirente());
        lista.add((Informacao)this.getEstoque());
        lista.add((Informacao)this.getCotacaoDolar());
        return lista;
    }
}

