/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.perguntas;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.ConstantesGlobaisGCAP;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.GcapUtil;

public class PerguntasUtil {
    private static PerguntasUtil pergutasUtil = new PerguntasUtil();

    private PerguntasUtil() {
    }

    public static PerguntasUtil getInstancia() {
        return pergutasUtil;
    }

    public boolean deveExibirPerguntaBensInferiorLimiteIsencao(AlienacaoBemImovel alienacaoBemImovel) {
        if (GCAPFacade.getInstancia().getDeclaracao() == null) {
            return false;
        }
        if (!GcapUtil.isDeclaracaoBrasileira(alienacaoBemImovel)) {
            return false;
        }
        if (!alienacaoBemImovel.existeCustoAquisicaoPosterior1969()) {
            return false;
        }
        if (this.temPrejuizo(alienacaoBemImovel)) {
            return false;
        }
        return this.isValorAlienacaoAbaixoLimiteIsencao(alienacaoBemImovel);
    }

    public boolean isValorAlienacaoAbaixoLimiteIsencao(AlienacaoBemImovel alienacaoBemImovel) {
        ValorPositivo valorPreenchido = this.obterValorAlienacao(alienacaoBemImovel);
        ValorBigDecimal lValorReferencia1 = alienacaoBemImovel.getValorIsencao();
        if (String.valueOf(AlienacaoBemImovel.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(alienacaoBemImovel.getNatureza().naoFormatado())) {
            if (alienacaoBemImovel.isAlienacaoBrasil()) {
                valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicao());
            } else {
                String origemRendimentos = alienacaoBemImovel.obterCodigoOrigemRendimentos().getConteudoAtual(0);
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                }
            }
        }
        return valorPreenchido.comparacao("<=", lValorReferencia1);
    }

    public boolean isValorAlienacaoAcimaValorIsencaoUnicoImovel(AlienacaoBemImovel alienacaoBemImovel) {
        ValorPositivo valorPreenchido = this.obterValorAlienacao(alienacaoBemImovel);
        ValorBigDecimal lValorReferencia1 = alienacaoBemImovel.getValorIsencaoUnicoImovel();
        if (String.valueOf(AlienacaoBemImovel.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(alienacaoBemImovel.getNatureza().naoFormatado())) {
            if (alienacaoBemImovel.isAlienacaoBrasil()) {
                valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicao());
            } else {
                String origemRendimentos = alienacaoBemImovel.obterCodigoOrigemRendimentos().getConteudoAtual(0);
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                }
            }
        }
        return valorPreenchido.comparacao(">", lValorReferencia1);
    }

    public ValorBigDecimal obterValorLiquidoAlienacao(AlienacaoBemImovel alienacaoBemImovel) {
        ValorBigDecimal valorLiquidoAlienacao = new ValorBigDecimal();
        if (alienacaoBemImovel.getBemImovel().isAdquiridoNoBrasil()) {
            valorLiquidoAlienacao.setConteudo(alienacaoBemImovel.getValorAlienacao().operacao('-', alienacaoBemImovel.getCustoCorretagem()));
        } else {
            valorLiquidoAlienacao.setConteudo(alienacaoBemImovel.getValorAlienacaoReal().operacao('-', alienacaoBemImovel.getValorCorretagemReal()));
        }
        return valorLiquidoAlienacao;
    }

    public ValorPositivo obterValorAlienacao(AlienacaoBemImovel alienacaoBemImovel) {
        ValorPositivo valorAlienacao = new ValorPositivo();
        if (alienacaoBemImovel.getBemImovel().isAdquiridoNoBrasil()) {
            valorAlienacao.setConteudo(alienacaoBemImovel.getValorAlienacao());
        } else {
            valorAlienacao.setConteudo(alienacaoBemImovel.getValorAlienacaoDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
        }
        return valorAlienacao;
    }

    public boolean temPrejuizo(AlienacaoBemImovel alienacaoBemImovel) {
        boolean prejuizo = false;
        prejuizo = alienacaoBemImovel.isAlienacaoBrasil() ? alienacaoBemImovel.getApuracao().getGanhoCapital1().comparacao("<=", "0,00") : alienacaoBemImovel.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', alienacaoBemImovel.getApuracao().getGanhoCapital1OrigemMEReal()).comparacao("<=", "0,00");
        return prejuizo;
    }

    public boolean deveExibirPerguntaPossuiOutroImovel(AlienacaoBemImovel alienacaoBemImovel) {
        if (GCAPFacade.getInstancia().getDeclaracao() == null) {
            return false;
        }
        if (!GcapUtil.isDeclaracaoBrasileira(alienacaoBemImovel)) {
            return false;
        }
        if (ControladorGui.isDemonstrativoAberto() && !GCAPFacade.getInstancia().verificaHabilitacaoAbaPerguntas(alienacaoBemImovel, GCAPFacade.getInstancia().getDeclaracao().getIdDemonstrativo())) {
            return false;
        }
        if (alienacaoBemImovel.isAlienacaoBrasil() || DataUtil.isDataPreenchida(alienacaoBemImovel.getDataAlienacao()) && Integer.parseInt(alienacaoBemImovel.getDataAlienacao().getAno()) < ConstantesGlobaisGCAP.ANO_IMPLANTACAO_GCAP) {
            if (this.temPrejuizo(alienacaoBemImovel)) {
                return false;
            }
            if (!alienacaoBemImovel.existeCustoAquisicaoPosterior1969()) {
                return false;
            }
            return this.isValorAlienacaoEntreLimitesIsencao(alienacaoBemImovel);
        }
        return true;
    }

    public boolean isValorAlienacaoEntreLimitesIsencao(AlienacaoBemImovel alienacaoBemImovel) {
        ValorBigDecimal valorPreenchido = new ValorBigDecimal();
        valorPreenchido = this.obterValorAlienacao(alienacaoBemImovel);
        ValorBigDecimal lValorReferencia1 = alienacaoBemImovel.getValorIsencao();
        ValorBigDecimal valorReferencia2 = alienacaoBemImovel.getValorIsencaoUnicoImovel();
        if (String.valueOf(AlienacaoBemImovel.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(alienacaoBemImovel.getNatureza().naoFormatado())) {
            if (alienacaoBemImovel.isAlienacaoBrasil()) {
                valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicao());
            } else {
                String origemRendimentos = alienacaoBemImovel.obterCodigoOrigemRendimentos().getConteudoAtual(0);
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                }
            }
        }
        boolean isMaiorReferencial1 = valorPreenchido.compareTo(lValorReferencia1) > 0;
        boolean isMenorOuIgualReferencial2 = valorPreenchido.compareTo(valorReferencia2) <= 0;
        return isMaiorReferencial1 && isMenorOuIgualReferencial2;
    }

    public boolean deveExibirPerguntaImovelResidencial(AlienacaoBemImovel alienacaoBemImovel) {
        if (GCAPFacade.getInstancia().getDeclaracao() == null) {
            return false;
        }
        if (!GcapUtil.isDeclaracaoBrasileira(alienacaoBemImovel)) {
            return false;
        }
        if (ControladorGui.isDemonstrativoAberto() && !GCAPFacade.getInstancia().verificaHabilitacaoAbaPerguntas(alienacaoBemImovel, GCAPFacade.getInstancia().getDeclaracao().getIdDemonstrativo())) {
            return false;
        }
        if (alienacaoBemImovel.isTransmissaoCausaMortis()) {
            return false;
        }
        if (!alienacaoBemImovel.isMP252PermitidaParaNaturezaSelecionada()) {
            return false;
        }
        if (alienacaoBemImovel.isAlienacaoBrasil() || DataUtil.isDataPreenchida(alienacaoBemImovel.getDataAlienacao()) && Integer.parseInt(alienacaoBemImovel.getDataAlienacao().getAno()) < ConstantesGlobaisGCAP.ANO_IMPLANTACAO_GCAP) {
            if (!alienacaoBemImovel.existeCustoAquisicaoPosterior1969()) {
                return false;
            }
            if (!alienacaoBemImovel.existeGanhoDeCapitalSobreCustoAquisicao()) {
                return false;
            }
            boolean naoPossuiOutroImovel = "0".equals(alienacaoBemImovel.getPerguntas().getPropriedadeOutroImovel().formatado());
            boolean possuiOutroImovel = "1".equals(alienacaoBemImovel.getPerguntas().getPropriedadeOutroImovel().formatado());
            boolean efetuouOutraAlienacao5anos = "1".equals(alienacaoBemImovel.getPerguntas().getOutraAlienacao().formatado());
            boolean naoRespondidas = alienacaoBemImovel.getPerguntas().getPropriedadeOutroImovel().isVazio() && alienacaoBemImovel.getPerguntas().getOutraAlienacao().isVazio();
            boolean entreLimites = this.isValorAlienacaoEntreLimitesIsencao(alienacaoBemImovel);
            boolean acimaLimiteIsencaoUnicoImovel = this.isValorAlienacaoAcimaValorIsencaoUnicoImovel(alienacaoBemImovel);
            String bemGrandeValor = alienacaoBemImovel.getBemGrandeValor().formatado();
            return possuiOutroImovel || naoPossuiOutroImovel && efetuouOutraAlienacao5anos || naoRespondidas && !entreLimites && bemGrandeValor.equals("1") || acimaLimiteIsencaoUnicoImovel;
        }
        return true;
    }

    public boolean deveExibirPerguntaMP252(AlienacaoBemImovel alienacaoBemImovel) {
        if (GCAPFacade.getInstancia().getDeclaracao() == null) {
            return false;
        }
        if (!GcapUtil.isDeclaracaoBrasileira(alienacaoBemImovel)) {
            return false;
        }
        if (alienacaoBemImovel.isTransmissaoCausaMortis()) {
            return false;
        }
        if (alienacaoBemImovel.isAlienacaoBrasil() || DataUtil.isDataPreenchida(alienacaoBemImovel.getDataAlienacao()) && Integer.parseInt(alienacaoBemImovel.getDataAlienacao().getAno()) < ConstantesGlobaisGCAP.ANO_IMPLANTACAO_GCAP) {
            if (!alienacaoBemImovel.existeCustoAquisicaoPosterior1969()) {
                return false;
            }
            if (this.temPrejuizo(alienacaoBemImovel)) {
                return false;
            }
            if (alienacaoBemImovel.getPerguntas().getImovelResidencial().isVazio() || "0".equals(alienacaoBemImovel.getPerguntas().getImovelResidencial().formatado())) {
                return false;
            }
            if (!alienacaoBemImovel.isMP252PermitidaParaNaturezaSelecionada()) {
                return false;
            }
            boolean isIsentoPorPequenoValor = alienacaoBemImovel.isIsentoPorPequenoValor();
            boolean isIsentoPorUnicoImovel = alienacaoBemImovel.isIsentoPorUnicoImovel();
            boolean isIsentoPorDataAquisicao = alienacaoBemImovel.isIsentoPorDataAquisicao();
            boolean isIsento = isIsentoPorPequenoValor || isIsentoPorUnicoImovel || isIsentoPorDataAquisicao;
            return !isIsento;
        }
        return !alienacaoBemImovel.getPerguntas().getImovelResidencial().isVazio() && "1".equals(alienacaoBemImovel.getPerguntas().getImovelResidencial().formatado());
    }

    public boolean deveExibirPerguntaMP252Parte2(AlienacaoBemImovel alienacaoBemImovel) {
        String mP252 = alienacaoBemImovel.getPerguntas().getMP252().naoFormatado();
        return this.deveExibirPerguntaMP252(alienacaoBemImovel) && "1".equals(mP252);
    }

    public void tratarExibicaoPerguntas(AlienacaoBemImovel alienacaoBemImovel) {
        if (GCAPFacade.getInstancia().getDeclaracao() != null && GcapUtil.getEstadoSistema() == 0) {
            this.tratarExibicaoPerguntaConjuntoBensSuperior35Mil(alienacaoBemImovel);
            this.tratarExibicaoPerguntaPropriedadeOutroImovel(alienacaoBemImovel);
            this.tratarExibicaoPerguntaImovelResidencial(alienacaoBemImovel);
            this.tratarExibicaoPerguntaMP252(alienacaoBemImovel);
            this.tratarExibirPerguntaOutraAlienacao5anos(alienacaoBemImovel);
        }
        alienacaoBemImovel.obterEnquadramentoInicial();
        alienacaoBemImovel.obterEnquadramentoFinal();
    }

    private void tratarExibicaoPerguntaConjuntoBensSuperior35Mil(AlienacaoBemImovel alienacaoBemImovel) {
        if (!alienacaoBemImovel.podeResponderPerguntaBemIsentoPorPequenoValor()) {
            alienacaoBemImovel.getBemGrandeValor().clear();
        }
    }

    private void tratarExibicaoPerguntaPropriedadeOutroImovel(AlienacaoBemImovel alienacaoBemImovel) {
        if (!GCAPFacade.getInstancia().deveExibirPerguntaPossuiOutroImovel(alienacaoBemImovel)) {
            alienacaoBemImovel.getPerguntas().getPropriedadeOutroImovel().clear();
        }
    }

    private void tratarExibicaoPerguntaImovelResidencial(AlienacaoBemImovel alienacaoBemImovel) {
        if (!GCAPFacade.getInstancia().deveExibirPerguntaImovelResidencial(alienacaoBemImovel)) {
            alienacaoBemImovel.getPerguntas().getImovelResidencial().clear();
        }
    }

    public void tratarExibicaoPerguntaMP252(AlienacaoBemImovel alienacaoBemImovel) {
        if (!GCAPFacade.getInstancia().deveExibirPerguntaMP252(alienacaoBemImovel)) {
            alienacaoBemImovel.getPerguntas().getMP252().clear();
            alienacaoBemImovel.getValorAplicado().clear();
        }
    }

    private void tratarExibirPerguntaOutraAlienacao5anos(AlienacaoBemImovel alienacaoBemImovel) {
        if (!"0".equals(alienacaoBemImovel.getPerguntas().getPropriedadeOutroImovel().formatado())) {
            alienacaoBemImovel.getPerguntas().getOutraAlienacao().clear();
        }
        this.tratarExibicaoPerguntaMP252(alienacaoBemImovel);
    }
}

