/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.acoes.NovoDemonstrativoAction;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.gui.GCAPBemVindo;
import br.gov.serpro.gcap.gui.GCAPTableModelAb;
import br.gov.serpro.gcap.gui.JanelaPrincipalGCAP;
import br.gov.serpro.gcap.gui.NavegacaoIf;
import br.gov.serpro.gcap.gui.PainelContainer;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.PainelPrincipalAb;
import br.gov.serpro.gcap.gui.listener.CabecalhoFichaListener;
import br.gov.serpro.gcap.gui.listener.DemonstrativoListener;
import br.gov.serpro.gcap.gui.listener.HelpListener;
import br.gov.serpro.gcap.gui.listener.MensagemFichaListener;
import br.gov.serpro.gcap.gui.listener.TabelasAtualizadasListener;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.gui.util.ProcessoSwing;
import br.gov.serpro.gcap.gui.util.Tarefa;
import br.gov.serpro.gcap.gui.util.TarefaComExcecao;
import br.gov.serpro.gcap.importacao.ImportacaoAnoAterior;
import br.gov.serpro.gcap.importacao.RestauradorCopiaSeguranca;
import br.gov.serpro.gcap.importacao.ResultadoImportacaoDTO;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.GcapUtil;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class ControladorGui {
    private static DemonstrativoGCAP demonstrativoAberto = null;
    private static PainelDemonstrativoIf painelAtualmenteExibido = null;
    private static List<DemonstrativoListener> listaEscutadores = null;
    private static List<CabecalhoFichaListener> listaEscutadoresCabecalhoFicha = null;
    private static List<MensagemFichaListener> listaEscutadoresMensagemFicha = null;
    private static List<HelpListener> listaEscutadoresHelp = null;
    private static ListenerList<TabelasAtualizadasListener> listaEscutadoresTabelasAtualizadas = null;
    private static final Preferences preferences = Preferences.userNodeForPackage(DemonstrativoGCAP.class);
    public static final String PERMITIR_MIGRACAO_GCAP = "PermitirMigracao";
    public static final String CONSTANTE_MENSAGEM_ABRIR_DEMONSTRATIVO = "msgAbrirDemonstrativo";
    public static final String NAO_EXIBIR_NOVIDADES_GCAP = "NaoExibirNovidadesGCAP" + ConstantesGlobais.EXERCICIO;

    public static Preferences getGCAPPreferences() {
        return preferences;
    }

    private static void dispatchDemonstrativoAberto() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores) {
                lListener.demonstrativoAberto();
            }
        }
    }

    private static boolean dispatchDemonstrativoVaiFechar() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores) {
                if (lListener.demonstrativoVaiFechar()) continue;
                return false;
            }
        }
        return true;
    }

    private static void dispatchDemonstrativoFechado() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores) {
                lListener.demonstrativoFechado();
            }
        }
    }

    private static void dispatchDemonstrativoSalvo() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores) {
                lListener.demonstrativoSalvo();
            }
        }
    }

    private static void dispatchMudouNumeroDemonstrativos() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores) {
                lListener.mudouNumeroDemonstrativos();
            }
        }
    }

    private static void dispatchMudouCabecalho(String novoTextoCabecalho) {
        if (listaEscutadoresCabecalhoFicha != null) {
            for (CabecalhoFichaListener lListener : listaEscutadoresCabecalhoFicha) {
                lListener.cabecalhoAlterado(novoTextoCabecalho);
            }
        }
    }

    private static void dispatchMudouMensagem(String novaMensagem) {
        if (listaEscutadoresMensagemFicha != null) {
            for (MensagemFichaListener lListener : listaEscutadoresMensagemFicha) {
                lListener.mensagemAlterada(novaMensagem);
            }
        }
    }

    private static void dispatchMudouHelpId(String novoHelpId) {
        if (listaEscutadoresHelp != null) {
            for (HelpListener lListener : listaEscutadoresHelp) {
                lListener.helpIdAlterado(novoHelpId);
            }
        }
    }

    public static void addDemonstrativoListener(DemonstrativoListener pListener) {
        if (listaEscutadores == null) {
            listaEscutadores = new ArrayList<DemonstrativoListener>();
        }
        listaEscutadores.add(pListener);
    }

    public static void removeDemonstrativoListener(DemonstrativoListener pListener) {
        if (listaEscutadores != null) {
            listaEscutadores.remove(pListener);
            if (listaEscutadores.isEmpty()) {
                listaEscutadores = null;
            }
        }
    }

    public static void addCabecalhoFichaListener(CabecalhoFichaListener pListener) {
        if (listaEscutadoresCabecalhoFicha == null) {
            listaEscutadoresCabecalhoFicha = new ArrayList<CabecalhoFichaListener>();
        }
        listaEscutadoresCabecalhoFicha.add(pListener);
    }

    public static void addMensagemFichaListener(MensagemFichaListener pListener) {
        if (listaEscutadoresMensagemFicha == null) {
            listaEscutadoresMensagemFicha = new ArrayList<MensagemFichaListener>();
        }
        listaEscutadoresMensagemFicha.add(pListener);
    }

    public static void removeMensagemFichaListener(MensagemFichaListener pListener) {
        if (listaEscutadoresMensagemFicha != null) {
            listaEscutadoresMensagemFicha.remove(pListener);
            if (listaEscutadoresMensagemFicha.isEmpty()) {
                listaEscutadoresMensagemFicha = null;
            }
        }
    }

    public static void addHelpListener(HelpListener pListener) {
        if (listaEscutadoresHelp == null) {
            listaEscutadoresHelp = new ArrayList<HelpListener>();
        }
        listaEscutadoresHelp.add(pListener);
    }

    public static void removeHelpListener(HelpListener pListener) {
        if (listaEscutadoresHelp != null) {
            listaEscutadoresHelp.remove(pListener);
            if (listaEscutadoresHelp.isEmpty()) {
                listaEscutadoresHelp = null;
            }
        }
    }

    public static void init() {
        if (ControladorGui.isDemonstrativoAberto()) {
            ControladorGui.dispatchDemonstrativoAberto();
        } else {
            ControladorGui.dispatchDemonstrativoFechado();
        }
        ControladorGui.dispatchMudouNumeroDemonstrativos();
        GCAPBemVindo painelBemVindos = (GCAPBemVindo)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
        ControladorGui.addDemonstrativoListener(painelBemVindos);
        ControladorGui.acionarPainel(painelBemVindos);
    }

    private static void verificarExisteDemonstrativo() {
        if (!ControladorGui.existemDemonstrativos() && GuiUtil.mostrarConfirma("ConfirmaAindaNaoExisteDemonstrativo")) {
            new NovoDemonstrativoAction().actionPerformed(null);
        }
    }

    public static DemonstrativoGCAP getDemonstrativoAberto() {
        return demonstrativoAberto;
    }

    private static void setDemonstrativoAberto(DemonstrativoGCAP pDemonstrativoAberto) {
        demonstrativoAberto = pDemonstrativoAberto;
    }

    public static void setPainelAtualmenteExibido(PainelDemonstrativoIf pPainelAtualmenteExibido) {
        painelAtualmenteExibido = pPainelAtualmenteExibido;
    }

    public static PainelDemonstrativoIf getPainelAtualmenteExibido() {
        return painelAtualmenteExibido;
    }

    public static void tratarException(Exception pExcecao) {
        if (pExcecao instanceof AplicacaoException) {
            GuiUtil.mostrarErro(pExcecao);
        } else if (pExcecao instanceof HashInvalidoException) {
            HashInvalidoException ex = (HashInvalidoException)pExcecao;
            FabricaUtilitarios.printStackEmDesenvolvimento((Exception)pExcecao);
            int result = JOptionPane.showConfirmDialog(null, "Foi detectado que o arquivo desta declara\u00e7\u00e3o est\u00e1 corrompido. \nGostaria que o sistema restaurasse um backup deste arquivo?", "Erro ao Abrir", 0, 0);
            if (result == 0) {
                try {
                    GCAPFacade.getInstancia().restaurarBackup(ex.getPathArquivo());
                    JOptionPane.showMessageDialog(null, "Declara\u00e7\u00e3o restaurada do backup com sucesso.", "Backup Restaurado", 1, null);
                }
                catch (BackupInexistenteException e) {
                    JOptionPane.showMessageDialog(null, "Ocorreu um erro ao restaurar o backup. \nN\u00e3o foi poss\u00edvel localizar o arquivo de backup em: " + e.getArquivoBkp(), "Erro ao Restaurar Backup", 0, null);
                }
            }
        } else {
            LogPPGD.erro((String)pExcecao.getMessage());
            pExcecao.printStackTrace();
        }
    }

    public static boolean acionarPainel(String pPainelStr) {
        boolean lTrocouPainel = false;
        try {
            JPanel painelAcionado = PainelCacher.getInstancia().obtemUrgentemente(pPainelStr);
            if (painelAcionado == null) {
                Class<?> c = Class.forName(pPainelStr);
                painelAcionado = (JPanel)c.newInstance();
            }
            lTrocouPainel = ControladorGui.acionarPainel((PainelDemonstrativoIf)((Object)painelAcionado));
        }
        catch (Exception ex) {
            ControladorGui.tratarException(ex);
        }
        return lTrocouPainel;
    }

    public static boolean acionarPainel(PainelDemonstrativoIf pPainelAcionado) {
        PainelDemonstrativoIf painelAtual = ControladorGui.getPainelAtualmenteExibido();
        GuiUtil.adicionarEnterComoTeclaDeNavegacao((JPanel)((Object)pPainelAcionado));
        if (painelAtual == null) {
            try {
                ControladorGui.alterarPainel(pPainelAcionado);
                return true;
            }
            catch (Exception ex) {
                ControladorGui.tratarException(ex);
            }
        } else if (!ControladorGui.getPainelAtualmenteExibido().getClass().getName().equals(pPainelAcionado.getClass().getName()) && painelAtual.isPodeSair()) {
            try {
                if (pPainelAcionado instanceof PainelPrincipalAb) {
                    PainelPrincipalAb painelPrincipal = (PainelPrincipalAb)pPainelAcionado;
                    GCAPTableModelAb gcapTableModel = (GCAPTableModelAb)painelPrincipal.getTabela().getModel();
                    gcapTableModel.refresh();
                }
                ControladorGui.alterarPainel(pPainelAcionado);
                return true;
            }
            catch (Exception ex) {
                ControladorGui.tratarException(ex);
            }
        }
        return false;
    }

    private static void alterarPainel(PainelDemonstrativoIf pPainelAcionado) throws Exception {
        pPainelAcionado.preExibir();
        PainelContainer lPainelBasico = ControladorGui.obterPainelContainer();
        ControladorGui.salvarDemonstrativoAberto();
        ImageIcon lImagem = pPainelAcionado.getImagemTitulo();
        if (lImagem != null) {
            lPainelBasico.setImagem(lImagem);
        }
        lPainelBasico.mudaCorpoPainelPrincipal(pPainelAcionado);
        ControladorGui.setPainelAtualmenteExibido(pPainelAcionado);
        PlataformaPPGD.getPlataforma().mudaPainelExibido((JPanel)lPainelBasico);
        JComponent lComponent = pPainelAcionado.getDefaultFocus();
        if (lComponent != null && GcapUtil.getEstadoSistema() != 1) {
            lComponent.requestFocusInWindow();
        }
        pPainelAcionado.posExibir();
    }

    private static PainelContainer obterPainelContainer() {
        return (PainelContainer)PainelCacher.getInstancia().obtemUrgentemente(PainelContainer.class.getName());
    }

    public static JanelaPrincipalGCAP getJanelaPrincipal() {
        return (JanelaPrincipalGCAP)PlataformaPPGD.getPlataforma().getJanelaPrincipal();
    }

    public static void fecharDemonstrativo() {
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                if (ControladorGui.dispatchDemonstrativoVaiFechar()) {
                    DemonstrativoGCAP lDemonstrativoAberto = ControladorGui.getDemonstrativoAberto();
                    lDemonstrativoAberto.ajustarFlagCobranca();
                    lDemonstrativoAberto.atualizarCalculoFaixasImposto();
                    lDemonstrativoAberto.atualizarDataDarfTCM();
                    GCAPFacade.getInstancia().salvarDeclaracao(lDemonstrativoAberto);
                    GCAPFacade.getInstancia().fazerBackup(GCAPFacade.getInstancia().getIdDeclaracaoAberto());
                    lDemonstrativoAberto.removeObservadores(new Class[]{JPanel.class});
                    ControladorGui.removeListeners();
                    PainelCacher.getInstancia().encerra();
                    ControladorGui.setPainelAtualmenteExibido(null);
                    ControladorGui.setDemonstrativoAberto(null);
                    MapeamentoInformacaoEditCampo.limpaAssociacoes();
                    GCAPFacade.limpaCacheDeclaracoes();
                    ControladorGui.dispatchDemonstrativoFechado();
                    System.gc();
                    GCAPBemVindo painelBemVindos = (GCAPBemVindo)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
                    ControladorGui.addDemonstrativoListener(painelBemVindos);
                    ControladorGui.acionarPainel(painelBemVindos);
                }
                GcapUtil.setEstadoSistema(-1);
            }
        }
        catch (Exception e) {
            GcapUtil.setEstadoSistema(-1);
            ControladorGui.tratarException(e);
        }
    }

    public static void informarTabelasAtualizadas() {
        ControladorGui.dispatchTabelasAtualizadas();
    }

    private static void dispatchTabelasAtualizadas() {
        if (listaEscutadoresTabelasAtualizadas != null) {
            for (TabelasAtualizadasListener lListener : listaEscutadoresTabelasAtualizadas.list()) {
                lListener.tabelasAtualizadas();
            }
        }
    }

    private static void removeListeners() {
        PainelContainer painelContainer = ControladorGui.obterPainelContainer();
        ControladorGui.removeMensagemFichaListener(painelContainer);
        ControladorGui.removeHelpListener(painelContainer);
        ControladorGui.removeDemonstrativoListener(painelContainer.getHoraSalvamentoPanel1());
    }

    public static void abrirDemonstrativo(final IdDemonstrativoGCAP pId, boolean pExecutaProcessoSwing) throws HashInvalidoException {
        block6: {
            if (pExecutaProcessoSwing) {
                try {
                    ProcessoSwing.executarTarefaComExcecao(new TarefaComExcecao(){

                        @Override
                        public Object definirTarefa() throws Exception {
                            ControladorGui.abrirDemonstrativo(pId);
                            return null;
                        }

                        @Override
                        public void definirComportamentoExcecao(Exception exception) {
                            if (exception instanceof HashInvalidoException) {
                                ControladorGui.tratarException(exception);
                            } else if (exception.getCause() instanceof HashInvalidoException) {
                                ControladorGui.tratarException((Exception)((HashInvalidoException)exception.getCause()));
                            } else {
                                LogPPGD.erro((String)exception.getMessage());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof HashInvalidoException) {
                        ControladorGui.tratarException(e);
                        break block6;
                    }
                    if (e.getCause() instanceof HashInvalidoException) {
                        ControladorGui.tratarException((Exception)((HashInvalidoException)e.getCause()));
                        break block6;
                    }
                    LogPPGD.erro((String)e.getMessage());
                }
            } else {
                ControladorGui.abrirDemonstrativo(pId);
            }
        }
        ControladorGui.exibirMensagemSalvaEmPreferencias(CONSTANTE_MENSAGEM_ABRIR_DEMONSTRATIVO);
    }

    public static void abrirDemonstrativo(final DemonstrativoGCAP pDec, boolean pExecutaProcessoSwing) {
        if (pExecutaProcessoSwing) {
            ProcessoSwing.executarTarefa(new Tarefa(){

                @Override
                public Object definirTarefa() {
                    ControladorGui.abrirDemonstrativo(pDec);
                    return null;
                }
            });
        } else {
            ControladorGui.abrirDemonstrativo(pDec);
        }
    }

    private static void abrirDemonstrativo(IdDemonstrativoGCAP pId) throws HashInvalidoException {
        try {
            String territorioParaisoFiscal = pId.getTerritorioParaisoFiscal().naoFormatado();
            GcapUtil.setEstadoSistema(-1);
            PainelContainer pc = ControladorGui.obterPainelContainer();
            ControladorGui.addDemonstrativoListener(pc.getHoraSalvamentoPanel1());
            ControladorGui.addCabecalhoFichaListener(pc);
            ControladorGui.addMensagemFichaListener(pc);
            ControladorGui.addHelpListener(pc);
            GCAPBemVindo painelBemVindos = (GCAPBemVindo)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
            ControladorGui.removeDemonstrativoListener(painelBemVindos);
            GCAPFacade.abreDeclaracao(pId);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
            ControladorGui.setDemonstrativoAberto(GCAPFacade.getInstancia().getDeclaracao());
            ControladorGui.dispatchDemonstrativoAberto();
            ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_CONTRIBUINTE);
            ControladorGui.getJanelaPrincipal().setLastAccessedItem(NavegacaoIf.PAINEL_IDENTIFICACAO_CONTRIBUINTE);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
            ControladorGui.getPainelAtualmenteExibido().getDefaultFocus().requestFocusInWindow();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAP2020_1_5();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAP2024_1_2();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAPSemFaixasAjuste();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAP2025_1_0();
            ControladorGui.getDemonstrativoAberto().getTotalizacaoMoedasAlienadas().recalcular();
            GcapUtil.setEstadoSistema(0);
        }
        catch (HashInvalidoException e) {
            throw e;
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    private static void abrirDemonstrativo(DemonstrativoGCAP pDec) {
    }

    public static void abrirDemonstrativoSemUI(IdDemonstrativoGCAP pId) throws HashInvalidoException {
        try {
            GcapUtil.setEstadoSistema(-1);
            PainelContainer pc = ControladorGui.obterPainelContainer();
            ControladorGui.addDemonstrativoListener(pc.getHoraSalvamentoPanel1());
            ControladorGui.addCabecalhoFichaListener(pc);
            ControladorGui.addMensagemFichaListener(pc);
            ControladorGui.addHelpListener(pc);
            GCAPBemVindo painelBemVindos = (GCAPBemVindo)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
            ControladorGui.removeDemonstrativoListener(painelBemVindos);
            GCAPFacade.abreDeclaracaoSemUI(pId);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
            ControladorGui.setDemonstrativoAberto(GCAPFacade.getInstancia().getDeclaracao());
            ControladorGui.dispatchDemonstrativoAberto();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
            ControladorGui.getDemonstrativoAberto().atualizarDataDarfTCM();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAP2020_1_5();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAP2024_1_2();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAPSemFaixasAjuste();
            ControladorGui.getDemonstrativoAberto().corrigirErroGCAP2025_1_0();
            ControladorGui.getDemonstrativoAberto().getTotalizacaoMoedasAlienadas().recalcular();
            GcapUtil.setEstadoSistema(0);
        }
        catch (HashInvalidoException e) {
            throw e;
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void fecharDemonstrativoSemUI() {
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                if (ControladorGui.dispatchDemonstrativoVaiFechar()) {
                    DemonstrativoGCAP lDemonstrativoAberto = ControladorGui.getDemonstrativoAberto();
                    lDemonstrativoAberto.ajustarFlagCobranca();
                    lDemonstrativoAberto.atualizarCalculoFaixasImposto();
                    GCAPFacade.getInstancia().salvarDeclaracao(lDemonstrativoAberto);
                    lDemonstrativoAberto.removeObservadores(new Class[]{JPanel.class});
                    ControladorGui.removeListeners();
                    PainelCacher.getInstancia().encerra();
                    ControladorGui.setPainelAtualmenteExibido(null);
                    ControladorGui.setDemonstrativoAberto(null);
                    MapeamentoInformacaoEditCampo.limpaAssociacoes();
                    GCAPFacade.limpaCacheDeclaracoes();
                    ControladorGui.dispatchDemonstrativoFechado();
                    System.gc();
                    GCAPBemVindo painelBemVindos = (GCAPBemVindo)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
                    ControladorGui.addDemonstrativoListener(painelBemVindos);
                    ControladorGui.acionarPainel(painelBemVindos);
                }
                GcapUtil.setEstadoSistema(-1);
            }
        }
        catch (Exception e) {
            GcapUtil.setEstadoSistema(-1);
            ControladorGui.tratarException(e);
        }
    }

    public static boolean isDemonstrativoAberto() {
        return ControladorGui.getDemonstrativoAberto() != null;
    }

    public static void salvarDemonstrativoAberto() throws Exception {
        DemonstrativoGCAP dec = ControladorGui.getDemonstrativoAberto();
        if (dec != null) {
            ControladorGui.salvarDemonstrativo(dec);
        }
    }

    public static void salvarDemonstrativo(DemonstrativoGCAP dec) throws Exception {
        GCAPFacade.getInstancia().salvarDeclaracao(dec);
        ControladorGui.dispatchDemonstrativoSalvo();
        ControladorGui.dispatchMudouNumeroDemonstrativos();
    }

    public static void excluirDemonstrativo(List<IdDemonstrativoGCAP> pIds) {
        try {
            for (IdDemonstrativoGCAP identificadorDeclaracao : pIds) {
                GCAPFacade.excluirDeclaracao(identificadorDeclaracao);
            }
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
        ControladorGui.dispatchMudouNumeroDemonstrativos();
    }

    public static boolean existemDemonstrativos() {
        try {
            return GCAPFacade.getInstancia().existeDeclaracoes();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
            return false;
        }
    }

    public static void alterarCabecalhoFicha(String novoTextoCabecalho) {
        try {
            ControladorGui.dispatchMudouCabecalho(novoTextoCabecalho);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void atualizarSubtitulo(String subtitulo) {
        ControladorGui.obterPainelContainer().subtituloAlterado(subtitulo);
    }

    public static void alterarMensagemFicha(String novaMensagem) {
        try {
            ControladorGui.dispatchMudouMensagem(novaMensagem);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void alterarHelpId(String novoHelpId) {
        try {
            ControladorGui.dispatchMudouHelpId(novoHelpId);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void atualizarNumeroDemonstrativos() {
        try {
            ControladorGui.dispatchMudouNumeroDemonstrativos();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static ResultadoImportacaoDTO importaDemonstrativoExercicioAnterior(File[] pArquivos) {
        ResultadoImportacaoDTO resultado = null;
        ImportacaoAnoAterior importacao = new ImportacaoAnoAterior();
        try {
            resultado = importacao.importaDemonstrativoExercicioAnterior(pArquivos);
            ControladorGui.dispatchMudouNumeroDemonstrativos();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
        return resultado;
    }

    public static ResultadoImportacaoDTO restaurarCopiaSeguranca(File[] pArquivos) {
        ResultadoImportacaoDTO resultado = null;
        RestauradorCopiaSeguranca importacao = new RestauradorCopiaSeguranca();
        try {
            resultado = importacao.restaurarCopiaSeguranca(pArquivos);
            ControladorGui.dispatchMudouNumeroDemonstrativos();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
        return resultado;
    }

    public static void exibirMensagemSalvaEmPreferencias(String constante) {
        String msg = ControladorGui.getGCAPPreferences().get(constante, null);
        if (msg != null) {
            GuiUtil.mostrarInfoSemQuebraDeLinha(msg);
            ControladorGui.getGCAPPreferences().remove(constante);
        }
    }

    public static class ListenerList<E> {
        private final ArrayList<WeakReference<E>> list = new ArrayList();

        public void add(E e) {
            this.list.add(new WeakReference<E>(e));
        }

        public boolean remove(Object o) {
            return this.list.removeIf(e -> e == null || e.get() == null || Objects.equals(e.get(), o));
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public List<E> list() {
            return this.list.stream().filter(e -> e != null && e.get() != null).map(e -> e.get()).collect(Collectors.toList());
        }
    }
}

