/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.gui.listener.ToolBarListener;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GCAPToolbar
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private List<ToolBarListener> listaEscutadores;
    private JButton[] botoesExtras = null;
    private JButton jButtonAbrir;
    private JButton jButtonExcluir;
    private JButton jButtonNovo;

    public GCAPToolbar() {
        this.initComponents();
        this.botoesExtras = new JButton[0];
        GuiUtil.inibirEnterNavegacaoFocoBotoes(this.jButtonNovo, this.jButtonAbrir, this.jButtonExcluir);
    }

    public GCAPToolbar(String botaoNovo, String botaoAbrir, String botaoExcluir, String ... botoesExtras) {
        this.initComponents(botaoNovo, botaoAbrir, botaoExcluir, botoesExtras);
        JButton[] b1 = new JButton[]{this.jButtonNovo, this.jButtonAbrir, this.jButtonExcluir};
        JButton[] b2 = Arrays.copyOf(this.botoesExtras, this.botoesExtras.length + b1.length);
        System.arraycopy(b1, 0, b2, this.botoesExtras.length, b1.length);
        GuiUtil.inibirEnterNavegacaoFocoBotoes(b2);
    }

    private void initComponents(String botaoNovo, String botaoAbrir, String botaoExcluir, String ... botoesExtras) {
        char mnemonico;
        int indexMnemonico;
        this.jButtonNovo = new JButton();
        this.jButtonAbrir = new JButton();
        this.jButtonExcluir = new JButton();
        this.setBorder(null);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(2));
        this.botoesExtras = new JButton[botoesExtras.length];
        int index = 0;
        for (String nome : botoesExtras) {
            if (nome == null || !nome.isEmpty()) {
                // empty if block
            }
            indexMnemonico = nome.indexOf(95) + 1 % nome.length();
            mnemonico = nome.toLowerCase().charAt(indexMnemonico);
            nome = nome.replaceAll("_", "");
            JButton botao = new JButton();
            botao.setMnemonic(mnemonico);
            botao.setText(nome);
            botao.setToolTipText(nome);
            botao.setPreferredSize(new Dimension(90, 25));
            botao.addActionListener(new IndexedActionListener(index));
            this.add(botao);
            this.botoesExtras[index] = botao;
            ++index;
        }
        indexMnemonico = botaoNovo.indexOf(95) + 1 % botaoNovo.length();
        mnemonico = botaoNovo.toLowerCase().charAt(indexMnemonico);
        botaoNovo = botaoNovo.replaceAll("_", "");
        this.jButtonNovo.setMnemonic(mnemonico);
        this.jButtonNovo.setText(botaoNovo);
        this.jButtonNovo.setToolTipText(botaoNovo);
        this.jButtonNovo.setPreferredSize(new Dimension(90, 25));
        this.jButtonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAPToolbar.this.jButtonNovoActionPerformed(evt);
            }
        });
        this.add(this.jButtonNovo);
        indexMnemonico = botaoAbrir.indexOf(95) + 1 % botaoAbrir.length();
        mnemonico = botaoAbrir.toLowerCase().charAt(indexMnemonico);
        botaoAbrir = botaoAbrir.replaceAll("_", "");
        this.jButtonAbrir.setMnemonic(mnemonico);
        this.jButtonAbrir.setText(botaoAbrir);
        this.jButtonAbrir.setToolTipText(botaoAbrir);
        this.jButtonAbrir.setEnabled(false);
        this.jButtonAbrir.setPreferredSize(new Dimension(90, 25));
        this.jButtonAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAPToolbar.this.jButtonAbrirActionPerformed(evt);
            }
        });
        this.add(this.jButtonAbrir);
        indexMnemonico = botaoExcluir.indexOf(95) + 1 % botaoExcluir.length();
        mnemonico = botaoExcluir.toLowerCase().charAt(indexMnemonico);
        botaoExcluir = botaoExcluir.replaceAll("_", "");
        this.jButtonExcluir.setMnemonic(mnemonico);
        this.jButtonExcluir.setText(botaoExcluir);
        this.jButtonExcluir.setToolTipText(botaoExcluir);
        this.jButtonExcluir.setEnabled(false);
        this.jButtonExcluir.setPreferredSize(new Dimension(90, 25));
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAPToolbar.this.jButtonExcluirActionPerformed(evt);
            }
        });
        this.add(this.jButtonExcluir);
    }

    private void dispatchOnBtnAbrirClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (ToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnAbrirClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnExcluirClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (ToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnExcluirClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnNovoClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (ToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnNovoClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnClick(int index, ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (ToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnClick(index, pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    public void addToolBarListener(ToolBarListener pListener) {
        if (this.listaEscutadores == null) {
            this.listaEscutadores = new ArrayList<ToolBarListener>();
        }
        this.listaEscutadores.add(pListener);
    }

    public void removeToolBarListener(ToolBarListener pListener) {
        if (this.listaEscutadores != null) {
            this.listaEscutadores.remove(pListener);
            if (this.listaEscutadores.isEmpty()) {
                this.listaEscutadores = null;
            }
        }
    }

    public JButton getBtnAbrir() {
        return this.jButtonAbrir;
    }

    public JButton getBtnNovo() {
        return this.jButtonNovo;
    }

    public JButton getBtnExcluir() {
        return this.jButtonExcluir;
    }

    private void initComponents() {
        this.jButtonNovo = new JButton();
        this.jButtonAbrir = new JButton();
        this.jButtonExcluir = new JButton();
        this.setBorder(null);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(2));
        this.jButtonNovo.setMnemonic('n');
        this.jButtonNovo.setText("Novo");
        this.jButtonNovo.setToolTipText("Novo");
        this.jButtonNovo.setPreferredSize(new Dimension(90, 25));
        this.jButtonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAPToolbar.this.jButtonNovoActionPerformed(evt);
            }
        });
        this.add(this.jButtonNovo);
        this.jButtonAbrir.setMnemonic('e');
        this.jButtonAbrir.setText("Editar");
        this.jButtonAbrir.setToolTipText("Editar");
        this.jButtonAbrir.setEnabled(false);
        this.jButtonAbrir.setPreferredSize(new Dimension(90, 25));
        this.jButtonAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAPToolbar.this.jButtonAbrirActionPerformed(evt);
            }
        });
        this.add(this.jButtonAbrir);
        this.jButtonExcluir.setMnemonic('x');
        this.jButtonExcluir.setText("Excluir");
        this.jButtonExcluir.setToolTipText("Excluir");
        this.jButtonExcluir.setEnabled(false);
        this.jButtonExcluir.setPreferredSize(new Dimension(90, 25));
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAPToolbar.this.jButtonExcluirActionPerformed(evt);
            }
        });
        this.add(this.jButtonExcluir);
    }

    private void jButtonNovoActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnNovoClick(evt);
    }

    private void jButtonAbrirActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnAbrirClick(evt);
    }

    private void jButtonExcluirActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnExcluirClick(evt);
    }

    private void jButtonActionPerformed(int index, ActionEvent evt) {
        this.dispatchOnBtnClick(index, evt);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        this.jButtonAbrir.setEnabled(!lsm.isSelectionEmpty());
        this.jButtonExcluir.setEnabled(!lsm.isSelectionEmpty());
    }

    public JButton[] getBotoesExtras() {
        return this.botoesExtras;
    }

    private class IndexedActionListener
    implements ActionListener {
        private int index;

        public IndexedActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GCAPToolbar.this.jButtonActionPerformed(this.index, e);
        }
    }
}

