/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.acoes.AbrirCalculadoraAction;
import br.gov.serpro.gcap.acoes.AbrirDemonstrativoAction;
import br.gov.serpro.gcap.acoes.AjudaAcessibilidadeAction;
import br.gov.serpro.gcap.acoes.AjudaAction;
import br.gov.serpro.gcap.acoes.ExcluirDemonstrativoAction;
import br.gov.serpro.gcap.acoes.ExibirAtalhosPGDGCAPAction;
import br.gov.serpro.gcap.acoes.ExportarIRPFAction;
import br.gov.serpro.gcap.acoes.FecharDemonstrativoAction;
import br.gov.serpro.gcap.acoes.GravarCopiaSegurancaAction;
import br.gov.serpro.gcap.acoes.ImportarExercicioAnteriorAction;
import br.gov.serpro.gcap.acoes.ImprimirDarfAction;
import br.gov.serpro.gcap.acoes.ImprimirDarfMoedaEspecieAction;
import br.gov.serpro.gcap.acoes.ImprimirDemonstrativoAction;
import br.gov.serpro.gcap.acoes.MudarPainelAction;
import br.gov.serpro.gcap.acoes.NovoDemonstrativoAction;
import br.gov.serpro.gcap.acoes.RestaurarCopiaSegurancaAction;
import br.gov.serpro.gcap.acoes.SairAction;
import br.gov.serpro.gcap.acoes.SobreAction;
import br.gov.serpro.gcap.acoes.VerificarNovaVersaoAction;
import br.gov.serpro.gcap.acoes.VerificarPendenciasAction;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.NavegacaoIf;
import br.gov.serpro.gcap.gui.componente.JDegradePanel;
import br.gov.serpro.gcap.gui.componente.JTaskAction;
import br.gov.serpro.gcap.gui.consolidacaogeral.PainelDadosConsolidacaoGeral;
import br.gov.serpro.gcap.gui.especie.PainelDadosMoedas;
import br.gov.serpro.gcap.gui.listener.DemonstrativoListener;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.TaskPaneUI;
import org.jdesktop.swingx.plaf.misc.GlossyTaskPaneUI;
import serpro.ppgd.infraestrutura.JanelaPrincipalPPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.eventos.BarramentoEventos;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class JanelaPrincipalGCAP
extends JFrame
implements JanelaPrincipalPPGD,
DemonstrativoListener {
    private static final Border BORDA_PRIMEIRO_TASKPANE = BorderFactory.createEmptyBorder(10, 0, 0, 0);
    private static final Border BORDA_ULTIMO_TASKPANE = BorderFactory.createEmptyBorder(0, 0, 10, 0);
    private static final Border BORDA_UNICO_TASKPANE = BorderFactory.createEmptyBorder(10, 0, 10, 0);
    private static final long serialVersionUID = 1L;
    private static final JDegradePanel painelVazio;
    private static final Color BACKGROUND_COLOR_TOOLBAR;
    private static final Color COR_FONTE_TASKPANE;
    private Map<String, String> backupTitles;
    private JXTaskPaneContainer tpcMenu;
    private JXTaskPaneContainer tpcToolbar;
    private JXTaskPane taskPaneFichasDeclaracao;
    private JTaskAction taskIdentificacao;
    private JTaskAction taskBensImoveis;
    private JTaskAction taskBensMoveis;
    private JTaskAction taskParticipacaoSocietarias;
    private JTaskAction taskMoedasEspecie;
    private JTaskAction taskConsolidacaoGeral;
    private JTaskAction taskNovo;
    private JTaskAction taskAbrir;
    private JTaskAction taskFechar;
    private JTaskAction taskExcluir;
    private JTaskAction taskImprimirDemonstrativo;
    private JTaskAction taskImprimirDarf;
    private JTaskAction taskImprimirDarfMoedaEspecie;
    private JTaskAction taskGravarEntrega;
    private JTaskAction taskVerificarAtualizacao;
    private JTaskAction taskGravarCopia;
    private JTaskAction taskRecuperarCopia;
    private JTaskAction taskCalculadora;
    private JTaskAction taskAjudaConteudo;
    private JTaskAction taskAjudaInstrucoes;
    private JTaskAction taskAjudaSobre;
    private JTaskAction taskAjudaProgramasIRPF;
    private JTaskAction taskImportarGcapExercicioAnterior;
    private boolean minimized;
    private int dividerPosition;
    private Icon iconeMinimizar;
    private Icon iconeMaximizar;
    private JLabel jLabelRedimensionar;
    private JMenu jMenuAjuda;
    private JMenuBar jMenuBarIRPF;
    private JMenu jMenuCopiaSeguranca;
    private JMenu jMenuDeclaracao;
    private JMenu jMenuFerramentas;
    private JMenu jMenuFichas;
    private JMenu jMenuInfoContribuinte;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItemAbrir;
    private JMenuItem jMenuItemAjudaAcessibilidade;
    private JMenuItem jMenuItemAjudaAcessibilidade1;
    private JMenuItem jMenuItemComoFazerPara;
    private JMenuItem jMenuItemConteudo;
    private JMenuItem jMenuItemExcluir;
    private JMenuItem jMenuItemFechar;
    private JMenuItem jMenuItemGravar;
    private JMenuItem jMenuItemImportarGCAPExercicioAnterior;
    private JMenu jMenuItemImprimir;
    private JMenuItem jMenuItemImprimirDarf;
    private JMenuItem jMenuItemImprimirDarfMoeda;
    private JMenuItem jMenuItemImprimirDemonstrativo;
    private JMenuItem jMenuItemInstPreenchimento;
    private JMenuItem jMenuItemNova;
    private JMenuItem jMenuItemProgramasIRPF;
    private JMenuItem jMenuItemRestaurar;
    private JMenuItem jMenuItemSair;
    private JMenuItem jMenuItemSobre;
    private JMenuItem jMenuItemVerificarPendencias;
    private JPanel jPanel2;
    private JPanel jPanelIRPF;
    private JPanel jPanelPaineis;
    private JPanel jPanelPrincipal;
    private JPanel jPanelRedimensionar;
    private JPanel jPanelTasks;
    private JPopupMenu jPopupMenuImprimir;
    private JMenuItem jPopupMenuItemImprimirDeclaracao;
    private JScrollPane jScrollPaneDireita;
    private JScrollPane jScrollPaneEsquerda;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JSplitPane jSplitPaneIRPF;
    private JXCollapsiblePane jXCollapsiblePane1;
    private JXCollapsiblePane jXCollapsiblePane2;
    private JLabel lblRetrairMenu;
    private JMenuItem menuItemFichaConsolidacaoGeral;
    private JMenuItem menuItemFichaDemonstrativo;
    private JMenuItem menuItemFichaDemonstrativo1;
    private JMenuItem menuItemFichaEscrituracao;
    private JMenuItem menuItemFichaIdentificao;

    private static void carregarPadroesInterface(boolean flat) {
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            if (System.getProperty("os.name").toUpperCase().indexOf("VISTA") < 0) {
                System.setProperty("sun.awt.noerasebackground", "true");
            }
            UIManager.setLookAndFeel("net.sf.tinylaf.TinyLookAndFeel");
            if (flat) {
                URL lUrl = TinyLookAndFeel.class.getResource("/Default-flat.theme");
                Theme.loadTheme((URL)lUrl);
            } else {
                URL lUrl = TinyLookAndFeel.class.getResource("/Default-orig.theme");
                Theme.loadTheme((URL)lUrl);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
        UIManager.put("OptionPane.yesButtonText", "Sim");
        UIManager.put("OptionPane.yesButtonMnemonic", "83");
        UIManager.put("OptionPane.noButtonText", "N\u00e3o");
        UIManager.put("OptionPane.noButtonMnemonic", "78");
        UIManager.put("OptionPane.okButtonText", "Ok");
        UIManager.put("OptionPane.okButtonMnemonic", "79");
        UIManager.put("OptionPane.cancelButtonText", "Cancelar");
        UIManager.put("OptionPane.cancelButtonMnemonic", "67");
        UIManager.put("OptionPane.errorIcon", new IconUIResource(GuiUtil.getImage("/icones/erro.png")));
        UIManager.put("OptionPane.informationIcon", new IconUIResource(GuiUtil.getImage("/icones/info.png")));
        UIManager.put("OptionPane.questionIcon", new IconUIResource(GuiUtil.getImage("/icones/pergunta.png")));
        UIManager.put("OptionPane.warningIcon", new IconUIResource(GuiUtil.getImage("/icones/atencao.png")));
        UIManager.put("FileChooser.lookInLabelText", "Procurar em:");
        UIManager.put("FileChooser.saveInLabelText", "Salvar em:");
        UIManager.put("FileChooser.filesOfTypeLabelText", "Tipo do Arquivo:");
        UIManager.put("FileChooser.saveButtonText", "Salvar");
        UIManager.put("FileChooser.cancelButtonText", "Cancelar");
        UIManager.put("FileChooser.cancelButtonMnemonic", "67");
        UIManager.put("FileChooser.fileNameLabelText", "Nome do Arquivo:");
        UIManager.put("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.misc.GlossyTaskPaneUI");
        if (flat) {
            UIManager.put("TaskPane.titleBackgroundGradientStart", new ColorUIResource(new Color(204, 227, 252)));
            UIManager.put("TaskPane.titleBackgroundGradientEnd", new ColorUIResource(new Color(204, 227, 252)));
            UIManager.put("OptionPane.background", new ColorUIResource(241, 245, 249));
            UIManager.put("Panel.background", new ColorUIResource(241, 245, 249));
            UIManager.put("Label.foreground", new ColorUIResource(55, 55, 55));
            UIManager.put("CheckBox.foreground", new ColorUIResource(55, 55, 55));
        } else {
            UIManager.put("TaskPane.titleBackgroundGradientStart", new ColorUIResource(new Color(250, 250, 250)));
            UIManager.put("TaskPane.titleBackgroundGradientEnd", new ColorUIResource(new Color(178, 198, 221)));
            UIManager.put("TaskPane.borderColor", new ColorUIResource(new Color(177, 188, 199)));
        }
        UIManager.put("TaskPane.specialTitleForeground", new ColorUIResource(new Color(27, 71, 44)));
        UIManager.put("TaskPane.specialTitleBackground", new ColorUIResource(new Color(160, 225, 185)));
        UIManager.put("TaskPane.background", new ColorUIResource(JTaskAction.BACKGROUND_COLOR));
        UIManager.put("swingx/TaskPaneContainerUI", "org.jdesktop.swingx.plaf.basic.BasicTaskPaneContainerUI");
        UIManager.put("TaskPaneContainer.backgroundPainter", new PainterUIResource((Painter)new MattePainter((Paint)BACKGROUND_COLOR_TOOLBAR, true)));
        UIManager.put("TaskPaneContainer.background", new ColorUIResource(BACKGROUND_COLOR_TOOLBAR));
        UIManager.put("TableHeader.cellBorder", new BorderUIResource(BorderFactory.createMatteBorder(0, 0, 1, 1, new Color(177, 188, 199))));
        UIManager.put("Table.scrollPaneBorder", new BorderUIResource(BorderFactory.createMatteBorder(1, 1, 0, 0, new Color(177, 188, 199))));
        UIManager.put("Tree.openIcon", GuiUtil.getImage("/icones/pastaAberta.png"));
        UIManager.put("Tree.closedIcon", GuiUtil.getImage("/icones/pastaFechada.png"));
        UIManager.put("ToolTip.foreground", new Color(0, 74, 106));
        UIManager.put("ToolTip.background", new Color(213, 238, 251));
    }

    private void carregarMenuLateral() {
        this.taskNovo = new JTaskAction("Novo", new NovoDemonstrativoAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_novo.png"));
        this.taskAbrir = new JTaskAction("Abrir", new AbrirDemonstrativoAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_abrir.png"));
        this.taskFechar = new JTaskAction("Fechar", new FecharDemonstrativoAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_fechar.png"));
        this.taskExcluir = new JTaskAction("Excluir", new ExcluirDemonstrativoAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_excluir.png"));
        this.taskGravarEntrega = new JTaskAction("Exportar para o IRPF " + ConstantesGlobais.EXERCICIO_POSTERIOR, new ExportarIRPFAction(), (Icon)GuiUtil.getImage("/icones/png20px/exportar.png"));
        this.taskImprimirDemonstrativo = new JTaskAction("Demonstrativo", new ImprimirDemonstrativoAction(), (Icon)GuiUtil.getImage("/icones/png20px/IM_decl.png"));
        this.taskImprimirDarf = new JTaskAction("Darf Direitos/Bens/Participa\u00e7\u00f5es Societ\u00e1rias", new ImprimirDarfAction(), (Icon)GuiUtil.getImage("/icones/png20px/IM_darf_cb.png"));
        this.taskImprimirDarfMoedaEspecie = new JTaskAction("Darf Moedas em Esp\u00e9cie", new ImprimirDarfMoedaEspecieAction(), (Icon)GuiUtil.getImage("/icones/png20px/IM_darf_cb.png"));
        this.taskVerificarAtualizacao = new JTaskAction("Verificar Atualiza\u00e7\u00f5es", new VerificarNovaVersaoAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_verificar_atualizacao.png"));
        this.taskGravarCopia = new JTaskAction("Gravar C\u00f3pia", new GravarCopiaSegurancaAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_gravar.png"));
        this.taskRecuperarCopia = new JTaskAction("Restaurar", new RestaurarCopiaSegurancaAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_recuperar.png"));
        this.taskCalculadora = new JTaskAction("Calculadora", new AbrirCalculadoraAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_calc.png"));
        this.taskImportarGcapExercicioAnterior = new JTaskAction("Importar dados do GCAP" + AplicacaoPropertiesUtil.getExercicioAnterior(), new ImportarExercicioAnteriorAction(), (Icon)GuiUtil.getImage("/icones/png20px/importar.png"));
        this.taskAjudaConteudo = new JTaskAction("Conte\u00fado", new AjudaAction(), (Icon)GuiUtil.getImage("/icones/png20px/AJ_conteudo.png"));
        this.taskAjudaInstrucoes = new JTaskAction("Instru\u00e7\u00f5es", new AjudaAction(), (Icon)GuiUtil.getImage("/icones/png20px/AJ_instrucoes.png"));
        this.taskAjudaSobre = new JTaskAction("Sobre", new SobreAction(), (Icon)GuiUtil.getImage("/icones/png20px/AJ_sobre.png"));
        this.taskAjudaProgramasIRPF = new JTaskAction("Programas de IRPF disponibilizados pela RFB", new AjudaAction("Programas de IRPF disponibilizados pela RFB"), (Icon)GuiUtil.getImage("/icones/png20px/AJ_tutorial.png"));
        int espacoItensMenu = 5;
        JXTaskPane taskPane = new JXTaskPane();
        taskPane.setName("ToolBarDeclaracao");
        taskPane.setForeground(COR_FONTE_TASKPANE);
        taskPane.setTitle("Demonstrativo                        ");
        taskPane.add((Component)this.taskNovo);
        taskPane.add((Component)this.taskAbrir);
        taskPane.add((Component)this.taskFechar);
        taskPane.add((Component)this.taskExcluir);
        taskPane.add((Component)this.taskImprimirDemonstrativo);
        taskPane.add((Component)this.taskImprimirDarf);
        taskPane.add((Component)this.taskImprimirDarfMoedaEspecie);
        ((VerticalLayout)taskPane.getContentPane().getLayout()).setGap(espacoItensMenu);
        this.tpcToolbar.add(taskPane);
        taskPane = new JXTaskPane();
        taskPane.setName("ToolBarImpressao");
        taskPane.setForeground(COR_FONTE_TASKPANE);
        taskPane.setTitle("Imprimir");
        taskPane.add((Component)this.taskImprimirDemonstrativo);
        taskPane.add((Component)this.taskImprimirDarf);
        taskPane.add((Component)this.taskImprimirDarfMoedaEspecie);
        ((VerticalLayout)taskPane.getContentPane().getLayout()).setGap(espacoItensMenu);
        this.tpcToolbar.add(taskPane);
        taskPane = new JXTaskPane();
        taskPane.setName("ToolBarFerramentas");
        taskPane.setForeground(COR_FONTE_TASKPANE);
        taskPane.setTitle("Ferramentas");
        taskPane.add((Component)this.taskGravarCopia);
        taskPane.add((Component)this.taskRecuperarCopia);
        taskPane.add((Component)this.taskImportarGcapExercicioAnterior);
        taskPane.add((Component)this.taskGravarEntrega);
        taskPane.add((Component)this.taskCalculadora);
        ((VerticalLayout)taskPane.getContentPane().getLayout()).setGap(espacoItensMenu);
        this.tpcToolbar.add(taskPane);
        taskPane = new JXTaskPane();
        taskPane.setName("ToolBarAjuda");
        taskPane.setForeground(COR_FONTE_TASKPANE);
        taskPane.setTitle("Ajuda");
        taskPane.add((Component)this.taskAjudaConteudo);
        taskPane.add((Component)this.taskAjudaInstrucoes);
        taskPane.add((Component)this.taskAjudaProgramasIRPF);
        taskPane.add((Component)this.taskAjudaSobre);
        ((VerticalLayout)taskPane.getContentPane().getLayout()).setGap(espacoItensMenu);
        this.tpcToolbar.add(taskPane);
        this.taskPaneFichasDeclaracao = new JXTaskPane();
        this.taskPaneFichasDeclaracao.setName("ToolBarFichasDeclaracao");
        this.taskPaneFichasDeclaracao.setForeground(COR_FONTE_TASKPANE);
        this.taskPaneFichasDeclaracao.setTitle("Fichas do Demonstrativo");
        this.taskIdentificacao = new JTaskAction("Identifica\u00e7\u00e3o", NavegacaoIf.PAINEL_IDENTIFICACAO_CONTRIBUINTE, (Icon)GuiUtil.getImage("/icones/png20px/DE_identificacao.png"));
        this.taskBensImoveis = new JTaskAction("Bens Im\u00f3veis", NavegacaoIf.PAINEL_BEM_IMOVEL, (Icon)GuiUtil.getImage("/icones/png20px/MN_bens_imoveis.png"));
        this.taskBensMoveis = new JTaskAction("Direitos/Bens M\u00f3veis", NavegacaoIf.PAINEL_BEM_MOVEL, (Icon)GuiUtil.getImage("/icones/png20px/MN_bens_moveis.png"));
        this.taskParticipacaoSocietarias = new JTaskAction("Participa\u00e7\u00f5es Societ\u00e1rias", NavegacaoIf.PAINEL_PARTICIPACAO_SOCIETARIA, (Icon)GuiUtil.getImage("/icones/png20px/socio.png"));
        this.taskMoedasEspecie = new JTaskAction(PainelDadosMoedas.TITULO, NavegacaoIf.PAINEL_MOEDA_ESPECIE, (Icon)GuiUtil.getImage("/icones/png20px/moedas.png"));
        this.taskConsolidacaoGeral = new JTaskAction(PainelDadosConsolidacaoGeral.TITULO, NavegacaoIf.PAINEL_CONSOLIDACAO_GERAL, (Icon)GuiUtil.getImage("/icones/png20px/consolidacao.png"));
        this.taskPaneFichasDeclaracao.add((Component)this.taskIdentificacao);
        this.taskPaneFichasDeclaracao.add((Component)this.taskBensImoveis);
        this.taskPaneFichasDeclaracao.add((Component)this.taskBensMoveis);
        this.taskPaneFichasDeclaracao.add((Component)this.taskParticipacaoSocietarias);
        this.taskPaneFichasDeclaracao.add((Component)this.taskMoedasEspecie);
        this.taskPaneFichasDeclaracao.add((Component)this.taskConsolidacaoGeral);
        this.taskPaneFichasDeclaracao.add((Component)new JTaskAction("Verificar Pend\u00eancias", new VerificarPendenciasAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_verificar.png")));
        ((VerticalLayout)this.taskPaneFichasDeclaracao.getContentPane().getLayout()).setGap(espacoItensMenu);
        this.jXCollapsiblePane1.setBorder(BORDA_UNICO_TASKPANE);
        this.jXCollapsiblePane2.setBorder(BORDA_UNICO_TASKPANE);
    }

    public void configurarHelp() {
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        plataforma.setHelpID((Container)this, "\u00cdndice");
        plataforma.setHelpID((JComponent)this.jMenuItemConteudo, "\u00cdndice");
        plataforma.setHelpID((JComponent)this.jMenuItemInstPreenchimento, "INSTRU\u00c7\u00d5ES DE PREENCHIMENTO");
        plataforma.setHelpID((JComponent)this.jMenuItemProgramasIRPF, "Programas de IRPF Disponibilizados pela RFB");
        plataforma.setHelpID((JComponent)this.taskAjudaConteudo, "\u00cdndice");
        plataforma.setHelpID((JComponent)this.taskAjudaInstrucoes, "INSTRU\u00c7\u00d5ES DE PREENCHIMENTO");
    }

    public JanelaPrincipalGCAP() {
        BarramentoEventos.getInstancia().registraOutput((Object)this);
        this.backupTitles = new HashMap<String, String>();
        this.initComponents();
        this.iconeMaximizar = new ImageIcon(this.getClass().getResource("/icones/png14px/expandir.png"));
        this.iconeMinimizar = new ImageIcon(this.getClass().getResource("/icones/png14px/recolher.png"));
        this.jLabelRedimensionar.setIcon(this.iconeMinimizar);
        this.jLabelRedimensionar.setCursor(Cursor.getPredefinedCursor(12));
        ResourceBundle bundle = ResourceBundle.getBundle("aplicacao");
        this.setTitle(AplicacaoPropertiesUtil.getTituloVersao());
        ImageIcon img = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)bundle.getString("icone")));
        this.setIconImage(img.getImage());
        this.jPanelTasks.setBackground(BACKGROUND_COLOR_TOOLBAR);
        this.tpcMenu = new JXTaskPaneContainer();
        this.tpcToolbar = new JXTaskPaneContainer();
        ((VerticalLayout)this.tpcToolbar.getLayout()).setGap(0);
        this.jXCollapsiblePane1.setContentPane((Container)this.tpcMenu);
        this.jXCollapsiblePane2.setContentPane((Container)this.tpcToolbar);
        this.jScrollPaneEsquerda.getVerticalScrollBar().setUnitIncrement(10);
        this.jScrollPaneDireita.getVerticalScrollBar().setUnitIncrement(10);
        this.carregarMenuLateral();
        this.configurarAcessibilidade();
        ControladorGui.addDemonstrativoListener(this);
    }

    private void initComponents() {
        this.jPopupMenuImprimir = new JPopupMenu();
        this.jPopupMenuItemImprimirDeclaracao = new JMenuItem();
        this.jPanelIRPF = new JPanel();
        this.jPanelPrincipal = new JPanel();
        this.jSplitPaneIRPF = new JSplitPane();
        this.jScrollPaneDireita = new JScrollPane();
        this.jPanelPaineis = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanelRedimensionar = new JPanel();
        this.jLabelRedimensionar = new JLabel();
        this.lblRetrairMenu = new JLabel();
        this.jScrollPaneEsquerda = new JScrollPane();
        this.jPanelTasks = new JPanel();
        this.jXCollapsiblePane1 = new JXCollapsiblePane();
        this.jXCollapsiblePane2 = new JXCollapsiblePane();
        this.jMenuBarIRPF = new JMenuBar();
        this.jMenuDeclaracao = new JMenu();
        this.jMenuItemNova = new JMenuItem();
        this.jMenuItemAbrir = new JMenuItem();
        this.jMenuItemFechar = new JMenuItem();
        this.jMenuItemImprimir = new JMenu();
        this.jMenuItemImprimirDemonstrativo = new JMenuItem();
        this.jMenuItemImprimirDarf = new JMenuItem();
        this.jMenuItemImprimirDarfMoeda = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemImportarGCAPExercicioAnterior = new JMenuItem();
        this.jMenuItemExcluir = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemVerificarPendencias = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemSair = new JMenuItem();
        this.jMenuFichas = new JMenu();
        this.menuItemFichaIdentificao = new JMenuItem();
        this.menuItemFichaEscrituracao = new JMenuItem();
        this.menuItemFichaDemonstrativo = new JMenuItem();
        this.menuItemFichaDemonstrativo1 = new JMenuItem();
        this.menuItemFichaConsolidacaoGeral = new JMenuItem();
        this.jMenuFerramentas = new JMenu();
        this.jMenuCopiaSeguranca = new JMenu();
        this.jMenuItemGravar = new JMenuItem();
        this.jMenuItemRestaurar = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuAjuda = new JMenu();
        this.jMenuItemConteudo = new JMenuItem();
        this.jMenuItemInstPreenchimento = new JMenuItem();
        this.jMenuItemComoFazerPara = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemProgramasIRPF = new JMenuItem();
        this.jMenuItemAjudaAcessibilidade = new JMenuItem();
        this.jMenuItemAjudaAcessibilidade1 = new JMenuItem();
        this.jMenuItemSobre = new JMenuItem();
        this.jMenuInfoContribuinte = new JMenu();
        this.jPopupMenuItemImprimirDeclaracao.setAction(new ImprimirDemonstrativoAction());
        this.jPopupMenuItemImprimirDeclaracao.setMnemonic('D');
        this.jPopupMenuItemImprimirDeclaracao.setText("Demonstrativo");
        this.jPopupMenuImprimir.add(this.jPopupMenuItemImprimirDeclaracao);
        this.setDefaultCloseOperation(3);
        this.setName("PPGD_JANELA_PRINCIPAL");
        this.jPanelIRPF.setLayout(new BorderLayout());
        this.jPanelPrincipal.setBackground(new Color(253, 251, 198));
        this.jPanelPrincipal.setLayout(new BorderLayout());
        this.jSplitPaneIRPF.setDividerLocation(235);
        this.jSplitPaneIRPF.setName("splitPPGD");
        this.jScrollPaneDireita.setName("ppgdScrollPnlPPGD");
        this.jPanelPaineis.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanelPaineis.setName("pnlPPGD");
        this.jPanelPaineis.setLayout(new BorderLayout());
        this.jScrollPaneDireita.setViewportView(this.jPanelPaineis);
        this.jSplitPaneIRPF.setRightComponent(this.jScrollPaneDireita);
        this.jPanel2.setPreferredSize(new Dimension(110, 27));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanelRedimensionar.setMaximumSize(new Dimension(1000, 28));
        this.jPanelRedimensionar.setMinimumSize(new Dimension(80, 25));
        this.jPanelRedimensionar.setPreferredSize(new Dimension(100, 25));
        this.jPanelRedimensionar.setLayout(new BorderLayout());
        this.jLabelRedimensionar.setHorizontalAlignment(0);
        this.jLabelRedimensionar.setMaximumSize(new Dimension(25, 25));
        this.jLabelRedimensionar.setMinimumSize(new Dimension(25, 25));
        this.jLabelRedimensionar.setPreferredSize(new Dimension(25, 25));
        this.jLabelRedimensionar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JanelaPrincipalGCAP.this.jLabelRedimensionarMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                JanelaPrincipalGCAP.this.jLabelRedimensionarMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JanelaPrincipalGCAP.this.jLabelRedimensionarMouseExited(evt);
            }
        });
        this.jPanelRedimensionar.add((Component)this.jLabelRedimensionar, "East");
        this.lblRetrairMenu.setFont(new Font("Arial", 0, 11));
        this.lblRetrairMenu.setHorizontalAlignment(4);
        this.lblRetrairMenu.setText("Retrair Menu");
        this.jPanelRedimensionar.add((Component)this.lblRetrairMenu, "Center");
        this.jPanel2.add(this.jPanelRedimensionar);
        this.jScrollPaneEsquerda.setName("ppgdAreaArvore");
        this.jPanelTasks.setBackground(new Color(254, 254, 254));
        this.jPanelTasks.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.jPanelTasks.add((Component)this.jXCollapsiblePane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelTasks.add((Component)this.jXCollapsiblePane2, gridBagConstraints);
        this.jScrollPaneEsquerda.setViewportView(this.jPanelTasks);
        this.jPanel2.add(this.jScrollPaneEsquerda);
        this.jSplitPaneIRPF.setLeftComponent(this.jPanel2);
        this.jPanelPrincipal.add((Component)this.jSplitPaneIRPF, "Center");
        this.jPanelIRPF.add((Component)this.jPanelPrincipal, "Center");
        this.getContentPane().add((Component)this.jPanelIRPF, "Center");
        this.jMenuBarIRPF.setName("mainMenubar");
        this.jMenuDeclaracao.setMnemonic('d');
        this.jMenuDeclaracao.setText("Demonstrativo");
        this.jMenuItemNova.setAction(new NovoDemonstrativoAction());
        this.jMenuItemNova.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.jMenuItemNova.setMnemonic('n');
        this.jMenuItemNova.setText("Novo...");
        this.jMenuDeclaracao.add(this.jMenuItemNova);
        this.jMenuItemAbrir.setAction(new AbrirDemonstrativoAction());
        this.jMenuItemAbrir.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        this.jMenuItemAbrir.setMnemonic('a');
        this.jMenuItemAbrir.setText("Abrir");
        this.jMenuDeclaracao.add(this.jMenuItemAbrir);
        this.jMenuItemFechar.setAction(new FecharDemonstrativoAction());
        this.jMenuItemFechar.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.jMenuItemFechar.setMnemonic('f');
        this.jMenuItemFechar.setText("Fechar");
        this.jMenuDeclaracao.add(this.jMenuItemFechar);
        this.jMenuItemImprimir.setMnemonic('i');
        this.jMenuItemImprimir.setText("Imprimir...");
        this.jMenuItemImprimirDemonstrativo.setAction(new ImprimirDemonstrativoAction());
        this.jMenuItemImprimirDemonstrativo.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.jMenuItemImprimirDemonstrativo.setMnemonic('i');
        this.jMenuItemImprimirDemonstrativo.setText("Demonstrativo...");
        this.jMenuItemImprimir.add(this.jMenuItemImprimirDemonstrativo);
        this.jMenuItemImprimirDarf.setAction(new ImprimirDarfAction());
        this.jMenuItemImprimirDarf.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        this.jMenuItemImprimirDarf.setMnemonic('d');
        this.jMenuItemImprimirDarf.setText("Darf Bens/Direitos/Participa\u00e7\u00f5es Societ\u00e1rias");
        this.jMenuItemImprimir.add(this.jMenuItemImprimirDarf);
        this.jMenuItemImprimirDarfMoeda.setAction(new ImprimirDarfMoedaEspecieAction());
        this.jMenuItemImprimirDarfMoeda.setAccelerator(KeyStroke.getKeyStroke(77, 640));
        this.jMenuItemImprimirDarfMoeda.setMnemonic('m');
        this.jMenuItemImprimirDarfMoeda.setText("Darf Moedas em Esp\u00e9cie");
        this.jMenuItemImprimir.add(this.jMenuItemImprimirDarfMoeda);
        this.jMenuDeclaracao.add(this.jMenuItemImprimir);
        this.jMenuDeclaracao.add(this.jSeparator6);
        this.jMenuItemImportarGCAPExercicioAnterior.setAction(new ImportarExercicioAnteriorAction());
        this.jMenuItemImportarGCAPExercicioAnterior.setMnemonic('G');
        this.jMenuItemImportarGCAPExercicioAnterior.setText("Importar dados do GCAP " + (AplicacaoPropertiesUtil.getExercicioAsInt() - 1));
        this.jMenuDeclaracao.add(this.jMenuItemImportarGCAPExercicioAnterior);
        this.jMenuItemExcluir.setAction(new ExcluirDemonstrativoAction());
        this.jMenuItemExcluir.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.jMenuItemExcluir.setMnemonic('x');
        this.jMenuItemExcluir.setText("Excluir...");
        this.jMenuDeclaracao.add(this.jMenuItemExcluir);
        this.jMenuDeclaracao.add(this.jSeparator3);
        this.jMenuItemVerificarPendencias.setAction(new VerificarPendenciasAction());
        this.jMenuItemVerificarPendencias.setAccelerator(KeyStroke.getKeyStroke(116, 0, true));
        this.jMenuItemVerificarPendencias.setMnemonic('p');
        this.jMenuItemVerificarPendencias.setText("Verificar Pend\u00eancias");
        this.jMenuDeclaracao.add(this.jMenuItemVerificarPendencias);
        this.jMenuDeclaracao.add(this.jSeparator7);
        this.jMenuItemSair.setAction(new SairAction());
        this.jMenuItemSair.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        this.jMenuItemSair.setMnemonic('s');
        this.jMenuItemSair.setText("Sair do Programa");
        this.jMenuItemSair.setName("menuDeclSair");
        this.jMenuDeclaracao.add(this.jMenuItemSair);
        this.jMenuBarIRPF.add(this.jMenuDeclaracao);
        this.jMenuFichas.setMnemonic('P');
        this.jMenuFichas.setText("Preenchimento");
        this.menuItemFichaIdentificao.setAction(new MudarPainelAction(NavegacaoIf.PAINEL_BEM_IMOVEL));
        this.menuItemFichaIdentificao.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        this.menuItemFichaIdentificao.setText("Bens Im\u00f3veis");
        this.jMenuFichas.add(this.menuItemFichaIdentificao);
        this.menuItemFichaEscrituracao.setAction(new MudarPainelAction(NavegacaoIf.PAINEL_BEM_MOVEL));
        this.menuItemFichaEscrituracao.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        this.menuItemFichaEscrituracao.setMnemonic('M');
        this.menuItemFichaEscrituracao.setText("Direitos/Bens M\u00f3veis");
        this.jMenuFichas.add(this.menuItemFichaEscrituracao);
        this.menuItemFichaDemonstrativo.setAction(new MudarPainelAction(NavegacaoIf.PAINEL_PARTICIPACAO_SOCIETARIA));
        this.menuItemFichaDemonstrativo.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.menuItemFichaDemonstrativo.setMnemonic('P');
        this.menuItemFichaDemonstrativo.setText("Participa\u00e7\u00f5es Societ\u00e1rias");
        this.jMenuFichas.add(this.menuItemFichaDemonstrativo);
        this.menuItemFichaDemonstrativo1.setAction(new MudarPainelAction(NavegacaoIf.PAINEL_MOEDA_ESPECIE));
        this.menuItemFichaDemonstrativo1.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.menuItemFichaDemonstrativo1.setMnemonic('O');
        this.menuItemFichaDemonstrativo1.setText("Moeda em Esp\u00e9cie");
        this.jMenuFichas.add(this.menuItemFichaDemonstrativo1);
        this.menuItemFichaConsolidacaoGeral.setAction(new MudarPainelAction(NavegacaoIf.PAINEL_CONSOLIDACAO_GERAL));
        this.menuItemFichaConsolidacaoGeral.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.menuItemFichaConsolidacaoGeral.setMnemonic('l');
        this.menuItemFichaConsolidacaoGeral.setText("Consolida\u00e7\u00e3o Geral");
        this.jMenuFichas.add(this.menuItemFichaConsolidacaoGeral);
        this.jMenuBarIRPF.add(this.jMenuFichas);
        this.jMenuFerramentas.setMnemonic('t');
        this.jMenuFerramentas.setText("Ferramentas");
        this.jMenuCopiaSeguranca.setMnemonic('p');
        this.jMenuCopiaSeguranca.setText("C\u00f3pia de Seguran\u00e7a");
        this.jMenuItemGravar.setAction(new GravarCopiaSegurancaAction());
        this.jMenuItemGravar.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.jMenuItemGravar.setMnemonic('g');
        this.jMenuItemGravar.setText("Gravar...");
        this.jMenuCopiaSeguranca.add(this.jMenuItemGravar);
        this.jMenuItemRestaurar.setAction(new RestaurarCopiaSegurancaAction());
        this.jMenuItemRestaurar.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.jMenuItemRestaurar.setMnemonic('r');
        this.jMenuItemRestaurar.setText("Restaurar...");
        this.jMenuCopiaSeguranca.add(this.jMenuItemRestaurar);
        this.jMenuFerramentas.add(this.jMenuCopiaSeguranca);
        this.jMenuItem1.setAction(new ExportarIRPFAction());
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.jMenuItem1.setMnemonic('x');
        this.jMenuItem1.setText("Exportar para o IRPF " + ConstantesGlobais.EXERCICIO_POSTERIOR + "...");
        this.jMenuFerramentas.add(this.jMenuItem1);
        this.jMenuItem3.setAction(new VerificarNovaVersaoAction());
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        this.jMenuItem3.setMnemonic('a');
        this.jMenuItem3.setText("Verificar Atualiza\u00e7\u00f5es");
        this.jMenuFerramentas.add(this.jMenuItem3);
        this.jMenuFerramentas.add(this.jSeparator1);
        this.jMenuItem2.setAction(new AbrirCalculadoraAction());
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(65, 640));
        this.jMenuItem2.setMnemonic('c');
        this.jMenuItem2.setText("Calculadora");
        this.jMenuFerramentas.add(this.jMenuItem2);
        this.jMenuBarIRPF.add(this.jMenuFerramentas);
        this.jMenuAjuda.setMnemonic('N');
        this.jMenuAjuda.setText("Ajuda");
        this.jMenuItemConteudo.setAction(new AjudaAction("\u00cdndice"));
        this.jMenuItemConteudo.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.jMenuItemConteudo.setMnemonic('C');
        this.jMenuItemConteudo.setText("Conte\u00fado");
        this.jMenuAjuda.add(this.jMenuItemConteudo);
        this.jMenuItemInstPreenchimento.setAction(new AjudaAction("INSTRU\u00c7\u00d5ES DE PREENCHIMENTO"));
        this.jMenuItemInstPreenchimento.setMnemonic('I');
        this.jMenuItemInstPreenchimento.setText("Instru\u00e7\u00f5es de Preenchimento");
        this.jMenuAjuda.add(this.jMenuItemInstPreenchimento);
        this.jMenuItemComoFazerPara.setAction(new AjudaAction("Como fazer para..."));
        this.jMenuItemComoFazerPara.setMnemonic('f');
        this.jMenuItemComoFazerPara.setText("Como Fazer para...");
        this.jMenuAjuda.add(this.jMenuItemComoFazerPara);
        this.jMenuAjuda.add(this.jSeparator2);
        this.jMenuItemProgramasIRPF.setAction(new AjudaAction("Programas de IRPF disponibilizados pela RFB"));
        this.jMenuItemProgramasIRPF.setMnemonic('I');
        this.jMenuItemProgramasIRPF.setText("Programas de IRPF disponibilizados pela RFB");
        this.jMenuAjuda.add(this.jMenuItemProgramasIRPF);
        this.jMenuItemAjudaAcessibilidade.setAction(new AjudaAcessibilidadeAction());
        this.jMenuItemAjudaAcessibilidade.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        this.jMenuItemAjudaAcessibilidade.setMnemonic('a');
        this.jMenuItemAjudaAcessibilidade.setText("Ajuda Acessibilidade");
        this.jMenuAjuda.add(this.jMenuItemAjudaAcessibilidade);
        this.jMenuItemAjudaAcessibilidade1.setAction(new ExibirAtalhosPGDGCAPAction());
        this.jMenuItemAjudaAcessibilidade1.setAccelerator(KeyStroke.getKeyStroke(80, 576));
        this.jMenuItemAjudaAcessibilidade1.setMnemonic('p');
        this.jMenuItemAjudaAcessibilidade1.setText("Guia de Atalhos do PGD GCAP");
        this.jMenuAjuda.add(this.jMenuItemAjudaAcessibilidade1);
        this.jMenuItemSobre.setAction(new SobreAction());
        this.jMenuItemSobre.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        this.jMenuItemSobre.setMnemonic('S');
        this.jMenuItemSobre.setText("Sobre");
        this.jMenuAjuda.add(this.jMenuItemSobre);
        this.jMenuBarIRPF.add(this.jMenuAjuda);
        this.jMenuInfoContribuinte.setIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/usuario.png")));
        this.jMenuInfoContribuinte.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/usuario.png")));
        this.jMenuInfoContribuinte.setEnabled(false);
        this.jMenuInfoContribuinte.setFocusable(false);
        this.jMenuBarIRPF.add(Box.createHorizontalGlue());
        this.jMenuBarIRPF.add(this.jMenuInfoContribuinte);
        this.setJMenuBar(this.jMenuBarIRPF);
        this.pack();
    }

    private void jLabelRedimensionarMouseClicked(MouseEvent evt) {
        this.redimensionarMenu();
    }

    private void jLabelRedimensionarMouseEntered(MouseEvent evt) {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabelRedimensionarMouseExited(MouseEvent evt) {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void redimensionarMenu() {
        if (this.minimized) {
            this.maximizarMenu();
            this.jLabelRedimensionar.setIcon(this.iconeMinimizar);
            this.jLabelRedimensionar.setToolTipText("Retrair Menu");
            this.lblRetrairMenu.setText("Retrair Menu");
        } else {
            this.minimizarMenu();
            this.jLabelRedimensionar.setIcon(this.iconeMaximizar);
            this.jLabelRedimensionar.setToolTipText("Expandir Menu");
            this.lblRetrairMenu.setText("Expandir Menu");
        }
        this.minimized = !this.minimized;
    }

    public Component getAreaArvore() {
        return this.jSplitPaneIRPF.getLeftComponent();
    }

    public Component getAreaPaineis() {
        return this.jPanelPaineis;
    }

    public Component getArvore() {
        return null;
    }

    public Component getComponent(String nome) {
        return null;
    }

    public JFrame getJanelaPrincipal() {
        return this;
    }

    public JPanel getPainelPrincipal() {
        return this.jPanelPrincipal;
    }

    public Component getPainelSplit() {
        return this.jSplitPaneIRPF;
    }

    public Component getScrollAreaPaineis() {
        return this.jScrollPaneDireita;
    }

    public Component getToolbar() {
        return null;
    }

    public JMenu getMenuFichas() {
        return this.jMenuFichas;
    }

    public JXTaskPaneContainer getTaskPaneContainerMenu() {
        return this.tpcMenu;
    }

    public JXTaskPaneContainer getTaskPaneContainerToolbar() {
        return this.tpcToolbar;
    }

    public JXCollapsiblePane getCollapsiblePaneMenu() {
        return this.jXCollapsiblePane1;
    }

    public JXCollapsiblePane getCollapsiblePaneToolbar() {
        return this.jXCollapsiblePane2;
    }

    public void setLastAccessedItem(String pPainel) {
        List<Component> lLista = this.obterComponentesMenu();
        for (Component component : lLista) {
            JTaskAction lAction = (JTaskAction)component;
            lAction.setLastAccessed(false);
            if (!lAction.getActionCommand().equals(pPainel)) continue;
            lAction.setLastAccessed(true);
        }
    }

    public void setLastAccessedItem(Class<? extends AbstractAction> pAction) {
        List<Component> lLista = this.obterComponentesMenu();
        for (Component component : lLista) {
            JTaskAction lAction = (JTaskAction)component;
            lAction.setLastAccessed(false);
            if (!pAction.isInstance(lAction.getAction())) continue;
            lAction.setLastAccessed(true);
        }
    }

    private List<Component> obterComponentesMenu() {
        ArrayList<Component> lLista = new ArrayList<Component>();
        Collections.addAll(lLista, this.taskPaneFichasDeclaracao.getContentPane().getComponents());
        return lLista;
    }

    private void minimizarMenu() {
        Component[] lLista3;
        Component[] lLista1;
        for (Component component : lLista1 = this.tpcMenu.getComponents()) {
            Component[] lLista2;
            JXTaskPane tp = (JXTaskPane)component;
            this.backupTitles.put(tp.getName(), tp.getTitle());
            tp.setTitle("");
            for (Component component2 : lLista2 = tp.getContentPane().getComponents()) {
                JTaskAction lAction = (JTaskAction)component2;
                lAction.setMinimized(true);
            }
        }
        for (Component component : lLista3 = this.tpcToolbar.getComponents()) {
            Component[] lLista4;
            JXTaskPane tp = (JXTaskPane)component;
            this.backupTitles.put(tp.getName(), tp.getTitle());
            tp.setTitle("");
            for (Component component2 : lLista4 = tp.getContentPane().getComponents()) {
                JTaskAction lAction = (JTaskAction)component2;
                lAction.setMinimized(true);
            }
        }
        this.dividerPosition = this.jSplitPaneIRPF.getDividerLocation();
        this.jSplitPaneIRPF.setDividerLocation(72);
    }

    private void maximizarMenu() {
        Component[] lLista3;
        Component[] lLista1;
        for (Component component : lLista1 = this.tpcMenu.getComponents()) {
            Component[] lLista2;
            JXTaskPane tp = (JXTaskPane)component;
            tp.setTitle(this.backupTitles.get(tp.getName()));
            for (Component component2 : lLista2 = tp.getContentPane().getComponents()) {
                JTaskAction lAction = (JTaskAction)component2;
                lAction.setMinimized(false);
            }
        }
        for (Component component : lLista3 = this.tpcToolbar.getComponents()) {
            Component[] lLista4;
            JXTaskPane tp = (JXTaskPane)component;
            tp.setTitle(this.backupTitles.get(tp.getName()));
            for (Component component2 : lLista4 = tp.getContentPane().getComponents()) {
                JTaskAction lAction = (JTaskAction)component2;
                lAction.setMinimized(false);
            }
        }
        this.jSplitPaneIRPF.setDividerLocation(this.dividerPosition);
    }

    @Override
    public void mudouNumeroDemonstrativos() {
        boolean existeDemonstrativo = ControladorGui.existemDemonstrativos();
        this.taskAbrir.setEnabled(existeDemonstrativo);
        this.taskImprimirDemonstrativo.setEnabled(existeDemonstrativo);
        this.taskImprimirDarf.setEnabled(existeDemonstrativo);
        this.taskImprimirDarfMoedaEspecie.setEnabled(existeDemonstrativo);
        this.taskGravarEntrega.setEnabled(existeDemonstrativo);
        this.taskGravarCopia.setEnabled(existeDemonstrativo);
        this.taskExcluir.setEnabled(existeDemonstrativo);
        this.jMenuItemExcluir.setEnabled(existeDemonstrativo);
        this.jMenuItemAbrir.setEnabled(existeDemonstrativo);
        this.jMenuItemImprimir.setEnabled(existeDemonstrativo);
        this.jMenuItemGravar.setEnabled(existeDemonstrativo);
        this.jPopupMenuItemImprimirDeclaracao.setEnabled(existeDemonstrativo);
    }

    @Override
    public boolean demonstrativoVaiFechar() {
        return true;
    }

    @Override
    public void demonstrativoFechado() {
        this.getTaskPaneContainerToolbar().setBorder(BORDA_UNICO_TASKPANE);
        this.getjMenuInfoContribuinte().setText(null);
        this.getjMenuInfoContribuinte().setVisible(false);
        this.jMenuItemFechar.setEnabled(false);
        this.taskFechar.setEnabled(false);
        this.jMenuItemVerificarPendencias.setEnabled(false);
        this.jMenuItemImportarGCAPExercicioAnterior.setEnabled(false);
        this.taskImportarGcapExercicioAnterior.setEnabled(false);
        this.getCollapsiblePaneMenu().setCollapsed(true);
        this.getMenuFichas().setVisible(false);
        PlataformaPPGD.getPlataforma().mudaPainelExibido((JPanel)painelVazio);
    }

    @Override
    public void demonstrativoAberto() {
        IdDemonstrativoGCAP lId = ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao();
        this.getjMenuInfoContribuinte().setText("Contribuinte: " + lId.getNome().naoFormatado() + " | CPF: " + lId.getCpf().formatado() + " | " + lId.getPaisDeclarante().getConteudoAtual(1) + " (" + lId.getDataInicioPermanencia().formatado() + "-" + lId.getDataFimPermanencia().formatado() + ")");
        this.getjMenuInfoContribuinte().setVisible(true);
        this.jMenuItemFechar.setEnabled(true);
        this.taskFechar.setEnabled(true);
        this.jMenuItemVerificarPendencias.setEnabled(true);
        JXTaskPaneContainer lContainer = this.getTaskPaneContainerMenu();
        if (lContainer.getComponents().length == 0) {
            lContainer.add((Component)this.taskPaneFichasDeclaracao, 0);
            lContainer.updateUI();
            SwingUtilities.updateComponentTreeUI((Component)this.taskPaneFichasDeclaracao);
            this.taskPaneFichasDeclaracao.setUI((TaskPaneUI)new GlossyTaskPaneUI());
            ((VerticalLayout)lContainer.getLayout()).setGap(0);
        }
        this.getTaskPaneContainerMenu().setBorder(BORDA_PRIMEIRO_TASKPANE);
        this.getTaskPaneContainerToolbar().setBorder(BORDA_ULTIMO_TASKPANE);
        try {
            this.taskMoedasEspecie.setEnabled(GCAPFacade.getInstancia().getDeclaracao().getIdDemonstrativo().isDemonstrativoBrasil());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.taskConsolidacaoGeral.setEnabled(true);
        this.getCollapsiblePaneMenu().setCollapsed(false);
        this.getMenuFichas().setVisible(true);
        this.jMenuItemImportarGCAPExercicioAnterior.setEnabled(true);
        this.taskImportarGcapExercicioAnterior.setEnabled(true);
    }

    @Override
    public void demonstrativoSalvo() {
    }

    public Map<String, Component> getComponentes() {
        return null;
    }

    public JMenu getjMenuInfoContribuinte() {
        return this.jMenuInfoContribuinte;
    }

    public JMenuItem getJMenuFerramentas() {
        return this.jMenuFerramentas;
    }

    private void configurarAcessibilidade() {
        this.jMenuItemImprimir.getAccessibleContext().setAccessibleName("Imprimir. Para acessar o submenu utilize a seta para a direita do teclado.");
        this.jMenuCopiaSeguranca.getAccessibleContext().setAccessibleName("C\u00f3pia de seguran\u00e7a. Para acessar o submenu utilize a seta para a direita do teclado.");
    }

    static {
        BACKGROUND_COLOR_TOOLBAR = Color.WHITE;
        COR_FONTE_TASKPANE = new Color(0, 74, 106);
        JanelaPrincipalGCAP.carregarPadroesInterface(true);
        painelVazio = new JDegradePanel();
        painelVazio.setCorInicial(new Color(117, 168, 211));
        painelVazio.setCorFinal(new Color(198, 216, 220));
    }
}

