/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.gui.dialogs.PainelSplash;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashScreen
extends JWindow {
    boolean showing = true;
    private long SLEEP_INTERVAL = 100L;
    private long sleepCount;

    public SplashScreen(URL filename, Frame f, int waitTime) {
        super(f);
        PainelSplash painelSplash = PainelSplash.getInstance();
        this.setPreferredSize(new Dimension(570, 178));
        this.getContentPane().add((Component)painelSplash, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = painelSplash.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
                SplashScreen.this.showing = false;
            }
        });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
                SplashScreen.this.showing = false;
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    SplashScreen.this.sleepCount = 0L;
                    while (SplashScreen.this.isShowing() && SplashScreen.this.sleepCount < (long)pause) {
                        Thread.sleep(SplashScreen.this.SLEEP_INTERVAL);
                        SplashScreen.this.sleepCount += SplashScreen.this.SLEEP_INTERVAL;
                    }
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }

    public void waitForFinish() {
        while (this.isShowing()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean status) {
        this.showing = status;
    }
}

