/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.util.ConstantesGlobaisGCAP;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;

public class TableListaCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component retorno = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Informacao) {
            if (value instanceof Valor) {
                this.setHorizontalAlignment(4);
            } else if (value instanceof Alfa) {
                this.setHorizontalAlignment(2);
            } else {
                this.setHorizontalAlignment(0);
            }
        }
        if (retorno instanceof JComponent) {
            JComponent jComp = (JComponent)retorno;
            jComp.setBorder(ConstantesGlobaisGCAP.bordaVazia);
        }
        if (retorno instanceof JLabel && value != null) {
            JLabel lRetorno = (JLabel)retorno;
            if (value instanceof Codigo) {
                Codigo codigo = (Codigo)value;
                if (codigo.isVazio()) {
                    lRetorno.setToolTipText(null);
                } else {
                    String hint = UtilitariosString.insereQuebraDeLinha((String)codigo.getDescricaoDefault(), (int)70, (String)"\n");
                    hint = UtilitariosString.strToHtml((String)hint);
                    lRetorno.setToolTipText(hint);
                }
            } else if (value instanceof Informacao) {
                Informacao info = (Informacao)value;
                if (info.toString().trim().isEmpty()) {
                    lRetorno.setToolTipText(null);
                } else {
                    String hint = UtilitariosString.insereQuebraDeLinha((String)info.toString(), (int)70, (String)"\n");
                    hint = UtilitariosString.strToHtml((String)hint);
                    lRetorno.setToolTipText(hint);
                }
            }
        }
        return retorno;
    }

    public static void main(String[] args) {
        String texto = "sdfsdf gsdgdfgfd dfgsdfgh dsfhgsdfh sdfsdf gsdgdfgfd dfgsdfgh dsfhgsdfh sdfsdf gsdgdfgfd dfgsdfgh dsfhgsdfh";
        texto = UtilitariosString.insereQuebraDeLinha((String)texto, (int)50, (String)"\n");
        System.out.println(texto);
        texto = UtilitariosString.strToHtml((String)texto);
        System.out.println(texto);
    }
}

