/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.GCAPTableAb;
import br.gov.serpro.gcap.gui.TableModelSelecionaDeclaracao;
import br.gov.serpro.gcap.gui.tabela.JComponentCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class TableSelecionaDeclaracao
extends GCAPTableAb {
    public TableSelecionaDeclaracao() {
        this.setShowGrid(false);
        Dimension dim = new Dimension(this.getTableHeader().getWidth(), 25);
        this.getTableHeader().setPreferredSize(dim);
        this.setModel(new TableModelSelecionaDeclaracao());
        this.setBackground(Color.WHITE);
        this.setRowHeight(25);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(0).setPreferredWidth(205);
        cm.getColumn(1).setPreferredWidth(405);
        cm.getColumn(2).setPreferredWidth(260);
        cm.getColumn(3).setPreferredWidth(180);
        cm.getColumn(4).setPreferredWidth(180);
        this.getTableHeader().setPreferredSize(new Dimension(700, this.getTableHeader().getPreferredSize().height));
        this.configuraOrdenacao();
        this.repaint();
    }

    private void configuraOrdenacao() {
        TableRowSorter<TableModelSelecionaDeclaracao> sorter = new TableRowSorter<TableModelSelecionaDeclaracao>((TableModelSelecionaDeclaracao)this.getModel());
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            sorter.setSortable(i, true);
        }
        sorter.setComparator(0, new Comparator<Object>(){

            @Override
            public int compare(Object obj1, Object obj2) {
                if (obj1 instanceof JPanel) {
                    JPanel painel = (JPanel)obj1;
                    JPanel outroPainel = (JPanel)obj2;
                    int indiceComponente = painel.getComponentCount() > 0 ? painel.getComponentCount() - 1 : painel.getComponentCount();
                    int indiceOutroComponente = outroPainel.getComponentCount() > 0 ? outroPainel.getComponentCount() - 1 : outroPainel.getComponentCount();
                    Component labelRecibo = painel.getComponent(indiceComponente);
                    Component outroLabelRecibo = outroPainel.getComponent(indiceOutroComponente);
                    if (labelRecibo instanceof JLabel && outroLabelRecibo instanceof JLabel) {
                        String texto = ((JLabel)labelRecibo).getText();
                        String outroTexto = ((JLabel)outroLabelRecibo).getText();
                        return texto != null && outroTexto != null ? texto.compareTo(outroTexto) : (texto == null && outroTexto == null ? 0 : (texto == null ? -1 : 1));
                    }
                    if (labelRecibo instanceof JLabel && !(outroLabelRecibo instanceof JLabel)) {
                        return -1;
                    }
                    if (!(labelRecibo instanceof JLabel) && outroLabelRecibo instanceof JLabel) {
                        return 1;
                    }
                    return 0;
                }
                if (obj1 instanceof String && obj2 instanceof String) {
                    String texto = (String)obj1;
                    String outroTexto = (String)obj2;
                    return texto != null && outroTexto != null ? texto.compareTo(outroTexto) : (texto == null && outroTexto == null ? 0 : (texto == null ? -1 : 1));
                }
                return -1;
            }
        });
        RowSorter.SortKey sk = new RowSorter.SortKey(1, SortOrder.ASCENDING);
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        keys.add(sk);
        sorter.setSortKeys(keys);
        this.setRowSorter(sorter);
    }

    @Override
    protected void setaDefaultRenderers() {
        this.setDefaultRenderer(JPanel.class, new JComponentCellRenderer());
    }

    public void addDeclaracaoSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeDeclaracaoSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().removeListSelectionListener(listener);
    }

    public IdDemonstrativoGCAP getIdentificadorDeclaracao(int row) {
        return ((TableModelSelecionaDeclaracao)this.getModel()).getIdentificadorDeclaracao(row);
    }

    public List<IdDemonstrativoGCAP> getIdentificadorDeclaracao(int[] rows) {
        ArrayList<IdDemonstrativoGCAP> retorno = new ArrayList<IdDemonstrativoGCAP>();
        for (int i = 0; i < rows.length; ++i) {
            retorno.add(((TableModelSelecionaDeclaracao)this.getModel()).getIdentificadorDeclaracao(rows[i]));
        }
        return retorno;
    }

    @Override
    protected void iniciaModelVazio() {
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

