/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensimoveis;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.perguntas.PerguntasUtil;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.NavegacaoIf;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.bensimoveis.adquirente.PainelAbaListaAdquirente;
import br.gov.serpro.gcap.gui.bensimoveis.apuracao.PainelAbaApuracaoBemImovel;
import br.gov.serpro.gcap.gui.bensimoveis.aquisicao.PainelAbaAquisicaoBemImovel;
import br.gov.serpro.gcap.gui.bensimoveis.calculoimposto.PainelAbaCalculoImpostoBemImovel;
import br.gov.serpro.gcap.gui.bensimoveis.consolidacao.PainelAbaConsolidacao;
import br.gov.serpro.gcap.gui.bensimoveis.identificacao.PainelAbaIdentificacaoBemImovel;
import br.gov.serpro.gcap.gui.bensimoveis.operacao.PainelAbaOperacaoBemImovel;
import br.gov.serpro.gcap.gui.bensimoveis.perguntas.PainelAbaPerguntas;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Observador;

public class PainelDadosBensImoveis
extends PainelComAbasAb {
    private static final long serialVersionUID = 1L;
    public String TITULO = "Bens Im\u00f3veis";
    private PainelAbaIdentificacaoBemImovel painelAbaIdentificacao;
    private PainelAbaAquisicaoBemImovel painelAbaAquisicao;
    private PainelAbaListaAdquirente painelAbaAdquirente;
    private PainelAbaOperacaoBemImovel painelAbaOperacaoBemImovel;
    private PainelAbaPerguntas painelAbaPerguntas;
    private PainelAbaApuracaoBemImovel painelAbaApuracaoBemImovel;
    private PainelAbaCalculoImpostoBemImovel painelAbaCalculoImpostoBemImovel;
    private PainelAbaConsolidacao painelAbaConsolidacao;
    private AlienacaoBemImovel alienacaoBemImovel;

    public PainelDadosBensImoveis(AlienacaoBemImovel alienacaoBemImovel) {
        super(alienacaoBemImovel);
        this.alienacaoBemImovel = alienacaoBemImovel;
        this.montarAbas();
        this.configurarHelpID();
        this.acionarAba("Identifica\u00e7\u00e3o", true);
        this.tratarHabilitacaoAbas();
        this.configObservadoresHabilitacaoDeAbas();
        this.exibirMensagemValorecebidoAnoAnterior();
    }

    @Override
    protected void montarAbas() {
        this.painelAbaIdentificacao = new PainelAbaIdentificacaoBemImovel(this);
        this.painelAbaAquisicao = new PainelAbaAquisicaoBemImovel(this);
        this.painelAbaAdquirente = new PainelAbaListaAdquirente(this);
        this.painelAbaApuracaoBemImovel = new PainelAbaApuracaoBemImovel(this);
        this.painelAbaCalculoImpostoBemImovel = new PainelAbaCalculoImpostoBemImovel(this);
        this.painelAbaOperacaoBemImovel = new PainelAbaOperacaoBemImovel(this);
        this.painelAbaPerguntas = new PainelAbaPerguntas(this);
        this.painelAbaConsolidacao = new PainelAbaConsolidacao(this);
        this.getTabbedPane().addTab("Identifica\u00e7\u00e3o", this.painelAbaIdentificacao);
        this.getTabbedPane().addTab("Aquisi\u00e7\u00e3o", this.painelAbaAquisicao);
        this.getTabbedPane().addTab("Adquirentes", this.painelAbaAdquirente);
        this.getTabbedPane().addTab("Opera\u00e7\u00e3o", this.painelAbaOperacaoBemImovel);
        this.getTabbedPane().addTab("Perguntas", this.painelAbaPerguntas);
        this.getTabbedPane().addTab("Apura\u00e7\u00e3o", this.painelAbaApuracaoBemImovel);
        this.getTabbedPane().addTab("C\u00e1lculo do Imposto", this.painelAbaCalculoImpostoBemImovel);
        this.getTabbedPane().addTab("Consolida\u00e7\u00e3o", this.painelAbaConsolidacao);
        this.tratarVisibilidadeAbaCalculo();
        this.tratarHabilitacaoAbaAdquirentes();
        this.getTabbedPane().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PainelDadosBensImoveis.this.getTabbedPane().getSelectedIndex() == 4) {
                    PainelDadosBensImoveis.this.painelAbaPerguntas.setDefaultFocus();
                }
            }
        });
    }

    public void tratarVisibilidadeAbaCalculo() {
        if (this.getTabbedPane().getTabCount() >= 6) {
            this.getTabbedPane().setEnabledAt(6, this.alienacaoBemImovel.podePreencherCalculo());
        }
    }

    @Override
    protected void tratarMudancaTabbedPane() {
        ControladorGui.alterarCabecalhoFicha(this.getTituloPainel());
        ControladorGui.alterarHelpId(this.getHelpIdAba(this.getTabbedPane().getSelectedIndex()));
        if (this.getTabbedPane().getSelectedIndex() == 1) {
            this.painelAbaAquisicao.atualizaSubPainelAquisicao();
        }
        if (this.getTabbedPane().getSelectedIndex() == 3) {
            this.painelAbaOperacaoBemImovel.exibirPaineis();
        }
        if (this.getTabbedPane().getSelectedIndex() == 4) {
            this.painelAbaPerguntas.tratarExibicaoPerguntas();
        }
        if (this.getTabbedPane().getSelectedIndex() == 5) {
            this.painelAbaApuracaoBemImovel.atualizaSubPainelApuracao();
        }
        if (this.getTabbedPane().getSelectedIndex() == 6) {
            this.painelAbaCalculoImpostoBemImovel.atualizaSubPainelCalculoImposto();
        }
        if (this.getTabbedPane().getSelectedIndex() == 7) {
            this.painelAbaConsolidacao.atualizaSubPainelConsolidacao();
        }
        this.configurarHelpID();
    }

    public void configObservadoresHabilitacaoDeAbas() {
        Observador lObsHabilitacaoAbas = new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                PainelDadosBensImoveis.this.tratarHabilitacaoAbas();
            }
        };
        this.alienacaoBemImovel.getDataAlienacao().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getNatureza().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getAquisicao().getDataAquisicao().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getAquisicao().getCustoAquisicao().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getValorAlienacao().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getCotacaoDolarDataAlienacao().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getValorAlienacaoDolar().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getValorCorretagemDolar().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNDolar().addObservador(lObsHabilitacaoAbas);
        this.alienacaoBemImovel.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar().addObservador(lObsHabilitacaoAbas);
    }

    @Override
    protected void tratarHabilitacaoAbas() {
        this.tratarHabilitacaoAbaAdquirentes();
        this.tratarHabilitacaoAbaPerguntas();
    }

    public void tratarHabilitacaoAbaAdquirentes() {
        this.setEnabledAbaPorNome("Adquirentes", this.alienacaoBemImovel.isAdquirenteRequerido());
    }

    private void tratarHabilitacaoAbaPerguntas() {
        boolean deveHabilitarPerguntas;
        boolean bl = deveHabilitarPerguntas = PerguntasUtil.getInstancia().deveExibirPerguntaPossuiOutroImovel(this.alienacaoBemImovel) || PerguntasUtil.getInstancia().deveExibirPerguntaImovelResidencial(this.alienacaoBemImovel) || this.alienacaoBemImovel.podeResponderPerguntaBemIsentoPorPequenoValor();
        if (deveHabilitarPerguntas) {
            this.setEnabledAbaPorNome("Perguntas", true);
        } else {
            this.setEnabledAbaPorNome("Perguntas", false);
            this.alienacaoBemImovel.limparPerguntas();
        }
    }

    private void exibirMensagemValorecebidoAnoAnterior() {
        if (this.alienacaoBemImovel.deveExibirMensagemValorecebidoAnoAnterior()) {
            GuiUtil.mostrarAviso("infoValorRecebidoAnosAnteriores");
        }
    }

    @Override
    protected String[] definirNomeAbas() {
        return new String[]{"Identifica\u00e7\u00e3o", "Aquisi\u00e7\u00e3o", "Adquirentes", "Opera\u00e7\u00e3o", "Perguntas", "Apura\u00e7\u00e3o", "Consolida\u00e7\u00e3o"};
    }

    @Override
    protected void configObservadores() {
    }

    @Override
    public String getTituloPainel() {
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            return "Bens Im\u00f3veis - Identifica\u00e7\u00e3o";
        }
        if (this.getTabbedPane().getSelectedIndex() == 1) {
            return "Bens Im\u00f3veis - Aquisi\u00e7\u00e3o";
        }
        if (this.getTabbedPane().getSelectedIndex() == 2) {
            return "Bens Im\u00f3veis - Adquirentes";
        }
        if (this.getTabbedPane().getSelectedIndex() == 3) {
            return "Bens Im\u00f3veis - Opera\u00e7\u00e3o";
        }
        if (this.getTabbedPane().getSelectedIndex() == 4) {
            return "Bens Im\u00f3veis - Perguntas";
        }
        if (this.getTabbedPane().getSelectedIndex() == 5) {
            return "Bens Im\u00f3veis - Apura\u00e7\u00e3o";
        }
        if (this.getTabbedPane().getSelectedIndex() == 6) {
            return "Bens Im\u00f3veis - C\u00e1lculo do Imposto";
        }
        if (this.getTabbedPane().getSelectedIndex() == 7) {
            return "Bens Im\u00f3veis - Consolida\u00e7\u00e3o";
        }
        return this.TITULO;
    }

    @Override
    public String getHelpID() {
        return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel";
    }

    private void configurarHelpID() {
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel");
        } else if (this.getTabbedPane().getSelectedIndex() == 1) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel/Identifica\u00e7\u00e3o");
        } else if (this.getTabbedPane().getSelectedIndex() == 2) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Adquirentes");
        } else if (this.getTabbedPane().getSelectedIndex() == 3) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Opera\u00e7\u00e3o");
        } else if (this.getTabbedPane().getSelectedIndex() == 4) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Perguntas");
        } else if (this.getTabbedPane().getSelectedIndex() == 5) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel/Apura\u00e7\u00e3o");
        } else if (this.getTabbedPane().getSelectedIndex() == 6) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel/C\u00e1lculo do Imposto");
        } else {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Consolida\u00e7\u00e3o");
        }
    }

    private String getHelpIdAba(int indiceAba) {
        if (indiceAba == 0) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel";
        }
        if (indiceAba == 1) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel/Identifica\u00e7\u00e3o";
        }
        if (indiceAba == 2) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Adquirentes";
        }
        if (indiceAba == 3) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Opera\u00e7\u00e3o";
        }
        if (indiceAba == 4) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Perguntas";
        }
        if (indiceAba == 5) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel/Apura\u00e7\u00e3o";
        }
        if (indiceAba == 6) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel/C\u00e1lculo do Imposto";
        }
        if (indiceAba == 7) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Consolida\u00e7\u00e3o";
        }
        return "";
    }

    @Override
    public boolean isTelaComVoltar() {
        return true;
    }

    @Override
    public void executaVoltar() {
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_BEM_IMOVEL);
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.alienacaoBemImovel.getBemImovel().getEspecificacao().naoFormatado();
    }

    public PainelAbaAquisicaoBemImovel getPainelAbaAquisicao() {
        return this.painelAbaAquisicao;
    }
}

