/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensimoveis;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoAlienacaoBemImovel;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelListaAb;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.bensimoveis.PainelDadosBensImoveis;
import br.gov.serpro.gcap.gui.bensimoveis.TableModelBensImoveis;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelListaBemImovel
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    public static final String TITULO_PAINEL = "Bens Im\u00f3veis";

    public PainelListaBemImovel() {
    }

    public PainelListaBemImovel(Colecao<? extends ObjetoNegocio> colecao) {
        super(colecao);
    }

    @Override
    public String getTituloPainel() {
        return TITULO_PAINEL;
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        DemonstrativoGCAP demostrativo = ControladorGui.getDemonstrativoAberto();
        TableModelBensImoveis lModel = (TableModelBensImoveis)this.getTabela().getModel();
        AlienacaoBemImovel lItem = new AlienacaoBemImovel();
        lItem.getPaisResidencia().setConteudo(ControladorGui.getDemonstrativoAberto().getIdDemonstrativo().getPaisDeclarante());
        lItem.getTerritorioParaisoFiscal().setConteudo(ControladorGui.getDemonstrativoAberto().getIdDemonstrativo().getTerritorioParaisoFiscal());
        demostrativo.getBensImoveis().add(lItem);
        ControladorGui.acionarPainel(new PainelDadosBensImoveis(lItem));
        lModel.refresh();
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableModelBensImoveis model = (TableModelBensImoveis)this.getTabela().getModel();
            ColecaoAlienacaoBemImovel colAlienacoes = (ColecaoAlienacaoBemImovel)model.getObjetoNegocio();
            AlienacaoBemImovel alienacao = (AlienacaoBemImovel)((Object)colAlienacoes.itens().get(indiceVetor));
            ControladorGui.acionarPainel(new PainelDadosBensImoveis(alienacao));
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    @Override
    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(1000);
    }

    @Override
    protected TableListaModel getTableModel() {
        return new TableModelBensImoveis(GCAPFacade.getInstancia().getDeclaracao().getBensImoveis());
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "Rela\u00e7\u00e3o de Bens Im\u00f3veis Alienados"};
        return tableLista;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return PainelDadosBensImoveis.class.getName();
    }

    @Override
    protected String getButtonHelpID() {
        return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem Im\u00f3vel";
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoBensImoveis.png");
    }

    @Override
    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens";
    }

    @Override
    public String[] getParametrosMensagemExclusao() {
        return new String[]{"bens im\u00f3veis"};
    }
}

