/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensimoveis.calculoimposto;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.gui.TableListaSumarioModel;
import java.lang.ref.WeakReference;
import serpro.ppgd.negocio.Informacao;

public class TableModelParcelasBrasil
extends TableListaSumarioModel {
    private static final long serialVersionUID = 1L;
    private WeakReference<AlienacaoBemImovel> weakAlienacao;

    public TableModelParcelasBrasil(AlienacaoBemImovel alienacao) {
        super(alienacao.getColecaoParcelaAlienacao());
        this.weakAlienacao = new WeakReference<AlienacaoBemImovel>(alienacao);
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Informacao getInformacaoAt(int row, int col) {
        boolean ultimaLinha;
        ColecaoParcelaAlienacaoBem parcelas = (ColecaoParcelaAlienacaoBem)this.getObjetoNegocio();
        ParcelaAlienacaoBem item = null;
        boolean bl = ultimaLinha = row == this.getRowCount() - 1;
        item = !ultimaLinha ? (ParcelaAlienacaoBem)((Object)parcelas.itens().get(row)) : (parcelas.itens().size() > 0 ? (ParcelaAlienacaoBem)((Object)parcelas.itens().get(0)) : new ParcelaAlienacaoBem());
        switch (col) {
            case 0: {
                return ultimaLinha ? this.labelTotal : item.getDataRecebimento();
            }
            case 1: {
                return ultimaLinha ? parcelas.getValorRecebidoTotal() : item.getValorRecebido();
            }
            case 2: {
                return ultimaLinha ? parcelas.getCustoCorretagemTotal() : item.getCustoCorretagem();
            }
            case 3: {
                return ultimaLinha ? parcelas.getValorLiquidoAlienacaoTotal() : item.getValorLiquidoAlienacao();
            }
            case 4: {
                if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).isPermutaComTorna()) {
                    return ultimaLinha ? parcelas.getCustoAquisicaoTornaProporcionalTotal() : item.getCustoAquisicaoTornaProporcional();
                }
                return ultimaLinha ? parcelas.getCustoAquisicaoProporcionalTotal() : item.getCustoAquisicaoProporcional();
            }
            case 5: {
                return ultimaLinha ? parcelas.getGanho5ProporcionalTotal() : item.getGanhoCapital5Proporcional();
            }
            case 6: {
                return item.getAliquotaMedia();
            }
            case 7: {
                return ultimaLinha ? parcelas.getImpostoDevidoTotal() : item.getImpostoDevido();
            }
            case 8: {
                return ultimaLinha ? parcelas.getImpostoPagoTotal() : item.getImpostoPago();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "<html><center>Data<br>Parcela</center></html>";
            }
            case 1: {
                return "<html><center>Valor<br>Recebido-(R$)</center></html>";
            }
            case 2: {
                return "<html><center>Custo de<br>Corretagem-(R$)</center></html>";
            }
            case 3: {
                return "<html><center>Valor<br>L\u00edquido-(R$)</center></html>";
            }
            case 4: {
                return "<html><center>Custo de Aquisi\u00e7\u00e3o<br>Proporcional</center></html>";
            }
            case 5: {
                return "<html><center>Ganho de Capital<br>Proporcional</center></html>";
            }
            case 6: {
                return "<html><center>% Al\u00edquota M\u00e9dia de<br>Imposto Devido</center></html>";
            }
            case 7: {
                return "<html><center>Imposto<br>Devido-(R$)</center></html>";
            }
            case 8: {
                return "<html><center>Imposto<br>Pago-(R$)</center></html>";
            }
        }
        return "";
    }
}

