/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensimoveis.calculoimposto;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.gui.TableListaSumarioModel;
import java.lang.ref.WeakReference;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;

public class TableModelParcelasExterior
extends TableListaSumarioModel {
    private WeakReference<AlienacaoBemImovel> weakAlienacao;
    private static final long serialVersionUID = 1L;
    private Alfa vazio = new Alfa();

    public TableModelParcelasExterior(AlienacaoBemImovel alienacao) {
        super(alienacao.getColecaoParcelaAlienacao());
        this.weakAlienacao = new WeakReference<AlienacaoBemImovel>(alienacao);
    }

    @Override
    public int getColumnCount() {
        int colcount = 11;
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            colcount = 11;
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            colcount = 10;
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            colcount = 8;
        }
        return colcount;
    }

    @Override
    public Informacao getInformacaoAt(int row, int col) {
        boolean ultimaLinha;
        ColecaoParcelaAlienacaoBem parcelas = (ColecaoParcelaAlienacaoBem)this.getObjetoNegocio();
        ParcelaAlienacaoBem item = null;
        boolean bl = ultimaLinha = row == this.getRowCount() - 1;
        item = !ultimaLinha ? (ParcelaAlienacaoBem)((Object)parcelas.itens().get(row)) : (parcelas.itens().size() > 0 ? (ParcelaAlienacaoBem)((Object)parcelas.itens().get(0)) : new ParcelaAlienacaoBem());
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            switch (col) {
                case 0: {
                    return ultimaLinha ? this.labelTotal : item.getDataRecebimento();
                }
                case 1: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoDolarTotal() : item.getValorLiquidoAlienacaoDolar();
                }
                case 2: {
                    return ultimaLinha ? this.vazio : item.getCotacaoDolar();
                }
                case 3: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoRealTotal() : item.getValorLiquidoAlienacaoReal();
                }
                case 4: {
                    if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).isPermutaComTorna()) {
                        return ultimaLinha ? parcelas.getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal() : item.getCustoAquisicaoTornaProporcionalOrigemNacionalReal();
                    }
                    return ultimaLinha ? parcelas.getCustoAquisicaoProporcionalOrigemNacionalRealTotal() : item.getCustoAquisicaoProporcionalOrigemNacionalReal();
                }
                case 5: {
                    return ultimaLinha ? parcelas.getGanhoCapital1ProporcionalNacionalRealTotal() : item.getGanhoCapital1ProporcionalOrigemNacionalReal();
                }
                case 6: {
                    return ultimaLinha ? parcelas.obterTotalSomatorioReducoesMN() : item.obterSomatorioReducoesMN();
                }
                case 7: {
                    return ultimaLinha ? parcelas.getGanhoCapital5ProporcionalNacionalRealTotal() : item.getGanhoCapital5ProporcionalMN();
                }
                case 8: {
                    return ultimaLinha ? this.vazio : item.getAliquotaMedia();
                }
                case 9: {
                    return ultimaLinha ? parcelas.getImpostoDevido2Total() : item.getImpostoDevido2();
                }
                case 10: {
                    return ultimaLinha ? parcelas.getImpostoPagoTotal() : item.getImpostoPago();
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            switch (col) {
                case 0: {
                    return ultimaLinha ? this.labelTotal : item.getDataRecebimento();
                }
                case 1: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoDolarTotal() : item.getValorLiquidoAlienacaoDolar();
                }
                case 2: {
                    if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).isPermutaComTorna()) {
                        return ultimaLinha ? parcelas.getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal() : item.getCustoAquisicaoTornaProporcionalOrigemMEDolar();
                    }
                    return ultimaLinha ? parcelas.getCustoAquisicaoProporcionalOrigemMEDolarTotal() : item.getCustoAquisicaoProporcionalOrigemMEDolar();
                }
                case 3: {
                    return ultimaLinha ? this.vazio : item.getCotacaoDolar();
                }
                case 4: {
                    return ultimaLinha ? parcelas.getGanhoCapital1ProporcionalMERealTotal() : item.getGanhoCapital1ProporcionalOrigemMEReal();
                }
                case 5: {
                    return ultimaLinha ? parcelas.obterTotalSomatorioReducoesME() : item.obterSomatorioReducoesME();
                }
                case 6: {
                    return ultimaLinha ? parcelas.getGanhoCapital5ProporcionalMERealTotal() : item.getGanhoCapital5ProporcionalME();
                }
                case 7: {
                    return ultimaLinha ? this.vazio : item.getAliquotaMedia();
                }
                case 8: {
                    return ultimaLinha ? parcelas.getImpostoDevido2Total() : item.getImpostoDevido2();
                }
                case 9: {
                    return ultimaLinha ? parcelas.getImpostoPagoTotal() : item.getImpostoPago();
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            switch (col) {
                case 0: {
                    return ultimaLinha ? this.labelTotal : item.getDataRecebimento();
                }
                case 1: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoDolarTotal() : item.getValorLiquidoAlienacaoDolar();
                }
                case 2: {
                    return ultimaLinha ? parcelas.getGanhoCapital1ProporcionalRealTotal() : item.getGanhoCapital1ProporcionalTotalReal();
                }
                case 3: {
                    ValorPositivo somatorioReducoes = new ValorPositivo();
                    if (ultimaLinha) {
                        somatorioReducoes.setConteudo(parcelas.obterTotalSomatorioReducoesMN());
                        somatorioReducoes.append('+', parcelas.obterTotalSomatorioReducoesME());
                    } else {
                        somatorioReducoes.setConteudo(item.obterSomatorioReducoesMN());
                        somatorioReducoes.append('+', item.obterSomatorioReducoesME());
                    }
                    return somatorioReducoes;
                }
                case 4: {
                    return ultimaLinha ? parcelas.getGanhoCapital5ProporcionalRealTotal() : item.getGanhoCapital5ProporcionalTotalReal();
                }
                case 5: {
                    return ultimaLinha ? this.vazio : item.getAliquotaMedia();
                }
                case 6: {
                    return ultimaLinha ? parcelas.getImpostoDevido2Total() : item.getImpostoDevido2();
                }
                case 7: {
                    return ultimaLinha ? parcelas.getImpostoPagoTotal() : item.getImpostoPago();
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            switch (column) {
                case 0: {
                    return "<html><center>Data<br>Parcela</center></html>";
                }
                case 1: {
                    return "<html><center>Valor L\u00edquido<br>Recebido-(XX$)</center></html>";
                }
                case 2: {
                    return "<html><center>Cota\u00e7\u00e3o da<br>Moeda Estrangeira</center></html>";
                }
                case 3: {
                    return "<html><center>Valor L\u00edquido<br>Recebido-(R$)</center></html>";
                }
                case 4: {
                    if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).isPermutaComTorna()) {
                        return "<html><center>Custo da<br>Torna-(R$)</center></html>";
                    }
                    return "<html><center>Custo de<br>Aquisi\u00e7\u00e3o-(R$)</center></html>";
                }
                case 5: {
                    return "<html><center>Resultado 1<br>-(R$)</center></html>";
                }
                case 6: {
                    return "<html><center>Total<br>Redu\u00e7\u00e3o-(R$)</center></html>";
                }
                case 7: {
                    return "<html><center>Ganho de<br>Capital-(R$)</center></html>";
                }
                case 8: {
                    return "<html><center>% Al\u00edquota<br>M\u00e9dia</center></html>";
                }
                case 9: {
                    return "<html><center>Imposto Devido<br>no Brasil-(R$)</center></html>";
                }
                case 10: {
                    return "<html><center>Imposto Pago<br>no Brasil-(R$)</center></html>";
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            switch (column) {
                case 0: {
                    return "<html><center>Data<br>Parcela</center></html>";
                }
                case 1: {
                    return "<html><center>Valor L\u00edquido<br>Recebido(US$)</center></html>";
                }
                case 2: {
                    if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).isPermutaComTorna()) {
                        return "<html><center>Custo da<br>Torna-(US$)</center></html>";
                    }
                    return "<html><center>Custo de<br>Aquisi\u00e7\u00e3o-(US$)</center></html>";
                }
                case 3: {
                    return "<html><center>Cota\u00e7\u00e3o<br>do D\u00f3lar</center></html>";
                }
                case 4: {
                    return "<html><center>Resultado 1<br>(R$)</center></html>";
                }
                case 5: {
                    return "<html><center>Total<br>Redu\u00e7\u00e3o -(R$)</center></html>";
                }
                case 6: {
                    return "<html><center>Ganho de<br>Capital-(R$)</center></html>";
                }
                case 7: {
                    return "<html><center>% Al\u00edquota<br>M\u00e9dia</center></html>";
                }
                case 8: {
                    return "<html><center>Imposto Devido<br>no Brasil-(R$)</center></html>";
                }
                case 9: {
                    return "<html><center>Imposto Pago<br>no Brasil-(R$)</center></html>";
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).obterCodigoOrigemRendimentos().naoFormatado())) {
            switch (column) {
                case 0: {
                    return "<html><center>Data<br>Parcela</center></html>";
                }
                case 1: {
                    return "<html><center>Valor L\u00edquido<br>Recebido-(US$)</center></html>";
                }
                case 2: {
                    return "<html><center>Resultado 1<br>(R$)</center></html>";
                }
                case 3: {
                    return "<html><center>Total<br>Redu\u00e7\u00e3o-(R$)</center></html>";
                }
                case 4: {
                    return "<html><center>Ganho de Capital<br>Total-(R$)</center></html>";
                }
                case 5: {
                    return "<html><center>% Al\u00edquota<br>M\u00e9dia</center></html>";
                }
                case 6: {
                    return "<html><center>Imposto Devido<br>no Brasil-(R$)</center></html>";
                }
                case 7: {
                    return "<html><center>Imposto Pago<br>no Brasil-(R$)</center></html>";
                }
            }
        }
        return "";
    }
}

