/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.componente;

import br.gov.serpro.gcap.acoes.MudarPainelAction;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.componente.DashedBorder;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.commons.collections.map.HashedMap;
import serpro.ppgd.negocio.util.UtilitariosString;

public class JTaskAction
extends JLabel {
    public static final Color BACKGROUND_COLOR = new Color(245, 249, 252);
    protected static final Color DEFAULT_LAST_ACCESSED_BACKGROUND = new Color(207, 235, 250);
    protected static final Border DEFAULT_FOCUS_BORDER = new DashedBorder(Color.gray, 1, 1, 1);
    protected static final Border DEFAULT_EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    protected static final int LINE_WRAP_LOCATION = 25;
    protected static HashedMap mapUnderlineFont = new HashedMap();
    protected static HashedMap mapPlainFont = new HashedMap();
    protected Action action;
    private boolean lastAccessed;
    private Color lastAccessedBackground;
    protected String backupName;

    public JTaskAction(String pName, String pCommandAction) {
        this(pName, pCommandAction, null);
    }

    public JTaskAction(String pName, String pCommandAction, Icon pIcon) {
        this(pName, pCommandAction, pIcon, 2);
    }

    public JTaskAction(String pName, String pCommandAction, Icon pIcon, int pHorizontalAlignment) {
        this(pName, pIcon, pHorizontalAlignment);
        this.action = new MudarPainelAction(pCommandAction);
    }

    public JTaskAction(String pName, Action pAction) {
        this(pName, pAction, null);
    }

    public JTaskAction(String pName, Action pAction, Icon pIcon) {
        this(pName, pAction, pIcon, 2);
    }

    public JTaskAction(String pName, Action pAction, Icon pIcon, int pHorizontalAlignment) {
        this(pName, pIcon, pHorizontalAlignment);
        this.action = pAction;
    }

    protected JTaskAction(String pName, Icon pIcon, int pHorizontalAlignment) {
        super(UtilitariosString.strToHtml((String)UtilitariosString.insereQuebraDeLinha((String)pName, (int)25, (String)"<BR>")), pIcon, pHorizontalAlignment);
        this.backupName = UtilitariosString.strToHtml((String)UtilitariosString.insereQuebraDeLinha((String)pName, (int)25, (String)"<BR>"));
        this.setFocusable(true);
        this.setOpaque(true);
        this.setBackground(BACKGROUND_COLOR);
        this.setBorder(DEFAULT_EMPTY_BORDER);
        this.setFont(this.getFont().deriveFont(12));
        this.setForeground(new Color(1, 62, 96));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                JTaskAction.this.setBorder(DEFAULT_EMPTY_BORDER);
            }

            @Override
            public void focusGained(FocusEvent e) {
                JTaskAction.this.setBorder(DEFAULT_FOCUS_BORDER);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTaskAction.this.requestFocusInWindow();
                JTaskAction.this.actionPerformed();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JTaskAction.this.setText(JTaskAction.this.getText().replaceAll("<html>", "<html><u>").replaceAll("</html>", "</u></html>"));
                ControladorGui.getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JTaskAction.this.setText(JTaskAction.this.getText().replaceAll("<html><u>", "<html>").replaceAll("</u></html>", "</html>"));
                ControladorGui.getJanelaPrincipal().getGlassPane().setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    JTaskAction.this.actionPerformed();
                }
            }
        });
    }

    public void actionPerformed() {
        if (this.action != null && this.isEnabled()) {
            ActionEvent lEvent = new ActionEvent(this, 0, this.getName());
            GuiUtil.startWaitCursor();
            this.action.actionPerformed(lEvent);
            GuiUtil.stopWaitCursor();
        }
    }

    public boolean isLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(boolean lastAccessed) {
        this.lastAccessed = lastAccessed;
        if (lastAccessed) {
            this.setBackground(this.getLastAccessedBackground());
        } else {
            this.setBackground(BACKGROUND_COLOR);
        }
    }

    public Color getLastAccessedBackground() {
        if (this.lastAccessedBackground == null) {
            return DEFAULT_LAST_ACCESSED_BACKGROUND;
        }
        return this.lastAccessedBackground;
    }

    public void setLastAccessedBackground(Color lastAccessedBackground) {
        this.lastAccessedBackground = lastAccessedBackground;
    }

    public String getActionCommand() {
        String lCommandAction = "";
        if (this.action instanceof MudarPainelAction) {
            MudarPainelAction lAction = (MudarPainelAction)this.action;
            lCommandAction = lAction.getCommandAction();
        }
        return lCommandAction;
    }

    public void setMinimized(boolean pMinimized) {
        if (pMinimized) {
            this.setText("");
            this.setToolTipText(this.backupName);
        } else {
            this.setText(this.backupName);
            this.setToolTipText(null);
        }
    }

    public Action getAction() {
        return this.action;
    }
}

