/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.dialogs;

import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.observador.ObservadorZeradorDePeriodoDoDemonstrativo;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelNovoDemonstrativo
extends JPanel {
    private static final String HELP_ID = "Como fazer para.../... Incluir novo Demonstrativo";
    protected IdDemonstrativoGCAP idDec = new IdDemonstrativoGCAP();
    private Observador obsPerguntaTerritorio = new Observador(){

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            if (PainelNovoDemonstrativo.this.idDec.paisTemTerritorioParaisoFiscal()) {
                PainelNovoDemonstrativo.this.pnlTerritorioParaisoFiscal.setVisible(true);
                PainelNovoDemonstrativo.this.lblTerritorio.setText("<html>\u00c9 residente de " + PainelNovoDemonstrativo.this.idDec.getPaisDeclarante().getConteudoAtual(3).replaceAll(",", "<BR>") + "? <font color=red>*</font></html>");
            } else {
                PainelNovoDemonstrativo.this.pnlTerritorioParaisoFiscal.setVisible(false);
            }
        }
    };
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButtonMensagem btnMsgTerritorio;
    private JButton btnOk;
    private JEditCPF edtCPF;
    private JEditMascara edtDdd;
    private JEditAlfa edtNome;
    private JAutoCompleteEditCodigo edtPais;
    private JEditMascara edtTelefone;
    private JButtonGroupPanel grpTerritorio;
    private JEditData jEditDataFim;
    private JEditData jEditDataInicio;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblTerritorio;
    private JPanel pnlTerritorioParaisoFiscal;
    private PPGDRadioItem rdbNao;
    private PPGDRadioItem rdbSim;

    public PainelNovoDemonstrativo() {
        this.idDec.getPaisDeclarante().addObservador((Observador)new ObservadorZeradorDePeriodoDoDemonstrativo(this.idDec.getDataInicioPermanencia(), this.idDec.getDataFimPermanencia()));
        this.initComponents();
        this.setValoresPadrao();
        this.associarInformacao();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        GuiUtil.inibirEnterNavegacaoFocoBotoes(this.btnAjuda, this.btnCancelar, this.btnOk);
        this.idDec.getPaisDeclarante().addObservador(this.obsPerguntaTerritorio);
        this.pnlTerritorioParaisoFiscal.setVisible(this.idDec.paisTemTerritorioParaisoFiscal());
        GuiUtil.inibirEnterNavegacaoFocoBotoes(this);
        GuiUtil.adicionarListenerF11(this, "Novo Demonstrativo");
    }

    private void associarInformacao() {
        this.edtNome.setInformacao((Informacao)this.idDec.getNome());
        this.edtCPF.setInformacao((Informacao)this.idDec.getCpf());
        this.edtPais.setInformacao((Informacao)this.idDec.getPaisDeclarante());
        this.edtDdd.setInformacao((Informacao)this.idDec.getDddDeclarante());
        this.edtTelefone.setInformacao((Informacao)this.idDec.getTelefoneDeclarante());
        this.jEditDataInicio.setInformacao((Informacao)this.idDec.getDataInicioPermanencia());
        this.jEditDataFim.setInformacao((Informacao)this.idDec.getDataFimPermanencia());
        this.grpTerritorio.setInformacao((Informacao)this.idDec.getTerritorioParaisoFiscal());
    }

    private void setValoresPadrao() {
        this.idDec.getPaisDeclarante().setConteudo("105");
        this.idDec.getDataInicioPermanencia().setConteudo(DataUtil.getPrimeiroDiaDoAno());
        this.idDec.getDataFimPermanencia().setConteudo(DataUtil.getUltimoDiaDoAno());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.edtCPF = new JEditCPF();
        this.jLabel3 = new JLabel();
        this.edtNome = new JEditAlfa();
        this.edtDdd = new JEditMascara();
        this.edtTelefone = new JEditMascara();
        this.jPanel2 = new JPanel();
        this.jEditDataInicio = new JEditData();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.pnlTerritorioParaisoFiscal = new JPanel();
        this.lblTerritorio = new JLabel();
        this.grpTerritorio = new JButtonGroupPanel();
        this.rdbSim = new PPGDRadioItem();
        this.rdbNao = new PPGDRadioItem();
        this.btnMsgTerritorio = new JButtonMensagem();
        this.jLabel14 = new JLabel();
        this.jEditDataFim = new JEditData();
        this.edtPais = new JAutoCompleteEditCodigo();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Contribuinte");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.jLabel2.setFont(new Font("Arial", 0, 11));
        this.jLabel2.setForeground(new Color(89, 89, 89));
        this.jLabel2.setText("CPF");
        this.jLabel2.setVerticalAlignment(3);
        this.jLabel3.setFont(new Font("Arial", 0, 11));
        this.jLabel3.setForeground(new Color(89, 89, 89));
        this.jLabel3.setText("Nome");
        this.jLabel3.setVerticalAlignment(3);
        this.edtNome.setMaxChars(60);
        this.edtDdd.setCaracteresValidos("1234567890 ");
        this.edtDdd.setMascara("**");
        this.edtTelefone.setCaracteresValidos("1234567890 ");
        this.edtTelefone.setMascara("*****-****");
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Resid\u00eancia", 0, 0, new Font("Arial", 1, 11), new Color(0, 74, 106)));
        this.jLabel6.setFont(new Font("Arial", 0, 11));
        this.jLabel6.setForeground(new Color(89, 89, 89));
        this.jLabel6.setText("Data Fim");
        this.jLabel6.setVerticalAlignment(3);
        this.jLabel7.setFont(new Font("Arial", 0, 11));
        this.jLabel7.setForeground(new Color(89, 89, 89));
        this.jLabel7.setText("Data In\u00edcio");
        this.jLabel7.setVerticalAlignment(3);
        this.jLabel8.setFont(new Font("Arial", 0, 11));
        this.jLabel8.setForeground(new Color(89, 89, 89));
        this.jLabel8.setText("Pa\u00eds");
        this.jLabel8.setVerticalAlignment(3);
        this.pnlTerritorioParaisoFiscal.setBackground(Color.white);
        this.lblTerritorio.setText("\u00c9 residente de Wilayah Persekutuan Labuan?");
        this.grpTerritorio.setBorder(null);
        this.grpTerritorio.setButtonMensagem(this.btnMsgTerritorio);
        this.rdbSim.setBackground(new Color(255, 255, 255));
        this.rdbSim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbSim.setText("Sim");
        this.rdbSim.setValorSelecionadoTrue(Logico.SIM);
        this.rdbSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelNovoDemonstrativo.this.rdbSimFocusLost(evt);
            }
        });
        this.rdbNao.setBackground(new Color(255, 255, 255));
        this.rdbNao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbNao.setText("N\u00e3o");
        this.rdbNao.setValorSelecionadoTrue(Logico.NAO);
        this.rdbNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelNovoDemonstrativo.this.rdbNaoFocusLost(evt);
            }
        });
        GroupLayout grpTerritorioLayout = new GroupLayout((Container)this.grpTerritorio);
        this.grpTerritorio.setLayout((LayoutManager)grpTerritorioLayout);
        grpTerritorioLayout.setHorizontalGroup((GroupLayout.Group)grpTerritorioLayout.createParallelGroup(1).add((GroupLayout.Group)grpTerritorioLayout.createSequentialGroup().add((Component)this.rdbSim, -2, -1, -2).addPreferredGap(1).add((Component)this.rdbNao, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpTerritorioLayout.setVerticalGroup((GroupLayout.Group)grpTerritorioLayout.createParallelGroup(1).add((Component)this.rdbNao, -1, -1, Short.MAX_VALUE).add((Component)this.rdbSim, -1, -1, Short.MAX_VALUE));
        this.rdbSim.getAccessibleContext().setAccessibleName("Utilize seta para esquerda e para direita para alterar a resposta para a pergunta: \u00c9 residente de Wilayah Persekutuan Labuan? Sim");
        this.rdbNao.getAccessibleContext().setAccessibleName("\u00c9 residente de Wilayah Persekutuan Labuan? N\u00e3o");
        this.btnMsgTerritorio.setText("jButtonMensagem1");
        this.jLabel14.setFont(new Font("Arial", 0, 11));
        this.jLabel14.setForeground(new Color(255, 0, 0));
        this.jLabel14.setText("*");
        this.jLabel14.setVerticalAlignment(3);
        GroupLayout pnlTerritorioParaisoFiscalLayout = new GroupLayout((Container)this.pnlTerritorioParaisoFiscal);
        this.pnlTerritorioParaisoFiscal.setLayout((LayoutManager)pnlTerritorioParaisoFiscalLayout);
        pnlTerritorioParaisoFiscalLayout.setHorizontalGroup((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createSequentialGroup().add((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createSequentialGroup().add((Component)this.lblTerritorio).add(3, 3, 3).add((Component)this.jLabel14)).add((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createSequentialGroup().add((Component)this.grpTerritorio, -2, -1, -2).addPreferredGap(0).add((Component)this.btnMsgTerritorio, -2, 29, -2))).add(0, 211, Short.MAX_VALUE)));
        pnlTerritorioParaisoFiscalLayout.setVerticalGroup((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createSequentialGroup().add((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createParallelGroup(1).add((Component)this.lblTerritorio).add((Component)this.jLabel14)).addPreferredGap(0).add((GroupLayout.Group)pnlTerritorioParaisoFiscalLayout.createParallelGroup(1).add((Component)this.grpTerritorio, -2, -1, -2).add((Component)this.btnMsgTerritorio, -2, -1, -2))));
        this.lblTerritorio.getAccessibleContext().setAccessibleName("");
        this.jLabel14.getAccessibleContext().setAccessibleName("");
        this.jLabel11.setFont(new Font("Arial", 0, 11));
        this.jLabel11.setForeground(new Color(255, 0, 0));
        this.jLabel11.setText("*");
        this.jLabel11.setVerticalAlignment(3);
        this.jLabel12.setFont(new Font("Arial", 0, 11));
        this.jLabel12.setForeground(new Color(255, 0, 0));
        this.jLabel12.setText("*");
        this.jLabel12.setVerticalAlignment(3);
        this.jLabel13.setFont(new Font("Arial", 0, 11));
        this.jLabel13.setForeground(new Color(255, 0, 0));
        this.jLabel13.setText("*");
        this.jLabel13.setVerticalAlignment(3);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel8).add(3, 3, 3).add((Component)this.jLabel11).add(0, 0, Short.MAX_VALUE)).add((Component)this.edtPais, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jEditDataInicio, -2, 113, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel7).add(3, 3, 3).add((Component)this.jLabel12))).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel6).add(3, 3, 3).add((Component)this.jLabel13)).add((Component)this.jEditDataFim, -2, 109, -2)).add(6, 6, 6)).add((Component)this.pnlTerritorioParaisoFiscal, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jLabel13)).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jLabel8).add((Component)this.jLabel11).add((Component)this.jLabel12))).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jEditDataInicio, -2, -1, -2).add((Component)this.jEditDataFim, -2, -1, -2).add((Component)this.edtPais, -2, 0, Short.MAX_VALUE)).add(9, 9, 9).add((Component)this.pnlTerritorioParaisoFiscal, -2, -1, -2).add(21, 21, 21)));
        this.jEditDataInicio.getAccessibleContext().setAccessibleName("Data In\u00edcio");
        this.jLabel6.getAccessibleContext().setAccessibleName("");
        this.jLabel7.getAccessibleContext().setAccessibleName("");
        this.jLabel8.getAccessibleContext().setAccessibleName("");
        this.jEditDataFim.getAccessibleContext().setAccessibleName("Data Fim");
        this.edtPais.getAccessibleContext().setAccessibleName("Pa\u00eds. Utilize seta para cima e para baixo para alterar o pa\u00eds selecionado.");
        this.jLabel11.getAccessibleContext().setAccessibleName("");
        this.jLabel12.getAccessibleContext().setAccessibleName("");
        this.jLabel13.getAccessibleContext().setAccessibleName("");
        this.jLabel4.setFont(new Font("Arial", 0, 11));
        this.jLabel4.setForeground(new Color(89, 89, 89));
        this.jLabel4.setText("DDD");
        this.jLabel4.setVerticalAlignment(3);
        this.jLabel5.setFont(new Font("Arial", 0, 11));
        this.jLabel5.setForeground(new Color(89, 89, 89));
        this.jLabel5.setText("Telefone");
        this.jLabel5.setVerticalAlignment(3);
        this.jLabel9.setFont(new Font("Arial", 0, 11));
        this.jLabel9.setForeground(new Color(255, 0, 0));
        this.jLabel9.setText("*");
        this.jLabel9.setVerticalAlignment(3);
        this.jLabel10.setFont(new Font("Arial", 0, 11));
        this.jLabel10.setForeground(new Color(255, 0, 0));
        this.jLabel10.setText("*");
        this.jLabel10.setVerticalAlignment(3);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.edtNome, -1, 559, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.edtCPF, -2, 160, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel2).add(3, 3, 3).add((Component)this.jLabel9))).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.edtDdd, -2, 56, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel5).add((Component)this.edtTelefone, -2, 138, -2))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).add(3, 3, 3).add((Component)this.jLabel10))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel9)).addPreferredGap(0).add((Component)this.edtCPF, -2, -1, -2)).add((Component)this.edtDdd, -2, -1, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.edtTelefone, -2, -1, -2))).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3, -2, 16, -2).add((Component)this.jLabel10)).addPreferredGap(0).add((Component)this.edtNome, -2, -1, -2).add(18, 18, 18).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(55, Short.MAX_VALUE)));
        this.jLabel2.getAccessibleContext().setAccessibleName("");
        this.edtCPF.getAccessibleContext().setAccessibleName("CPF");
        this.jLabel3.getAccessibleContext().setAccessibleName("");
        this.edtNome.getAccessibleContext().setAccessibleName("Nome do contribuinte");
        this.edtDdd.getAccessibleContext().setAccessibleName("Ddd com dois d\u00edgitos");
        this.edtTelefone.getAccessibleContext().setAccessibleName("Telefone");
        this.jLabel4.getAccessibleContext().setAccessibleName("");
        this.jLabel5.getAccessibleContext().setAccessibleName("");
        this.jLabel9.getAccessibleContext().setAccessibleName("");
        this.jLabel10.getAccessibleContext().setAccessibleName("");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelNovoDemonstrativo.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelNovoDemonstrativo.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.btnOk, -2, 90, -2).addPreferredGap(0).add((Component)this.btnCancelar, -2, 90, -2).addPreferredGap(0).add((Component)this.btnAjuda, -2, 90, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jLabel1, -1, 585, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.btnAjuda).add((Component)this.btnCancelar).add((Component)this.btnOk)).addContainerGap()));
        layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 2);
        this.btnOk.getAccessibleContext().setAccessibleName("OK");
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.idDec = null;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.criarDeclaracao(this.idDec)) {
            ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
            try {
                ControladorGui.abrirDemonstrativo(this.idDec, true);
            }
            catch (HashInvalidoException e) {
                ControladorGui.tratarException((Exception)((Object)e));
            }
        }
    }

    private void rdbSimFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbNao) {
            this.grpTerritorio.chamaValidacao();
        }
    }

    private void rdbNaoFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbSim) {
            this.grpTerritorio.chamaValidacao();
        }
    }

    public boolean criarDeclaracao(IdDemonstrativoGCAP id) {
        RetornoValidacao validacao = id.getCpf().validar().getPrimeiroRetornoValidacaoMaisSevero();
        if (!validacao.isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(validacao.getMensagemValidacao()), "Erro", 0);
            this.edtCPF.getComponenteFoco().requestFocusInWindow();
            return false;
        }
        validacao = id.getNome().validar().getPrimeiroRetornoValidacaoMaisSevero();
        if (!validacao.isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(validacao.getMensagemValidacao()), "Erro", 0);
            this.edtNome.getComponenteFoco().requestFocusInWindow();
            return false;
        }
        validacao = id.getPaisDeclarante().validar().getPrimeiroRetornoValidacaoMaisSevero();
        if (!validacao.isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(validacao.getMensagemValidacao()), "Erro", 0);
            this.edtPais.getComponenteFoco().requestFocusInWindow();
            return false;
        }
        validacao = id.getDataInicioPermanencia().validar().getPrimeiroRetornoValidacaoMaisSevero();
        if (!validacao.isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(validacao.getMensagemValidacao()), "Erro", 0);
            this.jEditDataInicio.getComponenteFoco().requestFocusInWindow();
            return false;
        }
        validacao = id.getDataFimPermanencia().validar().getPrimeiroRetornoValidacaoMaisSevero();
        if (!validacao.isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(validacao.getMensagemValidacao()), "Erro", 0);
            this.jEditDataFim.getComponenteFoco().requestFocusInWindow();
            return false;
        }
        validacao = id.getTerritorioParaisoFiscal().validar().getPrimeiroRetornoValidacaoMaisSevero();
        if (!validacao.isValido()) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(validacao.getMensagemValidacao()), "Erro", 0);
            this.grpTerritorio.getComponenteFoco().requestFocusInWindow();
            return false;
        }
        if (GCAPFacade.existeDeclaracao(this.idDec)) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(MensagemUtil.getMensagem("ExisteDemonstrativoComDados")), "Erro", 0);
            return false;
        }
        this.idDec.getPaisDeclarante().removeObservador(this.obsPerguntaTerritorio);
        GCAPFacade.criarDeclaracao(id);
        return true;
    }
}

