/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.dialogs;

import br.gov.serpro.gcap.acoes.VerificarPendenciasAction;
import br.gov.serpro.gcap.app.ConstantesImpressaoIf;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.especie.MoedasAlienadasMensal;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.componente.JEditLabel;
import br.gov.serpro.gcap.gui.componente.JTituloForaPanel;
import br.gov.serpro.gcap.gui.componente.JTituloPanel;
import br.gov.serpro.gcap.gui.dialogs.ListModelMesesDarf;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.impressao.ImpressaoDarf;
import br.gov.serpro.gcap.impressao.RelatorioDarf;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.observador.ObservadorTela;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelSelecionarImpressaoDarfMoedaEspecie
extends JPanel
implements ConstantesImpressaoIf {
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JEditLogico edtMeses;
    private JEditLogico edtSelecionarImpressao;
    private JTituloPanel gcapTitledPanel1;
    private JTituloPanel gcapTitledPanel2;
    private JTituloForaPanel jTituloForaPanel1;
    private JTituloForaPanel jTituloForaPanel2;
    private JEditLabel lblAtencaoImpressao;
    private JEditLabel lblCpf;
    private JEditLabel lblCpfSelecionado;
    private JEditLabel lblMeses;
    private JList lstMeses;
    private JPanel pnlBotoes;
    private JScrollPane scrollMeses;
    private static final long serialVersionUID = 1L;
    private DemonstrativoGCAP demonstrativoGCAP;
    private ListModelMesesDarf listModelMeses;
    private VerificarPendenciasAction verificarPendencias = new VerificarPendenciasAction();

    public PainelSelecionarImpressaoDarfMoedaEspecie() {
        this.initComponents();
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnAjuda.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
        this.btnOk.setFocusTraversalKeys(0, set);
    }

    public PainelSelecionarImpressaoDarfMoedaEspecie(DemonstrativoGCAP pDemonstrativo) {
        this.demonstrativoGCAP = pDemonstrativo;
        this.listModelMeses = new ListModelMesesDarf();
        this.initComponents();
        this.lblAtencaoImpressao.setText(MensagemUtil.getMensagem("vencimentodardiautil"));
        this.edtMeses.setBackground(Color.WHITE);
        this.edtSelecionarImpressao.setBackground(Color.WHITE);
        Logico selecaoRelatorio = new Logico();
        selecaoRelatorio.addOpcao("VISUALIZAR", "Visualizar");
        selecaoRelatorio.addOpcao("PDF", "Gerar imagem PDF");
        selecaoRelatorio.addOpcao("IMPRIMIR", "Imprimir");
        selecaoRelatorio.setConteudo("VISUALIZAR");
        this.edtSelecionarImpressao.setInformacao((Informacao)selecaoRelatorio);
        Logico opcaoTodosOuSelecionados = new Logico();
        opcaoTodosOuSelecionados.addOpcao("TODOS", "Todos");
        opcaoTodosOuSelecionados.addOpcao("SELECIONADOS", "Um ou mais");
        opcaoTodosOuSelecionados.setConteudo("TODOS");
        opcaoTodosOuSelecionados = new Logico();
        opcaoTodosOuSelecionados.addOpcao("TODOS", "Todos");
        opcaoTodosOuSelecionados.addOpcao("SELECIONADOS", "Um ou mais");
        opcaoTodosOuSelecionados.setConteudo("TODOS");
        this.edtMeses.setInformacao((Informacao)opcaoTodosOuSelecionados);
        this.edtMeses.getInformacao().setReadOnly(true);
        String cpfDeclarante = GCAPFacade.getInstancia().getDeclaracao().getIdDemonstrativo().getCpf().formatado();
        this.lblCpf.setText(cpfDeclarante);
        this.adicionarObservadores(this.demonstrativoGCAP.getTotalizacaoMoedasAlienadas().getMeses());
        this.edtMeses.getInformacao().setConteudo("TODOS");
        this.edtMeses.getInformacao().setReadOnly(false);
        this.filtraMesesQueContemDarf(this.demonstrativoGCAP.getTotalizacaoMoedasAlienadas().getMeses());
        this.edtMeses.setBackground(Color.WHITE);
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void atualizaHelp() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Como fazer para.../... Imprimir Darf");
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, "Como fazer para.../... Imprimir Darf");
    }

    private void adicionarObservadores(List<MoedasAlienadasMensal> listaMoedasAlienadasMensal) {
        this.adicionaObservadorTipoRelatorio();
        this.adicionaObservadorMeses();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        String opcaoSaidaRelatorio = this.edtSelecionarImpressao.getInformacao().asString();
        if ("IMPRIMIR".equals(opcaoSaidaRelatorio) && !GuiUtil.mostrarConfirma(null, "Se houver uma impressora instalada, a impress\u00e3o ser\u00e1 enviada diretamente para ela, confirma a impress\u00e3o?")) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        GuiUtil.fecharDialog(this);
        this.imprimir();
        this.setCursor(cursor);
    }

    private void adicionaObservadorMeses() {
        ObservadorTela lObservadorMeses = new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String escolhaMesesUsuario = PainelSelecionarImpressaoDarfMoedaEspecie.this.edtMeses.getInformacao().asString();
                if ("SELECIONADOS".equals(escolhaMesesUsuario)) {
                    PainelSelecionarImpressaoDarfMoedaEspecie.this.lstMeses.setEnabled(true);
                } else {
                    PainelSelecionarImpressaoDarfMoedaEspecie.this.lstMeses.setEnabled(false);
                }
            }
        };
        this.edtMeses.getInformacao().addObservador((Observador)lObservadorMeses);
    }

    private void obterMesesMoedaEspecie(List<MoedasAlienadasMensal> meses, Map<Integer, Integer> mesesComPagamento) {
        for (MoedasAlienadasMensal mes : meses) {
            if (mes.getImpostoDevido().isVazio()) continue;
            mesesComPagamento.put(mes.getMesAsInt(), mes.getMesAsInt() + 1);
        }
    }

    private void filtraMesesQueContemDarf(List<MoedasAlienadasMensal> pMoedasAlienadasMensal) {
        this.listModelMeses.zerarMeses();
        HashMap<Integer, Integer> mesesComPagamento = new HashMap<Integer, Integer>();
        this.obterMesesMoedaEspecie(pMoedasAlienadasMensal, mesesComPagamento);
        ListModelMesesDarf listModelMesesEncontrados = new ListModelMesesDarf(mesesComPagamento);
        this.lstMeses.setModel(listModelMesesEncontrados);
    }

    private boolean imprimir() {
        String lTipoRelatorio = this.edtSelecionarImpressao.getInformacao().getConteudoFormatado();
        return this.imprimirDarf(lTipoRelatorio);
    }

    private void adicionaObservadorTipoRelatorio() {
        ObservadorTela lObservadorTipoRelatorio = new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String stringNovo = valorNovo.toString();
                if ("VISUALIZAR".equals(stringNovo) || "PDF".equals(stringNovo)) {
                    PainelSelecionarImpressaoDarfMoedaEspecie.this.lblAtencaoImpressao.setText(MensagemUtil.getMensagem("vencimentodardiautil"));
                } else {
                    PainelSelecionarImpressaoDarfMoedaEspecie.this.lblAtencaoImpressao.setText(MensagemUtil.getMensagem("vencimentodardiautilmaispapela4"));
                }
                PainelSelecionarImpressaoDarfMoedaEspecie.this.atualizaHelp();
            }
        };
        this.edtSelecionarImpressao.getInformacao().addObservador((Observador)lObservadorTipoRelatorio);
    }

    private void btnAjudaActionPerformed(ActionEvent evt) {
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        GuiUtil.fecharDialog(this);
    }

    private int[] getMesesSelecionados() {
        Object[] nomesMesesSelecionados = null;
        if ("SELECIONADOS".equals(this.edtMeses.getInformacao().getConteudoFormatado())) {
            nomesMesesSelecionados = this.lstMeses.getSelectedValues();
        }
        int[] indiceRealDoMes = null;
        if (nomesMesesSelecionados != null) {
            indiceRealDoMes = new int[nomesMesesSelecionados.length];
            for (int i = 0; i < nomesMesesSelecionados.length; ++i) {
                String nomeMes = nomesMesesSelecionados[i].toString();
                indiceRealDoMes[i] = DataUtil.getNumeroMesPorNomeExtenso(nomeMes);
            }
        }
        return indiceRealDoMes;
    }

    private void initComponents() {
        this.jTituloForaPanel1 = new JTituloForaPanel();
        this.pnlBotoes = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.jTituloForaPanel2 = new JTituloForaPanel();
        this.lblAtencaoImpressao = new JEditLabel();
        this.gcapTitledPanel1 = new JTituloPanel();
        this.edtSelecionarImpressao = new JEditLogico();
        this.gcapTitledPanel2 = new JTituloPanel();
        this.lblMeses = new JEditLabel();
        this.edtMeses = new JEditLogico();
        this.scrollMeses = new JScrollPane();
        this.lstMeses = new JList();
        this.lblCpfSelecionado = new JEditLabel();
        this.lblCpf = new JEditLabel();
        GroupLayout jTituloForaPanel1Layout = new GroupLayout((Container)this.jTituloForaPanel1);
        this.jTituloForaPanel1.setLayout((LayoutManager)jTituloForaPanel1Layout);
        jTituloForaPanel1Layout.setHorizontalGroup((GroupLayout.Group)jTituloForaPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jTituloForaPanel1Layout.setVerticalGroup((GroupLayout.Group)jTituloForaPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.pnlBotoes.setLayout(new FlowLayout(2));
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.setPreferredSize(new Dimension(90, 27));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDarfMoedaEspecie.this.btnOkActionPerformed(evt);
            }
        });
        this.pnlBotoes.add(this.btnOk);
        this.btnCancelar.setMnemonic('c');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setPreferredSize(new Dimension(90, 27));
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDarfMoedaEspecie.this.btnCancelarActionPerformed(evt);
            }
        });
        this.pnlBotoes.add(this.btnCancelar);
        this.btnAjuda.setMnemonic('a');
        this.btnAjuda.setText("Ajuda");
        this.btnAjuda.setPreferredSize(new Dimension(90, 27));
        this.btnAjuda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDarfMoedaEspecie.this.btnAjudaActionPerformed(evt);
            }
        });
        this.pnlBotoes.add(this.btnAjuda);
        this.jTituloForaPanel2.setTitulo("");
        this.lblAtencaoImpressao.setText("<html><body><p>Aten\u00e7\u00e3o: para melhor qualidade na impress\u00e3o do Demonstrativo, configure a impressora para papel tamanho A4.</p></body></html>");
        this.lblAtencaoImpressao.setAlignmentX(0.5f);
        this.lblAtencaoImpressao.setMinimumSize(new Dimension(99, 27));
        this.gcapTitledPanel1.setTitulo("Selecione a op\u00e7\u00e3o desejada");
        GroupLayout gcapTitledPanel1Layout = new GroupLayout((Container)this.gcapTitledPanel1);
        this.gcapTitledPanel1.setLayout((LayoutManager)gcapTitledPanel1Layout);
        gcapTitledPanel1Layout.setHorizontalGroup((GroupLayout.Group)gcapTitledPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.edtSelecionarImpressao, -1, -1, Short.MAX_VALUE).addContainerGap()));
        gcapTitledPanel1Layout.setVerticalGroup((GroupLayout.Group)gcapTitledPanel1Layout.createParallelGroup(1).add((Component)this.edtSelecionarImpressao, -1, -1, Short.MAX_VALUE));
        this.gcapTitledPanel2.setTitulo("Sele\u00e7\u00e3o de Meses");
        this.lblMeses.setText("<html><body><p>Selecione o m\u00eas de RECEBIMENTO cujo Darf voc\u00ea deseja imprimir. O vencimento \u00e9 o \u00faltimo dia \u00fatil do m\u00eas seguinte ao do recebimento.</p></body></html>");
        this.edtMeses.setCorBackgroundComponenteReadOnly(Color.white);
        this.edtMeses.setOrientacaoTexto(0);
        this.scrollMeses.setNextFocusableComponent(this.lstMeses);
        this.lstMeses.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstMeses.setEnabled(false);
        this.scrollMeses.setViewportView(this.lstMeses);
        GroupLayout gcapTitledPanel2Layout = new GroupLayout((Container)this.gcapTitledPanel2);
        this.gcapTitledPanel2.setLayout((LayoutManager)gcapTitledPanel2Layout);
        gcapTitledPanel2Layout.setHorizontalGroup((GroupLayout.Group)gcapTitledPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)gcapTitledPanel2Layout.createParallelGroup(1).add(2, (Component)this.lblMeses, -2, 0, Short.MAX_VALUE).add(2, (Component)this.scrollMeses).add((Component)this.edtMeses, -1, 367, Short.MAX_VALUE)).addContainerGap()));
        gcapTitledPanel2Layout.setVerticalGroup((GroupLayout.Group)gcapTitledPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel2Layout.createSequentialGroup().add((Component)this.lblMeses, -2, -1, -2).addPreferredGap(0).add((Component)this.edtMeses, -2, -1, -2).add(9, 9, 9).add((Component)this.scrollMeses, -1, 207, Short.MAX_VALUE).addContainerGap()));
        this.lblCpfSelecionado.setText("CPF selecionado:");
        this.lblCpfSelecionado.setFont(new Font("Tahoma", 1, 11));
        this.lblCpf.setText("V\u00e1rios");
        GroupLayout jTituloForaPanel2Layout = new GroupLayout((Container)this.jTituloForaPanel2);
        this.jTituloForaPanel2.setLayout((LayoutManager)jTituloForaPanel2Layout);
        jTituloForaPanel2Layout.setHorizontalGroup((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((Component)this.lblCpfSelecionado, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblCpf, -2, -1, -2).add(583, 583, 583)).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.lblAtencaoImpressao, -2, 0, Short.MAX_VALUE).add(1, (Component)this.gcapTitledPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.gcapTitledPanel2, -1, -1, Short.MAX_VALUE)).add(0, 0, Short.MAX_VALUE)));
        jTituloForaPanel2Layout.setVerticalGroup((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(3).add((Component)this.lblCpfSelecionado, -2, -1, -2).add((Component)this.lblCpf, -2, -1, -2)).addPreferredGap(1).add((Component)this.gcapTitledPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.gcapTitledPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblAtencaoImpressao, -2, -1, -2).addContainerGap(48, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTituloForaPanel2, -2, 401, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 80, Short.MAX_VALUE).add((Component)this.pnlBotoes, -2, 321, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTituloForaPanel2, -2, 500, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.pnlBotoes, -2, -1, -2).addContainerGap()));
    }

    private boolean imprimirDarf(String opcaoSaidaRelatorio) {
        RelatorioDarf relatorio = new RelatorioDarf(null, null);
        boolean isValido = false;
        DemonstrativoGCAP demonstrativo = null;
        int[] mesesParaImprimir = null;
        demonstrativo = this.demonstrativoGCAP;
        mesesParaImprimir = this.getMesesSelecionados();
        isValido = this.validarImpressaoDarf();
        if (isValido) {
            try {
                ControladorGui.abrirDemonstrativoSemUI(this.demonstrativoGCAP.getIdDemonstrativo());
                demonstrativo = ControladorGui.getDemonstrativoAberto();
            }
            catch (HashInvalidoException hashInvalidoException) {
                // empty catch block
            }
            DemonstrativoGCAP decAtual = this.demonstrativoGCAP;
            VerificarPendenciasAction verificarPendenciasAction = new VerificarPendenciasAction();
            VerificarPendenciasAction.PendenciasDemonstrativo pendencias = verificarPendenciasAction.obterPendencias(decAtual.getMoedasAlienadas());
            if (pendencias.getTotalErros() > 0) {
                if (0 == JOptionPane.showConfirmDialog(this.getParent(), MensagemUtil.getMensagem("ErroImprimirDarfErrosImpeditivosExibirListaPendencias", new String[]{""}), "Confirma\u00e7\u00e3o", 0, 3)) {
                    GCAPFacade.limpaCacheDeclaracoes();
                    try {
                        ControladorGui.fecharDemonstrativoSemUI();
                        ControladorGui.abrirDemonstrativo(decAtual.getIdDemonstrativo(), true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                    verificarPendenciasAction.exibirPendencias(pendencias);
                    return true;
                }
                ControladorGui.fecharDemonstrativoSemUI();
                return true;
            }
            ControladorGui.fecharDemonstrativoSemUI();
            if ("VISUALIZAR".equals(opcaoSaidaRelatorio)) {
                new ImpressaoDarf().exibirPdfDarfMoedaEspecie(demonstrativo, PlataformaPPGD.getPlataforma().getPainelPrincipal(), mesesParaImprimir);
                return true;
            }
        }
        return false;
    }

    private boolean validarImpressaoDarf() {
        boolean isMesesConsistentes;
        int[] mesesParaImprimir = this.getMesesSelecionados();
        boolean selecionouAlgumMes = mesesParaImprimir != null && mesesParaImprimir.length > 0;
        String lOpcaoMeses = this.edtMeses.getInformacao().getConteudoFormatado();
        boolean bl = isMesesConsistentes = selecionouAlgumMes && lOpcaoMeses.equals("SELECIONADOS") || lOpcaoMeses.equals("TODOS");
        if (!isMesesConsistentes) {
            GuiUtil.mostrarErro("\u00c9 necess\u00e1rio escolher ao menos um m\u00eas para a gera\u00e7\u00e3o do DARF.");
            return false;
        }
        return true;
    }
}

