/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.especie;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.entidades.especie.MoedaAlienada;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelAbaIf;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.PainelListaAb;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.especie.PainelDadosMoedaAlienada;
import br.gov.serpro.gcap.gui.especie.TableModelMoedasEspecie;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import java.awt.event.ActionEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaListaMoedasEspecie
extends PainelListaAb
implements PainelAbaIf {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Moedas em Esp\u00e9cie";
    public static final String NOME_ABA = "Moedas Alienadas";
    public static final String HELP_ID = "\u00cdndice";
    private PainelDemonstrativoIf painelPai;

    public PainelAbaListaMoedasEspecie(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
        this.configurarAcessibilidade();
    }

    public void configurarAcessibilidade() {
        this.getTabela().getAccessibleContext().setAccessibleDescription("Moedas alienadas");
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        DemonstrativoGCAP demostrativo = ControladorGui.getDemonstrativoAberto();
        TableModelMoedasEspecie lModel = (TableModelMoedasEspecie)this.getTabela().getModel();
        MoedaAlienada lItem = new MoedaAlienada();
        demostrativo.getMoedasAlienadas().add(lItem);
        ControladorGui.acionarPainel(new PainelDadosMoedaAlienada(lItem));
        lModel.refresh();
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableListaModel model = (TableListaModel)this.getTabela().getModel();
            ColecaoMoedaAlienada moedas = (ColecaoMoedaAlienada)model.getObjetoNegocio();
            MoedaAlienada moeda = (MoedaAlienada)((Object)moedas.itens().get(indiceVetor));
            ControladorGui.acionarPainel(new PainelDadosMoedaAlienada(moeda));
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    @Override
    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(1000);
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "Rela\u00e7\u00e3o de Moedas Alienadas"};
        return tableLista;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return PainelDadosMoedaAlienada.class.getName();
    }

    @Override
    protected String getButtonHelpID() {
        return HELP_ID;
    }

    @Override
    protected TableListaModel getTableModel() {
        return new TableModelMoedasEspecie((ObjetoNegocio)GCAPFacade.getInstancia().getDeclaracao().getMoedasAlienadas());
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens";
    }

    @Override
    public String[] getParametrosMensagemExclusao() {
        return new String[]{"moedas em esp\u00e9cie"};
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    public void aposCriarAbas() {
    }

    @Override
    public String getNomeAba() {
        return NOME_ABA;
    }

    @Override
    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }
}

