/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.especie;

import br.gov.serpro.gcap.entidades.especie.MoedasAlienadasMensal;
import br.gov.serpro.gcap.entidades.especie.TotalizacaoMoedasAlienadas;
import br.gov.serpro.gcap.gui.TableListaModel;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelTotalizacaoMoedasEspecie
extends TableListaModel {
    private static final long serialVersionUID = 1L;
    public static String CONST_TXT_TRACO = "-      ";
    private Alfa vazio = new Alfa();
    private Alfa traco = new Alfa();

    public TableModelTotalizacaoMoedasEspecie(ObjetoNegocio pObj) {
        super(pObj);
        this.traco.setConteudo(CONST_TXT_TRACO);
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return 12;
    }

    @Override
    public Informacao getInformacaoAt(int row, int col) {
        MoedasAlienadasMensal moedasAlienadasMensal = ((TotalizacaoMoedasAlienadas)this.getObjetoNegocio()).getMes(row);
        switch (col) {
            case 0: {
                return moedasAlienadasMensal.getMes();
            }
            case 1: {
                if (moedasAlienadasMensal.getAlienacoesDolar().isVazio()) {
                    return this.vazio;
                }
                return moedasAlienadasMensal.getAlienacoesDolar();
            }
            case 2: {
                if (moedasAlienadasMensal.getAlienacoesConsolidadasDolar().isVazio()) {
                    return this.vazio;
                }
                return moedasAlienadasMensal.getAlienacoesConsolidadasDolar();
            }
            case 3: {
                if (moedasAlienadasMensal.getGanhosCapital().isVazio()) {
                    return this.vazio;
                }
                return moedasAlienadasMensal.getGanhosCapital();
            }
            case 4: {
                if (moedasAlienadasMensal.getGanhosCapitalTributavel().isVazio()) {
                    return this.traco;
                }
                return moedasAlienadasMensal.getGanhosCapitalTributavel();
            }
            case 5: {
                return moedasAlienadasMensal.getAliquotaMedia();
            }
            case 6: {
                if (moedasAlienadasMensal.getImpostoDevido().isVazio()) {
                    return this.traco;
                }
                return moedasAlienadasMensal.getImpostoDevido();
            }
            case 7: {
                if (moedasAlienadasMensal.getImpostoPago().isVazio()) {
                    return this.traco;
                }
                return moedasAlienadasMensal.getImpostoPago();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "<html><center>M\u00eas</center></html>";
            }
            case 1: {
                return "<html><center>Aliena\u00e7\u00f5es em d\u00f3lar (US$)</center></html>";
            }
            case 2: {
                return "<html><center>Aliena\u00e7\u00f5es consolidadas em d\u00f3lar (US$)</center></html>";
            }
            case 3: {
                return "<html><center>Ganhos de capital (R$)</center></html>";
            }
            case 4: {
                return "<html><center>Ganhos de capital tribut\u00e1vel (R$)</center></html>";
            }
            case 5: {
                return "<html><center>Al\u00edquota m\u00e9dia (%)</center></html>";
            }
            case 6: {
                return "<html><center>Imposto devido (R$)</center></html>";
            }
            case 7: {
                return "<html><center>Imposto pago (R$)</center></html>";
            }
        }
        return "";
    }

    @Override
    public ObjetoNegocio getObjetoNegocio(int rowIndex) {
        return ((TotalizacaoMoedasAlienadas)this.getObjetoNegocio()).getMes(rowIndex);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 7;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 7) {
            String conteudoAtualCelula = ((String)aValue).trim();
            if (conteudoAtualCelula.isEmpty()) {
                conteudoAtualCelula = "0,00";
            }
            MoedasAlienadasMensal mes = ((TotalizacaoMoedasAlienadas)this.getObjetoNegocio()).getMes(rowIndex);
            if (!"-".equals(conteudoAtualCelula)) {
                mes.getImpostoPago().setConteudo(conteudoAtualCelula);
                Informacao val = this.getInformacaoAt(rowIndex, columnIndex);
                if (mes.getImpostoPago().isVazio()) {
                    val.setConteudo((Object)this.traco);
                } else {
                    val.setConteudo(mes.getImpostoPago().formatado());
                }
            }
        }
    }
}

