/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.pendencias;

import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.GCAPTableAb;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.PainelComlListaEditavelIf;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.PainelListaAb;
import br.gov.serpro.gcap.gui.PainelPrincipalAb;
import br.gov.serpro.gcap.gui.componente.DashedBorder;
import br.gov.serpro.gcap.gui.pendencias.PendenciaGCAP;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.GcapUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.pendencia.LinhaPendencia;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.UtilitariosString;

public class PainelPendencias
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Verificar Pend\u00eancias";
    public static final int RETORNO_FECHAR = 1;
    private ImageIcon imagemTitulo;
    private int totalErros = 0;
    private int totalAvisos = 0;
    private int retorno = 1;
    private List<Pendencia> listaPendencias;
    private Action pendenciasComAcessibilidadeAction;
    private JTextField edtTotalAvisos;
    private JTextField edtTotalErros;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList<LinhaPendencia> jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JLabel lblTotalAvisos;
    private JLabel lblTotalErros;

    public PainelPendencias(List<Pendencia> listaPendencias) {
        this.initComponents();
        this.listaPendencias = listaPendencias;
        this.jList1.setCellRenderer(new PendenciasCellRenderer());
        this.jList1.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                int index = PainelPendencias.this.jList1.locationToIndex(p);
                if (index != ((PendenciasCellRenderer)PainelPendencias.this.jList1.getCellRenderer()).getItemSublinhado()) {
                    ((PendenciasCellRenderer)PainelPendencias.this.jList1.getCellRenderer()).setItemSublinhado(index);
                    PainelPendencias.this.jList1.repaint();
                }
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                int index = PainelPendencias.this.jList1.locationToIndex(p);
                Pendencia pendencia = PainelPendencias.this.jList1.getModel().getElementAt(index).getPendencia();
                if (pendencia != null) {
                    PainelPendencias.this.selecionaPendencia(pendencia);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((PendenciasCellRenderer)PainelPendencias.this.jList1.getCellRenderer()).setItemSublinhado(-1);
                PainelPendencias.this.jList1.repaint();
            }
        });
        this.jList1.getActionMap().remove(this.jList1.getInputMap(0).get(KeyStroke.getKeyStroke("SPACE")));
        this.jList1.getInputMap(0).put(KeyStroke.getKeyStroke("SPACE"), "selecionaPendencia");
        this.jList1.getActionMap().put("selecionaPendencia", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Pendencia pendencia;
                System.out.println("acao feita...");
                int index = PainelPendencias.this.jList1.getSelectedIndex();
                if (index >= 0 && (pendencia = PainelPendencias.this.jList1.getModel().getElementAt(index).getPendencia()) != null) {
                    PainelPendencias.this.selecionaPendencia(pendencia);
                }
            }
        });
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.imagemTitulo = GuiUtil.getImage("/icones/png40px/DE_verificar_pendencias.png");
    }

    public void bindKeys(JComponent c) {
        InputMap inputMap = c.getInputMap(2);
        ActionMap actionMap = c.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(123, 0), "pendenciasComAcessibilidadeAction");
        actionMap.put("pendenciasComAcessibilidadeAction", this.pendenciasComAcessibilidadeAction);
    }

    protected String getTotalErros() {
        return "" + this.totalErros;
    }

    public int getQtdTotalErros() {
        return this.totalErros;
    }

    protected String getTotalAvisos() {
        return "" + this.totalAvisos;
    }

    public int getQtdTotalAvisos() {
        return this.totalAvisos;
    }

    protected ObjetoNegocio obterDeclaracaoAberta() {
        return GCAPFacade.getInstancia().getDeclaracao();
    }

    public void selecionaPendencia(Pendencia pPendencia) {
        if (pPendencia != null) {
            JEditCampo edit;
            ObjetoNegocio dec = this.obterDeclaracaoAberta();
            String ficha = pPendencia.getCampoInformacao().getFicha();
            if (dec != null) {
                String classe = pPendencia.getClassePainel();
                if (classe != null) {
                    this.selecionarNodoArvore(classe, pPendencia);
                } else {
                    System.err.println("Aten\u00e7\u00e3o: n\u00e3o \u00e9 poss\u00edvel selecionar a pend\u00eancia porque classe est\u00e1 null. O ObjetoNegocio precisa implementar ObjetoFicha.");
                }
            }
            if ((edit = (JEditCampo)MapeamentoInformacaoEditCampo.getEditAssociado((Informacao)pPendencia.getCampoInformacao())) != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        edit.aplicaFocoPendencia();
                    }
                });
            }
        }
        GcapUtil.setEstadoSistema(0);
    }

    protected void selecionarNodoArvore(String classe, Pendencia pendencia) {
        PainelDemonstrativoIf panel;
        GcapUtil.setEstadoSistema(1);
        ControladorGui.acionarPainel(classe);
        if (pendencia instanceof PendenciaGCAP && ((PendenciaGCAP)pendencia).getListaSelecao() != null) {
            String[] passo;
            String[] listaPassosSelecaoFicha = ((PendenciaGCAP)pendencia).getListaSelecao().split("\\|");
            PainelDemonstrativoIf panel2 = ControladorGui.getPainelAtualmenteExibido();
            for (int i = 0; i < listaPassosSelecaoFicha.length && (passo = listaPassosSelecaoFicha[i].split("\\;", -1)).length > 1; ++i) {
                if (passo[0].equals("Lista")) {
                    int numItem = Integer.parseInt(passo[1]);
                    if (panel2 instanceof PainelListaAb) {
                        this.tratarTelaLista(numItem, (PainelListaAb)panel2);
                        panel2 = ControladorGui.getPainelAtualmenteExibido();
                        continue;
                    }
                    if (panel2 instanceof PainelComlListaEditavelIf) {
                        ((PainelComlListaEditavelIf)((Object)panel2)).acionarEdicaoLinha(numItem - 1);
                        continue;
                    }
                } else if (passo[0].equals("Aba")) {
                    String nomeAba = passo[1];
                    if (!(panel2 instanceof PainelComAbasAb)) continue;
                    ((PainelComAbasAb)panel2).acionarAba(nomeAba, true);
                    panel2 = (PainelDemonstrativoIf)((Object)((PainelComAbasAb)panel2).getTabbedPane().getSelectedComponent());
                    continue;
                }
                break;
            }
        } else if (pendencia.getNomeAba() != null) {
            PainelDemonstrativoIf panel3 = ControladorGui.getPainelAtualmenteExibido();
            if (panel3 instanceof PainelComAbasAb) {
                ((PainelComAbasAb)panel3).acionarAba(pendencia.getNomeAba(), true);
                if (pendencia.getNumItem() > -1 && ((PainelComAbasAb)panel3).getTabbedPane().getSelectedComponent() instanceof PainelListaAb) {
                    this.tratarTelaLista(pendencia, (PainelListaAb)((PainelComAbasAb)panel3).getTabbedPane().getSelectedComponent());
                }
            }
        } else if (pendencia.getNumItem() > -1 && (panel = ControladorGui.getPainelAtualmenteExibido()) instanceof PainelListaAb) {
            this.tratarTelaLista(pendencia, (PainelListaAb)panel);
        }
    }

    private void tratarTelaLista(Pendencia pendencia, PainelListaAb panel) {
        this.tratarTelaLista(pendencia.getNumItem(), panel);
    }

    private void tratarTelaLista(int numItem, PainelListaAb panel) {
        GCAPTableAb tabela = panel.getTabela();
        int indiceModel = numItem - 1;
        int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
        panel.onBtnAbrirClick(null);
    }

    private void tratarPopupTelaLista(Pendencia pendencia, PainelDemonstrativoIf panel) {
        GCAPTableAb tabela = ((PainelPrincipalAb)panel).getTabela();
        int indiceModel = pendencia.getNumItem() - 1;
        int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
        ((PainelPrincipalAb)panel).onBtnAbrirClick(null);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblTotalErros = new JLabel();
        this.edtTotalErros = new JTextField();
        this.jPanel3 = new JPanel();
        this.lblTotalAvisos = new JLabel();
        this.edtTotalAvisos = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(204, 204, 255)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.jLabel4.setFont(new Font("Arial", 0, 14));
        this.jLabel4.setForeground(new Color(0, 74, 106));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/erro.png")));
        this.jLabel4.setText(" Impede a grava\u00e7\u00e3o da declara\u00e7\u00e3o para entrega \u00e0 RFB.");
        this.jPanel2.add(this.jLabel4);
        this.jLabel5.setFont(new Font("Arial", 0, 14));
        this.jLabel5.setForeground(new Color(0, 74, 106));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/atencao.png")));
        this.jLabel5.setText(" N\u00e3o impede a grava\u00e7\u00e3o da declara\u00e7\u00e3o para entrega \u00e0 RFB.");
        this.jPanel2.add(this.jLabel5);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(204, 204, 255)), BorderFactory.createEmptyBorder(1, 10, 1, 1)));
        this.jPanel1.setPreferredSize(new Dimension(636, 35));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.lblTotalErros.setFont(new Font("Arial", 0, 14));
        this.lblTotalErros.setForeground(new Color(0, 74, 106));
        this.lblTotalErros.setText("Total de Erros ");
        this.jPanel1.add(this.lblTotalErros);
        this.edtTotalErros.setEditable(false);
        this.edtTotalErros.setHorizontalAlignment(0);
        this.edtTotalErros.setEnabled(false);
        this.edtTotalErros.setPreferredSize(new Dimension(45, 23));
        this.jPanel1.add(this.edtTotalErros);
        this.jPanel3.setMinimumSize(new Dimension(5, 100));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(40, 4));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 40, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel3);
        this.lblTotalAvisos.setFont(new Font("Arial", 0, 14));
        this.lblTotalAvisos.setForeground(new Color(0, 74, 106));
        this.lblTotalAvisos.setText("Total de Avisos");
        this.jPanel1.add(this.lblTotalAvisos);
        this.edtTotalAvisos.setEditable(false);
        this.edtTotalAvisos.setHorizontalAlignment(0);
        this.edtTotalAvisos.setEnabled(false);
        this.edtTotalAvisos.setPreferredSize(new Dimension(45, 23));
        this.jPanel1.add(this.edtTotalAvisos);
        this.jPanel4.add((Component)this.jPanel1, "South");
        this.jList1.setModel(new PendenciasListModel());
        this.jList1.setSelectionMode(0);
        this.jList1.setCursor(new Cursor(12));
        this.jScrollPane2.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleName("Pend\u00eancias");
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, 730, Short.MAX_VALUE).add((Component)this.jPanel4, -1, 730, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel4, -1, 400, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    public int getRetorno() {
        return this.retorno;
    }

    @Override
    public String getTituloPainel() {
        return "Pend\u00eancias";
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return this.imagemTitulo;
    }

    @Override
    public void preExibir() {
        PendenciasListModel model = (PendenciasListModel)this.jList1.getModel();
        model.atualizarListaPendencias(this.getListaPendencias());
        this.edtTotalErros.setText(this.getTotalErros());
        this.edtTotalAvisos.setText(this.getTotalAvisos());
        this.jList1.getAccessibleContext().setAccessibleDescription(this.obterDescricaoAcessivelListaPendencias());
    }

    public String obterDescricaoAcessivelListaPendencias() {
        return "Total de avisos: \"" + this.getTotalAvisos() + "\". Total de Erros: \"" + this.getTotalErros() + "\".";
    }

    @Override
    public String getMensagemTela() {
        return "<html>Para corrigir erro ou aviso, clique na respectiva descri\u00e7\u00e3o. O programa mostrar\u00e1 o campo a ser corrigido.</html>";
    }

    @Override
    public boolean isTelaComMensagem() {
        return true;
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.jList1;
    }

    public List<Pendencia> getListaPendencias() {
        return this.listaPendencias;
    }

    public List<LinhaPendencia> montaTableListaPendencia(List<Pendencia> lstPendencia) {
        this.totalErros = 0;
        this.totalAvisos = 0;
        ArrayList<LinhaPendencia> listaPendencia = new ArrayList<LinhaPendencia>(lstPendencia.size());
        int contaLinhasTitulo = 0;
        String tituloFichaAnterior = "";
        Object item = "";
        Object itemPendente = "";
        for (int i = 0; i < lstPendencia.size(); ++i) {
            if (lstPendencia.get(i) == null) continue;
            Pendencia pendencia = lstPendencia.get(i);
            String tituloFichaAtual = pendencia.getCampoInformacao() != null ? pendencia.getCampoInformacao().getFicha() : pendencia.getColecao().getFicha();
            byte severidade = pendencia.getSeveridade();
            if (!tituloFichaAtual.equals(tituloFichaAnterior)) {
                if (severidade == 2 || severidade == 3 || severidade == 5) {
                    listaPendencia.add(new LinhaPendencia(0, tituloFichaAtual, null));
                }
                tituloFichaAnterior = tituloFichaAtual;
                ++contaLinhasTitulo;
            }
            if (i != 0 && !tituloFichaAtual.equals(tituloFichaAnterior) || i > 0 && pendencia.getCampoInformacao() == lstPendencia.get(i - 1).getCampoInformacao() && pendencia.getSeveridade() == lstPendencia.get(i - 1).getSeveridade() && pendencia.getNumItem() == lstPendencia.get(i - 1).getNumItem()) continue;
            item = "";
            if (pendencia.getNumItem() >= 1) {
                item = " - Item n\u00ba " + pendencia.getNumItem();
            }
            if (((String)item).equals("")) {
                itemPendente = pendencia.getMsg();
            } else {
                String msgPendencia = pendencia.getMsg();
                if (msgPendencia.endsWith(".")) {
                    msgPendencia = msgPendencia.substring(0, msgPendencia.length() - 1);
                }
                itemPendente = msgPendencia + (String)item;
            }
            if (((String)itemPendente).equals("")) continue;
            switch (severidade) {
                case 2: {
                    ++this.totalAvisos;
                    break;
                }
                case 3: {
                    ++this.totalErros;
                    break;
                }
                case 5: {
                    ++this.totalErros;
                }
            }
            if (severidade != 2 && severidade != 3 && severidade != 5) continue;
            listaPendencia.add(new LinhaPendencia(severidade, (String)itemPendente, pendencia));
        }
        return listaPendencia;
    }

    public class PendenciasListModel
    extends AbstractListModel<LinhaPendencia> {
        private List<LinhaPendencia> listaPendencias = new ArrayList<LinhaPendencia>();

        public void atualizarListaPendencias(List<Pendencia> listaPendencias) {
            this.listaPendencias = PainelPendencias.this.montaTableListaPendencia(listaPendencias);
        }

        @Override
        public int getSize() {
            return this.listaPendencias.size();
        }

        @Override
        public LinhaPendencia getElementAt(int index) {
            return this.listaPendencias.get(index);
        }
    }

    class PendenciasCellRenderer
    extends JLabel
    implements ListCellRenderer<LinhaPendencia> {
        int itemSublinhado = -1;

        public PendenciasCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LinhaPendencia> list, LinhaPendencia value, int index, boolean isSelected, boolean cellHasFocus) {
            StringBuilder sbTagInicial = new StringBuilder("<html><p>");
            StringBuilder sbTagFinal = new StringBuilder("</p></html>");
            StringBuilder sbNomeAcessivel = new StringBuilder();
            this.setIconTextGap(10);
            if (value.getPendencia() == null) {
                this.setIcon(null);
                this.setBackground(new Color(229, 238, 243));
                sbTagInicial.append("<b>");
                sbTagFinal.insert(0, "</b>");
                sbNomeAcessivel.append("Ficha: ");
            } else {
                this.setIcon(value.getTipo());
                this.setBackground(Color.WHITE);
                if (value.getSeveridade() == 2) {
                    sbNomeAcessivel.append("Pend\u00eancia do tipo Aviso: ");
                } else if (value.getSeveridade() == 3) {
                    sbNomeAcessivel.append("Pend\u00eancia do tipo Erro: ");
                }
                if (index == this.getItemSublinhado()) {
                    sbTagInicial.append("<u>");
                    sbTagFinal.insert(0, "</u>");
                }
            }
            Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            if (isSelected) {
                border = BorderFactory.createCompoundBorder(new DashedBorder(new Color(0, 0, 0), 5, 5, 1), border);
            }
            this.setBorder(border);
            String texto = value.getCampo().replaceAll("\\<[^\\>]+\\>", " ");
            texto = UtilitariosString.insereQuebraDeLinha((String)texto, (int)150, (String)"<br>");
            this.setText(sbTagInicial.toString() + texto + sbTagFinal.toString());
            sbNomeAcessivel.append(value.getCampo());
            this.getAccessibleContext().setAccessibleName(sbNomeAcessivel.toString());
            return this;
        }

        public int getItemSublinhado() {
            return this.itemSublinhado;
        }

        public void setItemSublinhado(int itemSublinhado) {
            this.itemSublinhado = itemSublinhado;
        }
    }
}

