/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.psocietarias;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoAlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelListaAb;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.bensmoveis.PainelDadosBensMoveis;
import br.gov.serpro.gcap.gui.psocietarias.PainelDadosPSocietarias;
import br.gov.serpro.gcap.gui.psocietarias.TableModelPSocietarias;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelListaPSocietarias
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    public static final String TITULO_PAINEL = "Participa\u00e7\u00f5es Societ\u00e1rias";

    public PainelListaPSocietarias() {
    }

    public PainelListaPSocietarias(Colecao<? extends ObjetoNegocio> colecao) {
        super(colecao);
    }

    @Override
    public String getTituloPainel() {
        return TITULO_PAINEL;
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        DemonstrativoGCAP demostrativo = ControladorGui.getDemonstrativoAberto();
        TableModelPSocietarias lModel = (TableModelPSocietarias)this.getTabela().getModel();
        AlienacaoParticipacaoSocietaria lItem = new AlienacaoParticipacaoSocietaria();
        lItem.getPaisResidencia().setConteudo(ControladorGui.getDemonstrativoAberto().getIdDemonstrativo().getPaisDeclarante());
        lItem.getTerritorioParaisoFiscal().setConteudo(ControladorGui.getDemonstrativoAberto().getIdDemonstrativo().getTerritorioParaisoFiscal());
        demostrativo.getParticipacoesSocietarias().add(lItem);
        ControladorGui.acionarPainel(new PainelDadosPSocietarias(lItem));
        lModel.refresh();
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableModelPSocietarias model = (TableModelPSocietarias)this.getTabela().getModel();
            ColecaoAlienacaoParticipacaoSocietaria colAlienacoes = (ColecaoAlienacaoParticipacaoSocietaria)model.getObjetoNegocio();
            AlienacaoParticipacaoSocietaria alienacao = (AlienacaoParticipacaoSocietaria)((Object)colAlienacoes.itens().get(indiceVetor));
            ControladorGui.acionarPainel(new PainelDadosPSocietarias(alienacao));
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    @Override
    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(1000);
    }

    @Override
    protected TableListaModel getTableModel() {
        return new TableModelPSocietarias(GCAPFacade.getInstancia().getDeclaracao().getParticipacoesSocietarias());
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "Rela\u00e7\u00e3o de Participa\u00e7\u00f5es Societ\u00e1rias Alienadas"};
        return tableLista;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return PainelDadosBensMoveis.class.getName();
    }

    @Override
    protected String getButtonHelpID() {
        return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Participa\u00e7\u00e3o Societ\u00e1ria";
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoPSocietarias.png");
    }

    @Override
    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens";
    }

    @Override
    public String[] getParametrosMensagemExclusao() {
        return new String[]{"participa\u00e7\u00f5es societ\u00e1rias"};
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return false;
    }

    @Override
    public String getSubtitulo() {
        return null;
    }
}

