/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.psocietarias.aquisicao;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelComlListaEditavelIf;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.psocietarias.aquisicao.PainelAbaListaApuracaoCustoAquisicao;
import br.gov.serpro.gcap.gui.psocietarias.aquisicao.PainelListaOperacoesParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditNumero;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class PainelApuracaoCustoAquisicaoDetalhe
extends PainelDemonstrativoAb
implements PainelComlListaEditavelIf {
    private static final long serialVersionUID = 1L;
    public static String TITULO = "Participa\u00e7\u00f5es Societ\u00e1rias - Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o";
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Adquirentes";
    private ParcelaAquisicaoParticipacaoSocietaria parcela = null;
    private ParcelaAquisicaoParticipacaoSocietaria parcelaAnterior = null;
    private AlienacaoParticipacaoSocietaria alienacaoParticipacaoSocietaria;
    private PainelDemonstrativoIf painelPai;
    private PainelAbaListaApuracaoCustoAquisicao painelLista;
    private boolean informouSobrePlanilhaCustoMedio = false;
    private JButton btnCancelar;
    private JButton btnPlanilha;
    private JButton btnVoltar;
    private JEditCodigo cmbEspecieParticipacaoSocietaria;
    private JEditValor edtCustoMedioPonderado;
    private JEditValor edtCustoTotalAquisicao;
    private JEditNumero edtQtdQuotasAcoesAlienadas;
    private JPanel jPanel1;
    private JLabel lblCustoMedioPonderado;
    private JLabel lblCustoTotalAquisicao;
    private JLabel lblEspecieParticipacaoSocietaria;
    private JLabel lblQtdQuotasAcoesAlienadas;
    private JLabel lblTitulo;

    public PainelApuracaoCustoAquisicaoDetalhe(PainelDemonstrativoIf painelPai, PainelAbaListaApuracaoCustoAquisicao painelLista, AlienacaoParticipacaoSocietaria alienacaoParticipacaoSocietaria, ParcelaAquisicaoParticipacaoSocietaria parcela, boolean itemNovo) {
        this.painelPai = painelPai;
        this.alienacaoParticipacaoSocietaria = alienacaoParticipacaoSocietaria;
        this.parcela = parcela;
        this.parcelaAnterior = parcela.obterCopia();
        this.painelLista = painelLista;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.initComponents();
        this.associarInformacao();
        this.configurarAcessibilidade();
        this.criarListenerCustoMedio();
        this.configurarExibicaoPlanilha();
    }

    private void configurarExibicaoPlanilha() {
        if (this.alienacaoParticipacaoSocietaria.isAlienacaoEmAnoAnterior()) {
            this.btnPlanilha.setVisible(false);
        } else {
            this.btnPlanilha.setVisible(true);
        }
    }

    private void criarListenerCustoMedio() {
        this.edtCustoMedioPonderado.getComponenteFoco().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!PainelApuracaoCustoAquisicaoDetalhe.this.informouSobrePlanilhaCustoMedio) {
                    PainelApuracaoCustoAquisicaoDetalhe.this.informouSobrePlanilhaCustoMedio = true;
                    if (!PainelApuracaoCustoAquisicaoDetalhe.this.alienacaoParticipacaoSocietaria.isAlienacaoEmAnoAnterior() && GuiUtil.mostrarConfirma("ConfirmaParticipacaoSocietariaPlanilhaCustoMedio")) {
                        PainelApuracaoCustoAquisicaoDetalhe.this.executaPlanilha();
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    protected void associarInformacao() {
        this.cmbEspecieParticipacaoSocietaria.setInformacao((Informacao)this.parcela.getEspecieAquisicao());
        this.edtCustoTotalAquisicao.setInformacao((Informacao)this.parcela.getCustoAquisicao());
        this.edtQtdQuotasAcoesAlienadas.setInformacao((Informacao)this.parcela.getQuantidadeQuotas());
        this.edtCustoMedioPonderado.setInformacao((Informacao)this.parcela.getCustoMedio());
    }

    protected void configurarAcessibilidade() {
        this.cmbEspecieParticipacaoSocietaria.getAccessibleContext().setAccessibleName("Esp\u00e9cie de Participa\u00e7\u00e3o Societ\u00e1ria");
        this.edtQtdQuotasAcoesAlienadas.getAccessibleContext().setAccessibleName("Quantidade de Quotas/A\u00e7\u00f5es Alienadas");
        this.edtCustoMedioPonderado.getAccessibleContext().setAccessibleName("Custo M\u00e9dio Ponderado Unit\u00e1rio em Reais");
        this.edtCustoTotalAquisicao.getAccessibleContext().setAccessibleName("Custo Total de Aquisi\u00e7\u00e3o em Reais");
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.alienacaoParticipacaoSocietaria.getParticipacaoSocietaria().getNome().naoFormatado();
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.cmbEspecieParticipacaoSocietaria;
    }

    @Override
    public String getTituloPainel() {
        return TITULO + " - Detalhe";
    }

    @Override
    public void executaVoltar() {
        List pendencias = FabricaUtilitarios.verificarPendencias((Object)((Object)this.parcela));
        Pendencia erro = null;
        for (Pendencia pendencia : pendencias) {
            if (pendencia.getSeveridade() != 3) continue;
            erro = pendencia;
            break;
        }
        if (erro != null) {
            GuiUtil.mostrarErro(null, erro.getMsg());
        } else {
            this.alienacaoParticipacaoSocietaria.getColecaoParcelaAquisicaoParticipacaoSocietaria().excluirRegistrosEmBranco();
            ControladorGui.acionarPainel(this.painelPai);
            this.painelLista.atualizarTableModel();
        }
    }

    @Override
    public void executaCancelar() {
        this.parcela.restaurar(this.parcelaAnterior);
        this.alienacaoParticipacaoSocietaria.getColecaoParcelaAquisicaoParticipacaoSocietaria().excluirRegistrosEmBranco();
        ControladorGui.acionarPainel(this.painelPai);
    }

    private void executaPlanilha() {
        ControladorGui.acionarPainel(new PainelListaOperacoesParticipacaoSocietaria(this, this.parcela));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblQtdQuotasAcoesAlienadas = new JLabel();
        this.edtQtdQuotasAcoesAlienadas = new JEditNumero();
        this.lblEspecieParticipacaoSocietaria = new JLabel();
        this.lblCustoTotalAquisicao = new JLabel();
        this.edtCustoTotalAquisicao = new JEditValor();
        this.lblCustoMedioPonderado = new JLabel();
        this.edtCustoMedioPonderado = new JEditValor();
        this.cmbEspecieParticipacaoSocietaria = new JEditCodigo();
        this.lblTitulo = new JLabel();
        this.btnPlanilha = new JButton();
        this.btnVoltar = new JButton();
        this.btnCancelar = new JButton();
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblQtdQuotasAcoesAlienadas.setText("<html>Quantidade de Quotas/A\u00e7\u00f5es Alienadas <font color=red>*</font></html>");
        this.lblEspecieParticipacaoSocietaria.setText("<html>Esp\u00e9cie de Participa\u00e7\u00e3o Societ\u00e1ria <font color=red>*</font></html>");
        this.lblCustoTotalAquisicao.setText("<html>Custo Total de Aquisi\u00e7\u00e3o em Reais</html>");
        this.lblCustoMedioPonderado.setText("<html>Custo M\u00e9dio Ponderado Unit\u00e1rio em Reais <font color=red>*</font></html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblCustoMedioPonderado).addComponent((Component)this.edtCustoMedioPonderado, -2, 188, -2).addComponent(this.lblEspecieParticipacaoSocietaria, -2, -1, -2).addComponent((Component)this.cmbEspecieParticipacaoSocietaria, -1, -1, Short.MAX_VALUE)).addGap(108, 108, 108).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblQtdQuotasAcoesAlienadas, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.edtQtdQuotasAcoesAlienadas, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtCustoTotalAquisicao, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblCustoTotalAquisicao, GroupLayout.Alignment.LEADING, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblEspecieParticipacaoSocietaria, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmbEspecieParticipacaoSocietaria, -2, -1, -2).addGap(3, 3, 3)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblQtdQuotasAcoesAlienadas, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtQtdQuotasAcoesAlienadas, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCustoTotalAquisicao, -2, 14, -2).addComponent(this.lblCustoMedioPonderado, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtCustoTotalAquisicao, -2, -1, -2).addComponent((Component)this.edtCustoMedioPonderado, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblTitulo.setFont(new Font("DejaVu Sans", 1, 13));
        this.lblTitulo.setForeground(new Color(107, 151, 9));
        this.lblTitulo.setText("Dados da Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o");
        this.btnPlanilha.setMnemonic('N');
        this.btnPlanilha.setText("Planilha");
        this.btnPlanilha.setMaximumSize(new Dimension(100, 25));
        this.btnPlanilha.setMinimumSize(new Dimension(100, 25));
        this.btnPlanilha.setPreferredSize(new Dimension(100, 25));
        this.btnPlanilha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelApuracaoCustoAquisicaoDetalhe.this.btnPlanilhaActionPerformed(evt);
            }
        });
        this.btnVoltar.setMnemonic('V');
        this.btnVoltar.setText("Voltar");
        this.btnVoltar.setMaximumSize(new Dimension(100, 25));
        this.btnVoltar.setMinimumSize(new Dimension(100, 25));
        this.btnVoltar.setPreferredSize(new Dimension(100, 25));
        this.btnVoltar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelApuracaoCustoAquisicaoDetalhe.this.btnVoltarActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setMaximumSize(new Dimension(100, 25));
        this.btnCancelar.setMinimumSize(new Dimension(100, 25));
        this.btnCancelar.setPreferredSize(new Dimension(100, 25));
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelApuracaoCustoAquisicaoDetalhe.this.btnCancelarActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblTitulo).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnPlanilha, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnVoltar, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelar, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitulo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.btnVoltar, -1, -1, Short.MAX_VALUE).addComponent(this.btnPlanilha, -1, -1, Short.MAX_VALUE).addComponent(this.btnCancelar, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void btnPlanilhaActionPerformed(ActionEvent evt) {
        this.executaPlanilha();
    }

    private void btnVoltarActionPerformed(ActionEvent evt) {
        this.executaVoltar();
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.executaCancelar();
    }

    @Override
    public void acionarEdicaoLinha(int linha) {
        this.executaPlanilha();
    }
}

