/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.util;

import br.gov.serpro.gcap.exception.NegocioException;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.componente.JCustomDialog;
import br.gov.serpro.gcap.gui.dialogs.PainelAjudaAcessibilidade;
import br.gov.serpro.gcap.gui.util.DisabledGlassPane;
import br.gov.serpro.gcap.gui.util.NegativeDefaultButtonJOptionPane;
import br.gov.serpro.gcap.importacao.ResultadoConfirmaOpcoes;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.LeitorArquivoAjuda;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.gui.xbeans.JEditOpcao;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;

public class GuiUtil {
    private static HashMap<String, ImageIcon> cacheImagens;
    private static Font fonteSistema;

    public static void inibirEnterNavegacaoFocoBotoes(JButton ... buttons) {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        for (JButton btn : buttons) {
            btn.setFocusTraversalKeys(0, set);
        }
    }

    public static void inibirEnterNavegacaoFocoBotoes(JPanel painel) {
        Component[] componentes;
        if (painel instanceof JPanel && (componentes = painel.getComponents()) != null) {
            for (int i = 0; i < componentes.length; ++i) {
                if (componentes[i] instanceof JButton) {
                    GuiUtil.inibirEnterNavegacaoFocoBotoes((JButton)componentes[i]);
                    continue;
                }
                if (!(componentes[i] instanceof JPanel)) continue;
                GuiUtil.inibirEnterNavegacaoFocoBotoes((JPanel)componentes[i]);
            }
        }
    }

    public static Component getParent() {
        PlataformaPPGD lPlataformaPPGD = PlataformaPPGD.getPlataforma();
        JFrame lPai = null;
        if (lPlataformaPPGD != null) {
            try {
                lPai = lPlataformaPPGD.getJanelaPrincipal();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return lPai;
    }

    public static Component getParent(JPanel painel) {
        return SwingUtilities.getRoot(painel);
    }

    private static String getTituloTelaConfirmacao() {
        return MensagemUtil.getMensagem("TituloConfirmacao");
    }

    private static String getTituloTelaErro() {
        return MensagemUtil.getMensagem("TituloMensagemErro");
    }

    private static String getTituloTelaInfo() {
        return MensagemUtil.getMensagem("TituloMensagemInfo");
    }

    private static String getTituloTelaAviso() {
        return MensagemUtil.getMensagem("TituloMensagemAviso");
    }

    public static void mostrarErro(Component pPai, String pMensagem) {
        JOptionPane.showMessageDialog(pPai, pMensagem, GuiUtil.getTituloTelaErro(), 0);
    }

    public static void mostrarErro(String pChaveMsg) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static void mostrarErro(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgs));
    }

    public static void mostrarErro(Exception pExcecao) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), pExcecao.getMessage());
    }

    public static void mostrarErroFoco(NegocioException pExcecao) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), pExcecao.getMessage());
        JComponent jComponent = (JComponent)MapeamentoInformacaoEditCampo.getEditAssociado((Informacao)pExcecao.getInformacao());
        jComponent.requestFocusInWindow();
    }

    public static void mostrarAviso(Component pPai, String pMensagem) {
        JOptionPane.showMessageDialog(pPai, pMensagem, GuiUtil.getTituloTelaAviso(), 2);
    }

    public static void mostrarAviso(String pChaveMsg) {
        GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static void mostrarAviso(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgs));
    }

    public static void mostrarInfo(Component pPai, String pMensagem) {
        JOptionPane.showMessageDialog(pPai, pMensagem, GuiUtil.getTituloTelaInfo(), 1);
    }

    public static void mostrarInfo(String pChaveMsg) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static void mostrarInfo(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgs));
    }

    public static void mostrarInfoAjuda(String pChaveMsg, String helpID) {
        GuiUtil.mostrarInfoAjuda(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg), helpID);
    }

    public static void mostrarInfoAjuda(Component pPai, String pMensagem, String helpID) {
        JButton btnAjuda = new JButton("Ajuda");
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)btnAjuda, helpID);
        Object[] opcoes = new Object[]{"OK", btnAjuda};
        int resposta = JOptionPane.showOptionDialog(ControladorGui.getJanelaPrincipal(), pMensagem, "Confirma\u00e7\u00e3o", 2, 1, null, opcoes, opcoes[0]);
    }

    public static void mostrarInfoSemQuebraDeLinha(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), MensagemUtil.getMensagem(pChaveMsg, pArgs));
    }

    public static void mostrarInfoSemQuebraDeLinha(String msg) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), msg);
    }

    public static boolean mostrarConfirmaNaoPadrao(Component pPai, String pMensagem) {
        return NegativeDefaultButtonJOptionPane.showConfirmDialog(pPai, pMensagem, GuiUtil.getTituloTelaConfirmacao(), 0) == 0;
    }

    public static boolean mostrarConfirmaNaoPadrao(String pChaveMsg, String[] pArgsMsg) {
        return GuiUtil.mostrarConfirmaNaoPadrao(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgsMsg));
    }

    public static boolean mostrarConfirma(Component pPai, String pMensagem) {
        return JOptionPane.showConfirmDialog(pPai, pMensagem, GuiUtil.getTituloTelaConfirmacao(), 0, 3) == 0;
    }

    public static boolean mostrarConfirma(String pChaveMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static boolean mostrarConfirma(String pChaveMsg, String[] pArgsMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgsMsg));
    }

    public static boolean mostrarConfirmaSemQuebraDeLinha(String pChaveMsg, String[] pArgsMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagem(pChaveMsg, pArgsMsg));
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura, false);
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura, boolean pInibeSairNaoProgramado) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura, pInibeSairNaoProgramado, 2, true, false);
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura, boolean pInibeSairNaoProgramado, int defaultCloseOperation, boolean exibeBarraTitulo, boolean disabledGlass) {
        JComponent lComponent;
        GuiUtil.adicionarEnterComoTeclaDeNavegacao((JPanel)pComp);
        JCustomDialog lDialogo = null;
        if (pPai == null) {
            lDialogo = new JCustomDialog((Frame)null, pTitulo, pModal, pInibeSairNaoProgramado);
        } else if (pPai instanceof Dialog) {
            lDialogo = new JCustomDialog((Dialog)pPai, pTitulo, pModal, pInibeSairNaoProgramado);
            lDialogo.setLocationRelativeTo((Dialog)pPai);
        } else {
            lDialogo = pPai instanceof Frame ? new JCustomDialog((Frame)pPai, pTitulo, pModal, pInibeSairNaoProgramado) : new JCustomDialog((Frame)null, pTitulo, pModal, pInibeSairNaoProgramado);
        }
        lDialogo.getContentPane().add(pComp);
        lDialogo.setUndecorated(!exibeBarraTitulo);
        lDialogo.setDefaultCloseOperation(defaultCloseOperation);
        if (pComp instanceof WindowListener) {
            lDialogo.addWindowListener((WindowListener)((Object)pComp));
        }
        if (pComp instanceof PainelDemonstrativoIf) {
            ((PainelDemonstrativoIf)((Object)pComp)).initListener();
        }
        if (pLargura != null && pAltura != null) {
            lDialogo.setSize(pLargura, pAltura);
        } else {
            lDialogo.pack();
        }
        lDialogo.setLocationRelativeTo(null);
        lDialogo.setResizable(pRedimensionavel);
        if (pComp instanceof PainelDemonstrativoAb && (lComponent = ((PainelDemonstrativoAb)pComp).getDefaultFocus()) != null && GcapUtil.getEstadoSistema() != 1) {
            lComponent.requestFocusInWindow();
        }
        if (disabledGlass) {
            Component glassPaneAnterior = PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
            DisabledGlassPane glassPane = new DisabledGlassPane();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setGlassPane(glassPane);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
            glassPane.activate("");
            lDialogo.setVisible(true);
            glassPane.deactivate();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setGlassPane(glassPaneAnterior);
        } else {
            lDialogo.setVisible(true);
        }
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().repaint();
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().validate();
    }

    public static void exibePainelDemonstrativo(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static void exibeDialog(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel) {
        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, null, null);
    }

    public static void exibePainelDemonstrativo(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel) {
        GuiUtil.exibePainelDemonstrativo(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, null, null);
    }

    public static void exibeDialog(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, int pLargura, int pAltura) {
        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static void exibePainelDemonstrativo(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, int pLargura, int pAltura) {
        GuiUtil.exibePainelDemonstrativo(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static ImageIcon getImage(String pPath) {
        ImageIcon lImg = cacheImagens.get(pPath);
        if (lImg == null) {
            lImg = new ImageIcon(GuiUtil.class.getResource(pPath));
            cacheImagens.put(pPath, lImg);
        }
        return lImg;
    }

    public static void abreURL(String pURL) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.startsWith("mac os")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, pURL);
            } else if (os.startsWith("windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pURL);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    String lMensagem = MensagemUtil.getMensagem("NavegadorNaoEncontrado");
                    throw new Exception(lMensagem);
                }
                Runtime.getRuntime().exec(new String[]{browser, pURL});
            }
        }
        catch (Exception e) {
            GuiUtil.mostrarErro("ErroNavegadorInternet", new String[]{e.getLocalizedMessage()});
        }
    }

    public static void fecharDialog(JPanel pPainel) {
        Component lFramePai = SwingUtilities.getRoot(pPainel);
        if (lFramePai != null) {
            lFramePai.setVisible(false);
        }
    }

    public static void adicionarEnterComoTeclaDeNavegacao(JPanel pPainel) {
        Set<AWTKeyStroke> forwardKeys = pPainel.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        pPainel.setFocusTraversalKeys(0, newForwardKeys);
    }

    public static void setaFonteTodosLabelContainer(Container c) {
        GuiUtil.setaFonteTodosLabelContainer(c, fonteSistema);
    }

    public static void setaFonteTodosLabelContainer(Container c, Font pFonte) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Font fonte = pFonte;
            if (components[i] instanceof JComponent && ((JComponent)components[i]).getBorder() instanceof TitledBorder) {
                TitledBorder t = (TitledBorder)((JComponent)components[i]).getBorder();
                t.setTitleFont(fonte);
            }
            if (components[i] instanceof JEditLogico || components[i] instanceof JLabel || components[i] instanceof JEditOpcao) {
                components[i].setFont(fonte);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            GuiUtil.setaFonteTodosLabelContainer((Container)components[i], fonte);
        }
    }

    protected static Font obterFonteSistema() {
        boolean temArial = false;
        boolean temSansSerif = false;
        boolean temDialog = false;
        Font fontDefault = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontnames = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < fontnames.length; ++i) {
            if (fontnames[i].equals("SansSerif")) {
                temSansSerif = true;
                continue;
            }
            if (fontnames[i].equals("Arial")) {
                temArial = true;
                continue;
            }
            if (!fontnames[i].equals("Dialog")) continue;
            temDialog = true;
        }
        boolean isLinux = false;
        if (System.getProperty("os.name").startsWith("Linux")) {
            isLinux = true;
            fontDefault = temSansSerif ? new Font("SansSerif", 0, 11) : (temArial ? new Font("Arial", 0, 11) : (temDialog ? new Font("Dialog", 0, 11) : new Font("Default", 0, 11)));
        } else {
            fontDefault = temSansSerif ? new Font("SansSerif", 0, 11) : (temArial ? new Font("Arial", 0, 11) : (temDialog ? new Font("Dialog", 0, 11) : new Font("Default", 0, 11)));
        }
        if (!isLinux) {
            UIManager.put("Button.font", fontDefault);
        }
        UIManager.put("RadioButton.font", fontDefault);
        UIManager.put("CheckBox.font", fontDefault);
        UIManager.put("FileChooser.font", fontDefault);
        UIManager.put("Label.font", fontDefault);
        UIManager.put("List.font", fontDefault);
        UIManager.put("RadioButtonMenuItem.font", fontDefault);
        UIManager.put("Frame.font", fontDefault);
        UIManager.put("Panel.font", fontDefault);
        UIManager.put("ScrollPane.font", fontDefault);
        UIManager.put("Viewport.font", fontDefault);
        UIManager.put("TabbedPane.font", fontDefault);
        UIManager.put("Table.font", fontDefault);
        UIManager.put("TextField.font", fontDefault);
        UIManager.put("FormattedTextField.font", fontDefault);
        UIManager.put("TextArea.font", fontDefault);
        UIManager.put("TextPane.font", fontDefault);
        UIManager.put("EditorPane.font", fontDefault);
        UIManager.put("TitledBorder.font", fontDefault);
        UIManager.put("ToolBar.font", fontDefault);
        UIManager.put("Tree.font", fontDefault);
        UIManager.put("EditValorTotal.font", fontDefault.deriveFont(1));
        return fontDefault;
    }

    public static void ajustaLabel(JLabel pCampo, int pMaximo) {
        String text = pCampo.getText();
        if (text.length() > pMaximo) {
            pCampo.setToolTipText(text);
            pCampo.setText(text.substring(0, pMaximo) + "...");
        }
    }

    public static void startWaitCursor() {
        Component lGlassPane = PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
        lGlassPane.setVisible(true);
        lGlassPane.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void stopWaitCursor() {
        Component lGlassPane = PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
        lGlassPane.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void configurarMnemonicoBotoesFileChooser(Component componente) {
        block6: {
            block5: {
                if (!(componente instanceof JFileChooser)) break block5;
                JFileChooser chooser = (JFileChooser)componente;
                for (int i = 0; i < chooser.getComponents().length; ++i) {
                    this.configurarMnemonicoBotoesFileChooser(chooser.getComponents()[i]);
                }
                break block6;
            }
            if (!(componente instanceof JPanel)) break block6;
            JPanel panel = (JPanel)componente;
            for (int i = 0; i < panel.getComponents().length; ++i) {
                JButton btn;
                if (panel.getComponents()[i] instanceof JPanel) {
                    this.configurarMnemonicoBotoesFileChooser(panel.getComponents()[i]);
                    continue;
                }
                if (!(panel.getComponents()[i] instanceof JButton) || "".equals((btn = (JButton)panel.getComponents()[i]).getText()) || btn.getText() == null) continue;
                if ("SALVAR".equals(btn.getText().toUpperCase())) {
                    btn.setText("Ok");
                }
                if ("OK".equals(btn.getText().toUpperCase())) {
                    btn.setMnemonic('O');
                    continue;
                }
                if (!"CANCELAR".equals(btn.getText().toUpperCase())) continue;
                btn.setMnemonic('C');
            }
        }
    }

    public static ResultadoConfirmaOpcoes mostrarConfirmaOpcoes(String pMensagem) {
        Object[] options = new Object[]{ResultadoConfirmaOpcoes.SIM, ResultadoConfirmaOpcoes.NAO, ResultadoConfirmaOpcoes.SIM_PARA_TODOS, ResultadoConfirmaOpcoes.NAO_PARA_TODOS};
        int index = JOptionPane.showOptionDialog(GuiUtil.getParent(), pMensagem, GuiUtil.getTituloTelaConfirmacao(), -1, 3, null, options, options[2]);
        if (index == -1) {
            return ResultadoConfirmaOpcoes.CANCELADO;
        }
        return (ResultadoConfirmaOpcoes)((Object)options[index]);
    }

    public static void focusJEditLogico(JEditLogico jEditLogico) {
        JComponent radioSelecionado = null;
        for (JRadioButton radio : jEditLogico.getListaRadiosOrdenada()) {
            if (radio.isSelected()) {
                radioSelecionado = radio;
                continue;
            }
            if (radioSelecionado != null) continue;
            radioSelecionado = radio;
        }
        radioSelecionado.requestFocus();
    }

    public static void adicionarListenerF11(Container cont, final String txtAjudaAcessibilidade) {
        Component[] components = cont.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JTextComponent || components[i] instanceof AbstractButton || components[i] instanceof JToggleButton || components[i] instanceof JTable || components[i] instanceof JComboBox || components[i] instanceof JList || components[i] instanceof JTree) {
                components[i].addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 122) {
                            String texto = LeitorArquivoAjuda.getInstance().getTexto(txtAjudaAcessibilidade);
                            if (texto.equals("null")) {
                                texto = "N\u00e3o existem informa\u00e7\u00f5es sobre acessibilidade nesta ficha.";
                            }
                            GuiUtil.exibeDialog(new PainelAjudaAcessibilidade(texto), true, "Ajuda da ficha " + txtAjudaAcessibilidade, true);
                        }
                    }
                });
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            GuiUtil.adicionarListenerF11((Container)components[i], txtAjudaAcessibilidade);
        }
    }

    public static void adicionarListenerF11(JLabel label, final String txtAjudaAcessibilidade) {
        label.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 122) {
                    String texto = LeitorArquivoAjuda.getInstance().getTexto(txtAjudaAcessibilidade);
                    if (texto.equals("null")) {
                        texto = "N\u00e3o existem informa\u00e7\u00f5es sobre acessibilidade nesta ficha.";
                    }
                    GuiUtil.exibeDialog(new PainelAjudaAcessibilidade(texto), true, "Ajuda da ficha " + txtAjudaAcessibilidade, true);
                }
            }
        });
    }

    static {
        fonteSistema = GuiUtil.obterFonteSistema();
        cacheImagens = new HashMap();
    }
}

