/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.util;

import br.gov.serpro.gcap.gui.util.ProgressDialog;
import br.gov.serpro.gcap.gui.util.ProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressUtil {
    public static ProgressMonitor createModalProgressMonitor(Component owner, int total, boolean indeterminate, int milliSecondsToWait, String aTitulo) {
        ProgressMonitor monitor = new ProgressMonitor(total, indeterminate, milliSecondsToWait);
        Window window = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
        monitor.addChangeListener(new MonitorListener(window, monitor, true, aTitulo));
        return monitor;
    }

    public static ProgressMonitor createProgressMonitor(Component owner, int total, boolean indeterminate, int milliSecondsToWait, String aTitulo) {
        ProgressMonitor monitor = new ProgressMonitor(total, indeterminate, milliSecondsToWait);
        Window window = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
        monitor.addChangeListener(new MonitorListener(window, monitor, false, aTitulo));
        return monitor;
    }

    static class MonitorListener
    implements ChangeListener,
    ActionListener {
        ProgressMonitor monitor;
        Window owner;
        Timer timer;
        boolean modal;
        String titulo;

        public MonitorListener(Window owner, ProgressMonitor monitor, boolean aModal, String aTitulo) {
            this.owner = owner;
            this.monitor = monitor;
            this.modal = aModal;
            this.titulo = aTitulo;
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ProgressMonitor monitor = (ProgressMonitor)ce.getSource();
            if (monitor.getCurrent() != monitor.getTotal()) {
                if (this.timer == null) {
                    this.timer = new Timer(monitor.getMilliSecondsToWait(), this);
                    this.timer.setRepeats(false);
                    this.timer.start();
                }
            } else {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                monitor.removeChangeListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.monitor.removeChangeListener(this);
            ProgressDialog dlg = this.owner instanceof Frame ? new ProgressDialog((Frame)this.owner, this.monitor, this.modal, this.titulo) : new ProgressDialog((Dialog)this.owner, this.monitor);
            dlg.setSize(200, 90);
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
        }
    }
}

