/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.importacao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.especie.MoedaAlienada;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.exception.PGDException;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.importacao.ProcessoImportacaoGCAP;
import br.gov.serpro.gcap.importacao.ResultadoConfirmaOpcoes;
import br.gov.serpro.gcap.importacao.ResultadoImportacaoDTO;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;

public class ImportacaoAnoAterior {
    private static final String BENS_IMOVEIS = "Bens Im\u00f3veis";
    private static final String BENS_MOVEIS = "Direitos/Bens M\u00f3veis";
    private static final String PART_SOCIETARIA = "Participa\u00e7\u00f5es Societ\u00e1rias";
    private static final String MOEDAS_ALIENADAS = "Moedas Alienadas";
    private static final String BEM_IMOVEL = "bem im\u00f3vel";
    private static final String BEM_MOVEL = "direito/bem m\u00f3vel";
    private String[] saldoMoeda = new String[2];

    private List<DemonstrativoGCAP> recuperaDemonstrativosSelecionadosDoDisco(File[] selectedFiles) throws Exception {
        ArrayList<DemonstrativoGCAP> demonstrativosRecuperados = new ArrayList<DemonstrativoGCAP>();
        for (int i = 0; i < selectedFiles.length; ++i) {
            DemonstrativoGCAP demonstrativo = new DemonstrativoGCAP(new IdDemonstrativoGCAP());
            try {
                ProcessoImportacaoGCAP processo = new ProcessoImportacaoGCAP();
                demonstrativo = processo.importar(selectedFiles[i]);
                this.tratarImportacaoAnterior(demonstrativo);
            }
            catch (Exception e) {
                if (e instanceof AplicacaoException) {
                    throw (AplicacaoException)e;
                }
                throw new AplicacaoException("demonstrativo_gcap_corrompido");
            }
            demonstrativosRecuperados.add(demonstrativo);
        }
        return demonstrativosRecuperados;
    }

    private void tratarImportacaoAnterior(DemonstrativoGCAP demonstrativo) {
        ValorPositivo totalCustoCorretagem;
        Object totalValorRecebido;
        ArrayList<ParcelaAlienacao> parcelas;
        for (Alienacao alienacao : demonstrativo.getBensImoveis().itens()) {
            if (!((AlienacaoBemImovel)alienacao).isAlienacaoBrasil()) continue;
            parcelas = new ArrayList<ParcelaAlienacao>();
            for (ParcelaAlienacaoBem parcelaAlienacaoBem : ((AlienacaoBem)alienacao).getColecaoParcelaAlienacao().itens()) {
                parcelas.add(parcelaAlienacaoBem);
            }
            totalValorRecebido = new ValorPositivo(null, "valorRecebido", 11, 9);
            totalCustoCorretagem = new ValorPositivo(null, "custoCorretagem", 11, 9);
            ValorPositivo totalValorAplicacaoOutroImovel = new ValorPositivo(null, "valorAplicacaoOutroImovel", 11, 9);
            for (int count = 0; count < parcelas.size(); ++count) {
                ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)parcelas.get(count));
                ((ValorBigDecimal)((Object)totalValorRecebido)).append('+', parcela.getValorRecebido());
                totalCustoCorretagem.append('+', parcela.getCustoCorretagem());
                totalValorAplicacaoOutroImovel.append('+', parcela.getValorInformadoReducaoAplicacaoOutroImovel());
            }
            alienacao.getValorRecebidoAnosAnteriores().append('+', (ValorBigDecimal)((Object)totalValorRecebido));
            alienacao.getCorretagemAnosAnteriores().append('+', totalCustoCorretagem);
            alienacao.getValorAplicadoOutroImovelAnosAnteriores().append('+', totalValorAplicacaoOutroImovel);
            ((AlienacaoBem)alienacao).getColecaoParcelaAlienacao().itens().clear();
        }
        for (Alienacao alienacao : demonstrativo.getBensMoveis().itens()) {
            if (!((AlienacaoBemMovel)alienacao).isAlienacaoBrasil()) continue;
            parcelas = new ArrayList();
            for (ParcelaAlienacaoBem parcelaAlienacaoBem : ((AlienacaoBem)alienacao).getColecaoParcelaAlienacao().itens()) {
                parcelas.add(parcelaAlienacaoBem);
            }
            totalValorRecebido = new ValorPositivo(null, "valorRecebido", 11, 9);
            totalCustoCorretagem = new ValorPositivo(null, "custoCorretagem", 11, 9);
            for (int count = 0; count < parcelas.size(); ++count) {
                ParcelaAlienacaoBem parcela = (ParcelaAlienacaoBem)((Object)parcelas.get(count));
                ((ValorBigDecimal)((Object)totalValorRecebido)).append('+', parcela.getValorRecebido());
                totalCustoCorretagem.append('+', parcela.getCustoCorretagem());
            }
            alienacao.getValorRecebidoAnosAnteriores().append('+', (ValorBigDecimal)((Object)totalValorRecebido));
            alienacao.getCorretagemAnosAnteriores().append('+', totalCustoCorretagem);
            ((AlienacaoBem)alienacao).getColecaoParcelaAlienacao().itens().clear();
        }
        for (Alienacao alienacao : demonstrativo.getParticipacoesSocietarias().itens()) {
            if (!alienacao.isAlienacaoBrasil()) continue;
            parcelas = new ArrayList();
            for (ParcelaAlienacao parcelaAlienacao : ((AlienacaoParticipacaoSocietaria)alienacao).getColecaoParcelaAlienacao().itens()) {
                parcelas.add(parcelaAlienacao);
            }
            totalValorRecebido = new ValorPositivo(null, "valorRecebido", 11, 9);
            totalCustoCorretagem = new ValorPositivo(null, "custoCorretagem", 11, 9);
            for (int count = 0; count < parcelas.size(); ++count) {
                ParcelaAlienacao parcela = (ParcelaAlienacao)((Object)parcelas.get(count));
                ((ValorBigDecimal)((Object)totalValorRecebido)).append('+', parcela.getValorRecebido());
                totalCustoCorretagem.append('+', parcela.getCustoCorretagem());
            }
            alienacao.getValorRecebidoAnosAnteriores().append('+', (ValorBigDecimal)((Object)totalValorRecebido));
            alienacao.getCorretagemAnosAnteriores().append('+', totalCustoCorretagem);
            ((AlienacaoParticipacaoSocietaria)alienacao).getColecaoParcelaAlienacao().itens().clear();
        }
    }

    public ResultadoImportacaoDTO importaDemonstrativoExercicioAnterior(File[] selectedFiles) throws Exception {
        try {
            ResultadoImportacaoDTO resultado = new ResultadoImportacaoDTO();
            List<DemonstrativoGCAP> demonstrativosImportados = this.recuperaDemonstrativosSelecionadosDoDisco(selectedFiles);
            ArrayList<DemonstrativoGCAP> temp = new ArrayList<DemonstrativoGCAP>(demonstrativosImportados);
            for (DemonstrativoGCAP demonstrativoImportado : temp) {
                String cpfDemonstrativoImportado;
                DemonstrativoGCAP demonstrativoAberto = ControladorGui.getDemonstrativoAberto();
                String cpfDemonstrativoAberto = demonstrativoAberto.getIdDemonstrativo().getCpf().formatado();
                boolean isDemonstrativoAberto = cpfDemonstrativoAberto.equals(cpfDemonstrativoImportado = demonstrativoImportado.getIdDemonstrativo().getCpf().formatado());
                if (isDemonstrativoAberto) {
                    Object imovelParaImportar2;
                    List bensImoveisParaImportar = demonstrativoImportado.getBensImoveis().itens();
                    for (Object imovelParaImportar2 : bensImoveisParaImportar) {
                        boolean recebeuUltimaParcela = "1".equals(((Alienacao)((Object)imovelParaImportar2)).getTemUltimaParcela().formatado());
                        if (!((Alienacao)((Object)imovelParaImportar2)).isAlienacaoAPrazo() || recebeuUltimaParcela) continue;
                        boolean podeImportar = true;
                        if (((Alienacao)((Object)imovelParaImportar2)).isDesapropriacao()) {
                            podeImportar = false;
                            GuiUtil.mostrarAviso(null, MensagemUtil.getMensagem("desapropriacaoNaoPermitido", new String[]{BEM_IMOVEL, ((AlienacaoBemImovel)((Object)imovelParaImportar2)).getBemImovel().getEspecificacao().formatado()}));
                        } else if (((AlienacaoBemImovel)((Object)imovelParaImportar2)).isNaturezaComMP252SemPermissao()) {
                            GuiUtil.mostrarAviso(null, MensagemUtil.getMensagem("naturezaComMP252SemPermissao", new String[]{BEM_IMOVEL, ((AlienacaoBemImovel)((Object)imovelParaImportar2)).getBemImovel().getEspecificacao().formatado(), ((Alienacao)((Object)imovelParaImportar2)).getNatureza().getConteudoAtual(1)}));
                        }
                        if (podeImportar && (!this.existeBemDescricao((Alienacao)((Object)imovelParaImportar2)) || this.deveSobrescreverItem(BENS_IMOVEIS, ((AlienacaoBemImovel)((Object)imovelParaImportar2)).getBemImovel().getEspecificacao().formatado(), demonstrativoImportado, resultado))) {
                            this.inserirBemImovel((AlienacaoBemImovel)((Object)imovelParaImportar2), demonstrativoImportado.getIdDemonstrativo().getPaisDeclarante(), true);
                            resultado.adicionarImportado(BENS_IMOVEIS, ((AlienacaoBemImovel)((Object)imovelParaImportar2)).getBemImovel().getEspecificacao().formatado());
                            continue;
                        }
                        resultado.adicionarNaoImportado(BENS_IMOVEIS, ((AlienacaoBemImovel)((Object)imovelParaImportar2)).getBemImovel().getEspecificacao().formatado());
                    }
                    List bensMoveisParaImportar = demonstrativoImportado.getBensMoveis().itens();
                    imovelParaImportar2 = bensMoveisParaImportar.iterator();
                    while (imovelParaImportar2.hasNext()) {
                        AlienacaoBemMovel movel = (AlienacaoBemMovel)((Object)imovelParaImportar2.next());
                        boolean recebeuUltimaParcela = "1".equals(movel.getTemUltimaParcela().formatado());
                        if (!movel.isAlienacaoAPrazo() || recebeuUltimaParcela) continue;
                        boolean podeImportar = true;
                        if (movel.isDesapropriacao()) {
                            podeImportar = false;
                            GuiUtil.mostrarAviso(null, MensagemUtil.getMensagem("desapropriacaoNaoPermitido", new String[]{BEM_MOVEL, movel.getBemMovel().getEspecificacao().formatado()}));
                        }
                        if (podeImportar && (!this.existeBemDescricao(movel) || this.deveSobrescreverItem(BENS_MOVEIS, movel.getBemMovel().getEspecificacao().formatado(), demonstrativoImportado, resultado))) {
                            this.inserirBemMovel(movel, demonstrativoImportado.getIdDemonstrativo().getPaisDeclarante(), true);
                            resultado.adicionarImportado(BENS_MOVEIS, movel.getBemMovel().getEspecificacao().formatado());
                            continue;
                        }
                        resultado.adicionarNaoImportado(BENS_MOVEIS, movel.getBemMovel().getEspecificacao().formatado());
                    }
                    List bensPSocietariaParaImportar = demonstrativoImportado.getParticipacoesSocietarias().itens();
                    for (AlienacaoParticipacaoSocietaria pSocietaria : bensPSocietariaParaImportar) {
                        boolean recebeuUltimaParcela = "1".equals(pSocietaria.getTemUltimaParcela().formatado());
                        if (!pSocietaria.isAlienacaoAPrazo() || recebeuUltimaParcela) continue;
                        boolean psDescricaoJaExiste = this.existeBemDescricao(pSocietaria);
                        if (!psDescricaoJaExiste || this.deveSobrescreverItem(PART_SOCIETARIA, pSocietaria.getParticipacaoSocietaria().getNome().formatado(), demonstrativoImportado, resultado)) {
                            this.inserirParticipacaoSocietaria(pSocietaria, demonstrativoImportado.getIdDemonstrativo().getPaisDeclarante(), true);
                            resultado.adicionarImportado(PART_SOCIETARIA, pSocietaria.getParticipacaoSocietaria().getNome().formatado());
                            continue;
                        }
                        resultado.adicionarNaoImportado(PART_SOCIETARIA, pSocietaria.getParticipacaoSocietaria().getNome().formatado());
                    }
                    if (!demonstrativoAberto.getIdDemonstrativo().isDemonstrativoBrasil()) continue;
                    List moedasAlienadaParaImportar = demonstrativoImportado.getMoedasAlienadas().itens();
                    for (MoedaAlienada moeda : moedasAlienadaParaImportar) {
                        this.obterSaldo(moeda);
                        ValorBigDecimal estoque = new ValorBigDecimal(this.saldoMoeda[0]);
                        if (!estoque.ehMaiorQue(0L, true)) continue;
                        boolean moedaJaExiste = this.existeMoeda(moeda);
                        if (!moedaJaExiste || this.deveSobrescreverItem(MOEDAS_ALIENADAS, moeda.getMoeda().formatado(), demonstrativoImportado, resultado)) {
                            this.inserirMoeda(moeda, true);
                            resultado.adicionarImportado(MOEDAS_ALIENADAS, moeda.getMoeda().formatado());
                            continue;
                        }
                        resultado.adicionarNaoImportado(MOEDAS_ALIENADAS, moeda.getMoeda().formatado());
                    }
                    continue;
                }
                GuiUtil.mostrarErro("erroDemonstrativoImportadoNaoAberto");
                resultado = null;
            }
            return resultado;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof PGDException) {
                throw ex;
            }
            throw new AplicacaoException("ErroRestaurarCopiaAnoAnterior", ex);
        }
    }

    public void obterSaldo(MoedaAlienada moeda) {
        this.saldoMoeda[0] = moeda.getEstoqueInicial().formatado();
        this.saldoMoeda[1] = moeda.getSaldoInicial().formatado();
        Data dataUltimaOperacao = new Data();
        dataUltimaOperacao.setConteudo("0101" + AplicacaoPropertiesUtil.getExercicioAnterior());
        for (OperacaoEspecie operacao : moeda.getOperacoesEspecie().itens()) {
            if (operacao.getData().maisNova(dataUltimaOperacao)) {
                dataUltimaOperacao.setConteudo(operacao.getData());
                this.saldoMoeda[0] = operacao.getEstoque().formatado();
                this.saldoMoeda[1] = operacao.getSaldo().formatado();
                continue;
            }
            if (!operacao.getData().igual(dataUltimaOperacao) || !operacao.getTipo().formatado().equals("2")) continue;
            dataUltimaOperacao.setConteudo(operacao.getData());
            this.saldoMoeda[0] = operacao.getEstoque().formatado();
            this.saldoMoeda[1] = operacao.getSaldo().formatado();
        }
    }

    public boolean existeBemDescricao(Alienacao alienacao) {
        DemonstrativoGCAP demonstrativo = ControladorGui.getDemonstrativoAberto();
        if (alienacao instanceof AlienacaoBemImovel) {
            for (AlienacaoBemImovel imovel : demonstrativo.getBensImoveis().itens()) {
                if (!((AlienacaoBemImovel)alienacao).getBemImovel().getEspecificacao().naoFormatado().equals(imovel.getBemImovel().getEspecificacao().naoFormatado())) continue;
                return true;
            }
        }
        if (alienacao instanceof AlienacaoBemMovel) {
            for (AlienacaoBemMovel movel : demonstrativo.getBensMoveis().itens()) {
                if (!((AlienacaoBemMovel)alienacao).getBemMovel().getEspecificacao().naoFormatado().equals(movel.getBemMovel().getEspecificacao().naoFormatado())) continue;
                return true;
            }
        }
        if (alienacao instanceof AlienacaoParticipacaoSocietaria) {
            for (AlienacaoParticipacaoSocietaria partSoc : demonstrativo.getParticipacoesSocietarias().itens()) {
                if (!((AlienacaoParticipacaoSocietaria)alienacao).getParticipacaoSocietaria().getNome().naoFormatado().equals(partSoc.getParticipacaoSocietaria().getNome().naoFormatado())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existeMoeda(MoedaAlienada moeda) {
        DemonstrativoGCAP demonstrativo = ControladorGui.getDemonstrativoAberto();
        for (MoedaAlienada moedaAux : demonstrativo.getMoedasAlienadas().itens()) {
            if (!moeda.getMoeda().naoFormatado().equals(moedaAux.getMoeda().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    private boolean deveSobrescreverItem(String tipo, String nome, DemonstrativoGCAP demonstrativoImportado, ResultadoImportacaoDTO resultado) throws AplicacaoException {
        if (resultado.isMarcadoSimParaTodos()) {
            return true;
        }
        if (resultado.isMarcadoNaoParaTodos()) {
            return false;
        }
        ResultadoConfirmaOpcoes retorno = GuiUtil.mostrarConfirmaOpcoes(MensagemUtil.getMensagem("ConfirmarSobrescritaItemImportacao", new String[]{tipo, nome}));
        switch (retorno) {
            case SIM_PARA_TODOS: {
                resultado.setMarcadoSimParaTodos(true);
            }
            case SIM: {
                return true;
            }
            case NAO_PARA_TODOS: {
                resultado.setMarcadoNaoParaTodos(true);
            }
            case NAO: {
                return false;
            }
            case CANCELADO: {
                throw new AplicacaoException("Opera\u00e7\u00e3o cancelada pelo usu\u00e1rio.");
            }
        }
        return false;
    }

    private void inserirBemImovel(AlienacaoBemImovel bemImovel, Codigo paisResidenciaAnterior, boolean sobrescrever) throws Exception {
        int numItem;
        List bens = ControladorGui.getDemonstrativoAberto().getBensImoveis().itens();
        Integer indexExistente = this.obterBemImovelMesmoNome(bemImovel, bens);
        if (sobrescrever && indexExistente != null) {
            bens.remove(indexExistente);
            numItem = indexExistente + 1;
        } else {
            numItem = bens.size() + 1;
        }
        if (bemImovel.getPaisResidencia().isVazio()) {
            bemImovel.getPaisResidencia().setConteudo(paisResidenciaAnterior);
        }
        bemImovel.getNumeroItem().setConteudo("" + numItem);
        bens.add(numItem - 1, bemImovel);
    }

    private Integer obterBemImovelMesmoNome(AlienacaoBemImovel bemImovel, List<AlienacaoBemImovel> bens) {
        for (int i = 0; i < bens.size(); ++i) {
            AlienacaoBemImovel bemImovelCorrente = bens.get(i);
            if (!bemImovelCorrente.getBemImovel().getEspecificacao().formatado().equals(bemImovel.getBemImovel().getEspecificacao().formatado())) continue;
            return i;
        }
        return null;
    }

    private void inserirBemMovel(AlienacaoBemMovel bemMovel, Codigo paisResidenciaAnterior, boolean sobrescrever) throws Exception {
        int numItem;
        List bens = ControladorGui.getDemonstrativoAberto().getBensMoveis().itens();
        Integer indexExistente = this.obterBemMovelMesmoNome(bemMovel, bens);
        if (sobrescrever && indexExistente != null) {
            bens.remove(indexExistente);
            numItem = indexExistente + 1;
        } else {
            numItem = bens.size() + 1;
        }
        if (bemMovel.getPaisResidencia().isVazio()) {
            bemMovel.getPaisResidencia().setConteudo(paisResidenciaAnterior);
        }
        bemMovel.getNumeroItem().setConteudo("" + numItem);
        bens.add(numItem - 1, bemMovel);
    }

    private Integer obterBemMovelMesmoNome(AlienacaoBemMovel bemMovel, List<AlienacaoBemMovel> bens) {
        for (int i = 0; i < bens.size(); ++i) {
            AlienacaoBemMovel bemMovelCorrente = bens.get(i);
            if (!bemMovelCorrente.getBemMovel().getEspecificacao().formatado().equals(bemMovel.getBemMovel().getEspecificacao().formatado())) continue;
            return i;
        }
        return null;
    }

    private void inserirParticipacaoSocietaria(AlienacaoParticipacaoSocietaria pSocietaria, Codigo paisResidenciaAnterior, boolean sobrescrever) throws Exception {
        int numItem;
        List bens = ControladorGui.getDemonstrativoAberto().getParticipacoesSocietarias().itens();
        Integer indexExistente = this.obterParticipacaoSocietariaMesmoNome(pSocietaria, bens);
        if (sobrescrever && indexExistente != null) {
            bens.remove(indexExistente);
            numItem = indexExistente + 1;
        } else {
            numItem = bens.size() + 1;
        }
        if (pSocietaria.getPaisResidencia().isVazio()) {
            pSocietaria.getPaisResidencia().setConteudo(paisResidenciaAnterior);
        }
        pSocietaria.getNumeroItem().setConteudo("" + numItem);
        bens.add(numItem - 1, pSocietaria);
    }

    public void inserirMoeda(MoedaAlienada moeda, boolean sobrescrever) throws Exception {
        int numItem;
        List moedas = ControladorGui.getDemonstrativoAberto().getMoedasAlienadas().itens();
        Integer indexExistente = this.obterMoedaMesmoCodigo(moeda, moedas);
        if (sobrescrever && indexExistente != null) {
            moedas.remove(indexExistente);
            numItem = indexExistente + 1;
        } else {
            numItem = moedas.size() + 1;
        }
        moeda.getNumeroItem().setConteudo("" + numItem);
        moeda.getEstoqueInicial().setConteudo(this.saldoMoeda[0]);
        moeda.getSaldoInicial().setConteudo(this.saldoMoeda[1]);
        moeda.getOperacoesEspecie().itens().clear();
        moedas.add(numItem - 1, moeda);
    }

    private Integer obterParticipacaoSocietariaMesmoNome(AlienacaoParticipacaoSocietaria pSocietaria, List<AlienacaoParticipacaoSocietaria> bens) {
        for (int i = 0; i < bens.size(); ++i) {
            AlienacaoParticipacaoSocietaria pSocietariaCorrente = bens.get(i);
            if (!pSocietariaCorrente.getParticipacaoSocietaria().getNome().formatado().equals(pSocietaria.getParticipacaoSocietaria().getNome().formatado())) continue;
            return i;
        }
        return null;
    }

    private Integer obterMoedaMesmoCodigo(MoedaAlienada moeda, List<MoedaAlienada> moedas) {
        for (int i = 0; i < moedas.size(); ++i) {
            MoedaAlienada moedaCorrente = moedas.get(i);
            if (!moedaCorrente.getMoeda().formatado().equals(moeda.getMoeda().formatado())) continue;
            return i;
        }
        return null;
    }
}

