/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.importacao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.gui.util.ProgressMonitor;
import br.gov.serpro.gcap.gui.util.ProgressUtil;
import br.gov.serpro.gcap.importacao.MapeamentoXmlReader;
import br.gov.serpro.gcap.importacao.ObjetoNegocioXMLReaderTagHandler;
import br.gov.serpro.gcap.importacao.ResultadoImportacaoDTO;
import br.gov.serpro.gcap.importacao.XMLSaxHandler;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import serpro.ppgd.infraestrutura.PlataformaPPGD;

public class RestauradorCopiaSeguranca {
    private List<DemonstrativoGCAP> recuperaDemonstrativosSelecionadosDoDisco(File[] selectedFiles, ResultadoImportacaoDTO resultado) throws Exception {
        ArrayList<DemonstrativoGCAP> demonstrativosRecuperados = new ArrayList<DemonstrativoGCAP>();
        ProgressMonitor monitor = ProgressUtil.createProgressMonitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), selectedFiles.length, false, 500, "Restaurando");
        try {
            for (int i = 0; i < selectedFiles.length; ++i) {
                if (i == 0) {
                    monitor.start("Restaurando " + (i + 1) + " de " + selectedFiles.length);
                } else {
                    monitor.setCurrent("Restaurando " + (i + 1) + " de " + selectedFiles.length, i + 1);
                }
                DemonstrativoGCAP lDemonstrativo = this.restaurarCopiaSeguranca(selectedFiles[i]);
                if (lDemonstrativo.getIdDemonstrativo().getCpf().isVazio()) {
                    resultado.adicionarNaoImportado("", selectedFiles[i].getName());
                    continue;
                }
                resultado.adicionarImportado(lDemonstrativo.getIdDemonstrativo().getNome().naoFormatado(), lDemonstrativo.getIdDemonstrativo().getCpf().formatado() + " - (" + lDemonstrativo.getIdDemonstrativo().getDataInicioPermanencia().formatado() + " - " + lDemonstrativo.getIdDemonstrativo().getDataFimPermanencia().formatado() + ")");
                GCAPFacade.criarDeclaracao(lDemonstrativo);
                GCAPFacade.getInstancia().salvarDeclaracao(lDemonstrativo);
                demonstrativosRecuperados.add(lDemonstrativo);
            }
            if (monitor != null) {
                monitor.setCurrent("Conclu\u00eddo", selectedFiles.length);
            }
        }
        catch (Exception ex) {
            if (monitor != null) {
                monitor.setCurrent("Conclu\u00eddo", selectedFiles.length);
            }
            throw ex;
        }
        return demonstrativosRecuperados;
    }

    public ResultadoImportacaoDTO restaurarCopiaSeguranca(File[] selectedFiles) throws Exception {
        ResultadoImportacaoDTO resultado = new ResultadoImportacaoDTO();
        ArrayList<DemonstrativoGCAP> demonstrativosRecuperados = new ArrayList<DemonstrativoGCAP>();
        ProgressMonitor monitor = null;
        if (selectedFiles.length > 1) {
            monitor = ProgressUtil.createProgressMonitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), selectedFiles.length, false, 1000, "Restaurando");
        }
        try {
            for (int i = 0; i < selectedFiles.length; ++i) {
                if (monitor != null) {
                    if (i == 0) {
                        monitor.start("Restaurando " + (i + 1) + " de " + selectedFiles.length);
                    } else {
                        monitor.setCurrent("Restaurando " + (i + 1) + " de " + selectedFiles.length, i + 1);
                    }
                }
                String[] partes = selectedFiles[i].getName().split("-");
                String dataInicio = partes[1].substring(0, 2) + partes[1].substring(2, 4) + AplicacaoPropertiesUtil.getExercicio();
                String dataFim = partes[2].substring(0, 2) + partes[2].substring(2, 4) + AplicacaoPropertiesUtil.getExercicio();
                String dataInicioFormatada = partes[1].substring(0, 2) + "/" + partes[1].substring(2, 4) + "/" + AplicacaoPropertiesUtil.getExercicio();
                String dataFimFormatada = partes[2].substring(0, 2) + "/" + partes[2].substring(2, 4) + "/" + AplicacaoPropertiesUtil.getExercicio();
                boolean existeDemonstrativo = GCAPFacade.getInstancia().existeDemonstrativo(partes[0], dataInicio, dataFim);
                if (existeDemonstrativo && (!existeDemonstrativo || !GuiUtil.mostrarConfirmaSemQuebraDeLinha("copia_seg_restauracao_confirmacao", new String[]{partes[0], dataInicioFormatada + "-" + dataFimFormatada}))) continue;
                DemonstrativoGCAP lDemonstrativo = this.restaurarCopiaSeguranca(selectedFiles[i]);
                if (lDemonstrativo.getIdDemonstrativo().getCpf().isVazio()) {
                    resultado.adicionarNaoImportado("Arquivo corrompido ou inv\u00e1lido", selectedFiles[i].getName());
                    continue;
                }
                lDemonstrativo.atualizarCalculoFaixasImposto();
                lDemonstrativo.ajustarFlagCobranca();
                lDemonstrativo.atualizarDataDarfTCM();
                lDemonstrativo.getBensImoveis().atualizarDatasAlienacoes();
                resultado.adicionarImportado(lDemonstrativo.getIdDemonstrativo().getNome().naoFormatado(), lDemonstrativo.getIdDemonstrativo().getCpf().formatado() + " - (" + lDemonstrativo.getIdDemonstrativo().getDataInicioPermanencia().formatado() + " - " + lDemonstrativo.getIdDemonstrativo().getDataFimPermanencia().formatado() + ")");
                GCAPFacade.criarDeclaracao(lDemonstrativo);
                GCAPFacade.getInstancia().salvarDeclaracao(lDemonstrativo);
                demonstrativosRecuperados.add(lDemonstrativo);
            }
            for (DemonstrativoGCAP dec : demonstrativosRecuperados) {
                try {
                    ControladorGui.abrirDemonstrativoSemUI(dec.getIdentificadorDeclaracao());
                    ControladorGui.salvarDemonstrativoAberto();
                    ControladorGui.fecharDemonstrativoSemUI();
                }
                catch (Exception exception) {}
            }
            if (monitor != null) {
                monitor.setCurrent("Conclu\u00eddo", selectedFiles.length);
            }
        }
        catch (Exception ex) {
            if (monitor != null) {
                monitor.setCurrent("Conclu\u00eddo", selectedFiles.length);
            }
            throw ex;
        }
        for (DemonstrativoGCAP dec : demonstrativosRecuperados) {
            try {
                ControladorGui.abrirDemonstrativoSemUI(dec.getIdentificadorDeclaracao());
                ControladorGui.fecharDemonstrativoSemUI();
            }
            catch (Exception exception) {}
        }
        return resultado;
    }

    private DemonstrativoGCAP restaurarCopiaSeguranca(File file) {
        DemonstrativoGCAP demonstrativo = null;
        try {
            String strXml = this.descompactarArquivoObtendoDados(file.getAbsolutePath());
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            demonstrativo = new DemonstrativoGCAP(new IdDemonstrativoGCAP());
            ObjetoNegocioXMLReaderTagHandler tagHandler = new ObjetoNegocioXMLReaderTagHandler(demonstrativo, MapeamentoXmlReader.MAPEAMENTO_ARQUIVO_COPIA_SEGURANCA);
            XMLSaxHandler handler = new XMLSaxHandler();
            handler.addDefaultTagHandler(tagHandler);
            if (!strXml.isEmpty()) {
                InputSource in = new InputSource(new StringReader(strXml));
                parser.parse(in, (DefaultHandler)handler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            demonstrativo = null;
        }
        return demonstrativo;
    }

    private String descompactarArquivoObtendoDados(String pCaminhoNomeArquivo) throws Exception {
        String lDados = "";
        InputStream in = null;
        File file = new File(pCaminhoNomeArquivo);
        ZipFile zipFile = new ZipFile(new File(pCaminhoNomeArquivo));
        String arquivo = file.getName().replace("DBK", "xml").replace("DEC", "xml");
        in = this.getObterFile(arquivo, zipFile);
        if (in != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            lDados = out.toString();
        }
        return lDados;
    }

    public InputStream getObterFile(String filename, ZipFile zipFile) throws IOException {
        InputStream file = null;
        ZipEntry zipEntry = null;
        if (zipFile.getEntry(filename) != null) {
            zipEntry = zipFile.getEntry(filename);
            file = zipFile.getInputStream(zipEntry);
        }
        return file;
    }
}

