/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.importacao;

import br.gov.serpro.gcap.importacao.DefaultTagHandler;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSaxHandler
extends DefaultHandler {
    private Map<String, DefaultTagHandler> tagHandlers = new HashMap<String, DefaultTagHandler>();
    private StringBuffer tagPath;
    private StringBuffer text = new StringBuffer();

    public XMLSaxHandler() {
        this.tagPath = new StringBuffer();
    }

    public void addTagHandler(String tagPath, DefaultTagHandler tagHandler) {
        this.tagHandlers.put(tagPath.toLowerCase(), tagHandler);
    }

    public void addDefaultTagHandler(DefaultTagHandler tagHandler) {
        this.tagHandlers.put(null, tagHandler);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
        DefaultTagHandler tagHandler = this.getHandler(this.tagPath.toString());
        if (tagHandler != null) {
            tagHandler.characters(this.tagPath.toString(), this.text.toString());
        }
    }

    @Override
    public void startElement(String uri, String localName, String tag, Attributes attributes) throws SAXException {
        this.tagPath.append("/" + tag.toLowerCase());
        DefaultTagHandler tagHandler = this.getHandler(this.tagPath.toString());
        if (tagHandler != null) {
            tagHandler.startElement(this.tagPath.toString(), attributes);
        }
        this.text.delete(0, this.text.length());
    }

    @Override
    public void endElement(String uri, String localName, String tag) throws SAXException {
        DefaultTagHandler tagHandler = this.getHandler(this.tagPath.toString());
        if (tagHandler != null) {
            tagHandler.endElement(this.tagPath.toString(), this.text.toString());
        }
        this.text.delete(0, this.text.length());
        this.tagPath.delete(this.tagPath.length() - tag.length() - 1, this.tagPath.length());
    }

    public DefaultTagHandler getHandler(String tagPah) {
        if (this.tagHandlers.containsKey(tagPah)) {
            return this.tagHandlers.get(this.tagPath.toString());
        }
        if (this.tagHandlers.containsKey(null)) {
            return this.tagHandlers.get(null);
        }
        return null;
    }
}

