/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.especie.MoedasAlienadasMensal;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.exception.BarramentoException;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.gui.util.PainelDownloads;
import br.gov.serpro.gcap.gui.util.PdfUtil;
import br.gov.serpro.gcap.nuvem.BarramentoIRPFService;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.DataUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileSystemView;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ElementoTabela;

public class ImpressaoDarf {
    private Data calculaDataVencimentoMoedasAlienadas() {
        Data data = new Data();
        data.setConteudo("30/04/" + ConstantesGlobais.EXERCICIO_POSTERIOR);
        Calendar calendario = Calendar.getInstance();
        calendario.setTime(data.asDate());
        if (calendario.get(7) == 1) {
            calendario.add(5, -2);
        } else if (calendario.get(7) == 7) {
            calendario.add(5, -1);
        }
        data.setConteudo(calendario.getTime());
        return data;
    }

    public byte[] obterPdfDarfMoedaEspecie(String cpf, String nomeContribuinte, MoedasAlienadasMensal moedasAlienadasMensal) throws BarramentoException, AplicacaoException {
        String observacoes = "Caso seja feriado local, antecipe o pagamento.| |Programa de Apura\u00e7\u00e3o dos Ganhos de Capital " + ConstantesGlobais.EXERCICIO;
        String descricaoPrincipal = "IRPF - Ganho de Capital";
        String descricoesAdicionais = "Moeda Estrangeira Mantida em Esp\u00e9cie|" + moedasAlienadasMensal.getMes().naoFormatado() + "/" + ConstantesGlobais.EXERCICIO;
        Date periodoApuracao = DataUtil.obterUltimoDiaMes(AplicacaoPropertiesUtil.getExercicioAsInt(), moedasAlienadasMensal.getMesAsInt() + 1);
        Date dataVencimento = DataUtil.obterUltimoDiaMes(AplicacaoPropertiesUtil.getExercicioAsInt(), moedasAlienadasMensal.getMesAsInt() + 2);
        Double valorPrincipal = Double.valueOf(moedasAlienadasMensal.getImpostoDevido().getParteInteira() + "." + moedasAlienadasMensal.getImpostoDevido().getParteDecimal());
        return BarramentoIRPFService.obterPdfDarfGcap(BarramentoIRPFService.TipoDarfGCAP.AlienacaoMoedaEspecie, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, periodoApuracao, dataVencimento, valorPrincipal, false, null);
    }

    public void exibirPdfDarfMoedaEspecie(DemonstrativoGCAP demonstrativo, JPanel painel, int[] mesesImprimir) {
        boolean existeDARFMenos10Reais = false;
        String identificador = "darfMoedaEspecie";
        String titulo = "Darf - Moeda em Especie";
        ExecutorPdf executor = new ExecutorPdf();
        if (mesesImprimir != null) {
            for (int i = 0; i < mesesImprimir.length; ++i) {
                MoedasAlienadasMensal moedasAlienadasMensal = demonstrativo.getTotalizacaoMoedasAlienadas().getMes(mesesImprimir[i]);
                if (moedasAlienadasMensal.getImpostoDevido().comparacao(">=", "10,00")) {
                    executor.adicionarCriacaoPdf(this.adicionarCriacaoPdfMoedaEspecie(demonstrativo, moedasAlienadasMensal));
                    continue;
                }
                if (moedasAlienadasMensal.getImpostoDevido().isVazio()) continue;
                existeDARFMenos10Reais = true;
            }
        } else {
            for (MoedasAlienadasMensal mes : demonstrativo.getTotalizacaoMoedasAlienadas().getMeses()) {
                if (mes.getImpostoDevido().comparacao(">=", "10,00")) {
                    executor.adicionarCriacaoPdf(this.adicionarCriacaoPdfMoedaEspecie(demonstrativo, mes));
                    continue;
                }
                if (mes.getImpostoDevido().isVazio()) continue;
                existeDARFMenos10Reais = true;
            }
        }
        if (existeDARFMenos10Reais) {
            GuiUtil.mostrarInfo("ValorMinimoEmissaoDarf", new String[]{"10,00"});
        }
        if (executor.getTarefas().isEmpty()) {
            GuiUtil.mostrarAviso("NaoExistemDadosRelatorioDarf");
            return;
        }
        executor.criarPdfs(painel, identificador, titulo, this::exibirPdf);
    }

    private TarefaCriarPdf adicionarCriacaoPdfMoedaEspecie(DemonstrativoGCAP demonstrativo, MoedasAlienadasMensal moedasAlienadasMensal) {
        TarefaCriarPdf geradorPdf = () -> this.obterPdfDarfMoedaEspecie(demonstrativo.getIdDemonstrativo().getCpf().naoFormatado(), demonstrativo.getIdDemonstrativo().getNome().naoFormatado(), moedasAlienadasMensal);
        return geradorPdf;
    }

    public void adicionarPdfDarfBem(ExecutorPdf executor, String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Alienacao bem, int[] selecaoMeses, Map<Integer, String> vencimentos) {
        BarramentoIRPFService.TipoDarfGCAP tipoDarf;
        Data periodoApuracao = new Data();
        boolean laplicarIN599_2005 = false;
        Data dataVencimento = new Data();
        if ("105".equals(bem.getPaisResidencia().naoFormatado())) {
            String lVencimento;
            if (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS).equals(bem.getNatureza().naoFormatado())) {
                if (bem.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals("1")) {
                    periodoApuracao.setConteudo(bem.getDataTransitoJulgado());
                    if (periodoApuracao.isVazio()) {
                        return;
                    }
                } else {
                    periodoApuracao.setConteudo(bem.getDataAlienacao());
                }
                lVencimento = bem.calculaDataVencimentoDarfCausaMortis().formatado();
            } else {
                periodoApuracao.setConteudo(DataUtil.obterUltimoDiaMes(Integer.parseInt(bem.getDataAlienacao().getAno()), Integer.parseInt(bem.getDataAlienacao().getMes())));
                lVencimento = vencimentos.get(Integer.valueOf(periodoApuracao.getMes()));
            }
            dataVencimento.setConteudo(lVencimento);
            tipoDarf = bem.isAlienacaoBrasil() ? BarramentoIRPFService.TipoDarfGCAP.AlienacaoBrasilResidenteBrasil : (String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO).equals(bem.getNatureza().naoFormatado()) ? BarramentoIRPFService.TipoDarfGCAP.AlienacaoExteriorResidenteBrasilDepositosCartao : BarramentoIRPFService.TipoDarfGCAP.AlienacaoExteriorResidenteBrasil);
            laplicarIN599_2005 = bem instanceof AlienacaoBemImovel && ((AlienacaoBemImovel)bem).getPerguntas().isIN599_2005Aplicavel();
        } else {
            if (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS).equals(bem.getNatureza().naoFormatado()) && bem.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals("1")) {
                periodoApuracao.setConteudo(bem.getDataTransitoJulgado());
                dataVencimento.setConteudo(bem.getDataTransitoJulgado());
            } else {
                periodoApuracao.setConteudo(bem.getDataAlienacao());
                dataVencimento.setConteudo(bem.getDataAlienacao());
            }
            tipoDarf = BarramentoIRPFService.TipoDarfGCAP.AlienacaoBrasilResidenteExterior;
        }
        if (!this.isMesConsiderado(selecaoMeses, Integer.valueOf(periodoApuracao.getMes()))) {
            return;
        }
        ValorPositivo valImpostoDevido = bem.getCalculoImposto().getImpostoDevido2();
        BigInteger impostoDevidoBigInt = valImpostoDevido.getConteudoBigInteger();
        if (impostoDevidoBigInt.equals(BigInteger.ZERO)) {
            return;
        }
        if (impostoDevidoBigInt.compareTo(new BigInteger("1000")) < 0) {
            GuiUtil.mostrarInfo("ValorMinimoEmissaoDarf", new String[]{"10,00"});
            return;
        }
        Double valorPrincipal = Double.valueOf(valImpostoDevido.getParteInteira() + "." + valImpostoDevido.getParteDecimal());
        boolean aplicarIN599_2005 = laplicarIN599_2005;
        Data dataAlienacao = new Data();
        dataAlienacao.setConteudo(bem.getDataAlienacao());
        if (aplicarIN599_2005) {
            this.exibirPainelTestes(dataAlienacao, "Data de Aliena\u00e7\u00e3o");
        }
        this.exibirPainelTestes(periodoApuracao, "Per\u00edodo de Apura\u00e7\u00e3o");
        this.exibirPainelTestes(dataVencimento, "Data de Vencimento");
        TarefaCriarPdf tarefa = () -> BarramentoIRPFService.obterPdfDarfGcap(tipoDarf, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, periodoApuracao.asDate(), dataVencimento.asDate(), valorPrincipal, aplicarIN599_2005, dataAlienacao.asDate());
        executor.adicionarCriacaoPdf(tarefa);
    }

    public void adicionarPdfsDarfsBem(ExecutorPdf executor, String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Alienacao bem, ParcelaAlienacao parcela, int[] selecaoMeses, Map<Integer, String> vencimentos) {
        Data periodoApuracao = new Data();
        periodoApuracao.setConteudo(parcela.getDataRecebimento());
        if (periodoApuracao.isVazio()) {
            return;
        }
        Data dataVencimento = new Data();
        int lMesAlienacao = Integer.valueOf(parcela.getDataRecebimento().getMes());
        boolean laplicarIN599_2005 = false;
        if (lMesAlienacao != 0 && this.isMesConsiderado(selecaoMeses, lMesAlienacao)) {
            BarramentoIRPFService.TipoDarfGCAP tipoDarf;
            String lVencimento;
            if ("105".equals(bem.getPaisResidencia().naoFormatado())) {
                periodoApuracao.setConteudo(DataUtil.obterUltimoDiaMes(Integer.parseInt(periodoApuracao.getAno()), Integer.parseInt(periodoApuracao.getMes())));
                lVencimento = vencimentos.get(lMesAlienacao);
                tipoDarf = bem.isAlienacaoBrasil() ? BarramentoIRPFService.TipoDarfGCAP.AlienacaoBrasilResidenteBrasil : (String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO).equals(bem.getNatureza().naoFormatado()) ? BarramentoIRPFService.TipoDarfGCAP.AlienacaoExteriorResidenteBrasilDepositosCartao : BarramentoIRPFService.TipoDarfGCAP.AlienacaoExteriorResidenteBrasil);
                laplicarIN599_2005 = bem instanceof AlienacaoBemImovel && ((AlienacaoBemImovel)bem).getPerguntas().isIN599_2005Aplicavel();
            } else {
                lVencimento = parcela.getDataRecebimento().formatado();
                tipoDarf = BarramentoIRPFService.TipoDarfGCAP.AlienacaoBrasilResidenteExterior;
            }
            dataVencimento.setConteudo(lVencimento);
            ValorPositivo valImpostoDevido = parcela.getImpostoDevido2();
            BigInteger impostoDevidoBigInt = valImpostoDevido.getConteudoBigInteger();
            if (impostoDevidoBigInt.equals(BigInteger.ZERO)) {
                return;
            }
            if (impostoDevidoBigInt.compareTo(new BigInteger("1000")) < 0) {
                GuiUtil.mostrarInfo("ValorMinimoEmissaoDarf", new String[]{"10,00"});
                return;
            }
            Double valorPrincipal = Double.valueOf(valImpostoDevido.getParteInteira() + "." + valImpostoDevido.getParteDecimal());
            boolean aplicarIN599_2005 = laplicarIN599_2005;
            Data dataAlienacao = new Data();
            dataAlienacao.setConteudo(bem.getDataAlienacao());
            if (aplicarIN599_2005) {
                this.exibirPainelTestes(dataAlienacao, "Data de Aliena\u00e7\u00e3o");
            }
            this.exibirPainelTestes(periodoApuracao, "Per\u00edodo de Apura\u00e7\u00e3o");
            this.exibirPainelTestes(dataVencimento, "Data de Vencimento");
            TarefaCriarPdf tarefa = () -> BarramentoIRPFService.obterPdfDarfGcap(tipoDarf, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, periodoApuracao.asDate(), dataVencimento.asDate(), valorPrincipal, aplicarIN599_2005, dataAlienacao.asDate());
            executor.adicionarCriacaoPdf(tarefa);
        }
    }

    public void adicionarPdfsDarfsBem(ExecutorPdf executor, String cpf, String nomeContribuinte, Alienacao alienacao, int[] selecaoMeses) throws AplicacaoException {
        block19: {
            Map<Integer, String> vencimentos;
            String descricoesAdicionais;
            String descricaoPrincipal;
            String observacoes;
            block20: {
                block18: {
                    observacoes = "Caso seja feriado local, antecipe o pagamento.| |Programa de Apura\u00e7\u00e3o dos Ganhos de Capital.";
                    descricaoPrincipal = "IRPF - Ganho de Capital";
                    StringBuilder buildDescricoesAdicionais = new StringBuilder();
                    if (alienacao.isPaisResidenciaBrasil()) {
                        if (alienacao.isTransmissaoCausaMortis()) {
                            buildDescricoesAdicionais.append("Transmiss\u00e3o Causa Mortis");
                        } else if (alienacao.isAlienacaoBrasil()) {
                            if (alienacao instanceof AlienacaoBemImovel) {
                                if (((AlienacaoBemImovel)alienacao).getPerguntas().isImovelResidencial()) {
                                    buildDescricoesAdicionais.append("Im\u00f3vel Residencial");
                                } else {
                                    buildDescricoesAdicionais.append("Im\u00f3vel N\u00e3o Residencial");
                                }
                            } else if (alienacao instanceof AlienacaoBemMovel) {
                                buildDescricoesAdicionais.append("Bem m\u00f3vel");
                            } else if (alienacao instanceof AlienacaoParticipacaoSocietaria) {
                                buildDescricoesAdicionais.append("Participa\u00e7\u00e3o Societ\u00e1ria");
                            }
                        } else if (String.valueOf(AlienacaoBem.CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO).equals(alienacao.getNatureza().naoFormatado())) {
                            buildDescricoesAdicionais.append("De Dep\u00f3sito em Conta Corrente,|Cart\u00e3o de Cr\u00e9dito ou D\u00e9bito no Exterior");
                        } else {
                            buildDescricoesAdicionais.append("Na Aliena\u00e7\u00e3o de Bens e Direitos Localizados no Exterior");
                        }
                    } else {
                        buildDescricoesAdicionais.append("Aliena\u00e7\u00e3o de Bens e Direitos por n\u00e3o residente");
                    }
                    buildDescricoesAdicionais.append("|").append(ConstantesGlobais.EXERCICIO);
                    if (alienacao instanceof AlienacaoBemImovel && ((AlienacaoBemImovel)alienacao).getPerguntas().isIN599_2005Aplicavel()) {
                        buildDescricoesAdicionais.append("|").append("Data de aliena\u00e7\u00e3o: " + alienacao.getDataAlienacao().formatado());
                    }
                    descricoesAdicionais = buildDescricoesAdicionais.toString();
                    vencimentos = this.recarregarDatasVencimento();
                    if (!alienacao.isAlienacaoAVista()) break block18;
                    this.adicionarPdfDarfBem(executor, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, alienacao, selecaoMeses, vencimentos);
                    break block19;
                }
                if (!alienacao.isAlienacaoAPrazo()) break block19;
                boolean total = false;
                if (!(alienacao instanceof AlienacaoBem)) break block20;
                for (ParcelaAlienacao parcela : ((AlienacaoBem)alienacao).getColecaoParcelaAlienacao().itens()) {
                    this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, alienacao, parcela, selecaoMeses, vencimentos);
                }
                break block19;
            }
            if (!(alienacao instanceof AlienacaoParticipacaoSocietaria)) break block19;
            for (ParcelaAlienacao parcela : ((AlienacaoParticipacaoSocietaria)alienacao).getColecaoParcelaAlienacao().itens()) {
                this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, alienacao, parcela, selecaoMeses, vencimentos);
            }
        }
    }

    public void adicionarPdfsDarfsBens(ExecutorPdf executor, DemonstrativoGCAP demonstrativo, int[][] selecaoBens, int[] selecaoMeses) throws AplicacaoException {
        String cpf = demonstrativo.getIdDemonstrativo().getCpf().naoFormatado();
        String nomeContribuinte = demonstrativo.getIdDemonstrativo().getNome().naoFormatado();
        if (selecaoBens != null) {
            Alienacao alienacao;
            int i;
            for (i = 0; i < selecaoBens[0].length; ++i) {
                alienacao = (Alienacao)((Object)demonstrativo.getBensImoveis().itens().get(selecaoBens[0][i]));
                this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, alienacao, selecaoMeses);
            }
            for (i = 0; i < selecaoBens[1].length; ++i) {
                alienacao = (Alienacao)((Object)demonstrativo.getBensMoveis().itens().get(selecaoBens[1][i]));
                this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, alienacao, selecaoMeses);
            }
            for (i = 0; i < selecaoBens[2].length; ++i) {
                alienacao = (Alienacao)((Object)demonstrativo.getParticipacoesSocietarias().itens().get(selecaoBens[2][i]));
                this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, alienacao, selecaoMeses);
            }
        } else {
            for (Alienacao alienacao : demonstrativo.getBensImoveis().itens()) {
                this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, alienacao, selecaoMeses);
            }
            for (Alienacao alienacao : demonstrativo.getBensMoveis().itens()) {
                this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, alienacao, selecaoMeses);
            }
            for (Alienacao alienacao : demonstrativo.getParticipacoesSocietarias().itens()) {
                this.adicionarPdfsDarfsBem(executor, cpf, nomeContribuinte, alienacao, selecaoMeses);
            }
        }
    }

    public void exibirPdfsDarfsBens(JPanel painel, DemonstrativoGCAP demonstrativo, int[][] selecaoBens, int[] selecaoMeses) {
        ExecutorPdf executor = new ExecutorPdf();
        try {
            this.adicionarPdfsDarfsBens(executor, demonstrativo, selecaoBens, selecaoMeses);
            String titulo = "Darfs - Bens";
            String identificador = this.obterIdentificadorDarfBens(demonstrativo);
            if (executor.getTarefas().size() > 0) {
                executor.criarPdfs(painel, identificador, titulo, this::exibirPdf);
            } else {
                GuiUtil.mostrarAviso("NaoExistemDadosRelatorioDarf");
            }
        }
        catch (AplicacaoException e) {
            e.printStackTrace();
            GuiUtil.mostrarErro(painel, e.getMessage());
        }
    }

    private String obterIdentificadorDarfBens(DemonstrativoGCAP demonstrativo) {
        Data dataInicio = demonstrativo.getIdDemonstrativo().getDataInicioPermanencia();
        Data dataFim = demonstrativo.getIdDemonstrativo().getDataFimPermanencia();
        String strInicio = dataInicio.getDia() + dataInicio.getMes();
        String strFim = dataFim.getDia() + dataFim.getMes();
        return demonstrativo.getIdDemonstrativo().getCpf().naoFormatado() + "-" + strInicio + "-" + strFim + "-" + ConstantesGlobais.NOME_PROGRAMA + "-" + ConstantesGlobais.EXERCICIO + "-darf";
    }

    private boolean isMesConsiderado(int[] selecaoMeses, int pMes) {
        if (selecaoMeses == null) {
            return true;
        }
        for (int mes : selecaoMeses) {
            if (pMes != mes + 1) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, String> recarregarDatasVencimento() throws AplicacaoException {
        List<ElementoTabela> datasVencimento = CadastroTabelasGCAP.recuperarDatasVencimento(1);
        HashMap<Integer, String> vencimentos = new HashMap<Integer, String>();
        for (int meses = 1; meses <= 12; ++meses) {
            vencimentos.put(meses, DataUtil.converterFormatoDatayyyyMMddParaddMMyyyy(datasVencimento.get(meses - 1).getConteudo(1), true));
        }
        return vencimentos;
    }

    public void exibirPainelTestes(Data vencimento, String nomeCampo) {
        if (AplicacaoPropertiesUtil.isVersaoTestes()) {
            String data = JOptionPane.showInputDialog(null, "<html>Para fins de testes, deseja alterar o conte\u00fado<br>do campo <span style=\"color:red\"><strong>" + nomeCampo + "</span></strong> para este Darf?</html>", vencimento.formatado());
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            df.setLenient(false);
            if (data != null) {
                try {
                    vencimento.setConteudo(df.parse(data));
                }
                catch (ParseException e) {
                    GuiUtil.mostrarErro(null, "Data inv\u00e1lida : " + data);
                    this.exibirPainelTestes(vencimento, nomeCampo);
                }
            }
        }
    }

    private void exibirPdf(List<byte[]> pdfs, String identificador, String titulo) {
        String path = new File(FileSystemView.getFileSystemView().getDefaultDirectory(), identificador).getAbsolutePath();
        try {
            PdfUtil.exibirPdfs(pdfs, titulo, path);
        }
        catch (AplicacaoException e) {
            e.printStackTrace();
            GuiUtil.mostrarErro(e);
        }
    }

    public static void main(String[] args) {
        try {
            MoedasAlienadasMensal mes = new MoedasAlienadasMensal(MoedasAlienadasMensal.CONST_NOME_MES_JANEIRO);
            mes.getImpostoDevido().setConteudo("500,00");
            byte[] pdf = new ImpressaoDarf().obterPdfDarfMoedaEspecie("11185899987", "Pessoa de Testes", mes);
            try (FileOutputStream outputStream = new FileOutputStream(new File("darfMoedaEspecie.pdf"));){
                outputStream.write(pdf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class ExecutorPdf {
        private List<TarefaCriarPdf> tarefas = new ArrayList<TarefaCriarPdf>();

        public void adicionarCriacaoPdf(TarefaCriarPdf tarefa) {
            this.tarefas.add(tarefa);
        }

        public void criarPdfs(final JPanel painel, final String identificador, final String titulo, final TarefaTratarPdf tratamento) {
            final PainelDownloads painelDownlodas = new PainelDownloads(titulo, null);
            final SwingWorker<List<byte[]>, Integer> sw = new SwingWorker<List<byte[]>, Integer>(){

                @Override
                protected List<byte[]> doInBackground() throws Exception {
                    ArrayList<byte[]> pdfs = new ArrayList<byte[]>();
                    for (int i = 0; i < ExecutorPdf.this.getTarefas().size() && !this.isCancelled(); ++i) {
                        try {
                            this.publish(i + 1);
                            TarefaCriarPdf tarefa = ExecutorPdf.this.getTarefas().get(i);
                            byte[] pdf = tarefa.criarPdf();
                            pdfs.add(pdf);
                            continue;
                        }
                        catch (AplicacaoException | BarramentoException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new AplicacaoException("Ocorreu um erro durante a gera\u00e7\u00e3o do Darf ECA.", e, false);
                        }
                    }
                    return pdfs;
                }

                @Override
                protected void process(List<Integer> chunks) {
                    for (Integer item : chunks) {
                        painelDownlodas.getLblDescricao().setText("Obtendo Darf " + item + " de " + ExecutorPdf.this.getTarefas().size());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    if (this.isCancelled()) {
                        GuiUtil.mostrarAviso(GuiUtil.getParent(painel), "Opera\u00e7\u00e3o Cancelada pelo usu\u00e1rio");
                    } else {
                        try {
                            List pdfs = (List)this.get();
                            tratamento.tratarPdf(pdfs, identificador, titulo);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            Throwable cause = e.getCause();
                            if (cause != null && (cause instanceof AplicacaoException || cause instanceof BarramentoException)) {
                                BarramentoException bCause;
                                boolean isAviso = false;
                                String mensagem = cause.getMessage();
                                if (cause instanceof BarramentoException && ((BarramentoException)cause).getException().contains("Cod Retorno: 406") && (bCause = (BarramentoException)cause).getException().contains("\"mensagem\":")) {
                                    mensagem = bCause.getException().substring(bCause.getException().indexOf("\"mensagem\":"));
                                    mensagem = mensagem.replaceFirst("\"mensagem\": \"", "");
                                    mensagem = mensagem.substring(0, mensagem.indexOf("\""));
                                    isAviso = true;
                                }
                                if (isAviso) {
                                    GuiUtil.mostrarAviso(GuiUtil.getParent(painel), mensagem);
                                } else {
                                    GuiUtil.mostrarErro(GuiUtil.getParent(painel), mensagem);
                                }
                            } else {
                                GuiUtil.mostrarErro(GuiUtil.getParent(painel), "Ocorreu um erro durante a gera\u00e7\u00e3o do Darf");
                            }
                        }
                        finally {
                            GuiUtil.fecharDialog(painelDownlodas);
                        }
                    }
                }
            };
            painelDownlodas.getBtnCancelar().setAction(new AbstractAction("Cancelar"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    sw.cancel(true);
                    GuiUtil.fecharDialog(painelDownlodas);
                }
            });
            sw.execute();
            GuiUtil.exibeDialog(painelDownlodas, true, titulo, false);
        }

        public List<TarefaCriarPdf> getTarefas() {
            return this.tarefas;
        }
    }

    @FunctionalInterface
    public static interface TarefaTratarPdf {
        public void tratarPdf(List<byte[]> var1, String var2, String var3);
    }

    @FunctionalInterface
    public static interface TarefaCriarPdf {
        public byte[] criarPdf() throws BarramentoException, AplicacaoException;
    }
}

