/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.impressao.RelatorioGCAP;
import br.gov.serpro.gcap.impressao.pojo.ConsolidacaoRelatorio;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import serpro.ppgd.formatosexternos.RelatorioXML;
import serpro.ppgd.negocio.ConstantesGlobais;

public class RelatorioDemonstrativo
extends RelatorioGCAP {
    public static final String TITULO_RELATORIO = "GCAP - Demonstrativo";
    private static final String NOME_RELATORIO_PRINCIPAL = "relGcap.jasper";
    private RelatorioXML relatorio;

    public RelatorioDemonstrativo(DemonstrativoGCAP[] demonstrativos) {
        super(demonstrativos);
        this.gerarConsolidadoGeral = true;
    }

    public RelatorioDemonstrativo(DemonstrativoGCAP demonstrativo, int[][] itemDados) {
        super(demonstrativo, itemDados);
        if (itemDados == null) {
            this.gerarConsolidadoGeral = true;
        }
        this.relatorio = new RelatorioXML(TITULO_RELATORIO, NOME_RELATORIO_PRINCIPAL, demonstrativo.getIdDemonstrativo().getPathArquivo(), "/classe");
        RelatorioDemonstrativo.adicionarParametrosGerais(this.relatorio);
        RelatorioDemonstrativo.adicionarParametrosDemonstrativo(this.relatorio, demonstrativo);
    }

    @Override
    protected void adicionarBensEspecificadosAoRelatorio(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo) {
        this.adicionarBemImovelEspecificados(this.relatorio, demonstrativo);
        this.adicionarBemMovelEspecificados(this.relatorio, demonstrativo);
        this.adicionarParticipacaoSocEspecificados(this.relatorio, demonstrativo);
        this.adicionarMoedaEmEspecie(this.relatorio);
        this.adicionarRelatorioBensEspecifados(relatorios);
        try {
            ControladorGui.salvarDemonstrativoAberto();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void adicionarBensAoRelatorio(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo) {
        this.adicionarBensImoveisAoRelatorio(this.relatorio, demonstrativo);
        this.adicionarBensMoveisAoRelatorio(this.relatorio, demonstrativo);
        this.adicionarBensParticipacaoSocietariaAoRelatorio(this.relatorio, demonstrativo);
        this.adicionarMoedaEmEspecie(this.relatorio, demonstrativo);
        this.adicionarRelatorioTodos(relatorios, demonstrativo);
        this.relatorio.addParametro("consolidadoGeral", (Object)this.gerarConsolidadoGeral);
        try {
            ControladorGui.salvarDemonstrativoAberto();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void adicionarBemImovelEspecificados(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        if (this.arrayItemDados != null) {
            ArrayList<Integer> lista = new ArrayList<Integer>();
            for (int i = 0; i < this.arrayItemDados[0].length; ++i) {
                AlienacaoBemImovel bemImovel = (AlienacaoBemImovel)((Object)demonstrativo.getBensImoveis().itens().get(this.arrayItemDados[0][i]));
                bemImovel.getCalculoImposto().atualizarCalculoFaixasImposto(bemImovel.getGanhoCapitalAlienacaoAnterior(), bemImovel.getCalculoImposto().getGanhoCapitalTotal());
                if (!bemImovel.getColecaoParcelaAlienacao().getDataRecebimentoUltimaParcela().isVazio() && !bemImovel.getAjuste().getGanhoCapitalTotal().isVazio()) {
                    bemImovel.getAjuste().atualizarCalculoFaixasImposto(bemImovel.getGanhoCapitalAlienacaoAnterior(), bemImovel.getAjuste().getGanhoCapitalTotal());
                }
                lista.add(this.arrayItemDados[0][i]);
            }
            relatorio.addParametro("SelecaoBensImoveis", lista);
        }
    }

    private void adicionarBemMovelEspecificados(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        if (this.arrayItemDados != null) {
            ArrayList<Integer> lista = new ArrayList<Integer>();
            for (int i = 0; i < this.arrayItemDados[1].length; ++i) {
                AlienacaoBemMovel bemMovel = (AlienacaoBemMovel)((Object)demonstrativo.getBensMoveis().itens().get(this.arrayItemDados[1][i]));
                bemMovel.getCalculoImposto().atualizarCalculoFaixasImposto(bemMovel.getGanhoCapitalAlienacaoAnterior(), bemMovel.getCalculoImposto().getGanhoCapitalTotal());
                if (!bemMovel.getColecaoParcelaAlienacao().getDataRecebimentoUltimaParcela().isVazio() && !bemMovel.getAjuste().getGanhoCapitalTotal().isVazio()) {
                    bemMovel.getAjuste().atualizarCalculoFaixasImposto(bemMovel.getGanhoCapitalAlienacaoAnterior(), bemMovel.getAjuste().getGanhoCapitalTotal());
                }
                lista.add(this.arrayItemDados[1][i]);
            }
            relatorio.addParametro("SelecaoBensMoveis", lista);
        }
    }

    private void adicionarParticipacaoSocEspecificados(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        if (this.arrayItemDados != null) {
            ArrayList<Integer> lista = new ArrayList<Integer>();
            for (int i = 0; i < this.arrayItemDados[2].length; ++i) {
                AlienacaoParticipacaoSocietaria particSoc = (AlienacaoParticipacaoSocietaria)((Object)demonstrativo.getParticipacoesSocietarias().itens().get(this.arrayItemDados[2][i]));
                particSoc.getCalculoImposto().atualizarCalculoFaixasImposto(particSoc.getGanhoCapitalAlienacaoAnterior(), particSoc.getCalculoImposto().getGanhoCapitalTotal());
                lista.add(this.arrayItemDados[2][i]);
            }
            relatorio.addParametro("SelecaoParticipacaoSoc", lista);
        }
    }

    private void adicionarMoedaEmEspecie(RelatorioXML relatorio) {
        if (this.arrayItemDados[3].length != 0) {
            relatorio.addParametro("colecaoMoedaAlienada", (Object)Boolean.TRUE);
        }
    }

    private void adicionarBensImoveisAoRelatorio(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        List lBensImoveis = demonstrativo.getBensImoveis().itens();
        ArrayList<Integer> lista = new ArrayList<Integer>();
        for (int i = 0; i < lBensImoveis.size(); ++i) {
            AlienacaoBemImovel bemImovel = (AlienacaoBemImovel)((Object)lBensImoveis.get(i));
            bemImovel.getCalculoImposto().atualizarCalculoFaixasImposto(bemImovel.getGanhoCapitalAlienacaoAnterior(), bemImovel.getCalculoImposto().getGanhoCapitalTotal());
            if (!bemImovel.getColecaoParcelaAlienacao().getDataRecebimentoUltimaParcela().isVazio() && !bemImovel.getAjuste().getGanhoCapitalTotal().isVazio()) {
                bemImovel.getAjuste().atualizarCalculoFaixasImposto(bemImovel.getGanhoCapitalAlienacaoAnterior(), bemImovel.getAjuste().getGanhoCapitalTotal());
            }
            lista.add(i);
        }
        relatorio.addParametro("SelecaoBensImoveis", lista);
    }

    private void adicionarBensMoveisAoRelatorio(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        List lBensMoveis = demonstrativo.getBensMoveis().itens();
        ArrayList<Integer> lista = new ArrayList<Integer>();
        for (int i = 0; i < lBensMoveis.size(); ++i) {
            AlienacaoBemMovel bemMovel = (AlienacaoBemMovel)((Object)lBensMoveis.get(i));
            bemMovel.getCalculoImposto().atualizarCalculoFaixasImposto(bemMovel.getGanhoCapitalAlienacaoAnterior(), bemMovel.getCalculoImposto().getGanhoCapitalTotal());
            if (!bemMovel.getColecaoParcelaAlienacao().getDataRecebimentoUltimaParcela().isVazio()) {
                bemMovel.getAjuste().atualizarCalculoFaixasImposto(bemMovel.getGanhoCapitalAlienacaoAnterior(), bemMovel.getAjuste().getGanhoCapitalTotal());
            }
            lista.add(i);
        }
        relatorio.addParametro("SelecaoBensMoveis", lista);
    }

    private void adicionarBensParticipacaoSocietariaAoRelatorio(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        List lParticipacoes = demonstrativo.getParticipacoesSocietarias().itens();
        ArrayList<Integer> lista = new ArrayList<Integer>();
        for (int i = 0; i < lParticipacoes.size(); ++i) {
            AlienacaoParticipacaoSocietaria particSoc = (AlienacaoParticipacaoSocietaria)((Object)lParticipacoes.get(i));
            particSoc.getCalculoImposto().atualizarCalculoFaixasImposto(particSoc.getGanhoCapitalAlienacaoAnterior(), particSoc.getCalculoImposto().getGanhoCapitalTotal());
            lista.add(i);
        }
        relatorio.addParametro("SelecaoParticipacaoSoc", lista);
    }

    private void adicionarMoedaEmEspecie(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        if (!demonstrativo.getMoedasAlienadas().isVazio()) {
            relatorio.addParametro("colecaoMoedaAlienada", (Object)Boolean.TRUE);
        }
    }

    private void adicionarRelatorioBensEspecifados(List<RelatorioXML> relatorios) {
        if (!(this.arrayItemDados[0].length == 0 && this.arrayItemDados[1].length == 0 && this.arrayItemDados[2].length == 0 && this.arrayItemDados[3].length == 0 || relatorios.contains(this.relatorio))) {
            relatorios.add(this.relatorio);
        }
    }

    private void adicionarRelatorioTodos(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo) {
        if (!(demonstrativo.getBensImoveis().isVazio() && demonstrativo.getBensMoveis().isVazio() && demonstrativo.getParticipacoesSocietarias().isVazio() && demonstrativo.getMoedasAlienadas().isVazio() || relatorios.contains(this.relatorio))) {
            relatorios.add(this.relatorio);
        }
    }

    public static void adicionarParametrosDemonstrativo(RelatorioXML relatorio, DemonstrativoGCAP demonstrativo) {
        String lCodigoReceita = null;
        lCodigoReceita = "105".equals(demonstrativo.getIdDemonstrativo().getPaisDeclarante().naoFormatado()) ? "4600" : "0473";
        relatorio.addParametro("codigoReceita", lCodigoReceita);
        relatorio.addParametro("nomeDeclarante", demonstrativo.getIdDemonstrativo().getNome().formatado());
        relatorio.addParametro("cpfDeclarante", demonstrativo.getIdDemonstrativo().getCpf().formatado());
        relatorio.addParametro("pais", demonstrativo.getIdDemonstrativo().getPaisDeclarante().getConteudoAtual(1));
        relatorio.addParametro("codigoPais", demonstrativo.getIdDemonstrativo().getPaisDeclarante().getConteudoAtual(0));
        relatorio.addParametro("dataInicial", demonstrativo.getIdDemonstrativo().getDataInicioPermanencia().formatado());
        relatorio.addParametro("dataFinal", demonstrativo.getIdDemonstrativo().getDataFimPermanencia().formatado());
        relatorio.addParametro("telefoneDeclarante", demonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado());
        relatorio.addParametro("dddDeclarante", demonstrativo.getIdDemonstrativo().getDddDeclarante().formatado());
        if (demonstrativo.getIdDemonstrativo().isParaisoFiscal() || demonstrativo.getIdDemonstrativo().isTerritorioParaisoFiscal()) {
            relatorio.addParametro("paraisoFiscal", (Object)true);
        } else {
            relatorio.addParametro("paraisoFiscal", (Object)false);
        }
    }

    public static void adicionarParametrosGerais(RelatorioXML relatorio) {
        relatorio.addParametro("PATH", "");
        relatorio.addParametro("SUBREPORT_DIR", "");
        relatorio.addParametro("icone", "imagens/brasao.jpg");
        relatorio.addParametro("anoCalendario", ConstantesGlobais.EXERCICIO);
    }

    public static Collection<ConsolidacaoRelatorio> obterListaConsolidacao(Consolidacao pConsolidacaoDemonstrativo) {
        ArrayList<ConsolidacaoRelatorio> lRetorno = new ArrayList<ConsolidacaoRelatorio>();
        lRetorno.add(new ConsolidacaoRelatorio(pConsolidacaoDemonstrativo));
        return lRetorno;
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo, AlienacaoBemImovel alienacaoBemImovel) {
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo, AlienacaoBemMovel alienacaoBemMovel) {
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo, AlienacaoParticipacaoSocietaria pParticipacao) {
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo, ColecaoMoedaAlienada colecaoMoedaAlienada) {
    }

    @Override
    protected void adicionarRelatorioConsolidado(List<RelatorioXML> relatorios, DemonstrativoGCAP demonstrativo) {
    }

    @Override
    protected boolean isPaginado() {
        return false;
    }

    @Override
    protected String obterExtensaoArquivoRelatorio() {
        return "-imagem-demonstrativo.pdf";
    }
}

