/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao;

import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.formatosexternos.RelatorioXML;
import serpro.ppgd.gui.NavegadorHtml;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class RelatorioMultiploXMLGCAP
implements RelatorioIf {
    private List<RelatorioXML> relatorios = new ArrayList<RelatorioXML>();
    private List<DuplaParam> parametros = new ArrayList<DuplaParam>();
    private String titulo;
    private String nomeArquivo;
    private JasperPrint jasperPrint;
    private boolean preparado = false;
    private String PARAM_PAG_INICIAL = "pagInicial";
    private boolean paginado;

    public RelatorioMultiploXMLGCAP(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, String nomeArquivo) {
        this.titulo = aTitulo;
        this.nomeArquivo = nomeArquivo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz));
    }

    public RelatorioMultiploXMLGCAP(String aTitulo, String aRelatorioJasper, String nomeArquivo) {
        this.titulo = aTitulo;
        this.nomeArquivo = nomeArquivo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper));
    }

    public RelatorioMultiploXMLGCAP(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        this.titulo = aTitulo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz));
    }

    public RelatorioMultiploXMLGCAP(String aTitulo, String aRelatorioJasper) {
        this.titulo = aTitulo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper));
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            Object valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.getRelatorios().add(novoRelatorio);
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            Object valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.getRelatorios().add(novoRelatorio);
    }

    public void imprimir() {
        try {
            this.prepara();
            this.jasperPrint.setName(this.nomeArquivo);
            JasperPrintManager.printReport((JasperPrint)this.jasperPrint, (boolean)false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void gerarPDF() {
        try {
            this.prepara();
            this.jasperPrint.setName(this.nomeArquivo);
            byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)this.jasperPrint);
            Object nomeArq = null;
            if (this.nomeArquivo != null) {
                nomeArq = this.nomeArquivo;
            } else {
                long diferenciador = new Date().getTime();
                nomeArq = "relatorio" + diferenciador + ".pdf";
            }
            String caminho = UtilitariosArquivo.getPathAplicacao() + (String)nomeArq;
            FileOutputStream stream = new FileOutputStream(caminho);
            stream.write(bytes);
            stream.close();
            NavegadorHtml.executarNavegador((String)("file://" + UtilitariosArquivo.getPathAplicacao() + this.nomeArquivo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void prepara() {
        if (this.paginado) {
            this.preparaPaginado();
        } else {
            this.preparaNaoPaginado();
        }
    }

    public void preparaPaginado() {
        if (!this.isPreparado()) {
            int pageCount = 1;
            this.jasperPrint = new JasperPrint();
            int y = this.getRelatorios().size();
            for (int x = 0; x < y; ++x) {
                this.addParametro(this.PARAM_PAG_INICIAL, String.valueOf(pageCount), x);
                JasperPrint printTmp = this.getRelatorios().get(x).obterPaginas();
                List lista = printTmp.getPages();
                pageCount += lista.size();
                if (x == 0) {
                    this.jasperPrint = printTmp;
                    continue;
                }
                for (int i = 0; i < lista.size(); ++i) {
                    this.jasperPrint.addPage((JRPrintPage)lista.get(i));
                }
            }
            List pages = this.jasperPrint.getPages();
            JRPrintPage page2 = null;
            JRTemplatePrintText texto = null;
            int indicePagina = 1;
            for (JRPrintPage page2 : pages) {
                texto = (JRTemplatePrintText)page2.getElements().get(page2.getElements().size() - 1);
                texto.setText(String.valueOf(indicePagina++));
            }
            this.preparado = true;
        }
    }

    public void preparaNaoPaginado() {
        if (!this.isPreparado()) {
            int pageCount = 1;
            this.jasperPrint = new JasperPrint();
            int y = this.getRelatorios().size();
            for (int x = 0; x < y; ++x) {
                this.addParametro(this.PARAM_PAG_INICIAL, String.valueOf(pageCount), x);
                JasperPrint printTmp = this.getRelatorios().get(x).obterPaginas();
                List lista = printTmp.getPages();
                pageCount += lista.size();
                if (x == 0) {
                    this.jasperPrint = printTmp;
                    continue;
                }
                for (int i = 0; i < lista.size(); ++i) {
                    this.jasperPrint.addPage((JRPrintPage)lista.get(i));
                }
            }
            this.preparado = true;
        }
    }

    public void visualizar() {
        try {
            this.prepara();
            this.jasperPrint.setName(this.nomeArquivo);
            boolean continua = true;
            PPGDJasperViewer viewer = null;
            int numMaxTentativas = 500;
            int i = 0;
            while (continua && i++ < numMaxTentativas) {
                try {
                    viewer = new PPGDJasperViewer(this.jasperPrint, false, new Locale("pt", "BR"));
                    continua = false;
                }
                catch (Exception e) {
                    System.out.println("erro " + i + ": " + String.valueOf(e));
                }
            }
            viewer.setTitle(this.getTitulo());
            viewer.setIconImage(Frame.getFrames()[0].getIconImage());
            viewer.setVisible(true);
            viewer.addWindowFocusListener(new WindowFocusListener(){
                private boolean firstLost = true;

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (this.firstLost) {
                        e.getWindow().toFront();
                        this.firstLost = false;
                    }
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }
            });
        }
        catch (Exception e) {
            System.out.println("Houve um erro ao tentar gerar a impress\u00e3o: " + e.getMessage());
            System.out.println("Classe: RelatorioultiploXMLGCAP, m\u00e9todo: visualizar()");
            e.printStackTrace();
        }
    }

    public void addParametro(String nome, String valor) {
        for (int x = 0; x < this.getRelatorios().size(); ++x) {
            this.getRelatorios().get(x).addParametro(nome, valor);
        }
        this.parametros.add(new DuplaParam(nome, valor));
    }

    public void addParametro(String nome, String valor, int indice) {
        this.getRelatorios().get(indice).addParametro(nome, valor);
    }

    public void addParametro(String nome, Object valor) {
        for (int x = 0; x < this.getRelatorios().size(); ++x) {
            this.getRelatorios().get(x).addParametro(nome, valor);
        }
        this.parametros.add(new DuplaParam(nome, valor));
    }

    public void addParametroUltimo(String nome, String valor) {
        this.getRelatorios().get(this.getRelatorios().size() - 1).addParametro(nome, valor);
    }

    public List<DuplaParam> getAllParametro() {
        return this.parametros;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String aTitulo) {
        this.titulo = aTitulo;
    }

    public boolean isHabilitado() {
        return false;
    }

    public void setHabilitado(boolean aHabilitado) {
    }

    public boolean isPreparado() {
        return this.preparado;
    }

    public int getQtdPaginas() {
        int qtd = -1;
        if (this.isPreparado()) {
            qtd = this.jasperPrint.getPages().size();
        }
        return qtd;
    }

    public void setRelatorios(List<RelatorioXML> relatorios) {
        this.relatorios = relatorios;
    }

    public List<RelatorioXML> getRelatorios() {
        return this.relatorios;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public boolean isPaginado() {
        return this.paginado;
    }

    public void setPaginado(boolean paginado) {
        this.paginado = paginado;
    }

    private class DuplaParam {
        String nome;
        Object valor;

        public String getNome() {
            return this.nome;
        }

        public Object getValor() {
            return this.valor;
        }

        public DuplaParam(String nome, Object valor) {
            this.nome = nome;
            this.valor = valor;
        }
    }
}

